/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.common.configs;

import com.baomidou.mybatisplus.autoconfigure.MybatisPlusAutoConfiguration;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.extension.parsers.BlockAttackSqlParser;
import com.baomidou.mybatisplus.extension.plugins.OptimisticLockerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.PaginationInterceptor;
import com.jdaz.sinosoftgz.apis.commons.model.base.entity.BaseEntity;
import java.util.ArrayList;
import java.util.Date;
import org.apache.ibatis.reflection.MetaObject;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.ComponentScans;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@EnableTransactionManagement
@MapperScan(basePackages={"com.jdaz.sinosoftgz.apis.commons.model.*.mapper"})
@ComponentScans(value={@ComponentScan(value={"com.jdaz.sinosoftgz.apis.commons.service.service"}), @ComponentScan(value={"com.jdaz.sinosoftgz.apis.commons.model.*.service"}), @ComponentScan(value={"com.jdaz.sinosoftgz.apis.commons.service.*.service"})})
@AutoConfigureAfter(value={MybatisPlusAutoConfiguration.class})
public class MybatisAutoConfig {
    private static final Logger log = LoggerFactory.getLogger(MybatisAutoConfig.class);

    @Bean
    MetaObjectHandler myMetaObjectHandler() {
        String entityFieldNameDateCreated = "createTime";
        String entityFieldNameLastUpdated = "updateTime";
        String entityFieldNameDeleteFlag = "deleted";
        String entityFieldNameDeleteDate = "deleteTime";
        return new MetaObjectHandler(){

            public void insertFill(MetaObject metaObject) {
                Date now = new Date();
                log.debug("start insert fill ....");
                this.setFieldValByName("createTime", now, metaObject);
                this.setFieldValByName("updateTime", new Date(), metaObject);
                this.setFieldValByName("deleteTime", null, metaObject);
            }

            public void updateFill(MetaObject metaObject) {
                Date now = new Date();
                Integer deleteFlag = (Integer)this.getFieldValByName("deleted", metaObject);
                if (BaseEntity.DELETE_FLAG_TRUE.equals(deleteFlag) && this.getFieldValByName("deleteTime", metaObject) == null) {
                    this.setFieldValByName("deleteTime", now, metaObject);
                }
                this.setFieldValByName("updateTime", now, metaObject);
            }
        };
    }

    @Bean
    public PaginationInterceptor paginationInterceptor() {
        PaginationInterceptor paginationInterceptor = new PaginationInterceptor();
        ArrayList<BlockAttackSqlParser> sqlParserList = new ArrayList<BlockAttackSqlParser>();
        sqlParserList.add(new BlockAttackSqlParser());
        paginationInterceptor.setSqlParserList(sqlParserList);
        return paginationInterceptor;
    }

    @Bean
    @ConditionalOnMissingBean(value={OptimisticLockerInterceptor.class})
    public OptimisticLockerInterceptor optimisticLockerInterceptor() {
        return new OptimisticLockerInterceptor();
    }
}

