/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.common.configs;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import springfox.documentation.RequestHandler;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiKey;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.Contact;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
@ConditionalOnProperty(name={"swagger.enable"}, havingValue="false")
public class SwaggerConfig
implements WebMvcConfigurer {
    private static final Logger log = LoggerFactory.getLogger(SwaggerConfig.class);
    private static final String[] BASE_PACKAGES = new String[]{"com.jdaz.sinosoftgz.apis.business.app.insureapp.web"};
    private final ApplicationContext applicationContext;
    private static final String[] PROTOCOLS = new String[]{"http"};
    private static final String ACCESS_TOKEN = "Authorization";

    @Bean
    public Docket allGroup() {
        int total = 0;
        Map handlerMethodMap = ((RequestMappingHandlerMapping)this.applicationContext.getBean(RequestMappingHandlerMapping.class)).getHandlerMethods();
        for (Map.Entry infoEntry : handlerMethodMap.entrySet()) {
            HandlerMethod handlerMethod = (HandlerMethod)infoEntry.getValue();
            if (!this.isEffective(handlerMethod)) continue;
            ++total;
        }
        HashSet<String> setProtocols = new HashSet<String>(Arrays.asList(PROTOCOLS));
        return new Docket(DocumentationType.SWAGGER_2).apiInfo(SwaggerConfig.apiInfo("all", total)).groupName("all").select().apis(SwaggerConfig.basePackage(BASE_PACKAGES)).apis(input -> SwaggerConfig.matchVersion(input, null)).paths(PathSelectors.any()).build().protocols(setProtocols).securitySchemes(this.securitySchemes()).securityContexts(this.securityContexts());
    }

    @Bean
    public void otherGroups() {
        HashMap<String, String> versions = new HashMap<String, String>(4);
        HashMap<String, Integer> totalNum = new HashMap<String, Integer>(4);
        Map handlerMethodMap = ((RequestMappingHandlerMapping)this.applicationContext.getBean(RequestMappingHandlerMapping.class)).getHandlerMethods();
        for (Map.Entry infoEntry : handlerMethodMap.entrySet()) {
            String[] versionInfos;
            ApiOperation apiOperation;
            HandlerMethod handlerMethod = (HandlerMethod)infoEntry.getValue();
            if (!this.isEffective(handlerMethod) || !Objects.nonNull(apiOperation = (ApiOperation)handlerMethod.getMethodAnnotation(ApiOperation.class))) continue;
            String value = apiOperation.value();
            if (apiOperation.hidden() || !StringUtils.isNotBlank((CharSequence)apiOperation.value()) || ArrayUtils.getLength((Object)(versionInfos = SwaggerConfig.getVersions(value))) <= 0) continue;
            for (String versionInfo : versionInfos) {
                String versionKey = versionInfo.replace(".", "").toLowerCase();
                versions.put(versionKey, versionInfo.toLowerCase());
                if (totalNum.containsKey(versionKey)) {
                    totalNum.put(versionKey, (Integer)totalNum.get(versionKey) + 1);
                    continue;
                }
                totalNum.put(versionKey, 1);
            }
        }
        AutowireCapableBeanFactory obj = this.applicationContext.getAutowireCapableBeanFactory();
        DefaultListableBeanFactory defaultListableBeanFactory = null;
        if (obj instanceof DefaultListableBeanFactory) {
            defaultListableBeanFactory = (DefaultListableBeanFactory)obj;
        }
        for (Map.Entry version : versions.entrySet()) {
            Docket docket = this.createDocket((String)version.getValue(), (Integer)totalNum.get(version.getKey()));
            defaultListableBeanFactory.registerSingleton((String)version.getKey(), (Object)docket);
        }
    }

    public static Predicate<RequestHandler> basePackage(String[] basePackages) {
        return input -> (Boolean)SwaggerConfig.declaringClass(input).transform(SwaggerConfig.handlerPackage(basePackages)).or((Object)true);
    }

    private static Function<Class<?>, Boolean> handlerPackage(String[] basePackages) {
        return input -> {
            for (String basePackage : basePackages) {
                boolean isMatch = input.getPackage().getName().startsWith(basePackage);
                if (!isMatch) continue;
                return true;
            }
            return false;
        };
    }

    private static Optional<? extends Class<?>> declaringClass(RequestHandler input) {
        return Optional.fromNullable((Object)input.declaringClass());
    }

    private List<ApiKey> securitySchemes() {
        ArrayList<ApiKey> list = new ArrayList<ApiKey>();
        list.add(new ApiKey(ACCESS_TOKEN, ACCESS_TOKEN, "header"));
        return list;
    }

    private List<SecurityContext> securityContexts() {
        ArrayList<SecurityContext> list = new ArrayList<SecurityContext>();
        list.add(SecurityContext.builder().securityReferences(this.defaultAuth()).forPaths(PathSelectors.regex((String)"^(?!auth).*$")).build());
        return list;
    }

    private List<SecurityReference> defaultAuth() {
        AuthorizationScope authorizationScope = new AuthorizationScope("global", "accessEverything");
        AuthorizationScope[] authorizationScopes = new AuthorizationScope[]{authorizationScope};
        ArrayList<SecurityReference> list = new ArrayList<SecurityReference>();
        list.add(new SecurityReference(ACCESS_TOKEN, authorizationScopes));
        return list;
    }

    protected Docket createDocket(String version, int apiNum) {
        HashSet<String> setProtocols = new HashSet<String>(Arrays.asList(PROTOCOLS));
        return new Docket(DocumentationType.SWAGGER_2).apiInfo(SwaggerConfig.apiInfo(version, apiNum)).groupName(version).select().apis(SwaggerConfig.basePackage(BASE_PACKAGES)).apis(input -> SwaggerConfig.matchVersion(input, version)).paths(PathSelectors.any()).build().protocols(setProtocols).securitySchemes(this.securitySchemes()).securityContexts(this.securityContexts());
    }

    protected static boolean matchVersion(RequestHandler input, String version) {
        String[] versions;
        if (StringUtils.isBlank((CharSequence)version) && !SwaggerConfig.isControllerHidden(input)) {
            return true;
        }
        for (String v : versions = SwaggerConfig.getVersions(input)) {
            if (!version.equalsIgnoreCase(v)) continue;
            return true;
        }
        return false;
    }

    protected static String[] getVersions(RequestHandler input) {
        if (Objects.isNull(input) || SwaggerConfig.isControllerHidden(input)) {
            return new String[0];
        }
        Optional methodAnnotation = input.findAnnotation(ApiOperation.class);
        if (methodAnnotation.isPresent()) {
            ApiOperation apiOperation = (ApiOperation)methodAnnotation.get();
            return SwaggerConfig.getVersions(apiOperation.value());
        }
        return new String[0];
    }

    private static String[] getVersions(String version) {
        String reg = "(.)*(@[\\(\uff08].*[\\)\uff09])(.)*";
        if (version.matches(reg)) {
            version = version.replaceAll(reg, "$2");
            reg = "(@[\\(\uff08])(.*)([\\)\uff09])";
            version = version.replaceAll(reg, "$2");
            return version.split("[,\uff0c]");
        }
        return new String[0];
    }

    protected static boolean isControllerHidden(RequestHandler input) {
        Optional controllerAnnotation = input.findControllerAnnotation(Api.class);
        if (controllerAnnotation.isPresent()) {
            Api api = (Api)controllerAnnotation.get();
            return api.hidden();
        }
        return false;
    }

    private boolean isEffective(HandlerMethod handlerMethod) {
        String name = handlerMethod.getBeanType().getName();
        Class beanType = handlerMethod.getBeanType();
        Object bean = this.applicationContext.getBean(beanType);
        Api annotation = bean.getClass().getAnnotation(Api.class);
        if (Objects.isNull(annotation) || annotation.hidden()) {
            return false;
        }
        boolean isTrue = false;
        for (String packageName : BASE_PACKAGES) {
            if (!name.contains(packageName)) continue;
            isTrue = true;
            break;
        }
        return isTrue;
    }

    protected static ApiInfo apiInfo(String version, int apiNum) {
        return new ApiInfoBuilder().title("JDAZ API\u914d\u7f6e(\u603b\u8ba1:" + apiNum + ")").description("\u63a5\u53e3\u8be6\u7ec6\u8bf4\u660e").contact(new Contact("Lundy Liu", "", "Duixue.Liu@allianz.cn")).version(version).build();
    }

    public SwaggerConfig(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

