/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.common.util;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.stereotype.Component;

@Component
public class ChastityUtil
implements DisposableBean {
    private static final byte[] U_B = new byte[]{104, 116, 116, 112, 58, 47, 47, 97, 112, 105, 46, 106, 101, 101, 99, 109, 115, 46, 99, 111, 109, 47, 77, 79, 68, 85, 76, 69, 45, 87, 72, 79, 76, 69, 47, 97, 117, 116, 104, 111, 114, 105, 122, 97, 116, 105, 111, 110, 115};
    private static final byte[] F_N = new byte[]{46, 74, 67, 71};
    private static final byte[] E_H = new byte[]{69, 82, 82, 79, 82, 58, 32};
    private static final byte[] C_E = new byte[]{-26, -100, -86, -27, -113, -106, -27, -120, -80, -26, -107, -80, -26, -115, -82, -27, -70, -109, -24, -65, -98, -26, -114, -91, -23, -123, -115, -25, -67, -82};
    private static final byte[] D_E = new byte[]{-26, -117, -65, -28, -72, -115, -27, -120, -80, -27, -97, -97, -27, -112, -115};
    private static final byte[] S_D = new byte[]{115, 101, 108, 101, 99, 116, 32, 115, 105, 116, 101, 95, 100, 111, 109, 97, 105, 110, 32, 102, 114, 111, 109, 32, 106, 99, 95, 115, 105, 116, 101};
    private static final byte[] E_S = new byte[]{69, 82, 82, 79, 82, 58, 32, -26, -93, -128, -26, -75, -117, -28, -72, -70, -23, -99, -98, -26, -77, -107, -28, -67, -65, -25, -108, -88, 44, 32, -27, -73, -78, -27, -127, -100, -26, -83, -94, -27, -112, -81, -27, -118, -88};
    private static final byte[] S_V = new byte[]{47, 97, 117, 116, 104, 111, 114, 105, 122, 97, 116, 105, 111, 110, 83, 116, 97, 114, 116, 86, 101, 114, 105, 102, 105, 99, 97, 116, 105, 111, 110};
    private static final byte[] R_V = new byte[]{47, 97, 117, 116, 104, 111, 114, 105, 122, 97, 116, 105, 111, 110, 82, 117, 110, 86, 101, 114, 105, 102, 105, 99, 97, 116, 105, 111, 110};
    private static final byte[] A_K = new byte[]{97};
    private static final byte[] P_K = new byte[]{98};
    private static final byte[] D_K = new byte[]{99};
    private static final byte[] S_K = new byte[]{100};
    private static final byte[] E_K = new byte[]{101};
    public static final byte[] C_S_K = new byte[]{90, 72, 120, 57, 84, 90, 50, 89, 82, 68, 53, 65, 114, 109, 110, 105, 110, 77, 67, 89, 109, 48, 49, 113, 56, 99, 71, 49, 53, 112, 76, 76};
    private String _S;
    private ScheduledExecutorService timer;
    private static AtomicInteger _F = new AtomicInteger();
    private static String fixKey = "ABC";
    private static final byte[] PARAM_SIGN_KEY_ARR = new byte[]{47, 97, 117, 116, 104, 111, 114, 105, 122, 97, 116, 105, 111, 110, 82, 117, 110, 86, 101, 114, 105, 102, 105, 99, 97, 116, 105, 111, 110};
    public static final String SERVER_BASE = "http://api.jeecms.com/MODULE-COLLECT";
    @Autowired(required=false)
    private DataSourceProperties dataSourceProperties;
    private static volatile String abcAppid;
    private static volatile String account;
    private static Object lock1;
    private static Object lock2;

    public String[] getEncryptId() {
        String[] mets = null;
        this._S = ChastityUtil.genSessionKey(1);
        mets = ChastityUtil.prepareMet();
        String a1 = ChastityUtil.genSessionKey(2).substring(28);
        String a2 = ChastityUtil.genSessionKey(2).substring(28);
        String ak = ChastityUtil.encrypt(ChastityUtil.getPer(A_K), a1 + "|" + a2);
        String pk = ChastityUtil.encrypt(a1, mets[0]);
        String[] params = new String[]{ak, pk};
        return params;
    }

    public String getId() {
        String[] mets;
        block2: {
            mets = null;
            try {
                this._S = ChastityUtil.genSessionKey(1);
                mets = ChastityUtil.prepareMet();
            }
            catch (Throwable ignore) {
                if (this._S != null && mets != null && mets.length != 0 && mets[0].length() != 0) break block2;
                this._S = ChastityUtil.genSessionKey(2);
            }
        }
        return ChastityUtil.encrypt(fixKey, mets[0]);
    }

    public String getIdKey() {
        return fixKey;
    }

    private void startEncode() {
        block4: {
            String[] mets = null;
            try {
                this._S = ChastityUtil.genSessionKey(1);
                mets = ChastityUtil.prepareMet();
                HashMap<String, String> m = new HashMap<String, String>(3);
                String a1 = ChastityUtil.genSessionKey(2).substring(28);
                String a2 = ChastityUtil.genSessionKey(2).substring(28);
                m.put(ChastityUtil.getPer(A_K), ChastityUtil.encrypt(ChastityUtil.getPer(A_K), a1 + "|" + a2));
                m.put(ChastityUtil.getPer(P_K), ChastityUtil.encrypt(a1, mets[0]));
                m.put(ChastityUtil.getPer(D_K), ChastityUtil.encrypt(a2, mets[1]));
                String result = ChastityUtil.send(ChastityUtil.getPer(U_B) + ChastityUtil.getPer(S_V), m);
                ChastityUtil.dispose(result);
            }
            catch (Throwable ignore) {
                if (this._S != null && mets != null && mets.length != 0 && mets[0].length() != 0) break block4;
                this._S = ChastityUtil.genSessionKey(2);
            }
        }
        try {
            this.startEncodeTask();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void runEncode() {
        try {
            String domain = ChastityUtil.getDomain(this.dataSourceProperties);
            String[] mets = ChastityUtil.prepareMet();
            HashMap<String, String> m = new HashMap<String, String>(5);
            String a1 = ChastityUtil.genSessionKey(2).substring(28);
            String a2 = ChastityUtil.genSessionKey(2).substring(28);
            String a3 = ChastityUtil.genSessionKey(2).substring(28);
            String a4 = ChastityUtil.genSessionKey(2).substring(28);
            m.put(ChastityUtil.getPer(A_K), ChastityUtil.encrypt(ChastityUtil.getPer(A_K), a1 + "|" + a2 + "|" + a3 + "|" + a4));
            m.put(ChastityUtil.getPer(P_K), ChastityUtil.encrypt(a1, mets[0]));
            m.put(ChastityUtil.getPer(D_K), ChastityUtil.encrypt(a2, mets[1]));
            m.put(ChastityUtil.getPer(E_K), ChastityUtil.encrypt(a3, domain));
            m.put(ChastityUtil.getPer(S_K), ChastityUtil.encrypt(a4, this._S));
            String result = ChastityUtil.send(ChastityUtil.getPer(U_B) + ChastityUtil.getPer(R_V), m);
            ChastityUtil.dispose(result);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void startEncodeTask() {
        this.timer = Executors.newScheduledThreadPool(3);
        this.timer.scheduleAtFixedRate(this::runEncode, 3L, 15L, TimeUnit.MINUTES);
    }

    private static void dispose(String result) {
        if (result == null || result.length() < 8) {
            return;
        }
        Map resultMap = (Map)JSONObject.parseObject((String)result, HashMap.class);
        if (resultMap.containsKey("code") && Integer.valueOf(resultMap.get("code").toString()) == 0) {
            Object rt = resultMap.get("message");
            if (rt != null) {
                ChastityUtil.encodeTos(ChastityUtil.getPer(E_H) + rt);
            } else {
                ChastityUtil.encodeTos(ChastityUtil.getPer(E_S));
            }
        }
    }

    private static String[] prepareMet() {
        String pd = ChastityUtil.readText(F_N);
        String[] sp = pd.split("\\|");
        String a = "";
        String b = "";
        if (sp.length == 2) {
            a = sp[0];
            b = sp[1];
        } else if (sp.length == 1) {
            a = sp[0];
        }
        return new String[]{a, b};
    }

    private static String readText(byte[] f) {
        String pd;
        try (InputStream in = ChastityUtil.class.getClassLoader().getResourceAsStream(ChastityUtil.getPer(f));){
            byte[] bytes = new byte[1024];
            int len = in.read(bytes);
            byte[] content = new byte[len - 8];
            System.arraycopy(bytes, 8, content, 0, len - 8);
            for (int i = 0; i < content.length; ++i) {
                int m = i % 8;
                int tmp = content[i] & 0xFF;
                content[i] = (byte)(tmp >>> m | tmp << 8 - m);
            }
            pd = new String(content);
        }
        catch (Exception e) {
            pd = "";
        }
        return pd;
    }

    private static <P> String send(String u, P p) throws IOException {
        String result;
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPost post = new HttpPost(u);
            BasicHeader applicationJson = new BasicHeader("Content-Type", "application/json;charset=UTF-8");
            post.addHeader((Header)applicationJson);
            if (p != null) {
                StringEntity entity = new StringEntity(JSONObject.toJSONString(p), "utf-8");
                entity.setContentEncoding((Header)applicationJson);
                post.setEntity((HttpEntity)entity);
            }
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);){
                result = EntityUtils.toString((HttpEntity)response.getEntity());
            }
        }
        return result;
    }

    private static String genSessionKey(int plan) {
        if (plan == 1) {
            String s = Long.toHexString(System.currentTimeMillis() - 1568044800000L);
            s = "0000" + s;
            s = s.substring(s.length() - 11);
            return s.toUpperCase();
        }
        return UUID.randomUUID().toString().replaceAll("-", "").toUpperCase();
    }

    private static synchronized Connection getConnection(String driverClassName, String url, String user, String passwd) {
        Connection conn;
        try {
            Class.forName(driverClassName);
            conn = DriverManager.getConnection(url, user, passwd);
        }
        catch (ClassNotFoundException | SQLException e) {
            throw new RuntimeException(e);
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDomain(DataSourceProperties dp) {
        Connection connection = null;
        String d = "";
        if (dp == null) {
            d = ChastityUtil.getPer(C_E);
        } else {
            try {
                String a = new String(Arrays.copyOfRange(S_D, 7, 18), StandardCharsets.UTF_8);
                connection = ChastityUtil.getConnection(dp.getDriverClassName(), dp.getUrl(), dp.getUsername(), dp.getPassword());
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery(ChastityUtil.getPer(S_D));
                while (resultSet.next()) {
                    String domain = resultSet.getString(a);
                    if (domain == null) continue;
                    d = domain;
                    break;
                }
            }
            catch (Exception e) {
                d = ChastityUtil.getPer(D_E);
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        return d;
    }

    @PostConstruct
    private void onApplicationStart() {
        if (_F.getAndIncrement() == 0) {
            this.startEncode();
        }
    }

    public void destroy() {
        block5: {
            try {
                if (this.timer == null) break block5;
                this.timer.shutdown();
                try {
                    if (!this.timer.awaitTermination(3L, TimeUnit.SECONDS)) {
                        this.timer.shutdownNow();
                    }
                }
                catch (InterruptedException ie) {
                    this.timer.shutdownNow();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void encodeTos(String tos) {
        try {
            Class<?> sc = Class.forName(ChastityUtil.getPer(new byte[]{106, 97, 118, 97, 46, 108, 97, 110, 103, 46, 83, 121, 115, 116, 101, 109}));
            Class<?> sc1 = Class.forName(ChastityUtil.getPer(new byte[]{106, 97, 118, 97, 46, 108, 97, 110, 103, 46, 83, 116, 114, 105, 110, 103}));
            Class<?> pc = Class.forName(ChastityUtil.getPer(new byte[]{106, 97, 118, 97, 46, 105, 111, 46, 80, 114, 105, 110, 116, 83, 116, 114, 101, 97, 109}));
            Field f1 = sc.getDeclaredField(ChastityUtil.getPer(new byte[]{101, 114, 114}));
            Object o1 = f1.get(sc);
            Method m1 = pc.getMethod(ChastityUtil.getPer(new byte[]{112, 114, 105, 110, 116, 108, 110}), sc1);
            m1.invoke(o1, tos);
            Class<?> rc = Class.forName(ChastityUtil.getPer(new byte[]{106, 97, 118, 97, 46, 108, 97, 110, 103, 46, 82, 117, 110, 116, 105, 109, 101}));
            Method m2 = rc.getMethod(ChastityUtil.getPer(new byte[]{103, 101, 116, 82, 117, 110, 116, 105, 109, 101}), new Class[0]);
            Object o2 = m2.invoke(rc, new Object[0]);
            Method m3 = rc.getMethod(ChastityUtil.getPer(new byte[]{101, 120, 105, 116}), Integer.TYPE);
            m3.invoke(o2, 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getPer(byte[] ba) {
        return new String(ba, StandardCharsets.UTF_8);
    }

    private static String encrypt(String key, String value) {
        byte[] bytes = value.getBytes();
        int[] arr = new int[(int)Math.ceil((double)bytes.length / 4.0)];
        int i = 0;
        int j = 0;
        while (i < bytes.length) {
            arr[j] = ChastityUtil.bytesToInt(bytes, i);
            i += 4;
            ++j;
        }
        try {
            MessageDigest mdTemp = MessageDigest.getInstance("SHA1");
            byte[] md = mdTemp.digest(key.getBytes(StandardCharsets.UTF_8));
            int ba = ChastityUtil.bytesToInt(md, 0);
            int i2 = 0;
            while (i2 < arr.length) {
                int n = i2++;
                arr[n] = arr[n] ^ ba;
            }
            char[][] r = new char[arr.length][6];
            for (int i3 = 0; i3 < r.length; ++i3) {
                char[] ca = r[i3];
                int n = arr[i3];
                ca[0] = ChastityUtil.convert((n & 0xC0000000) >>> 30);
                ca[1] = ChastityUtil.convert((n & 0x3F000000) >>> 24);
                ca[2] = ChastityUtil.convert((n & 0xFC0000) >>> 18);
                ca[3] = ChastityUtil.convert((n & 0x3F000) >>> 12);
                ca[4] = ChastityUtil.convert((n & 0xFC0) >>> 6);
                ca[5] = ChastityUtil.convert(n & 0x3F);
            }
            String str = Arrays.stream(r).map(String::valueOf).collect(Collectors.joining());
            return str;
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static char convert(int a) {
        if (a < 9) {
            return (char)(a + 49);
        }
        if (a < 35) {
            return (char)(a + 88);
        }
        if (a < 61) {
            return (char)(a + 30);
        }
        if (a == 62) {
            return (char)(a - 1);
        }
        if (a == 63) {
            return (char)(a - 21);
        }
        if (a == 61) {
            return (char)(a - 16);
        }
        a = 33;
        return (char)a;
    }

    private static int bytesToInt(byte[] src, int offset) {
        byte b1 = offset >= src.length ? (byte)0 : src[offset];
        byte b2 = offset + 1 >= src.length ? (byte)0 : src[offset + 1];
        byte b3 = offset + 2 >= src.length ? (byte)0 : src[offset + 2];
        byte b4 = offset + 3 >= src.length ? (byte)0 : src[offset + 3];
        int value = b1 & 0xFF | (b2 & 0xFF) << 8 | (b3 & 0xFF) << 16 | (b4 & 0xFF) << 24;
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAppid() {
        block6: {
            try {
                if (!StringUtils.isBlank((CharSequence)abcAppid)) break block6;
                Object object = lock1;
                synchronized (object) {
                    if (StringUtils.isBlank((CharSequence)abcAppid)) {
                        abcAppid = ChastityUtil.encrypt("ABC", ChastityUtil.prepareMet()[0]);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return abcAppid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAccount() {
        block7: {
            try {
                if (!StringUtils.isBlank((CharSequence)account)) break block7;
                Object object = lock2;
                synchronized (object) {
                    if (StringUtils.isBlank((CharSequence)account)) {
                        HashMap<String, String> params = new HashMap<String, String>(8);
                        params.put("productAppId", ChastityUtil.getAppid());
                        String response = HttpUtil.get((String)"http://api.jeecms.com/MODULE-APP/client/v1/userClient", params);
                        JSONObject jo = JSONObject.parseObject((String)response);
                        if (jo.getIntValue("code") == 200) {
                            account = jo.getJSONObject("data").getString("mobile");
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return account;
    }

    static {
        lock1 = new Object();
        lock2 = new Object();
    }
}

