/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetRequestJsonUtil {
    private static final Logger log = LoggerFactory.getLogger(GetRequestJsonUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject getParamsFromRequestBody(HttpServletRequest request) throws IOException {
        BufferedReader reader = request.getReader();
        StringBuilder builder = new StringBuilder();
        try {
            String line = null;
            while ((line = reader.readLine()) != null) {
                builder.append(line);
            }
            String bodyString = builder.toString();
            JSONObject jSONObject = JSON.parseObject((String)bodyString);
            return jSONObject;
        }
        catch (Exception e) {
            log.error("getParamsFromRequestBody error->");
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static JSONObject getRequestJsonObject(HttpServletRequest request) throws IOException {
        String json = GetRequestJsonUtil.getRequestJsonString(request);
        return JSONObject.parseObject((String)json);
    }

    public static String getRequestJsonString(HttpServletRequest request) throws IOException {
        String submitMehtod = request.getMethod();
        if (submitMehtod.equals("GET")) {
            return new String(request.getQueryString().getBytes("iso-8859-1"), "utf-8").replaceAll("%22", "\"");
        }
        return GetRequestJsonUtil.getRequestPostStr(request);
    }

    public static byte[] getRequestPostBytes(HttpServletRequest request) throws IOException {
        int readlen;
        int contentLength = request.getContentLength();
        if (contentLength < 0) {
            return null;
        }
        byte[] buffer = new byte[contentLength];
        for (int i = 0; i < contentLength && (readlen = request.getInputStream().read(buffer, i, contentLength - i)) != -1; i += readlen) {
        }
        return buffer;
    }

    public static String getRequestPostStr(HttpServletRequest request) throws IOException {
        byte[] buffer = GetRequestJsonUtil.getRequestPostBytes(request);
        String charEncoding = request.getCharacterEncoding();
        if (charEncoding == null) {
            charEncoding = "UTF-8";
        }
        return new String(buffer, charEncoding);
    }
}

