/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.common.util;

import com.jeecms.common.util.ProcessOldDataService;
import com.jeecms.common.util.ProcessResourceUtil;
import java.io.File;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.stereotype.Component;

@ConditionalOnBean(value={ProcessOldDataService.class})
@Component
public class ProcessPluginUtils
implements DisposableBean {
    static Logger logger = LoggerFactory.getLogger(ProcessPluginUtils.class);
    private static final String INDEX_PATH = logger.getClass().getClassLoader().getResource("").getPath();
    private static final String INDEX_REAL_PATH = INDEX_PATH + "hanlp";
    private static final String IP_PATH = INDEX_PATH + "geolite2";
    private static final String IP_REAL_PATH = IP_PATH + "/GeoLite2-City.mmdb";
    private ScheduledExecutorService timer;
    private static int frequency = 0;
    @Autowired
    private ProcessResourceUtil util;
    @Autowired
    private ProcessOldDataService processOldDataService;

    @PostConstruct
    private void checkProcess() {
        this.startEncodeTask();
    }

    private void startEncodeTask() {
        this.timer = Executors.newScheduledThreadPool(3);
        this.timer.scheduleAtFixedRate(this::startCheck, 1L, 15L, TimeUnit.MINUTES);
    }

    private void startCheck() {
        this.util.deleteTempFile();
        this.startCheckIndex();
        this.startCheckIp();
    }

    private void startCheckIndex() {
        File file = new File(INDEX_REAL_PATH);
        String localVersion = this.util.getLocalVersion(2);
        String lineVersion = this.util.getLineVersion("Hanlp");
        boolean isFile = false;
        if (file.exists() && file.list().length > 0) {
            isFile = true;
        }
        this.util.processResource(isFile, localVersion, lineVersion, 2);
    }

    private void startCheckIp() {
        File directory = new File(IP_PATH);
        if (!directory.isDirectory()) {
            directory.mkdir();
        }
        File file = new File(IP_REAL_PATH);
        String localVersion = this.util.getLocalVersion(1);
        String lineVersion = this.util.getLineVersion("GeoLite2-City");
        this.util.processResource(file.exists(), localVersion, lineVersion, 1);
        if (frequency == 0) {
            this.processOldDataService.processUserCommentArea();
            ++frequency;
        }
    }

    public void destroy() {
        block5: {
            try {
                if (this.timer == null) break block5;
                this.timer.shutdown();
                try {
                    if (!this.timer.awaitTermination(3L, TimeUnit.SECONDS)) {
                        this.timer.shutdownNow();
                    }
                }
                catch (InterruptedException ie) {
                    this.timer.shutdownNow();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

