/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.common.util;

public class SnowFlake {
    public static final int SHORT_STR_CODE = 1;
    public static final int LONG_STR_CODE = 2;
    private static final long START_STMP = 1483200000000L;
    private long sequenceBit;
    private long machineBit;
    private long dataCenterBit;
    private long datacenterId = 0L;
    private long machineId = 0L;
    private long sequence = 0L;
    private long lastStmp = -1L;

    public SnowFlake(int generateModel) {
        if (this.datacenterId < 0L) {
            throw new IllegalArgumentException("datacenterId can't  less than 0");
        }
        if (this.machineId < 0L) {
            throw new IllegalArgumentException("machineId can't  less than 0");
        }
        int len10 = 10;
        if (this.datacenterId + this.machineId > (long)len10) {
            throw new IllegalArgumentException("sum of machineId and datacenter can't over 10");
        }
        if (1 == generateModel) {
            this.sequenceBit = 6L;
            this.datacenterId = 2L;
            this.dataCenterBit = 2L;
            this.machineId = 2L;
            this.machineBit = 2L;
        } else {
            this.sequenceBit = 12L;
            this.datacenterId = 5L;
            this.dataCenterBit = 5L;
            this.machineId = 5L;
            this.machineBit = 5L;
        }
    }

    public synchronized long nextId() {
        long currStmp = this.getNewstmp();
        if (currStmp < this.lastStmp) {
            throw new RuntimeException("Clock moved backwards.  Refusing to generate id");
        }
        if (currStmp == this.lastStmp) {
            this.sequence = this.sequence + 1L & (0xFFFFFFFFFFFFFFFFL ^ -1L << (int)this.sequenceBit);
            if (this.sequence == 0L) {
                currStmp = this.getNextMill();
            }
        } else {
            this.sequence = 0L;
        }
        this.lastStmp = currStmp;
        return currStmp - 1483200000000L << (int)(this.dataCenterBit + this.sequenceBit + this.machineBit) | this.datacenterId << (int)(this.sequenceBit + this.machineBit) | this.machineId << (int)this.machineBit | this.sequence;
    }

    private long getNextMill() {
        long mill = this.getNewstmp();
        while (mill <= this.lastStmp) {
            mill = this.getNewstmp();
        }
        return mill;
    }

    private long getNewstmp() {
        return System.currentTimeMillis();
    }
}

