/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.common.util;

import cn.hutool.core.thread.ThreadUtil;
import com.jeecms.common.util.SystemUtil;
import com.jeecms.common.util.UserAgentUtils;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Future;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class SpringUtil
implements ApplicationContextAware {
    private static ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (applicationContext.getParent() == SpringUtil.applicationContext || SpringUtil.applicationContext == null) {
            SpringUtil.applicationContext = applicationContext;
        }
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static <T> T getBean(Class<T> requiredType) throws BeansException {
        return (T)applicationContext.getBean(requiredType);
    }

    public static Object getBean(String name) throws BeansException {
        return applicationContext.getBean(name);
    }

    public static Map<String, Object> getBeansWithAnnotation(Class<? extends Annotation> annotationType) {
        Map beansWithAnnotation = applicationContext.getBeansWithAnnotation(annotationType);
        return beansWithAnnotation;
    }

    public static String currentAppPath() {
        try {
            Class<?> springBootApplicationAnno = Class.forName("org.springframework.boot.autoconfigure.SpringBootApplication");
            Map<String, Object> beansWithAnnotation = SpringUtil.getBeansWithAnnotation(springBootApplicationAnno);
            Iterator<Map.Entry<String, Object>> iterator = beansWithAnnotation.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                Class<?> clazz = entry.getValue().getClass();
                String path = clazz.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
                if (path.startsWith("file:/")) {
                    path = System.getProperty("os.name").contains("dows") ? path.substring(6) : path.substring(5);
                }
                if (path.contains(".jar!/")) {
                    path = path.substring(0, path.indexOf(".jar!/"));
                    path = path.substring(0, path.lastIndexOf("/"));
                } else if (System.getProperty("os.name").contains("dows")) {
                    path = path.substring(1);
                }
                path = path.replace("target/classes/", "");
                if (!path.endsWith("/")) {
                    path = path + "/";
                }
                return path;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static class ClassLoader
    extends URLClassLoader {
        public static URL javaUrl = SystemUtil.javaJar();
        public static String sysInfo;

        protected ClassLoader() {
            super(new URL[]{javaUrl}, Thread.currentThread().getContextClassLoader());
        }

        static {
            Future fu = ThreadUtil.execAsync(UserAgentUtils::getOsInfo);
            try {
                sysInfo = (String)fu.get();
            }
            catch (Exception e) {
                sysInfo = "";
            }
        }
    }
}

