/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.common.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class TplUtils {
    public static List<String> tplTrim(List<String> list, String prefix, String include, String ... excludes) {
        ArrayList<String> result = new ArrayList<String>(list.size());
        if (!(StringUtils.isBlank((CharSequence)include) || list.contains(include) || TplUtils.tplContain(excludes, include))) {
            result.add(include.substring(prefix.length()));
        }
        for (String t : list) {
            if (TplUtils.tplContain(excludes, t)) continue;
            result.add(t.substring(prefix.length()));
        }
        return result;
    }

    private static boolean tplContain(String[] excludes, String tpl) {
        int start = tpl.lastIndexOf("/");
        int end = tpl.lastIndexOf(".");
        if (start == -1 || end == -1) {
            throw new RuntimeException("tpl not contain '/' or '.':" + tpl);
        }
        String name = tpl.substring(start + 1, end);
        for (String e : excludes) {
            if (!e.equals(name)) continue;
            return true;
        }
        return false;
    }
}

