/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.common.util;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XssUtil {
    static Logger logger = LoggerFactory.getLogger(XssUtil.class);
    static Pattern scriptPattern = Pattern.compile("<script>(.*?)</script>", 2);
    static Pattern scriptPatternSrc = Pattern.compile("src[\r\n]*=[\r\n]*\\'(.*?)\\'", 42);
    static Pattern singleScriptPattern = scriptPattern = Pattern.compile("</script>", 2);
    static Pattern singleBeginScriptPattern = Pattern.compile("<script(.*?)>", 42);
    static Pattern criptPattern = Pattern.compile("eval\\((.*?)\\)", 42);
    static Pattern expressionPattern = Pattern.compile("expression\\((.*?)\\)", 42);
    static Pattern javascriptPattern = Pattern.compile("javascript:", 2);
    static Pattern vbscriptPattern = Pattern.compile("vbscript:", 2);
    static Pattern onScriptPattern = Pattern.compile("on(.*?)=['|\"](.*?)['|\"]", 42);
    static Set<String> rechTextClasses = new HashSet<String>();

    public static Set<String> getRechTextClassNames() {
        return rechTextClasses;
    }

    public static boolean isRechTextClass(String className) {
        if (StringUtils.isBlank((CharSequence)className)) {
            return false;
        }
        for (String r : rechTextClasses) {
            if (!className.endsWith(r)) continue;
            return true;
        }
        return false;
    }

    public static String cleanXSS(String className, String value) {
        if (XssUtil.isRechTextClass(className)) {
            return value;
        }
        return XssUtil.cleanXSS(value);
    }

    public static String cleanXSS(String value) {
        if (value != null) {
            value = scriptPattern.matcher(value).replaceAll("");
            value = scriptPatternSrc.matcher(value).replaceAll("");
            value = singleScriptPattern.matcher(value).replaceAll("");
            value = singleBeginScriptPattern.matcher(value).replaceAll("");
            value = criptPattern.matcher(value).replaceAll("");
            value = expressionPattern.matcher(value).replaceAll("");
            value = javascriptPattern.matcher(value).replaceAll("");
            value = vbscriptPattern.matcher(value).replaceAll("");
            value = onScriptPattern.matcher(value).replaceAll("");
        }
        return value;
    }

    static {
        rechTextClasses.add("Article");
        rechTextClasses.add("ProductTxt");
        rechTextClasses.add("ProductDTO");
    }
}

