/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.common.web.util;

import com.alibaba.fastjson.JSONObject;
import com.jeecms.common.util.XssUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.Normalizer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UrlPathHelper;

public abstract class ResponseUtilBase {
    public static final Logger log = LoggerFactory.getLogger(ResponseUtilBase.class);
    private static final Map<String, String> HEADMAP = new HashMap<String, String>();
    public static final int PORT_DEF = 80;
    public static final String LOGIN_URL = "/login";

    public static void downloadVideo(HttpServletRequest request, HttpServletResponse response, String fileName, String suffix, byte[] bytes, String url) throws IOException, InterruptedException {
        if (bytes != null) {
            response.setCharacterEncoding("UTF-8");
            response.setHeader("content-Type", HEADMAP.get(suffix));
            fileName = XssUtil.cleanXSS(fileName);
            fileName = Normalizer.normalize(fileName, Normalizer.Form.NFKD);
            suffix = Normalizer.normalize(suffix, Normalizer.Form.NFKD);
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName + "." + suffix, "UTF-8"));
            response.getOutputStream().write(bytes);
        } else {
            JSONObject object = new JSONObject();
            object.put("url", (Object)url);
            ResponseUtilBase.renderJson(response, object.toJSONString());
        }
    }

    public static void renderJson(HttpServletResponse response, String text) {
        ResponseUtilBase.render(response, "application/json;charset=UTF-8", text);
    }

    public static void render(HttpServletResponse response, String contentType, String text) {
        response.setContentType(contentType);
        try {
            response.getWriter().write(text);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String loginUrl = LOGIN_URL;
        String location = ResponseUtilBase.getLocation(request);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{location})) {
            location = !location.startsWith(ResponseUtilBase.getServerUrl(request)) ? "/" : location.substring(ResponseUtilBase.getServerUrl(request).length());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{request.getContextPath()})) {
            loginUrl = request.getContextPath() + loginUrl;
        }
        response.sendRedirect(String.format("%s?backUrl=%s", loginUrl, location));
    }

    public static String getLocation(HttpServletRequest request) {
        UrlPathHelper helper = new UrlPathHelper();
        StringBuffer buff = request.getRequestURL();
        String uri = request.getRequestURI();
        String origUri = helper.getOriginatingRequestUri(request);
        buff.replace(buff.length() - uri.length(), buff.length(), origUri);
        String queryString = helper.getOriginatingQueryString(request);
        if (queryString != null) {
            buff.append("?").append(queryString);
        }
        try {
            return new String(buff.toString().getBytes(), "iso-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            return buff.toString();
        }
    }

    public static String getServerUrl(HttpServletRequest request) {
        String agreement = request.getScheme();
        String serverName = request.getServerName();
        int port = request.getServerPort();
        String contextPath = request.getContextPath();
        String url = "%s://%s%s%s";
        String portStr = "";
        if (port != 80) {
            portStr = portStr + ":" + port;
        }
        return String.format(url, agreement, serverName, portStr, contextPath);
    }

    static {
        HEADMAP.put("jpg", "image/jpeg");
        HEADMAP.put("bmp", "image/bmp");
        HEADMAP.put("jpeg", "image/jpeg");
        HEADMAP.put("png", "image/png");
        HEADMAP.put("gif", "image/gif");
        HEADMAP.put("mp3", "audio/mpeg");
        HEADMAP.put("wma", "audio/x-ms-wma");
        HEADMAP.put("wav", "audio/x-wav");
        HEADMAP.put("amr", "audio/amr");
        HEADMAP.put("mp4", "video/mpeg4");
    }
}

