/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.algorithm.common;

import cfca.sadk.algorithm.common.PKCSObjectIdentifiers;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.common.X9ObjectIdentifiers;
import java.util.HashMap;
import java.util.Map;

public class Mechanism {
    public static Map OIDALGMap = new HashMap();
    public static Map ALGOIDMap = new HashMap();
    public static final String RSA = "RSA";
    public static final String RSA_PKCS = "RSA/ECB/PKCS1PADDING";
    public static final String SM2 = "SM2";
    public static final String SM4_KEY = "SM4";
    public static final String SM4_CBC = "SM4/CBC/PKCS7Padding";
    public static final String SM4_ECB = "SM4/ECB/PKCS7Padding";
    public static final String RC4 = "RC4";
    public static final String RC4_KEY = "RC4";
    public static final String DES3_KEY = "DESede";
    public static final String DES3_ECB = "DESede/ECB/PKCS7Padding";
    public static final String DES3_CBC = "DESede/CBC/PKCS7Padding";
    public static final String AES_KEY = "AES";
    public static final String AES_ECB = "AES/ECB/PKCS7Padding";
    public static final String AES_CBC = "AES/CBC/PKCS7Padding";
    public static final String PBE_KEY = "PBEWithMD5AndDES";
    public static final String PBE_MD5_RC2_KEY = "PBEWithMD5AndRC2";
    public static final String PBE_SHA1_RC2_KEY = "PBEWithSHA1AndRC2";
    public static final String PBE_SHA1_DES_KEY = "PBEWithSHA1AndDES";
    public static final String PBE_2KEY = "PBEWITHSHAAND2-KEYTRIPLEDES-CBC";
    public static final String PBE_3KEY = "PBEWITHSHAAND3-KEYTRIPLEDES-CBC";
    public static final String PBE_40BITRC4KEY = "PBEWITHSHAAND40BITRC4";
    public static final String PBE_128BITRC4KEY = "PBEWITHSHAAND128BITRC4";
    public static final String PBE_MD5_DES = "PBEWithMD5AndDES";
    public static final String PBE_MD5_RC2 = "PBEWithMD5AndRC2";
    public static final String PBE_SHA1_DES = "PBEWithSHA1AndDES";
    public static final String PBE_SHA1_2DES = "PBEWITHSHAAND2-KEYTRIPLEDES-CBC";
    public static final String PBE_SHA1_3DES = "PBEWITHSHAAND3-KEYTRIPLEDES-CBC";
    public static final String PBE_SHA1_RC2 = "PBEWithSHA1AndRC2";
    public static final String PBE_SHA1_40BITRC4 = "PBEWITHSHAAND40BITRC4";
    public static final String PBE_SHA1_128BITRC4 = "PBEWITHSHAAND128BITRC4";
    public static final String MD2 = "MD2";
    public static final String MD4 = "MD4";
    public static final String MD5 = "MD5";
    public static final String RIPEMD128 = "RIPEMD128";
    public static final String RIPEMD160 = "RIPEMD160";
    public static final String RIPEMD256 = "RIPEMD256";
    public static final String SHA1 = "SHA-1";
    public static final String SHA244 = "SHA-244";
    public static final String SHA256 = "SHA-256";
    public static final String SHA384 = "SHA-384";
    public static final String SHA512 = "SHA-512";
    public static final String SM3 = "SM3";
    public static final String MD5_RSA = "md5WithRSAEncryption";
    public static final String SHA1_RSA = "sha1WithRSAEncryption";
    public static final String SHA256_RSA = "sha256WithRSAEncryption";
    public static final String SHA512_RSA = "sha512WithRSAEncryption";
    public static final String SM3_SM2 = "sm3WithSM2Encryption";
    public static final String SM3_SM2_OLD = "sm3WithSM2Encryption_OLD";
    public static final String MD2_RSA = "md2WithRSAEncryption";
    protected String mechanismType;
    protected Object param;

    public Mechanism(String mechanismType, Object param) {
        this.mechanismType = mechanismType;
        this.param = param;
    }

    public Mechanism(String mechanismType) {
        this.mechanismType = mechanismType;
        this.param = null;
    }

    public String getMechanismType() {
        return this.mechanismType;
    }

    public Object getParam() {
        return this.param;
    }

    public void setParam(Object param) {
        this.param = param;
    }

    public void setMechanismType(String mechanismType) {
        this.mechanismType = mechanismType;
    }

    public static Mechanism getMechanismFromDigestAlgotithm(String digestAlgorithm) throws PKIException {
        if (digestAlgorithm.equals(MD5)) {
            return new Mechanism(MD5_RSA);
        }
        if (digestAlgorithm.equals(SHA1)) {
            return new Mechanism(SHA1_RSA);
        }
        if (digestAlgorithm.equals(SHA256)) {
            return new Mechanism(SHA256_RSA);
        }
        if (digestAlgorithm.equals(SHA512)) {
            return new Mechanism(SHA512_RSA);
        }
        throw new PKIException("can not support this degest algorithm:" + digestAlgorithm);
    }

    public static boolean isDigestAlgorithmValid(String degestAlgorithm) {
        if (degestAlgorithm == null) {
            return false;
        }
        return degestAlgorithm.equals(MD5) || degestAlgorithm.equals(SHA1) || degestAlgorithm.equals(SHA256) || degestAlgorithm.equals(SHA512);
    }

    public static boolean isSymmetricAlgorithmValid(String symmetricAlgorithm) {
        if (symmetricAlgorithm == null) {
            return false;
        }
        return symmetricAlgorithm.equals(SM2) || symmetricAlgorithm.equals(RSA_PKCS) || symmetricAlgorithm.equals("RC4") || symmetricAlgorithm.equals(DES3_ECB) || symmetricAlgorithm.equals(DES3_CBC) || symmetricAlgorithm.equals(SM4_CBC) || symmetricAlgorithm.equals(SM4_ECB);
    }

    static {
        OIDALGMap.put(PKCSObjectIdentifiers.md5WithRSAEncryption, MD5_RSA);
        OIDALGMap.put(PKCSObjectIdentifiers.sha1WithRSAEncryption, SHA1_RSA);
        OIDALGMap.put(PKCSObjectIdentifiers.sha256WithRSAEncryption, SHA256_RSA);
        OIDALGMap.put(PKCSObjectIdentifiers.sha512WithRSAEncryption, SHA512_RSA);
        OIDALGMap.put(X9ObjectIdentifiers.sm3WithSM2Encryption, SM3_SM2);
        OIDALGMap.put(X9ObjectIdentifiers.sm3WithSM2Encryption_OLD, SM3_SM2_OLD);
        ALGOIDMap.put(MD5_RSA, PKCSObjectIdentifiers.md5WithRSAEncryption);
        ALGOIDMap.put(SHA1_RSA, PKCSObjectIdentifiers.sha1WithRSAEncryption);
        ALGOIDMap.put(SHA256_RSA, PKCSObjectIdentifiers.sha256WithRSAEncryption);
        ALGOIDMap.put(SHA512_RSA, PKCSObjectIdentifiers.sha512WithRSAEncryption);
        ALGOIDMap.put(SM3_SM2, X9ObjectIdentifiers.sm3WithSM2Encryption);
        ALGOIDMap.put(SM3_SM2_OLD, X9ObjectIdentifiers.sm3WithSM2Encryption_OLD);
    }
}

