/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.algorithm.sm2;

import cfca.sadk.algorithm.util.BigIntegerUtil;
import cfca.sadk.org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import cfca.sadk.org.bouncycastle.crypto.params.ECDomainParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import cfca.sadk.org.bouncycastle.math.ec.ECCurve;
import cfca.sadk.org.bouncycastle.math.ec.ECFieldElement;
import cfca.sadk.org.bouncycastle.math.ec.ECPoint;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SM2Param {
    public static String[] sm2_param = new String[]{"FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF", "FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC", "28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93", "FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123", "32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7", "BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0"};
    private static BigInteger p = new BigInteger(sm2_param[0], 16);
    private static BigInteger a = new BigInteger(sm2_param[1], 16);
    private static BigInteger b = new BigInteger(sm2_param[2], 16);
    private static BigInteger n = new BigInteger(sm2_param[3], 16);
    private static BigInteger Gx = new BigInteger(sm2_param[4], 16);
    private static BigInteger Gy = new BigInteger(sm2_param[5], 16);
    public static BigInteger ecc_p = p;
    public static BigInteger ecc_a = a;
    public static BigInteger ecc_b = b;
    public static BigInteger ecc_n = n;
    public static BigInteger ecc_gx = Gx;
    public static BigInteger ecc_gy = Gy;
    public static ECFieldElement ecc_gx_fieldelement = new ECFieldElement.Fp(ecc_p, ecc_gx);
    public static ECFieldElement ecc_gy_fieldelement = new ECFieldElement.Fp(ecc_p, ecc_gy);
    public static ECCurve ecc_curve = new ECCurve.Fp(ecc_p, ecc_a, ecc_b);
    public static ECPoint ecc_point_g = new ECPoint.Fp(ecc_curve, ecc_gx_fieldelement, ecc_gy_fieldelement);
    public static ECDomainParameters ecc_bc_spec = new ECDomainParameters(ecc_curve, ecc_point_g, ecc_n);
    public ECKeyGenerationParameters ecc_ecgenparam;
    public ECKeyPairGenerator ecc_key_pair_generator;

    public SM2Param() {
        this.init();
    }

    public void init() {
        this.ecc_ecgenparam = new ECKeyGenerationParameters(ecc_bc_spec, new SecureRandom());
        this.ecc_key_pair_generator = new ECKeyPairGenerator();
        this.ecc_key_pair_generator.init(this.ecc_ecgenparam);
    }

    public static BigInteger getBigIntegerGx() {
        return Gx;
    }

    public static BigInteger getBigIntegerGy() {
        return Gy;
    }

    public static byte[] getP() {
        return BigIntegerUtil.asUnsigned32ByteArray(p);
    }

    public static byte[] getA() {
        return BigIntegerUtil.asUnsigned32ByteArray(a);
    }

    public static byte[] getB() {
        return BigIntegerUtil.asUnsigned32ByteArray(b);
    }

    public static byte[] getN() {
        return BigIntegerUtil.asUnsigned32ByteArray(n);
    }

    public static byte[] getGx() {
        return BigIntegerUtil.asUnsigned32ByteArray(Gx);
    }

    public static byte[] getGy() {
        return BigIntegerUtil.asUnsigned32ByteArray(Gy);
    }
}

