/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.algorithm.sm2;

import cfca.sadk.algorithm.util.BigEndianUtil;
import cfca.sadk.algorithm.util.BitRotateUtil;
import java.math.BigInteger;

class SM3 {
    public static final byte[] iv;
    public static int[] Tj;

    SM3() {
    }

    public static byte[] CF(byte[] V, byte[] B) {
        int[] v = SM3.convert(V);
        int[] b = SM3.convert(B);
        return SM3.convert(SM3.CF(v, b));
    }

    private static int[] convert(byte[] arr) {
        int[] out = new int[arr.length / 4];
        byte[] tmp = new byte[4];
        for (int i = 0; i < arr.length; i += 4) {
            System.arraycopy(arr, i, tmp, 0, 4);
            out[i / 4] = BigEndianUtil.bigEndianByteToInt(tmp);
        }
        return out;
    }

    private static byte[] convert(int[] arr) {
        byte[] out = new byte[arr.length * 4];
        byte[] tmp = null;
        for (int i = 0; i < arr.length; ++i) {
            tmp = BigEndianUtil.bigEndianIntToByte(arr[i]);
            System.arraycopy(tmp, 0, out, i * 4, 4);
        }
        return out;
    }

    public static int[] CF(int[] V, int[] B) {
        int a = V[0];
        int b = V[1];
        int c = V[2];
        int d = V[3];
        int e = V[4];
        int f = V[5];
        int g = V[6];
        int h = V[7];
        int[][] arr = SM3.expand(B);
        int[] w = arr[0];
        int[] w1 = arr[1];
        for (int j = 0; j < 64; ++j) {
            int tt1;
            long ss1_l = BitRotateUtil.bitCycleLeft(a, 12) + e + BitRotateUtil.bitCycleLeft(Tj[j], j);
            int ss1 = (int)(ss1_l & 0xFFFFFFFFFFFFFFFFL);
            ss1 = BitRotateUtil.bitCycleLeft(ss1, 7);
            int ss2 = ss1 ^ BitRotateUtil.bitCycleLeft(a, 12);
            long tt1_l = SM3.FFj(a, b, c, j) + d + ss2 + w1[j];
            long tt2_l = SM3.GGj(e, f, g, j) + h + ss1 + w[j];
            d = c;
            c = BitRotateUtil.bitCycleLeft(b, 9);
            b = a;
            a = tt1 = (int)(tt1_l & 0xFFFFFFFFFFFFFFFFL);
            h = g;
            g = BitRotateUtil.bitCycleLeft(f, 19);
            f = e;
            int tt2 = (int)(tt2_l & 0xFFFFFFFFFFFFFFFFL);
            e = SM3.P0(tt2);
        }
        int[] out = new int[]{a ^ V[0], b ^ V[1], c ^ V[2], d ^ V[3], e ^ V[4], f ^ V[5], g ^ V[6], h ^ V[7]};
        return out;
    }

    private static int[][] expand(int[] B) {
        int i;
        int[] W = new int[68];
        int[] W1 = new int[64];
        for (i = 0; i < B.length; ++i) {
            W[i] = B[i];
        }
        for (i = 16; i < 68; ++i) {
            W[i] = SM3.P1(W[i - 16] ^ W[i - 9] ^ BitRotateUtil.bitCycleLeft(W[i - 3], 15)) ^ BitRotateUtil.bitCycleLeft(W[i - 13], 7) ^ W[i - 6];
        }
        for (i = 0; i < 64; ++i) {
            W1[i] = W[i] ^ W[i + 4];
        }
        int[][] arr = new int[][]{W, W1};
        return arr;
    }

    private static int FFj(int X, int Y, int Z, int j) {
        if (j >= 0 && j <= 15) {
            return SM3.FF1j(X, Y, Z);
        }
        return SM3.FF2j(X, Y, Z);
    }

    private static int GGj(int X, int Y, int Z, int j) {
        if (j >= 0 && j <= 15) {
            return SM3.GG1j(X, Y, Z);
        }
        return SM3.GG2j(X, Y, Z);
    }

    private static int FF1j(int X, int Y, int Z) {
        int tmp = X ^ Y ^ Z;
        return tmp;
    }

    private static int FF2j(int X, int Y, int Z) {
        int tmp = X & Y | X & Z | Y & Z;
        return tmp;
    }

    private static int GG1j(int X, int Y, int Z) {
        int tmp = X ^ Y ^ Z;
        return tmp;
    }

    private static int GG2j(int X, int Y, int Z) {
        int tmp = X & Y | ~X & Z;
        return tmp;
    }

    private static int P0(int X) {
        int y = BitRotateUtil.bitCycleLeft(X, 9);
        int z = BitRotateUtil.bitCycleLeft(X, 17);
        int t = X ^ y ^ z;
        return t;
    }

    private static int P1(int X) {
        int t = X ^ BitRotateUtil.bitCycleLeft(X, 15) ^ BitRotateUtil.bitCycleLeft(X, 23);
        return t;
    }

    public static byte[] padding(byte[] in, int bLen) {
        int k = 448 - (8 * in.length + 1) % 512;
        if (k < 0) {
            k = 960 - (8 * in.length + 1) % 512;
        }
        byte[] padd = new byte[++k / 8];
        padd[0] = -128;
        long n = in.length * 8 + bLen * 512;
        byte[] out = new byte[in.length + k / 8 + 8];
        int pos = 0;
        System.arraycopy(in, 0, out, 0, in.length);
        System.arraycopy(padd, 0, out, pos += in.length, padd.length);
        byte[] tmp = BigEndianUtil.bigEndianLongTobyte(n);
        System.arraycopy(tmp, 0, out, pos += padd.length, tmp.length);
        return out;
    }

    static {
        int i;
        iv = new BigInteger("7380166f4914b2b9172442d7da8a0600a96f30bc163138aae38dee4db0fb0e4e", 16).toByteArray();
        Tj = new int[64];
        for (i = 0; i < 16; ++i) {
            SM3.Tj[i] = 2043430169;
        }
        for (i = 16; i < 64; ++i) {
            SM3.Tj[i] = 2055708042;
        }
    }
}

