/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.algorithm.util;

import cfca.sadk.algorithm.common.PKCSObjectIdentifiers;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.asn1.parser.ASN1Parser;
import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.ASN1OutputStream;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.ASN1Set;
import cfca.sadk.org.bouncycastle.asn1.DEROutputStream;
import cfca.sadk.org.bouncycastle.asn1.DERSet;
import cfca.sadk.org.bouncycastle.asn1.pkcs.ContentInfo;
import cfca.sadk.org.bouncycastle.asn1.pkcs.SignedData;
import cfca.sadk.org.bouncycastle.asn1.x509.Certificate;
import cfca.sadk.util.Base64;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;

public class P7BParser {
    private static ContentInfo generateP7B(X509Cert[] certs) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        for (int i = 0; i < certs.length; ++i) {
            Certificate certStruc = certs[i].getCertStructure();
            v.add(certStruc);
        }
        DERSet certSet = new DERSet(v);
        DERSet algs = new DERSet();
        DERSet signerInfos = new DERSet();
        ContentInfo ci = new ContentInfo(PKCSObjectIdentifiers.data, null);
        SignedData signedData = new SignedData(new ASN1Integer(1L), algs, ci, certSet, null, signerInfos);
        ContentInfo contentInfo = new ContentInfo(PKCSObjectIdentifiers.signedData, signedData);
        return contentInfo;
    }

    public static void generateP7BFile(X509Cert[] certs, String filePath) throws PKIException {
        ContentInfo contentInfo = P7BParser.generateP7B(certs);
        FileOutputStream fos = null;
        ASN1OutputStream dos = null;
        try {
            fos = new FileOutputStream(filePath);
            dos = new DEROutputStream(fos);
            ((DEROutputStream)dos).writeObject(contentInfo.toASN1Primitive());
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.GEN_P7B_ERR, PKIException.GEN_P7B_ERR_DES, ex);
        }
        finally {
            try {
                dos.close();
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void generateP7BFile(X509Cert[] x509Certs, OutputStream os) throws PKIException {
        ContentInfo contentInfo = P7BParser.generateP7B(x509Certs);
        DEROutputStream dos = null;
        try {
            dos = new DEROutputStream(os);
            dos.writeObject(contentInfo.toASN1Primitive());
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.GEN_P7B_ERR, PKIException.GEN_P7B_ERR_DES, ex);
        }
        finally {
            try {
                dos.close();
                os.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static byte[] generateP7BData(X509Cert[] certs) throws PKIException {
        ContentInfo contentInfo = P7BParser.generateP7B(certs);
        ByteArrayOutputStream bos = null;
        ASN1OutputStream dos = null;
        try {
            byte[] b64Data;
            bos = new ByteArrayOutputStream();
            dos = new DEROutputStream(bos);
            ((DEROutputStream)dos).writeObject(contentInfo.toASN1Primitive());
            byte[] noB64Data = bos.toByteArray();
            byte[] byArray = b64Data = Base64.encode(noB64Data);
            return byArray;
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.GEN_P7B_ERR, PKIException.GEN_P7B_ERR_DES, ex);
        }
        finally {
            try {
                dos.close();
                bos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static X509Cert[] parseP7B(byte[] p7bData) throws PKIException {
        boolean isBase64 = ASN1Parser.isBase64Compatability(p7bData);
        if (isBase64) {
            p7bData = Base64.decode(p7bData);
        }
        if (p7bData[0] != 48) {
            throw new PKIException(PKIException.PARSE_P7B_ERR, PKIException.PARSE_P7B_ERR_DES, new Exception("The P7B certification chain content error."));
        }
        ASN1Sequence sequence = (ASN1Sequence)ASN1Parser.parseBytes2DERObj(p7bData);
        ContentInfo contentInfo = ContentInfo.getInstance(sequence);
        if (!contentInfo.getContentType().equals(PKCSObjectIdentifiers.signedData)) {
            throw new PKIException(PKIException.PARSE_P7B_ERR, PKIException.PARSE_P7B_ERR_DES + " " + PKIException.PARSE_P7B_ERR_FORMAT_DES + " " + contentInfo.getContentType().getId());
        }
        SignedData signedData = SignedData.getInstance(contentInfo.getContent());
        ASN1Set certSet = signedData.getCertificates();
        Enumeration enumeration = certSet.getObjects();
        Vector<X509Cert> v = new Vector<X509Cert>();
        X509Cert cert = null;
        while (enumeration.hasMoreElements()) {
            Certificate certStruc = Certificate.getInstance(enumeration.nextElement());
            cert = new X509Cert(certStruc);
            v.add(cert);
        }
        X509Cert[] certs = new X509Cert[v.size()];
        v.toArray(certs);
        return certs;
    }

    public static X509Cert[] parseP7B(String p7bFilePath) throws IOException, PKIException {
        FileInputStream fis = new FileInputStream(p7bFilePath);
        return P7BParser.parseP7B(fis);
    }

    public static X509Cert[] parseP7B(InputStream is) throws IOException, PKIException {
        byte[] p7bData = new byte[is.available()];
        is.read(p7bData);
        is.close();
        return P7BParser.parseP7B(p7bData);
    }
}

