/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.jni;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.sm2.SM2Param;
import cfca.sadk.algorithm.sm2.SM2PrivateKey;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.algorithm.util.BigFileCipherUtil;
import cfca.sadk.algorithm.util.HashEncoderUtil;
import cfca.sadk.algorithm.util.RSAAndItsCloseSymAlgUtil;
import cfca.sadk.algorithm.util.SM2AndItsCloseSymAlgUtil;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.jni.JNISM2;
import cfca.sadk.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import cfca.sadk.org.bouncycastle.math.ec.ECFieldElement;
import cfca.sadk.org.bouncycastle.math.ec.ECPoint;
import cfca.sadk.signature.rsa.RSAPackageUtil;
import cfca.sadk.signature.sm2.SM2PackageUtil;
import cfca.sadk.system.global.SM2ContextConfig;
import cfca.sadk.util.HashUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import javax.crypto.spec.SecretKeySpec;

public class JNISoftLib
implements Session {
    public KeyPair generateKeyPair(Mechanism mechanism, int keyLength) throws PKIException {
        try {
            if (mechanism.getMechanismType().equals("SM2")) {
                byte[] da = new byte[32];
                byte[] pubx = new byte[32];
                byte[] puby = new byte[32];
                try {
                    JNISM2.generateKeypair(da, pubx, puby);
                }
                catch (Exception e) {
                    throw new PKIException(e.getMessage());
                }
                BigInteger ecc_px = new BigInteger(1, pubx);
                BigInteger ecc_py = new BigInteger(1, puby);
                ECFieldElement.Fp ecc_px_fieldelement = new ECFieldElement.Fp(SM2Param.ecc_p, ecc_px);
                ECFieldElement.Fp ecc_py_fieldelement = new ECFieldElement.Fp(SM2Param.ecc_p, ecc_py);
                ECPoint.Fp pubPoint = new ECPoint.Fp(SM2Param.ecc_curve, ecc_px_fieldelement, ecc_py_fieldelement);
                ECPublicKeyParameters pub = new ECPublicKeyParameters(pubPoint, SM2Param.ecc_bc_spec);
                BigInteger d = new BigInteger(1, da);
                ECPrivateKeyParameters priv = new ECPrivateKeyParameters(d, SM2Param.ecc_bc_spec);
                SM2PublicKey pubKey = new SM2PublicKey(pub);
                SM2PrivateKey priKey = new SM2PrivateKey(priv);
                priKey.setSM2PublicKey(pubKey);
                return new KeyPair(pubKey, priKey);
            }
            if (mechanism.getMechanismType().equals("RSA")) {
                KeyPairGenerator keyPairGen = null;
                try {
                    keyPairGen = KeyPairGenerator.getInstance("RSA");
                }
                catch (Exception e) {
                    return null;
                }
                if (keyLength != 1024 && keyLength != 2048 && keyLength != 4096) {
                    keyLength = 1024;
                }
                keyPairGen.initialize(keyLength);
                KeyPair keyPair = keyPairGen.generateKeyPair();
                return keyPair;
            }
            throw new PKIException(PKIException.JNI_KEY_PAIR, PKIException.JNI_KEY_PAIR_DES + " " + PKIException.NOT_SUP_DES + mechanism.getMechanismType());
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public byte[] sign(Mechanism mechanism, PrivateKey priKey, byte[] sourceData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("md5WithRSAEncryption") || mType.equals("sha1WithRSAEncryption") || mType.equals("sha256WithRSAEncryption") || mType.equals("sha512WithRSAEncryption") || mType.equals("sm3WithSM2Encryption"))) {
            throw new PKIException(PKIException.SIGN, PKIException.SIGN_DES + " " + PKIException.NOT_SUP_DES + " " + mType);
        }
        if (sourceData == null) {
            throw new PKIException("the source data is null!");
        }
        try {
            if (mType.equals("sm3WithSM2Encryption")) {
                SM2PublicKey sm2PubKey = null;
                SM2PrivateKey sm2priKey = null;
                if (!(priKey instanceof SM2PrivateKey)) {
                    throw new PKIException("The private key type is not sm2 type!");
                }
                sm2priKey = (SM2PrivateKey)priKey;
                byte[] out = null;
                if (SM2ContextConfig.getUseZValue()) {
                    sm2PubKey = sm2priKey.getSM2PublicKey();
                    byte[] pubX = sm2PubKey.getPubXByBytes();
                    byte[] pubY = sm2PubKey.getPubYByBytes();
                    out = HashUtil.SM2HashMessageByJNIWithZValue(null, sourceData, pubX, pubY);
                } else {
                    out = HashUtil.SM2HashMessageByJNIWithoutZValue(sourceData);
                }
                return SM2PackageUtil.encryptByJNI(out, sm2priKey.getDByInt());
            }
            byte[] out = HashUtil.RSAHashMessageByJNI(sourceData, mechanism, true);
            return RSAPackageUtil.encryptByJNI(out, priKey);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.SIGN, PKIException.SIGN_DES, e);
        }
    }

    public byte[] sign(Mechanism mechanism, PrivateKey priKey, InputStream sourceStream) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("md5WithRSAEncryption") || mType.equals("sha1WithRSAEncryption") || mType.equals("sha256WithRSAEncryption") || mType.equals("sha512WithRSAEncryption") || mType.equals("sm3WithSM2Encryption"))) {
            throw new PKIException(PKIException.SIGN, PKIException.SIGN_DES + " " + PKIException.NOT_SUP_DES + " " + mType);
        }
        try {
            if (mType.equals("sm3WithSM2Encryption")) {
                SM2PublicKey sm2PubKey = null;
                SM2PrivateKey sm2priKey = null;
                if (!(priKey instanceof SM2PrivateKey)) {
                    throw new PKIException("The private key type is not sm2 type!");
                }
                sm2priKey = (SM2PrivateKey)priKey;
                byte[] out = null;
                if (SM2ContextConfig.getUseZValue()) {
                    sm2PubKey = sm2priKey.getSM2PublicKey();
                    byte[] pubX = sm2PubKey.getPubXByBytes();
                    byte[] pubY = sm2PubKey.getPubYByBytes();
                    out = HashUtil.SM2HashFileByJNIWithZValue(null, sourceStream, pubX, pubY);
                } else {
                    out = HashUtil.SM2HashFileByJNIWithoutZValue(sourceStream);
                }
                return SM2PackageUtil.encryptByJNI(out, sm2priKey.getDByInt());
            }
            byte[] digestData = HashUtil.RSAHashFileByJNI(sourceStream, mechanism, true);
            return RSAPackageUtil.encryptByJNI(digestData, priKey);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.SIGN, PKIException.SIGN_DES, e);
        }
    }

    public boolean verify(Mechanism mechanism, PublicKey pubKey, byte[] sourceData, byte[] signData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("md5WithRSAEncryption") || mType.equals("sha1WithRSAEncryption") || mType.equals("sha256WithRSAEncryption") || mType.equals("sha512WithRSAEncryption") || mType.equals("sm3WithSM2Encryption"))) {
            throw new PKIException(PKIException.SIGN, PKIException.SIGN_DES + " " + PKIException.NOT_SUP_DES + " " + mType);
        }
        try {
            if (mType.equals("sm3WithSM2Encryption")) {
                SM2PublicKey sm2PubKey = (SM2PublicKey)pubKey;
                byte[] pubX = sm2PubKey.getPubXByBytes();
                byte[] pubY = sm2PubKey.getPubYByBytes();
                byte[] hashData = null;
                hashData = SM2ContextConfig.getUseZValue() ? HashUtil.SM2HashMessageByJNIWithZValue(null, sourceData, pubX, pubY) : HashUtil.SM2HashMessageByJNIWithoutZValue(sourceData);
                return SM2PackageUtil.verifyByJNI(hashData, signData, pubX, pubY);
            }
            byte[] hashData = HashUtil.RSAHashMessageByJNI(sourceData, mechanism, true);
            byte[] sig = RSAPackageUtil.decryptByJNI(signData, pubKey);
            return RSAPackageUtil.isRSAHashEqual(sig, hashData);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.VERIFY_SIGN, PKIException.VERIFY_SIGN_DES, e);
        }
    }

    public boolean verify(Mechanism mechanism, PublicKey pubKey, InputStream sourceStream, byte[] signData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("md5WithRSAEncryption") || mType.equals("sha1WithRSAEncryption") || mType.equals("sha256WithRSAEncryption") || mType.equals("sha512WithRSAEncryption") || mType.equals("sm3WithSM2Encryption"))) {
            throw new PKIException(PKIException.SIGN, PKIException.SIGN_DES + " " + PKIException.NOT_SUP_DES + " " + mType);
        }
        try {
            if (mType.equals("sm3WithSM2Encryption")) {
                SM2PublicKey sm2PubKey = (SM2PublicKey)pubKey;
                byte[] pubX = sm2PubKey.getPubXByBytes();
                byte[] pubY = sm2PubKey.getPubYByBytes();
                byte[] out = null;
                out = SM2ContextConfig.getUseZValue() ? HashUtil.SM2HashFileByJNIWithZValue(null, sourceStream, pubX, pubY) : HashUtil.SM2HashFileByJNIWithoutZValue(sourceStream);
                return SM2PackageUtil.verifyByJNI(out, signData, pubX, pubY);
            }
            byte[] hashData = HashUtil.RSAHashFileByJNI(sourceStream, mechanism, true);
            byte[] sig = RSAPackageUtil.decryptByJNI(signData, pubKey);
            return RSAPackageUtil.isRSAHashEqual(sig, hashData);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.VERIFY_SIGN, PKIException.VERIFY_SIGN_DES, e);
        }
    }

    public byte[] encrypt(Mechanism mechanism, Key key, byte[] sourceData) throws PKIException {
        try {
            String mType = mechanism.getMechanismType();
            if (mType.equals("SM2")) {
                return SM2AndItsCloseSymAlgUtil.sm2EncryptByJNI(true, key, sourceData);
            }
            if (mType.equals("RSA/ECB/PKCS1PADDING")) {
                return RSAAndItsCloseSymAlgUtil.rsaEncryptByJNI(true, key, sourceData);
            }
            if (mType.equals("DESede/CBC/PKCS7Padding") || mType.equals("DESede/ECB/PKCS7Padding") || mType.equals("RC4")) {
                return RSAAndItsCloseSymAlgUtil.crypto(true, true, key.getEncoded(), sourceData, mechanism);
            }
            if (mType.equals("SM4/ECB/PKCS7Padding") || mType.equals("SM4/CBC/PKCS7Padding")) {
                return SM2AndItsCloseSymAlgUtil.crypto(true, true, key.getEncoded(), sourceData, mechanism);
            }
            throw new PKIException(PKIException.ENCRYPT, PKIException.ENCRYPT_DES + " " + PKIException.NOT_SUP_DES + mType);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.ENCRYPT, PKIException.ENCRYPT_DES, e);
        }
    }

    public byte[] decrypt(Mechanism mechanism, Key key, byte[] encryptData) throws PKIException {
        try {
            String mType = mechanism.getMechanismType();
            if (mType.equals("SM2")) {
                return SM2AndItsCloseSymAlgUtil.sm2EncryptByJNI(false, key, encryptData);
            }
            if (mType.equals("RSA/ECB/PKCS1PADDING")) {
                return RSAAndItsCloseSymAlgUtil.rsaEncryptByJNI(false, key, encryptData);
            }
            if (mType.equals("DESede/CBC/PKCS7Padding") || mType.equals("DESede/ECB/PKCS7Padding") || mType.equals("RC4")) {
                return RSAAndItsCloseSymAlgUtil.crypto(true, false, key.getEncoded(), encryptData, mechanism);
            }
            if (mType.equals("SM4/ECB/PKCS7Padding") || mType.equals("SM4/CBC/PKCS7Padding")) {
                return SM2AndItsCloseSymAlgUtil.crypto(true, false, key.getEncoded(), encryptData, mechanism);
            }
            throw new PKIException(PKIException.DECRYPT, PKIException.DECRYPT_DES + " " + PKIException.NOT_SUP_DES + mType);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.DECRYPT, PKIException.DECRYPT_DES, e);
        }
    }

    public byte[] signByHash(Mechanism mechanim, PrivateKey priKey, byte[] digest) throws PKIException {
        String signAlg = mechanim.getMechanismType();
        if (!(signAlg.equals("md5WithRSAEncryption") || signAlg.equals("sha1WithRSAEncryption") || signAlg.equals("sha256WithRSAEncryption") || signAlg.equals("sha512WithRSAEncryption") || signAlg.equals("sm3WithSM2Encryption"))) {
            throw new PKIException(PKIException.SIGN, PKIException.SIGN_DES + " " + PKIException.NOT_SUP_DES + " " + signAlg);
        }
        if (digest == null) {
            throw new PKIException("the hash data is null!");
        }
        try {
            if (signAlg.equals("sm3WithSM2Encryption")) {
                SM2PrivateKey sm2priKey = null;
                if (!(priKey instanceof SM2PrivateKey)) {
                    throw new PKIException("The private key type is not sm2 type!");
                }
                sm2priKey = (SM2PrivateKey)priKey;
                return SM2PackageUtil.encryptByJNI(digest, sm2priKey.getDByInt());
            }
            byte[] derDigest = HashEncoderUtil.derEncoder(signAlg, digest);
            return RSAPackageUtil.encryptByJNI(derDigest, priKey);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.SIGN, PKIException.SIGN_DES, e);
        }
    }

    public boolean verifyByHash(Mechanism signAlg, PublicKey pubKey, byte[] digest, byte[] signData) throws PKIException {
        String mType = signAlg.getMechanismType();
        if (!(mType.equals("md5WithRSAEncryption") || mType.equals("sha1WithRSAEncryption") || mType.equals("sha256WithRSAEncryption") || mType.equals("sha512WithRSAEncryption") || mType.equals("sm3WithSM2Encryption"))) {
            throw new PKIException(PKIException.SIGN, PKIException.SIGN_DES + " " + PKIException.NOT_SUP_DES + " " + mType);
        }
        try {
            if (mType.equals("sm3WithSM2Encryption")) {
                SM2PublicKey sm2PubKey = (SM2PublicKey)pubKey;
                byte[] pubX = sm2PubKey.getPubXByBytes();
                byte[] pubY = sm2PubKey.getPubYByBytes();
                return SM2PackageUtil.verifyByJNI(digest, signData, pubX, pubY);
            }
            byte[] sig = RSAPackageUtil.decryptByJNI(signData, pubKey);
            byte[] derDigest = HashEncoderUtil.derEncoder(mType, digest);
            return RSAPackageUtil.isRSAHashEqual(sig, derDigest);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.VERIFY_SIGN, PKIException.VERIFY_SIGN_DES, e);
        }
    }

    public void encrypt(Mechanism encryptAlg, Key key, InputStream sourceStream, OutputStream encryptStream) throws PKIException {
        try {
            BigFileCipherUtil.bigFileBlockCipher(true, encryptAlg, key.getEncoded(), sourceStream, encryptStream);
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public void decrypt(Mechanism encryptAlg, Key key, InputStream encryptStream, OutputStream plainTextStream) throws PKIException {
        try {
            BigFileCipherUtil.bigFileBlockCipher(false, encryptAlg, key.getEncoded(), encryptStream, plainTextStream);
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public Key generateKey(Mechanism keyType) throws PKIException {
        String type = keyType.getMechanismType();
        SecureRandom random = new SecureRandom();
        if (type.equals("DESede")) {
            byte[] keyData = new byte[24];
            random.nextBytes(keyData);
            SecretKeySpec key = new SecretKeySpec(keyData, type);
            return key;
        }
        if (type.equals("SM4")) {
            byte[] keyData = new byte[16];
            random.nextBytes(keyData);
            SecretKeySpec key = new SecretKeySpec(keyData, type);
            return key;
        }
        if (type.equals("RC4")) {
            byte[] keyData = new byte[16];
            random.nextBytes(keyData);
            SecretKeySpec key = new SecretKeySpec(keyData, type);
            return key;
        }
        throw new PKIException("do not support this key type:" + type);
    }

    public Key generateKey(Mechanism keyType, byte[] keyData) throws PKIException {
        return null;
    }

    public Provider getProvider() {
        return null;
    }

    public String getProviderName() {
        return null;
    }
}

