/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.asn1.test;

import cfca.sadk.org.bouncycastle.asn1.ASN1InputStream;
import cfca.sadk.org.bouncycastle.asn1.ASN1OctetString;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import cfca.sadk.org.bouncycastle.asn1.icao.DataGroupHash;
import cfca.sadk.org.bouncycastle.util.test.SimpleTest;
import java.io.IOException;
import java.util.Random;

public class DataGroupHashUnitTest
extends SimpleTest {
    public String getName() {
        return "DataGroupHash";
    }

    private byte[] generateHash() {
        Random rand = new Random();
        byte[] bytes = new byte[20];
        for (int i = 0; i != bytes.length; ++i) {
            bytes[i] = (byte)rand.nextInt();
        }
        return bytes;
    }

    public void performTest() throws Exception {
        int dataGroupNumber = 1;
        DEROctetString dataHash = new DEROctetString(this.generateHash());
        DataGroupHash dg = new DataGroupHash(dataGroupNumber, dataHash);
        this.checkConstruction(dg, dataGroupNumber, dataHash);
        try {
            DataGroupHash.getInstance(null);
        }
        catch (Exception e) {
            this.fail("getInstance() failed to handle null.");
        }
        try {
            DataGroupHash.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    private void checkConstruction(DataGroupHash dg, int dataGroupNumber, ASN1OctetString dataGroupHashValue) throws IOException {
        this.checkValues(dg, dataGroupNumber, dataGroupHashValue);
        dg = DataGroupHash.getInstance(dg);
        this.checkValues(dg, dataGroupNumber, dataGroupHashValue);
        ASN1InputStream aIn = new ASN1InputStream(dg.toASN1Object().getEncoded());
        ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
        dg = DataGroupHash.getInstance(seq);
        this.checkValues(dg, dataGroupNumber, dataGroupHashValue);
    }

    private void checkValues(DataGroupHash dg, int dataGroupNumber, ASN1OctetString dataGroupHashValue) {
        if (dg.getDataGroupNumber() != dataGroupNumber) {
            this.fail("group number don't match.");
        }
        if (!dg.getDataGroupHashValue().equals(dataGroupHashValue)) {
            this.fail("hash value don't match.");
        }
    }

    public static void main(String[] args) {
        DataGroupHashUnitTest.runTest(new DataGroupHashUnitTest());
    }
}

