/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.asn1.test;

import cfca.sadk.org.bouncycastle.asn1.ASN1InputStream;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.ess.OtherCertID;
import cfca.sadk.org.bouncycastle.asn1.ess.OtherSigningCertificate;
import cfca.sadk.org.bouncycastle.asn1.test.ASN1UnitTest;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import java.io.IOException;

public class OtherSigningCertificateUnitTest
extends ASN1UnitTest {
    public String getName() {
        return "OtherSigningCertificate";
    }

    public void performTest() throws Exception {
        AlgorithmIdentifier algId = new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.2.3"));
        byte[] digest = new byte[20];
        OtherCertID otherCertID = new OtherCertID(algId, digest);
        OtherSigningCertificate otherCert = new OtherSigningCertificate(otherCertID);
        this.checkConstruction(otherCert, otherCertID);
        otherCert = OtherSigningCertificate.getInstance(null);
        if (otherCert != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            OtherCertID.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    private void checkConstruction(OtherSigningCertificate otherCert, OtherCertID otherCertID) throws IOException {
        this.checkValues(otherCert, otherCertID);
        otherCert = OtherSigningCertificate.getInstance(otherCert);
        this.checkValues(otherCert, otherCertID);
        ASN1InputStream aIn = new ASN1InputStream(otherCert.toASN1Object().getEncoded());
        ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
        otherCert = OtherSigningCertificate.getInstance(seq);
        this.checkValues(otherCert, otherCertID);
    }

    private void checkValues(OtherSigningCertificate otherCert, OtherCertID otherCertID) {
        if (otherCert.getCerts().length != 1) {
            this.fail("getCerts() length wrong");
        }
        this.checkMandatoryField("getCerts()[0]", otherCertID, otherCert.getCerts()[0]);
    }

    public static void main(String[] args) {
        OtherSigningCertificateUnitTest.runTest(new OtherSigningCertificateUnitTest());
    }
}

