/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.asn1.test;

import cfca.sadk.org.bouncycastle.asn1.ASN1InputStream;
import cfca.sadk.org.bouncycastle.asn1.DERBitString;
import cfca.sadk.org.bouncycastle.asn1.cmp.PKIFailureInfo;
import cfca.sadk.org.bouncycastle.asn1.test.BitStringConstantTester;
import cfca.sadk.org.bouncycastle.util.encoders.Base64;
import cfca.sadk.org.bouncycastle.util.test.SimpleTest;
import java.io.IOException;

public class PKIFailureInfoTest
extends SimpleTest {
    private static final byte[] CORRECT_FAILURE_INFO = Base64.decode("AwIANQ==");

    public String getName() {
        return "PKIFailureInfo";
    }

    private void testEncoding() throws IOException {
        DERBitString bitString = (DERBitString)new ASN1InputStream(CORRECT_FAILURE_INFO).readObject();
        PKIFailureInfo correct = new PKIFailureInfo(bitString);
        PKIFailureInfo bug = new PKIFailureInfo(53);
        if (!this.areEqual(correct.getEncoded("DER"), bug.getEncoded("DER"))) {
            this.fail("encoding doesn't match");
        }
    }

    public void performTest() throws IOException {
        BitStringConstantTester.testFlagValueCorrect(0, 128);
        BitStringConstantTester.testFlagValueCorrect(1, 64);
        BitStringConstantTester.testFlagValueCorrect(2, 32);
        BitStringConstantTester.testFlagValueCorrect(3, 16);
        BitStringConstantTester.testFlagValueCorrect(4, 8);
        BitStringConstantTester.testFlagValueCorrect(5, 4);
        BitStringConstantTester.testFlagValueCorrect(6, 2);
        BitStringConstantTester.testFlagValueCorrect(7, 1);
        BitStringConstantTester.testFlagValueCorrect(8, 32768);
        BitStringConstantTester.testFlagValueCorrect(9, 16384);
        BitStringConstantTester.testFlagValueCorrect(14, 512);
        BitStringConstantTester.testFlagValueCorrect(15, 256);
        BitStringConstantTester.testFlagValueCorrect(16, 0x800000);
        BitStringConstantTester.testFlagValueCorrect(17, 0x400000);
        BitStringConstantTester.testFlagValueCorrect(25, 0x40000000);
        this.testEncoding();
    }

    public static void main(String[] args) {
        PKIFailureInfoTest.runTest(new PKIFailureInfoTest());
    }
}

