/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.asn1.test;

import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1InputStream;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.DERSequence;
import cfca.sadk.org.bouncycastle.asn1.DERTaggedObject;
import cfca.sadk.org.bouncycastle.asn1.DERUTF8String;
import cfca.sadk.org.bouncycastle.asn1.esf.SignerLocation;
import cfca.sadk.org.bouncycastle.util.test.SimpleTest;
import java.io.IOException;

public class SignerLocationUnitTest
extends SimpleTest {
    public String getName() {
        return "SignerLocation";
    }

    public void performTest() throws Exception {
        DERUTF8String countryName = new DERUTF8String("Australia");
        SignerLocation sl = new SignerLocation(countryName, null, null);
        this.checkConstruction(sl, countryName, null, null);
        DERUTF8String localityName = new DERUTF8String("Melbourne");
        sl = new SignerLocation(null, localityName, null);
        this.checkConstruction(sl, null, localityName, null);
        sl = new SignerLocation(countryName, localityName, null);
        this.checkConstruction(sl, countryName, localityName, null);
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new DERUTF8String("line 1"));
        v.add(new DERUTF8String("line 2"));
        DERSequence postalAddress = new DERSequence(v);
        sl = new SignerLocation(null, null, postalAddress);
        this.checkConstruction(sl, null, null, postalAddress);
        sl = new SignerLocation(countryName, null, postalAddress);
        this.checkConstruction(sl, countryName, null, postalAddress);
        sl = new SignerLocation(countryName, localityName, postalAddress);
        this.checkConstruction(sl, countryName, localityName, postalAddress);
        sl = SignerLocation.getInstance(null);
        if (sl != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            SignerLocation.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        v = new ASN1EncodableVector();
        v.add(new DERUTF8String("line 1"));
        v.add(new DERUTF8String("line 2"));
        v.add(new DERUTF8String("line 3"));
        v.add(new DERUTF8String("line 4"));
        v.add(new DERUTF8String("line 5"));
        v.add(new DERUTF8String("line 6"));
        v.add(new DERUTF8String("line 7"));
        postalAddress = new DERSequence(v);
        try {
            new SignerLocation(null, null, postalAddress);
            this.fail("constructor failed to detect bad postalAddress.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            SignerLocation.getInstance(new DERSequence(new DERTaggedObject(2, postalAddress)));
            this.fail("sequence constructor failed to detect bad postalAddress.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            SignerLocation.getInstance(new DERSequence(new DERTaggedObject(5, postalAddress)));
            this.fail("sequence constructor failed to detect bad tag.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    private void checkConstruction(SignerLocation sl, DERUTF8String countryName, DERUTF8String localityName, ASN1Sequence postalAddress) throws IOException {
        this.checkValues(sl, countryName, localityName, postalAddress);
        sl = SignerLocation.getInstance(sl);
        this.checkValues(sl, countryName, localityName, postalAddress);
        ASN1InputStream aIn = new ASN1InputStream(sl.toASN1Object().getEncoded());
        ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
        sl = SignerLocation.getInstance(seq);
        this.checkValues(sl, countryName, localityName, postalAddress);
    }

    private void checkValues(SignerLocation sl, DERUTF8String countryName, DERUTF8String localityName, ASN1Sequence postalAddress) {
        if (countryName != null) {
            if (!countryName.equals(sl.getCountryName())) {
                this.fail("countryNames don't match.");
            }
        } else if (sl.getCountryName() != null) {
            this.fail("countryName found when none expected.");
        }
        if (localityName != null) {
            if (!localityName.equals(sl.getLocalityName())) {
                this.fail("localityNames don't match.");
            }
        } else if (sl.getLocalityName() != null) {
            this.fail("localityName found when none expected.");
        }
        if (postalAddress != null) {
            if (!postalAddress.equals(sl.getPostalAddress())) {
                this.fail("postalAddresses don't match.");
            }
        } else if (sl.getPostalAddress() != null) {
            this.fail("postalAddress found when none expected.");
        }
    }

    public static void main(String[] args) {
        SignerLocationUnitTest.runTest(new SignerLocationUnitTest());
    }
}

