/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.cms.test;

import cfca.sadk.org.bouncycastle.asn1.ASN1InputStream;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.ASN1OctetString;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import cfca.sadk.org.bouncycastle.asn1.DERSet;
import cfca.sadk.org.bouncycastle.asn1.DERUTF8String;
import cfca.sadk.org.bouncycastle.asn1.cms.Attribute;
import cfca.sadk.org.bouncycastle.asn1.cms.AttributeTable;
import cfca.sadk.org.bouncycastle.asn1.kisa.KISAObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.ntt.NTTObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.pkcs.RC2CBCParameter;
import cfca.sadk.org.bouncycastle.asn1.x500.X500Name;
import cfca.sadk.org.bouncycastle.asn1.x509.Extension;
import cfca.sadk.org.bouncycastle.cert.X509CertificateHolder;
import cfca.sadk.org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import cfca.sadk.org.bouncycastle.cms.CMSAlgorithm;
import cfca.sadk.org.bouncycastle.cms.CMSEnvelopedData;
import cfca.sadk.org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import cfca.sadk.org.bouncycastle.cms.CMSException;
import cfca.sadk.org.bouncycastle.cms.CMSProcessableByteArray;
import cfca.sadk.org.bouncycastle.cms.KeyTransRecipientInformation;
import cfca.sadk.org.bouncycastle.cms.OriginatorInfoGenerator;
import cfca.sadk.org.bouncycastle.cms.OriginatorInformation;
import cfca.sadk.org.bouncycastle.cms.PasswordRecipientInformation;
import cfca.sadk.org.bouncycastle.cms.RecipientInformation;
import cfca.sadk.org.bouncycastle.cms.RecipientInformationStore;
import cfca.sadk.org.bouncycastle.cms.SimpleAttributeTableGenerator;
import cfca.sadk.org.bouncycastle.cms.bc.BcCMSContentEncryptorBuilder;
import cfca.sadk.org.bouncycastle.cms.bc.BcRSAKeyTransRecipientInfoGenerator;
import cfca.sadk.org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import cfca.sadk.org.bouncycastle.cms.jcajce.JceKEKEnvelopedRecipient;
import cfca.sadk.org.bouncycastle.cms.jcajce.JceKEKRecipientInfoGenerator;
import cfca.sadk.org.bouncycastle.cms.jcajce.JceKeyAgreeEnvelopedRecipient;
import cfca.sadk.org.bouncycastle.cms.jcajce.JceKeyAgreeRecipientId;
import cfca.sadk.org.bouncycastle.cms.jcajce.JceKeyAgreeRecipientInfoGenerator;
import cfca.sadk.org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import cfca.sadk.org.bouncycastle.cms.jcajce.JceKeyTransRecipientId;
import cfca.sadk.org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import cfca.sadk.org.bouncycastle.cms.jcajce.JcePasswordEnvelopedRecipient;
import cfca.sadk.org.bouncycastle.cms.jcajce.JcePasswordRecipientInfoGenerator;
import cfca.sadk.org.bouncycastle.cms.test.CMSSampleMessages;
import cfca.sadk.org.bouncycastle.cms.test.CMSTestSetup;
import cfca.sadk.org.bouncycastle.cms.test.CMSTestUtil;
import cfca.sadk.org.bouncycastle.operator.OutputEncryptor;
import cfca.sadk.org.bouncycastle.util.encoders.Base64;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class NewEnvelopedDataTest
extends TestCase {
    private static final String BC = "BC";
    private static String _signDN;
    private static KeyPair _signKP;
    private static X509Certificate _signCert;
    private static String _origDN;
    private static KeyPair _origKP;
    private static X509Certificate _origCert;
    private static String _reciDN;
    private static String _reciDN2;
    private static KeyPair _reciKP;
    private static KeyPair _reciOaepKP;
    private static X509Certificate _reciCert;
    private static X509Certificate _reciCertOaep;
    private static KeyPair _origEcKP;
    private static KeyPair _reciEcKP;
    private static X509Certificate _reciEcCert;
    private static KeyPair _reciEcKP2;
    private static X509Certificate _reciEcCert2;
    private static boolean _initialised;
    private byte[] oldKEK = Base64.decode("MIAGCSqGSIb3DQEHA6CAMIACAQIxQaI/MD0CAQQwBwQFAQIDBAUwDQYJYIZIAWUDBAEFBQAEIFi2eHTPM4bQSjP4DUeDzJZLpfemW2gF1SPq7ZPHJi1mMIAGCSqGSIb3DQEHATAUBggqhkiG9w0DBwQImtdGyUdGGt6ggAQYk9X9z01YFBkU7IlS3wmsKpm/zpZClTceAAAAAAAAAAAAAA==");
    private byte[] ecKeyAgreeMsgAES256 = Base64.decode("MIAGCSqGSIb3DQEHA6CAMIACAQIxgcShgcECAQOgQ6FBMAsGByqGSM49AgEFAAMyAAPdXlSTpub+qqno9hUGkUDl+S3/ABhPziIB5yGU4678tgOgU5CiKG9ZkfnabIJ3nZYwGgYJK4EFEIZIPwACMA0GCWCGSAFlAwQBLQUAMFswWTAtMCgxEzARBgNVBAMTCkFkbWluLU1EU0UxETAPBgNVBAoTCDRCQ1QtMklEAgEBBCi/rJRLbFwEVW6PcLLmojjW9lI/xGD7CfZzXrqXFw8iHaf3hTRau1gYMIAGCSqGSIb3DQEHATAdBglghkgBZQMEASoEEMtCnKKPwccmyrbgeSIlA3qggAQQDLw8pNJR97bPpj6baG99bQQQwhEDsoj5Xg1oOxojHVcYzAAAAAAAAAAAAAA=");
    private byte[] ecKeyAgreeMsgAES128 = Base64.decode("MIAGCSqGSIb3DQEHA6CAMIACAQIxgbShgbECAQOgQ6FBMAsGByqGSM49AgEFAAMyAAL01JLEgKvKh5rbxI/hOxs/9WEezMIsAbUaZM4l5tn3CzXAN505nr5dLhrcurMK+tAwGgYJK4EFEIZIPwACMA0GCWCGSAFlAwQBBQUAMEswSTAtMCgxEzARBgNVBAMTCkFkbWluLU1EU0UxETAPBgNVBAoTCDRCQ1QtMklEAgEBBBhiFLjc5g6aqDT3f8LomljOwl1WTrplUT8wgAYJKoZIhvcNAQcBMB0GCWCGSAFlAwQBAgQQzXjms16Y69S/rB0EbHqRMaCABBAFmc/QdVW6LTKdEy97kaZzBBBafQuviUS03NycpojELx0bAAAAAAAAAAAAAA==");
    private byte[] ecKeyAgreeMsgDESEDE = Base64.decode("MIAGCSqGSIb3DQEHA6CAMIACAQIxgcahgcMCAQOgQ6FBMAsGByqGSM49AgEFAAMyAALIici6Nx1WN5f0ThH2A8ht9ovm0thpC5JK54t73E1RDzCifePaoQo0xd6sUqoyGaYwHAYJK4EFEIZIPwACMA8GCyqGSIb3DQEJEAMGBQAwWzBZMC0wKDETMBEGA1UEAxMKQWRtaW4tTURTRTERMA8GA1UEChMINEJDVC0ySUQCAQEEKJuqZQ1NB1vXrKPOnb4TCpYOsdm6GscWdwAAZlm2EHMp444j0s55J9wwgAYJKoZIhvcNAQcBMBQGCCqGSIb3DQMHBAjwnsDMsafCrKCABBjyPvqFOVMKxxutVfTx4fQlNGJN8S2ATRgECMcTQ/dsmeViAAAAAAAAAAAAAA==");
    private byte[] ecMQVKeyAgreeMsgAES128 = Base64.decode("MIAGCSqGSIb3DQEHA6CAMIACAQIxgf2hgfoCAQOgQ6FBMAsGByqGSM49AgEFAAMyAAPDKU+0H58tsjpoYmYCInMr/FayvCCkupebgsnpaGEB7qS9vzcNVUj6mrnmiC2grpmhRwRFMEMwQTALBgcqhkjOPQIBBQADMgACZpD13z9c7DzRWx6S0xdbq3S+EJ7vWO+YcHVjTD8NcQDcZcWASW899l1PkL936zsuMBoGCSuBBRCGSD8AEDANBglghkgBZQMEAQUFADBLMEkwLTAoMRMwEQYDVQQDEwpBZG1pbi1NRFNFMREwDwYDVQQKEwg0QkNULTJJRAIBAQQYFq58L71nyMK/70w3nc6zkkRyRL7DHmpZMIAGCSqGSIb3DQEHATAdBglghkgBZQMEAQIEEDzRUpreBsZXWHBeonxOtSmggAQQ7csAZXwT1lHUqoazoy8bhAQQq+9Zjj8iGdOWgyebbfj67QAAAAAAAAAAAAA=");
    private byte[] ecKeyAgreeKey = Base64.decode("MIG2AgEAMBAGByqGSM49AgEGBSuBBAAiBIGeMIGbAgEBBDC8vp7xVTbKSgYVU5WchGkWbzaj+yUFETIWP1Dt7+WSpq3ikSPdl7PpHPqnPVZfoIWhZANiAgSYHTgxf+DdTt84dUvuSKkFy3RhjxJmjwIscK6zbEUzKhcPQG2GHzXhWK5x1kov0I74XpGhVkyaElH5K6SaOXiXAzcyNGggTOk4+ZFnz5Xl0pBje3zKxPhYu0SnCw7Pcqw=");
    private byte[] bobPrivRsaEncrypt = Base64.decode("MIIChQIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBAKnhZ5g/OdVf8qCTQV6meYmFyDVdmpFb+x0B2hlwJhcPvaUi0DWFbXqYZhRBXM+3twg7CcmRuBlpN235ZR572akzJKN/O7uvRgGGNjQyywcDWVL8hYsxBLjMGAgUSOZPHPtdYMTgXB9T039T2GkB8QX4enDRvoPGXzjPHCyqaqfrAgMBAAECgYBnzUhMmg2PmMIbZf8ig5xt8KYGHbztpwOIlPIcaw+LNd4Ogngwy+e6alatd8brUXlweQqg9P5F4Kmy9Bnah5jWMIR05PxZbMHGd9ypkdB8MKCixQheIXFD/A0HPfD6bRSeTmPwF1h5HEuYHD09sBvf+iU7o8AsmAX2EAnYh9sDGQJBANDDIsbeopkYdo+NvKZ11mY/1I1FUox29XLE6/BGmvE+XKpVC5va3Wtt+Pw7PAhDk7Vb/s7q/WiEI2Kv8zHCueUCQQDQUfweIrdb7bWOAcjXq/JY1PeClPNTqBlFy2bKKBlf4hAr84/sajB0+E0R9KfEILVHIdxJAfkKICnwJAiEYH2PAkA0umTJSChXdNdVUN5qSO8bKlocSHseIVnDYDubl6nA7xhmqU5iUjiEzuUJiEiUacUgFJlaV/4jbOSnI3vQgLeFAkEAni+zN5r7CwZdV+EJBqRd2ZCWBgVfJAZAcpw6iIWchw+dYhKIFmioNRobQ+g4wJhprwMKSDIETukPj3d9NDAlBwJAVxhn1grStavCunrnVNqcBU+B1O8BiR4yPWnLMcRSyFRVJQA7HCp8JlDV6abXd8vPFfXuC9WN7rOvTKF8Y0ZB9qANMAsGA1UdDzEEAwIAEA==");
    private byte[] rfc4134ex5_1 = Base64.decode("MIIBHgYJKoZIhvcNAQcDoIIBDzCCAQsCAQAxgcAwgb0CAQAwJjASMRAwDgYDVQQDEwdDYXJsUlNBAhBGNGvHgABWvBHTbi7NXXHQMA0GCSqGSIb3DQEBAQUABIGAC3EN5nGIiJi2lsGPcP2iJ97a4e8kbKQz36zg6Z2i0yx6zYC4mZ7mX7FBs3IWg+f6KgCLx3M1eCbWx8+MDFbbpXadCDgO8/nUkUNYeNxJtuzubGgzoyEd8Ch4H/dd9gdzTd+taTEgS0ipdSJuNnkVY4/M652jKKHRLFf02hosdR8wQwYJKoZIhvcNAQcBMBQGCCqGSIb3DQMHBAgtaMXpRwZRNYAgDsiSf8Z9P43LrY4OxUk660cu1lXeCSFOSOpOJ7FuVyU=");
    private byte[] rfc4134ex5_2 = Base64.decode("MIIBZQYJKoZIhvcNAQcDoIIBVjCCAVICAQIxggEAMIG9AgEAMCYwEjEQMA4GA1UEAxMHQ2FybFJTQQIQRjRrx4AAVrwR024uzV1x0DANBgkqhkiG9w0BAQEFAASBgJQmQojGi7Z4IP+CVypBmNFoCDoEp87khtgyff2N4SmqD3RxPx+8hbLQt9i3YcMwcap+aiOkyqjMalT03VUC0XBOGv+HYI3HBZm/aFzxoq+YOXAWs5xlGerZwTOc9j6AYlK4qXvnztR5SQ8TBjlzytm4V7zg+TGrnGVNQBNw47Ewoj4CAQQwDQQLTWFpbExpc3RSQzIwEAYLKoZIhvcNAQkQAwcCAToEGHcUr5MSJ/g9HnJVHsQ6X56VcwYb+OfojTBJBgkqhkiG9w0BBwEwGgYIKoZIhvcNAwIwDgICAKAECJwE0hkuKlWhgCBeKNXhojuej3org9Lt7n+wWxOhnky5V50vSpoYRfRRyw==");
    private byte[] tooShort3DES = Base64.decode("MIAGCSqGSIb3DQEHA6CAMIACAQAxgcQwgcECAQAwKjAlMRYwFAYDVQQKDA1Cb3VuY3kgQ2FzdGxlMQswCQYDVQQGEwJBVQIBCjANBgkqhkiG9w0BAQEFAASBgJIM2QN0o6iv8Ux018pVCJ8js+ROV4t6+KoMwLJ4DzRKLU8XCAb9BS+crP+FghNTxTpTX8TaxPrO4wV0USgVHu2SvFnxNaWZjBDVIyZI2HR4QkSTqFMhsUB26CuZIWBZkhqQ6ruDfvn9UuBWVnfsBD4iryZ1idr713sDeVo5TyvTMIAGCSqGSIb3DQEHATAUBggqhkiG9w0DBwQIQq9e4+WB3CqggAQIwU4cOlmkWUcAAAAAAAAAAAAA");
    private byte[] tooShort3DESKey = Base64.decode("MIICdwIBADANBgkqhkiG9w0BAQEFAASCAmEwggJdAgEAAoGBAODZDCj0nQdVf0GGeFsPjjvPx1Vem0V6IkJ4SzazGKfddk0pX58ZDCnG+S+OPiXmPDqValiu9FtNy2/r9rrf/6qtcVQJkfSJv9E5Y7HgI98L/Y9lKxZWsfRqu/SlYO5zx0Dc2rzDvvZRtrtaq0uuHXWJlbWda2L9S65sv/Le/zvjAgMBAAECgYEAnn+iGMTGZMMaH6Cg+t/uTa9cPougPMuplt2hd3+sY7izihUeONK5RkHiqmlE2gaAcnOdMcKysiIWxGC73mPEnsOObPkaFlneVb5CtjTaTMdptuLNEQkwvtKhuW2HnMra4afEgFZdll3FyRpvW/CDooe4Bppjd4aGn/Sr/o9nOzECQQD4QKLwZssucljinD/8gU1CqGMMnGNogTMpHm1269HUOE7r1y3MuapUqSWsVhpuEQ8P/Tko0haJjeZn2eWTbZu/AkEA591snui8FMeGvkRgvyMFNvXZWDEjsh+N74XEL1lykTgZFQJ+cmThnrdM/8yj1dKkdASYrk5kFJ4PVE6CzDI43QJAFS22eNncJZc9u/9meg0x4SjqYk4JMQYsripZXlbZ7Mfs+7O8xYVlYZmYjC5ATPmJlmyc7r2VjKCdcmilbEFikwJBAMh7yf8BaBdjitubzjeW9VxXaa37F01eQWD5PfBfHFP6uJ1VAbayCfAtuHN6I7OwJih3DPmyqJC3NrQECs67IjUCQAb4TfVE/2G1s66SGnb4no34BspoV/i4f0uLhJap84bTHcF/ZRSXCmQOCRGdSvQkXHeNPI5Lus6lOHuUvUDbQC8=");

    private static void init() throws Exception {
        if (!_initialised) {
            _initialised = true;
            _signDN = "O=Bouncy Castle, C=AU";
            _signKP = CMSTestUtil.makeKeyPair();
            _signCert = CMSTestUtil.makeCertificate(_signKP, _signDN, _signKP, _signDN);
            _origDN = "CN=Bob, OU=Sales, O=Bouncy Castle, C=AU";
            _origKP = CMSTestUtil.makeKeyPair();
            _origCert = CMSTestUtil.makeCertificate(_origKP, _origDN, _signKP, _signDN);
            _reciDN = "CN=Doug, OU=Sales, O=Bouncy Castle, C=AU";
            _reciDN2 = "CN=Fred, OU=Sales, O=Bouncy Castle, C=AU";
            _reciKP = CMSTestUtil.makeKeyPair();
            _reciCert = CMSTestUtil.makeCertificate(_reciKP, _reciDN, _signKP, _signDN);
            _reciCertOaep = CMSTestUtil.makeOaepCertificate(_reciKP, _reciDN, _signKP, _signDN);
            _origEcKP = CMSTestUtil.makeEcDsaKeyPair();
            _reciEcKP = CMSTestUtil.makeEcDsaKeyPair();
            _reciEcCert = CMSTestUtil.makeCertificate(_reciEcKP, _reciDN, _signKP, _signDN);
            _reciEcKP2 = CMSTestUtil.makeEcDsaKeyPair();
            _reciEcCert2 = CMSTestUtil.makeCertificate(_reciEcKP2, _reciDN2, _signKP, _signDN);
        }
    }

    public static void main(String[] args) throws Exception {
        TestRunner.run((Test)NewEnvelopedDataTest.suite());
    }

    public static Test suite() throws Exception {
        NewEnvelopedDataTest.init();
        return new CMSTestSetup((Test)new TestSuite(NewEnvelopedDataTest.class));
    }

    public void testUnprotectedAttributes() throws Exception {
        byte[] data = "WallaWallaWashington".getBytes();
        CMSEnvelopedDataGenerator edGen = new CMSEnvelopedDataGenerator();
        edGen.addRecipientInfoGenerator(new JceKeyTransRecipientInfoGenerator(_reciCert).setProvider(BC));
        Hashtable<ASN1ObjectIdentifier, Attribute> attrs = new Hashtable<ASN1ObjectIdentifier, Attribute>();
        attrs.put(PKCSObjectIdentifiers.id_aa_contentHint, new Attribute(PKCSObjectIdentifiers.id_aa_contentHint, new DERSet(new DERUTF8String("Hint"))));
        attrs.put(PKCSObjectIdentifiers.id_aa_receiptRequest, new Attribute(PKCSObjectIdentifiers.id_aa_receiptRequest, new DERSet(new DERUTF8String("Request"))));
        AttributeTable attrTable = new AttributeTable(attrs);
        edGen.setUnprotectedAttributeGenerator(new SimpleAttributeTableGenerator(attrTable));
        CMSEnvelopedData ed = edGen.generate(new CMSProcessableByteArray(data), new JceCMSContentEncryptorBuilder(CMSAlgorithm.DES_EDE3_CBC).setProvider(BC).build());
        RecipientInformationStore recipients = ed.getRecipientInfos();
        NewEnvelopedDataTest.assertEquals((String)ed.getEncryptionAlgOID(), (String)CMSEnvelopedDataGenerator.DES_EDE3_CBC);
        attrTable = ed.getUnprotectedAttributes();
        NewEnvelopedDataTest.assertEquals((int)attrs.size(), (int)2);
        NewEnvelopedDataTest.assertEquals((Object)new DERUTF8String("Hint"), (Object)attrTable.get(PKCSObjectIdentifiers.id_aa_contentHint).getAttrValues().getObjectAt(0));
        NewEnvelopedDataTest.assertEquals((Object)new DERUTF8String("Request"), (Object)attrTable.get(PKCSObjectIdentifiers.id_aa_receiptRequest).getAttrValues().getObjectAt(0));
        Collection c = recipients.getRecipients();
        NewEnvelopedDataTest.assertEquals((int)1, (int)c.size());
        Iterator it = c.iterator();
        while (it.hasNext()) {
            RecipientInformation recipient = (RecipientInformation)it.next();
            NewEnvelopedDataTest.assertEquals((String)recipient.getKeyEncryptionAlgOID(), (String)PKCSObjectIdentifiers.rsaEncryption.getId());
            byte[] recData = recipient.getContent(new JceKeyTransEnvelopedRecipient(_reciKP.getPrivate()).setProvider(BC));
            NewEnvelopedDataTest.assertEquals((boolean)true, (boolean)Arrays.equals(data, recData));
        }
    }

    public void testKeyTrans() throws Exception {
        byte[] data = "WallaWallaWashington".getBytes();
        CMSEnvelopedDataGenerator edGen = new CMSEnvelopedDataGenerator();
        edGen.addRecipientInfoGenerator(new JceKeyTransRecipientInfoGenerator(_reciCert).setProvider(BC));
        edGen.addRecipientInfoGenerator(new JceKeyTransRecipientInfoGenerator(ASN1OctetString.getInstance(ASN1OctetString.getInstance(_reciCert.getExtensionValue(Extension.subjectKeyIdentifier.getId())).getOctets()).getOctets(), _reciCert.getPublicKey()).setProvider(BC));
        CMSEnvelopedData ed = edGen.generate(new CMSProcessableByteArray(data), new JceCMSContentEncryptorBuilder(CMSAlgorithm.DES_EDE3_CBC).setProvider(BC).build());
        RecipientInformationStore recipients = ed.getRecipientInfos();
        NewEnvelopedDataTest.assertEquals((String)ed.getEncryptionAlgOID(), (String)CMSEnvelopedDataGenerator.DES_EDE3_CBC);
        Collection c = recipients.getRecipients();
        NewEnvelopedDataTest.assertEquals((int)2, (int)c.size());
        Iterator it = c.iterator();
        while (it.hasNext()) {
            RecipientInformation recipient = (RecipientInformation)it.next();
            NewEnvelopedDataTest.assertEquals((String)recipient.getKeyEncryptionAlgOID(), (String)PKCSObjectIdentifiers.rsaEncryption.getId());
            byte[] recData = recipient.getContent(new JceKeyTransEnvelopedRecipient(_reciKP.getPrivate()).setProvider(BC));
            NewEnvelopedDataTest.assertEquals((boolean)true, (boolean)Arrays.equals(data, recData));
        }
        JceKeyTransRecipientId id = new JceKeyTransRecipientId(_reciCert);
        Collection collection = recipients.getRecipients(id);
        if (collection.size() != 2) {
            NewEnvelopedDataTest.fail((String)"recipients not matched using general recipient ID.");
        }
        NewEnvelopedDataTest.assertTrue((boolean)(collection.iterator().next() instanceof RecipientInformation));
    }

    public void testKeyTransWithAlgMapping() throws Exception {
        byte[] data = "WallaWallaWashington".getBytes();
        CMSEnvelopedDataGenerator edGen = new CMSEnvelopedDataGenerator();
        edGen.addRecipientInfoGenerator(new JceKeyTransRecipientInfoGenerator(_reciCert).setAlgorithmMapping(PKCSObjectIdentifiers.rsaEncryption, "RSA/2/PKCS1Padding").setProvider(BC));
        CMSEnvelopedData ed = edGen.generate(new CMSProcessableByteArray(data), new JceCMSContentEncryptorBuilder(CMSAlgorithm.DES_EDE3_CBC).setProvider(BC).build());
        RecipientInformationStore recipients = ed.getRecipientInfos();
        NewEnvelopedDataTest.assertEquals((String)ed.getEncryptionAlgOID(), (String)CMSEnvelopedDataGenerator.DES_EDE3_CBC);
        Collection c = recipients.getRecipients();
        NewEnvelopedDataTest.assertEquals((int)1, (int)c.size());
        Iterator it = c.iterator();
        while (it.hasNext()) {
            RecipientInformation recipient = (RecipientInformation)it.next();
            NewEnvelopedDataTest.assertEquals((String)recipient.getKeyEncryptionAlgOID(), (String)PKCSObjectIdentifiers.rsaEncryption.getId());
            byte[] recData = recipient.getContent(new JceKeyTransEnvelopedRecipient(_reciKP.getPrivate()).setAlgorithmMapping(PKCSObjectIdentifiers.rsaEncryption, "RSA/2/PKCS1Padding").setProvider(BC));
            NewEnvelopedDataTest.assertEquals((boolean)true, (boolean)Arrays.equals(data, recData));
        }
        JceKeyTransRecipientId id = new JceKeyTransRecipientId(_reciCert);
        Collection collection = recipients.getRecipients(id);
        if (collection.size() != 1) {
            NewEnvelopedDataTest.fail((String)"recipients not matched using general recipient ID.");
        }
        NewEnvelopedDataTest.assertTrue((boolean)(collection.iterator().next() instanceof RecipientInformation));
    }

    public void testOriginatorInfoGeneration() throws Exception {
        byte[] data = "WallaWallaWashington".getBytes();
        CMSEnvelopedDataGenerator edGen = new CMSEnvelopedDataGenerator();
        X509CertificateHolder origCert = new X509CertificateHolder(_origCert.getEncoded());
        edGen.setOriginatorInfo(new OriginatorInfoGenerator(origCert).generate());
        edGen.addRecipientInfoGenerator(new JceKeyTransRecipientInfoGenerator(_reciCert).setProvider(BC));
        edGen.addRecipientInfoGenerator(new JceKeyTransRecipientInfoGenerator(ASN1OctetString.getInstance(ASN1OctetString.getInstance(_reciCert.getExtensionValue(Extension.subjectKeyIdentifier.getId())).getOctets()).getOctets(), _reciCert.getPublicKey()).setProvider(BC));
        CMSEnvelopedData ed = edGen.generate(new CMSProcessableByteArray(data), new JceCMSContentEncryptorBuilder(CMSAlgorithm.DES_EDE3_CBC).setProvider(BC).build());
        RecipientInformationStore recipients = ed.getRecipientInfos();
        NewEnvelopedDataTest.assertEquals((String)ed.getEncryptionAlgOID(), (String)CMSEnvelopedDataGenerator.DES_EDE3_CBC);
        NewEnvelopedDataTest.assertTrue((boolean)ed.getOriginatorInfo().getCertificates().getMatches(null).contains(origCert));
        Collection c = recipients.getRecipients();
        NewEnvelopedDataTest.assertEquals((int)2, (int)c.size());
        Iterator it = c.iterator();
        while (it.hasNext()) {
            RecipientInformation recipient = (RecipientInformation)it.next();
            NewEnvelopedDataTest.assertEquals((String)recipient.getKeyEncryptionAlgOID(), (String)PKCSObjectIdentifiers.rsaEncryption.getId());
            byte[] recData = recipient.getContent(new JceKeyTransEnvelopedRecipient(_reciKP.getPrivate()).setProvider(BC));
            NewEnvelopedDataTest.assertEquals((boolean)true, (boolean)Arrays.equals(data, recData));
        }
        JceKeyTransRecipientId id = new JceKeyTransRecipientId(_reciCert);
        Collection collection = recipients.getRecipients(id);
        if (collection.size() != 2) {
            NewEnvelopedDataTest.fail((String)"recipients not matched using general recipient ID.");
        }
        NewEnvelopedDataTest.assertTrue((boolean)(collection.iterator().next() instanceof RecipientInformation));
    }

    public void testKeyTransRC2bit40() throws Exception {
        byte[] data = "WallaWallaBouncyCastle".getBytes();
        CMSEnvelopedDataGenerator edGen = new CMSEnvelopedDataGenerator();
        edGen.addRecipientInfoGenerator(new JceKeyTransRecipientInfoGenerator(_reciCert).setProvider(BC));
        CMSEnvelopedData ed = edGen.generate(new CMSProcessableByteArray(data), new JceCMSContentEncryptorBuilder(CMSAlgorithm.RC2_CBC, 40).setProvider(BC).build());
        RecipientInformationStore recipients = ed.getRecipientInfos();
        NewEnvelopedDataTest.assertEquals((Object)ed.getContentEncryptionAlgorithm().getAlgorithm(), (Object)CMSAlgorithm.RC2_CBC);
        RC2CBCParameter rc2P = RC2CBCParameter.getInstance(ed.getContentEncryptionAlgorithm().getParameters());
        NewEnvelopedDataTest.assertEquals((int)160, (int)rc2P.getRC2ParameterVersion().intValue());
        Collection c = recipients.getRecipients();
        NewEnvelopedDataTest.assertEquals((int)1, (int)c.size());
        Iterator it = c.iterator();
        while (it.hasNext()) {
            RecipientInformation recipient = (RecipientInformation)it.next();
            byte[] recData = recipient.getContent(new JceKeyTransEnvelopedRecipient(_reciKP.getPrivate()).setProvider(BC));
            NewEnvelopedDataTest.assertEquals((boolean)true, (boolean)Arrays.equals(data, recData));
        }
    }

    public void testKeyTransRC4() throws Exception {
        byte[] data = "WallaWallaBouncyCastle".getBytes();
        CMSEnvelopedDataGenerator edGen = new CMSEnvelopedDataGenerator();
        edGen.addRecipientInfoGenerator(new JceKeyTransRecipientInfoGenerator(_reciCert).setProvider(BC));
        CMSEnvelopedData ed = edGen.generate(new CMSProcessableByteArray(data), new JceCMSContentEncryptorBuilder(new ASN1ObjectIdentifier("1.2.840.113549.3.4")).setProvider(BC).build());
        RecipientInformationStore recipients = ed.getRecipientInfos();
        NewEnvelopedDataTest.assertEquals((String)ed.getEncryptionAlgOID(), (String)"1.2.840.113549.3.4");
        Collection c = recipients.getRecipients();
        NewEnvelopedDataTest.assertEquals((int)1, (int)c.size());
        Iterator it = c.iterator();
        while (it.hasNext()) {
            RecipientInformation recipient = (RecipientInformation)it.next();
            byte[] recData = recipient.getContent(new JceKeyTransEnvelopedRecipient(_reciKP.getPrivate()).setProvider(BC));
            NewEnvelopedDataTest.assertEquals((boolean)true, (boolean)Arrays.equals(data, recData));
        }
    }

    public void testKeyTrans128RC4() throws Exception {
        byte[] data = "WallaWallaBouncyCastle".getBytes();
        CMSEnvelopedDataGenerator edGen = new CMSEnvelopedDataGenerator();
        edGen.addRecipientInfoGenerator(new JceKeyTransRecipientInfoGenerator(_reciCert).setProvider(BC));
        CMSEnvelopedData ed = edGen.generate(new CMSProcessableByteArray(data), new JceCMSContentEncryptorBuilder(new ASN1ObjectIdentifier("1.2.840.113549.3.4"), 128).setProvider(BC).build());
        RecipientInformationStore recipients = ed.getRecipientInfos();
        NewEnvelopedDataTest.assertEquals((String)ed.getEncryptionAlgOID(), (String)"1.2.840.113549.3.4");
        Collection c = recipients.getRecipients();
        Iterator it = c.iterator();
        if (it.hasNext()) {
            RecipientInformation recipient = (RecipientInformation)it.next();
            byte[] recData = recipient.getContent(new JceKeyTransEnvelopedRecipient(_reciKP.getPrivate()).setProvider(BC));
            NewEnvelopedDataTest.assertEquals((boolean)true, (boolean)Arrays.equals(data, recData));
        } else {
            NewEnvelopedDataTest.fail((String)"no recipient found");
        }
    }

    public void testKeyTransLight128RC4() throws Exception {
        byte[] data = "WallaWallaBouncyCastle".getBytes();
        CMSEnvelopedDataGenerator edGen = new CMSEnvelopedDataGenerator();
        edGen.addRecipientInfoGenerator(new BcRSAKeyTransRecipientInfoGenerator(new JcaX509CertificateHolder(_reciCert)));
        CMSEnvelopedData ed = edGen.generate(new CMSProcessableByteArray(data), new JceCMSContentEncryptorBuilder(new ASN1ObjectIdentifier("1.2.840.113549.3.4"), 128).setProvider(BC).build());
        RecipientInformationStore recipients = ed.getRecipientInfos();
        NewEnvelopedDataTest.assertEquals((String)ed.getEncryptionAlgOID(), (String)"1.2.840.113549.3.4");
        Collection c = recipients.getRecipients();
        Iterator it = c.iterator();
        if (it.hasNext()) {
            RecipientInformation recipient = (RecipientInformation)it.next();
            byte[] recData = recipient.getContent(new JceKeyTransEnvelopedRecipient(_reciKP.getPrivate()).setProvider(BC));
            NewEnvelopedDataTest.assertEquals((boolean)true, (boolean)Arrays.equals(data, recData));
        } else {
            NewEnvelopedDataTest.fail((String)"no recipient found");
        }
    }

    public void testKeyTransODES() throws Exception {
        byte[] data = "WallaWallaBouncyCastle".getBytes();
        CMSEnvelopedDataGenerator edGen = new CMSEnvelopedDataGenerator();
        edGen.addRecipientInfoGenerator(new JceKeyTransRecipientInfoGenerator(_reciCert).setProvider(BC));
        CMSEnvelopedData ed = edGen.generate(new CMSProcessableByteArray(data), new JceCMSContentEncryptorBuilder(new ASN1ObjectIdentifier("1.3.14.3.2.7")).setProvider(BC).build());
        RecipientInformationStore recipients = ed.getRecipientInfos();
        NewEnvelopedDataTest.assertEquals((String)ed.getEncryptionAlgOID(), (String)"1.3.14.3.2.7");
        Collection c = recipients.getRecipients();
        Iterator it = c.iterator();
        if (it.hasNext()) {
            RecipientInformation recipient = (RecipientInformation)it.next();
            byte[] recData = recipient.getContent(new JceKeyTransEnvelopedRecipient(_reciKP.getPrivate()).setProvider(BC));
            NewEnvelopedDataTest.assertEquals((boolean)true, (boolean)Arrays.equals(data, recData));
        } else {
            NewEnvelopedDataTest.fail((String)"no recipient found");
        }
    }

    public void testKeyTransSmallAES() throws Exception {
        byte[] data = new byte[]{0, 1, 2, 3};
        CMSEnvelopedDataGenerator edGen = new CMSEnvelopedDataGenerator();
        edGen.addRecipientInfoGenerator(new JceKeyTransRecipientInfoGenerator(_reciCert).setProvider(BC));
        CMSEnvelopedData ed = edGen.generate(new CMSProcessableByteArray(data), new JceCMSContentEncryptorBuilder(CMSAlgorithm.AES128_CBC).setProvider(BC).build());
        RecipientInformationStore recipients = ed.getRecipientInfos();
        NewEnvelopedDataTest.assertEquals((String)ed.getEncryptionAlgOID(), (String)CMSEnvelopedDataGenerator.AES128_CBC);
        Collection c = recipients.getRecipients();
        Iterator it = c.iterator();
        if (it.hasNext()) {
            RecipientInformation recipient = (RecipientInformation)it.next();
            byte[] recData = recipient.getContent(new JceKeyTransEnvelopedRecipient(_reciKP.getPrivate()).setProvider(BC));
            NewEnvelopedDataTest.assertEquals((boolean)true, (boolean)Arrays.equals(data, recData));
        } else {
            NewEnvelopedDataTest.fail((String)"no recipient found");
        }
    }

    public void testKeyTransDESEDE3Short() throws Exception {
        byte[] data = new byte[]{0, 1, 2, 3};
        KeyFactory kf = KeyFactory.getInstance("RSA", BC);
        PrivateKey kPriv = kf.generatePrivate(new PKCS8EncodedKeySpec(this.tooShort3DESKey));
        CMSEnvelopedData ed = new CMSEnvelopedData(this.tooShort3DES);
        RecipientInformationStore recipients = ed.getRecipientInfos();
        NewEnvelopedDataTest.assertEquals((String)ed.getEncryptionAlgOID(), (String)CMSEnvelopedDataGenerator.DES_EDE3_CBC);
        Collection c = recipients.getRecipients();
        Iterator it = c.iterator();
        if (it.hasNext()) {
            byte[] recData;
            RecipientInformation recipient = (RecipientInformation)it.next();
            try {
                recData = recipient.getContent(new JceKeyTransEnvelopedRecipient(kPriv).setKeySizeValidation(true).setProvider(BC));
                NewEnvelopedDataTest.fail((String)"invalid 3DES-EDE key not picked up");
            }
            catch (CMSException e) {
                NewEnvelopedDataTest.assertEquals((String)"Expected key size for algorithm OID not found in recipient.", (String)e.getMessage());
            }
            recData = recipient.getContent(new JceKeyTransEnvelopedRecipient(kPriv).setKeySizeValidation(false).setProvider(BC));
            NewEnvelopedDataTest.assertEquals((boolean)true, (boolean)Arrays.equals(data, recData));
        } else {
            NewEnvelopedDataTest.fail((String)"no recipient found");
        }
    }

    public void testKeyTransDESEDE3Light() throws Exception {
        byte[] data = new byte[]{0, 1, 2, 3};
        CMSEnvelopedDataGenerator edGen = new CMSEnvelopedDataGenerator();
        edGen.addRecipientInfoGenerator(new BcRSAKeyTransRecipientInfoGenerator(new JcaX509CertificateHolder(_reciCert)));
        CMSEnvelopedData ed = edGen.generate(new CMSProcessableByteArray(data), new BcCMSContentEncryptorBuilder(CMSAlgorithm.DES_EDE3_CBC, 192).build());
        RecipientInformationStore recipients = ed.getRecipientInfos();
        NewEnvelopedDataTest.assertEquals((String)ed.getEncryptionAlgOID(), (String)CMSEnvelopedDataGenerator.DES_EDE3_CBC);
        Collection c = recipients.getRecipients();
        Iterator it = c.iterator();
        if (it.hasNext()) {
            RecipientInformation recipient = (RecipientInformation)it.next();
            byte[] recData = recipient.getContent(new JceKeyTransEnvelopedRecipient(_reciKP.getPrivate()).setKeySizeValidation(true).setProvider(BC));
            NewEnvelopedDataTest.assertEquals((boolean)true, (boolean)Arrays.equals(data, recData));
        } else {
            NewEnvelopedDataTest.fail((String)"no recipient found");
        }
    }

    public void testKeyTransDES() throws Exception {
        this.tryKeyTrans(CMSAlgorithm.DES_CBC, CMSAlgorithm.DES_CBC, 8, DEROctetString.class);
    }

    public void testKeyTransCAST5() throws Exception {
        this.tryKeyTrans(CMSAlgorithm.CAST5_CBC, CMSAlgorithm.CAST5_CBC, 16, ASN1Sequence.class);
    }

    public void testKeyTransAES128() throws Exception {
        this.tryKeyTrans(CMSAlgorithm.AES128_CBC, NISTObjectIdentifiers.id_aes128_CBC, 16, DEROctetString.class);
    }

    public void testKeyTransAES192() throws Exception {
        this.tryKeyTrans(CMSAlgorithm.AES192_CBC, NISTObjectIdentifiers.id_aes192_CBC, 24, DEROctetString.class);
    }

    public void testKeyTransAES256() throws Exception {
        this.tryKeyTrans(CMSAlgorithm.AES256_CBC, NISTObjectIdentifiers.id_aes256_CBC, 32, DEROctetString.class);
    }

    public void testKeyTransSEED() throws Exception {
        this.tryKeyTrans(CMSAlgorithm.SEED_CBC, KISAObjectIdentifiers.id_seedCBC, 16, DEROctetString.class);
    }

    public void testKeyTransCamellia128() throws Exception {
        this.tryKeyTrans(CMSAlgorithm.CAMELLIA128_CBC, NTTObjectIdentifiers.id_camellia128_cbc, 16, DEROctetString.class);
    }

    public void testKeyTransCamellia192() throws Exception {
        this.tryKeyTrans(CMSAlgorithm.CAMELLIA192_CBC, NTTObjectIdentifiers.id_camellia192_cbc, 24, DEROctetString.class);
    }

    public void testKeyTransCamellia256() throws Exception {
        this.tryKeyTrans(CMSAlgorithm.CAMELLIA256_CBC, NTTObjectIdentifiers.id_camellia256_cbc, 32, DEROctetString.class);
    }

    private void tryKeyTrans(ASN1ObjectIdentifier generatorOID, ASN1ObjectIdentifier checkOID, int keySize, Class asn1Params) throws Exception {
        byte[] data = "WallaWallaWashington".getBytes();
        CMSEnvelopedDataGenerator edGen = new CMSEnvelopedDataGenerator();
        edGen.addRecipientInfoGenerator(new JceKeyTransRecipientInfoGenerator(_reciCert).setProvider(BC));
        OutputEncryptor encryptor = new JceCMSContentEncryptorBuilder(generatorOID).setProvider(BC).build();
        CMSEnvelopedData ed = edGen.generate(new CMSProcessableByteArray(data), encryptor);
        RecipientInformationStore recipients = ed.getRecipientInfos();
        NewEnvelopedDataTest.assertEquals((String)checkOID.getId(), (String)ed.getEncryptionAlgOID());
        NewEnvelopedDataTest.assertEquals((int)keySize, (int)((byte[])encryptor.getKey().getRepresentation()).length);
        if (asn1Params != null) {
            ASN1InputStream aIn = new ASN1InputStream(ed.getEncryptionAlgParams());
            NewEnvelopedDataTest.assertTrue((boolean)asn1Params.isAssignableFrom(aIn.readObject().getClass()));
        }
        Collection c = recipients.getRecipients();
        NewEnvelopedDataTest.assertEquals((int)1, (int)c.size());
        Iterator it = c.iterator();
        if (!it.hasNext()) {
            NewEnvelopedDataTest.fail((String)"no recipients found");
        }
        while (it.hasNext()) {
            RecipientInformation recipient = (RecipientInformation)it.next();
            NewEnvelopedDataTest.assertEquals((String)recipient.getKeyEncryptionAlgOID(), (String)PKCSObjectIdentifiers.rsaEncryption.getId());
            byte[] recData = recipient.getContent(new JceKeyTransEnvelopedRecipient(_reciKP.getPrivate()).setKeySizeValidation(true).setProvider(BC));
            NewEnvelopedDataTest.assertEquals((boolean)true, (boolean)Arrays.equals(data, recData));
        }
    }

    public void testErroneousKEK() throws Exception {
        byte[] data = "WallaWallaWashington".getBytes();
        SecretKeySpec kek = new SecretKeySpec(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16}, "AES");
        CMSEnvelopedData ed = new CMSEnvelopedData(this.oldKEK);
        RecipientInformationStore recipients = ed.getRecipientInfos();
        NewEnvelopedDataTest.assertEquals((String)ed.getEncryptionAlgOID(), (String)CMSEnvelopedDataGenerator.DES_EDE3_CBC);
        Collection c = recipients.getRecipients();
        Iterator it = c.iterator();
        if (it.hasNext()) {
            RecipientInformation recipient = (RecipientInformation)it.next();
            NewEnvelopedDataTest.assertEquals((String)recipient.getKeyEncryptionAlgOID(), (String)NISTObjectIdentifiers.id_aes128_wrap.getId());
            byte[] recData = recipient.getContent(new JceKEKEnvelopedRecipient(kek).setProvider(BC));
            NewEnvelopedDataTest.assertEquals((boolean)true, (boolean)Arrays.equals(data, recData));
        } else {
            NewEnvelopedDataTest.fail((String)"no recipient found");
        }
    }

    public void testDESKEK() throws Exception {
        this.tryKekAlgorithm(CMSTestUtil.makeDesede192Key(), new ASN1ObjectIdentifier("1.2.840.113549.1.9.16.3.6"));
    }

    public void testRC2128KEK() throws Exception {
        this.tryKekAlgorithm(CMSTestUtil.makeRC2128Key(), new ASN1ObjectIdentifier("1.2.840.113549.1.9.16.3.7"));
    }

    public void testAES128KEK() throws Exception {
        this.tryKekAlgorithm(CMSTestUtil.makeAESKey(128), NISTObjectIdentifiers.id_aes128_wrap);
    }

    public void testAES192KEK() throws Exception {
        this.tryKekAlgorithm(CMSTestUtil.makeAESKey(192), NISTObjectIdentifiers.id_aes192_wrap);
    }

    public void testAES256KEK() throws Exception {
        this.tryKekAlgorithm(CMSTestUtil.makeAESKey(256), NISTObjectIdentifiers.id_aes256_wrap);
    }

    public void testSEED128KEK() throws Exception {
        this.tryKekAlgorithm(CMSTestUtil.makeSEEDKey(), KISAObjectIdentifiers.id_npki_app_cmsSeed_wrap);
    }

    public void testCamellia128KEK() throws Exception {
        this.tryKekAlgorithm(CMSTestUtil.makeCamelliaKey(128), NTTObjectIdentifiers.id_camellia128_wrap);
    }

    public void testCamellia192KEK() throws Exception {
        this.tryKekAlgorithm(CMSTestUtil.makeCamelliaKey(192), NTTObjectIdentifiers.id_camellia192_wrap);
    }

    public void testCamellia256KEK() throws Exception {
        this.tryKekAlgorithm(CMSTestUtil.makeCamelliaKey(256), NTTObjectIdentifiers.id_camellia256_wrap);
    }

    private void tryKekAlgorithm(SecretKey kek, ASN1ObjectIdentifier algOid) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        byte[] data = "WallaWallaWashington".getBytes();
        CMSEnvelopedDataGenerator edGen = new CMSEnvelopedDataGenerator();
        byte[] kekId = new byte[]{1, 2, 3, 4, 5};
        edGen.addRecipientInfoGenerator(new JceKEKRecipientInfoGenerator(kekId, kek).setProvider(BC));
        CMSEnvelopedData ed = edGen.generate(new CMSProcessableByteArray(data), new JceCMSContentEncryptorBuilder(CMSAlgorithm.DES_EDE3_CBC).setProvider(BC).build());
        RecipientInformationStore recipients = ed.getRecipientInfos();
        Collection c = recipients.getRecipients();
        Iterator it = c.iterator();
        NewEnvelopedDataTest.assertEquals((String)ed.getEncryptionAlgOID(), (String)CMSEnvelopedDataGenerator.DES_EDE3_CBC);
        if (it.hasNext()) {
            RecipientInformation recipient = (RecipientInformation)it.next();
            NewEnvelopedDataTest.assertEquals((String)algOid.getId(), (String)recipient.getKeyEncryptionAlgOID());
            byte[] recData = recipient.getContent(new JceKEKEnvelopedRecipient(kek).setKeySizeValidation(true).setProvider(BC));
            NewEnvelopedDataTest.assertTrue((boolean)Arrays.equals(data, recData));
        } else {
            NewEnvelopedDataTest.fail((String)"no recipient found");
        }
    }

    public void testECKeyAgree() throws Exception {
        byte[] data = Hex.decode("504b492d4320434d5320456e76656c6f706564446174612053616d706c65");
        CMSEnvelopedDataGenerator edGen = new CMSEnvelopedDataGenerator();
        edGen.addRecipientInfoGenerator(new JceKeyAgreeRecipientInfoGenerator(CMSAlgorithm.ECDH_SHA1KDF, _origEcKP.getPrivate(), _origEcKP.getPublic(), CMSAlgorithm.AES128_WRAP).addRecipient(_reciEcCert).setProvider(BC));
        CMSEnvelopedData ed = edGen.generate(new CMSProcessableByteArray(data), new JceCMSContentEncryptorBuilder(CMSAlgorithm.AES128_CBC).setProvider(BC).build());
        NewEnvelopedDataTest.assertEquals((String)ed.getEncryptionAlgOID(), (String)CMSEnvelopedDataGenerator.AES128_CBC);
        RecipientInformationStore recipients = ed.getRecipientInfos();
        NewEnvelopedDataTest.confirmDataReceived(recipients, data, _reciEcCert, _reciEcKP.getPrivate(), BC);
        NewEnvelopedDataTest.confirmNumberRecipients(recipients, 1);
    }

    public void testECMQVKeyAgree() throws Exception {
        byte[] data = Hex.decode("504b492d4320434d5320456e76656c6f706564446174612053616d706c65");
        CMSEnvelopedDataGenerator edGen = new CMSEnvelopedDataGenerator();
        edGen.addRecipientInfoGenerator(new JceKeyAgreeRecipientInfoGenerator(CMSAlgorithm.ECMQV_SHA1KDF, _origEcKP.getPrivate(), _origEcKP.getPublic(), CMSAlgorithm.AES128_WRAP).addRecipient(_reciEcCert).setProvider(BC));
        CMSEnvelopedData ed = edGen.generate(new CMSProcessableByteArray(data), new JceCMSContentEncryptorBuilder(CMSAlgorithm.AES128_CBC).setProvider(BC).build());
        NewEnvelopedDataTest.assertEquals((String)ed.getEncryptionAlgOID(), (String)CMSEnvelopedDataGenerator.AES128_CBC);
        RecipientInformationStore recipients = ed.getRecipientInfos();
        NewEnvelopedDataTest.confirmDataReceived(recipients, data, _reciEcCert, _reciEcKP.getPrivate(), BC);
        NewEnvelopedDataTest.confirmNumberRecipients(recipients, 1);
    }

    public void testECMQVKeyAgreeMultiple() throws Exception {
        byte[] data = Hex.decode("504b492d4320434d5320456e76656c6f706564446174612053616d706c65");
        CMSEnvelopedDataGenerator edGen = new CMSEnvelopedDataGenerator();
        JceKeyAgreeRecipientInfoGenerator recipientGenerator = new JceKeyAgreeRecipientInfoGenerator(CMSAlgorithm.ECMQV_SHA1KDF, _origEcKP.getPrivate(), _origEcKP.getPublic(), CMSAlgorithm.AES128_WRAP).setProvider(BC);
        recipientGenerator.addRecipient(_reciEcCert);
        recipientGenerator.addRecipient(_reciEcCert2);
        edGen.addRecipientInfoGenerator(recipientGenerator);
        CMSEnvelopedData ed = edGen.generate(new CMSProcessableByteArray(data), new JceCMSContentEncryptorBuilder(CMSAlgorithm.AES128_CBC).setProvider(BC).build());
        NewEnvelopedDataTest.assertEquals((String)ed.getEncryptionAlgOID(), (String)CMSEnvelopedDataGenerator.AES128_CBC);
        RecipientInformationStore recipients = ed.getRecipientInfos();
        NewEnvelopedDataTest.confirmDataReceived(recipients, data, _reciEcCert, _reciEcKP.getPrivate(), BC);
        NewEnvelopedDataTest.confirmDataReceived(recipients, data, _reciEcCert2, _reciEcKP2.getPrivate(), BC);
        NewEnvelopedDataTest.confirmNumberRecipients(recipients, 2);
    }

    private static void confirmDataReceived(RecipientInformationStore recipients, byte[] expectedData, X509Certificate reciCert, PrivateKey reciPrivKey, String provider) throws CMSException, NoSuchProviderException, CertificateEncodingException, IOException {
        JceKeyAgreeRecipientId rid = new JceKeyAgreeRecipientId(reciCert);
        RecipientInformation recipient = recipients.get(rid);
        NewEnvelopedDataTest.assertNotNull((Object)recipient);
        byte[] actualData = recipient.getContent(new JceKeyAgreeEnvelopedRecipient(reciPrivKey).setProvider(provider));
        NewEnvelopedDataTest.assertEquals((boolean)true, (boolean)Arrays.equals(expectedData, actualData));
    }

    private static void confirmNumberRecipients(RecipientInformationStore recipients, int count) {
        NewEnvelopedDataTest.assertEquals((int)count, (int)recipients.getRecipients().size());
    }

    public void testECKeyAgreeVectors() throws Exception {
        PKCS8EncodedKeySpec privSpec = new PKCS8EncodedKeySpec(this.ecKeyAgreeKey);
        KeyFactory fact = KeyFactory.getInstance("ECDH", BC);
        PrivateKey privKey = fact.generatePrivate(privSpec);
        this.verifyECKeyAgreeVectors(privKey, "2.16.840.1.101.3.4.1.42", this.ecKeyAgreeMsgAES256);
        this.verifyECKeyAgreeVectors(privKey, "2.16.840.1.101.3.4.1.2", this.ecKeyAgreeMsgAES128);
        this.verifyECKeyAgreeVectors(privKey, "1.2.840.113549.3.7", this.ecKeyAgreeMsgDESEDE);
    }

    public void testECMQVKeyAgreeVectors() throws Exception {
        PKCS8EncodedKeySpec privSpec = new PKCS8EncodedKeySpec(this.ecKeyAgreeKey);
        KeyFactory fact = KeyFactory.getInstance("ECDH", BC);
        PrivateKey privKey = fact.generatePrivate(privSpec);
        this.verifyECMQVKeyAgreeVectors(privKey, "2.16.840.1.101.3.4.1.2", this.ecMQVKeyAgreeMsgAES128);
    }

    public void testPasswordAES256() throws Exception {
        this.passwordTest(CMSEnvelopedDataGenerator.AES256_CBC);
        this.passwordUTF8Test(CMSEnvelopedDataGenerator.AES256_CBC);
    }

    public void testPasswordDESEDE() throws Exception {
        this.passwordTest(CMSEnvelopedDataGenerator.DES_EDE3_CBC);
        this.passwordUTF8Test(CMSEnvelopedDataGenerator.DES_EDE3_CBC);
    }

    public void testRFC4134ex5_1() throws Exception {
        byte[] data = Hex.decode("5468697320697320736f6d652073616d706c6520636f6e74656e742e");
        KeyFactory kFact = KeyFactory.getInstance("RSA", BC);
        PrivateKey key = kFact.generatePrivate(new PKCS8EncodedKeySpec(this.bobPrivRsaEncrypt));
        CMSEnvelopedData ed = new CMSEnvelopedData(this.rfc4134ex5_1);
        RecipientInformationStore recipients = ed.getRecipientInfos();
        NewEnvelopedDataTest.assertEquals((String)"1.2.840.113549.3.7", (String)ed.getEncryptionAlgOID());
        Collection c = recipients.getRecipients();
        Iterator it = c.iterator();
        if (it.hasNext()) {
            RecipientInformation recipient = (RecipientInformation)it.next();
            byte[] recData = recipient.getContent(new JceKeyTransEnvelopedRecipient(key).setProvider(BC));
            NewEnvelopedDataTest.assertEquals((boolean)true, (boolean)Arrays.equals(data, recData));
        } else {
            NewEnvelopedDataTest.fail((String)"no recipient found");
        }
    }

    public void testRFC4134ex5_2() throws Exception {
        byte[] data = Hex.decode("5468697320697320736f6d652073616d706c6520636f6e74656e742e");
        KeyFactory kFact = KeyFactory.getInstance("RSA", BC);
        PrivateKey key = kFact.generatePrivate(new PKCS8EncodedKeySpec(this.bobPrivRsaEncrypt));
        CMSEnvelopedData ed = new CMSEnvelopedData(this.rfc4134ex5_2);
        RecipientInformationStore recipients = ed.getRecipientInfos();
        NewEnvelopedDataTest.assertEquals((String)"1.2.840.113549.3.2", (String)ed.getEncryptionAlgOID());
        Collection c = recipients.getRecipients();
        Iterator it = c.iterator();
        if (it.hasNext()) {
            while (it.hasNext()) {
                RecipientInformation recipient = (RecipientInformation)it.next();
                if (!(recipient instanceof KeyTransRecipientInformation)) continue;
                byte[] recData = recipient.getContent(new JceKeyTransEnvelopedRecipient(key).setProvider(BC));
                NewEnvelopedDataTest.assertEquals((boolean)true, (boolean)Arrays.equals(data, recData));
            }
        } else {
            NewEnvelopedDataTest.fail((String)"no recipient found");
        }
    }

    public void testOriginatorInfo() throws Exception {
        CMSEnvelopedData env = new CMSEnvelopedData(CMSSampleMessages.originatorMessage);
        RecipientInformationStore recipients = env.getRecipientInfos();
        OriginatorInformation origInfo = env.getOriginatorInfo();
        NewEnvelopedDataTest.assertEquals((Object)new X500Name("C=US,O=U.S. Government,OU=HSPD12Lab,OU=Agents,CN=user1"), (Object)((X509CertificateHolder)origInfo.getCertificates().getMatches(null).iterator().next()).getSubject());
        NewEnvelopedDataTest.assertEquals((String)CMSEnvelopedDataGenerator.DES_EDE3_CBC, (String)env.getEncryptionAlgOID());
    }

    private void passwordTest(String algorithm) throws Exception {
        byte[] recData;
        RecipientInformation recipient;
        byte[] data = Hex.decode("504b492d4320434d5320456e76656c6f706564446174612053616d706c65");
        CMSEnvelopedDataGenerator edGen = new CMSEnvelopedDataGenerator();
        edGen.addRecipientInfoGenerator(new JcePasswordRecipientInfoGenerator(new ASN1ObjectIdentifier(algorithm), "password".toCharArray()).setProvider(BC).setPasswordConversionScheme(0).setSaltAndIterationCount(new byte[20], 5));
        CMSEnvelopedData ed = edGen.generate(new CMSProcessableByteArray(data), new JceCMSContentEncryptorBuilder(CMSAlgorithm.AES128_CBC).setProvider(BC).build());
        RecipientInformationStore recipients = ed.getRecipientInfos();
        NewEnvelopedDataTest.assertEquals((String)ed.getEncryptionAlgOID(), (String)CMSEnvelopedDataGenerator.AES128_CBC);
        Collection c = recipients.getRecipients();
        Iterator it = c.iterator();
        if (it.hasNext()) {
            recipient = (PasswordRecipientInformation)it.next();
            recData = recipient.getContent(new JcePasswordEnvelopedRecipient("password".toCharArray()).setPasswordConversionScheme(0).setProvider(BC));
            NewEnvelopedDataTest.assertEquals((boolean)true, (boolean)Arrays.equals(data, recData));
        } else {
            NewEnvelopedDataTest.fail((String)"no recipient found");
        }
        it = c.iterator();
        recipient = (RecipientInformation)it.next();
        recData = recipient.getContent(new JcePasswordEnvelopedRecipient("password".toCharArray()).setPasswordConversionScheme(0).setProvider(BC));
        NewEnvelopedDataTest.assertEquals((boolean)true, (boolean)Arrays.equals(data, recData));
    }

    private void passwordUTF8Test(String algorithm) throws Exception {
        byte[] recData;
        RecipientInformation recipient;
        byte[] data = Hex.decode("504b492d4320434d5320456e76656c6f706564446174612053616d706c65");
        CMSEnvelopedDataGenerator edGen = new CMSEnvelopedDataGenerator();
        edGen.addRecipientInfoGenerator(new JcePasswordRecipientInfoGenerator(new ASN1ObjectIdentifier(algorithm), "abc\u5639\u563b".toCharArray()).setProvider(BC).setSaltAndIterationCount(new byte[20], 5));
        CMSEnvelopedData ed = edGen.generate(new CMSProcessableByteArray(data), new JceCMSContentEncryptorBuilder(CMSAlgorithm.AES128_CBC).setProvider(BC).build());
        RecipientInformationStore recipients = ed.getRecipientInfos();
        NewEnvelopedDataTest.assertEquals((String)ed.getEncryptionAlgOID(), (String)CMSEnvelopedDataGenerator.AES128_CBC);
        Collection c = recipients.getRecipients();
        Iterator it = c.iterator();
        if (it.hasNext()) {
            recipient = (RecipientInformation)it.next();
            recData = recipient.getContent(new JcePasswordEnvelopedRecipient("abc\u5639\u563b".toCharArray()).setProvider(BC));
            NewEnvelopedDataTest.assertEquals((boolean)true, (boolean)Arrays.equals(data, recData));
        } else {
            NewEnvelopedDataTest.fail((String)"no recipient found");
        }
        it = c.iterator();
        recipient = (RecipientInformation)it.next();
        recData = recipient.getContent(new JcePasswordEnvelopedRecipient("abc\u5639\u563b".toCharArray()).setProvider(BC));
        NewEnvelopedDataTest.assertEquals((boolean)true, (boolean)Arrays.equals(data, recData));
    }

    private void verifyECKeyAgreeVectors(PrivateKey privKey, String wrapAlg, byte[] message) throws CMSException, GeneralSecurityException {
        byte[] data = Hex.decode("504b492d4320434d5320456e76656c6f706564446174612053616d706c65");
        CMSEnvelopedData ed = new CMSEnvelopedData(message);
        RecipientInformationStore recipients = ed.getRecipientInfos();
        Collection c = recipients.getRecipients();
        Iterator it = c.iterator();
        NewEnvelopedDataTest.assertEquals((String)wrapAlg, (String)ed.getEncryptionAlgOID());
        if (it.hasNext()) {
            RecipientInformation recipient = (RecipientInformation)it.next();
            NewEnvelopedDataTest.assertEquals((String)"1.3.133.16.840.63.0.2", (String)recipient.getKeyEncryptionAlgOID());
            byte[] recData = recipient.getContent(new JceKeyAgreeEnvelopedRecipient(privKey).setProvider(BC));
            NewEnvelopedDataTest.assertTrue((boolean)Arrays.equals(data, recData));
        } else {
            NewEnvelopedDataTest.fail((String)"no recipient found");
        }
    }

    private void verifyECMQVKeyAgreeVectors(PrivateKey privKey, String wrapAlg, byte[] message) throws CMSException, GeneralSecurityException {
        byte[] data = Hex.decode("504b492d4320434d5320456e76656c6f706564446174612053616d706c65");
        CMSEnvelopedData ed = new CMSEnvelopedData(message);
        RecipientInformationStore recipients = ed.getRecipientInfos();
        Collection c = recipients.getRecipients();
        Iterator it = c.iterator();
        NewEnvelopedDataTest.assertEquals((String)wrapAlg, (String)ed.getEncryptionAlgOID());
        if (it.hasNext()) {
            RecipientInformation recipient = (RecipientInformation)it.next();
            NewEnvelopedDataTest.assertEquals((String)"1.3.133.16.840.63.0.16", (String)recipient.getKeyEncryptionAlgOID());
            byte[] recData = recipient.getContent(new JceKeyAgreeEnvelopedRecipient(privKey).setProvider(BC));
            NewEnvelopedDataTest.assertTrue((boolean)Arrays.equals(data, recData));
        } else {
            NewEnvelopedDataTest.fail((String)"no recipient found");
        }
    }

    static {
        _initialised = false;
    }
}

