/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.crypto.kems;

import cfca.sadk.org.bouncycastle.crypto.CipherParameters;
import cfca.sadk.org.bouncycastle.crypto.DerivationFunction;
import cfca.sadk.org.bouncycastle.crypto.KeyEncapsulation;
import cfca.sadk.org.bouncycastle.crypto.params.ECDomainParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECKeyParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import cfca.sadk.org.bouncycastle.crypto.params.KDFParameters;
import cfca.sadk.org.bouncycastle.crypto.params.KeyParameter;
import cfca.sadk.org.bouncycastle.math.ec.ECCurve;
import cfca.sadk.org.bouncycastle.math.ec.ECMultiplier;
import cfca.sadk.org.bouncycastle.math.ec.ECPoint;
import cfca.sadk.org.bouncycastle.math.ec.FixedPointCombMultiplier;
import cfca.sadk.org.bouncycastle.util.Arrays;
import cfca.sadk.org.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECIESKeyEncapsulation
implements KeyEncapsulation {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private DerivationFunction kdf;
    private SecureRandom rnd;
    private ECKeyParameters key;
    private boolean CofactorMode;
    private boolean OldCofactorMode;
    private boolean SingleHashMode;

    public ECIESKeyEncapsulation(DerivationFunction kdf, SecureRandom rnd) {
        this.kdf = kdf;
        this.rnd = rnd;
        this.CofactorMode = false;
        this.OldCofactorMode = false;
        this.SingleHashMode = false;
    }

    public ECIESKeyEncapsulation(DerivationFunction kdf, SecureRandom rnd, boolean cofactorMode, boolean oldCofactorMode, boolean singleHashMode) {
        this.kdf = kdf;
        this.rnd = rnd;
        this.CofactorMode = cofactorMode;
        this.OldCofactorMode = oldCofactorMode;
        this.SingleHashMode = singleHashMode;
    }

    public void init(CipherParameters key) throws IllegalArgumentException {
        if (!(key instanceof ECKeyParameters)) {
            throw new IllegalArgumentException("EC key required");
        }
        this.key = (ECKeyParameters)key;
    }

    public CipherParameters encrypt(byte[] out, int outOff, int keyLen) throws IllegalArgumentException {
        if (!(this.key instanceof ECPublicKeyParameters)) {
            throw new IllegalArgumentException("Public key required for encryption");
        }
        ECPublicKeyParameters ecPubKey = (ECPublicKeyParameters)this.key;
        ECDomainParameters ecParams = ecPubKey.getParameters();
        ECCurve curve = ecParams.getCurve();
        BigInteger n = ecParams.getN();
        BigInteger h = ecParams.getH();
        BigInteger r = BigIntegers.createRandomInRange(ONE, n, this.rnd);
        BigInteger rPrime = this.CofactorMode ? r.multiply(h).mod(n) : r;
        ECMultiplier basePointMultiplier = this.createBasePointMultiplier();
        ECPoint[] ghTilde = new ECPoint[]{basePointMultiplier.multiply(ecParams.getG(), r), ecPubKey.getQ().multiply(rPrime)};
        curve.normalizeAll(ghTilde);
        ECPoint gTilde = ghTilde[0];
        ECPoint hTilde = ghTilde[1];
        byte[] C2 = gTilde.getEncoded();
        System.arraycopy(C2, 0, out, outOff, C2.length);
        byte[] PEH = hTilde.getAffineXCoord().getEncoded();
        byte[] kdfInput = this.SingleHashMode ? Arrays.concatenate(C2, PEH) : PEH;
        this.kdf.init(new KDFParameters(kdfInput, null));
        byte[] K = new byte[keyLen];
        this.kdf.generateBytes(K, 0, K.length);
        return new KeyParameter(K);
    }

    public CipherParameters encrypt(byte[] out, int keyLen) {
        return this.encrypt(out, 0, keyLen);
    }

    public CipherParameters decrypt(byte[] in, int inOff, int inLen, int keyLen) throws IllegalArgumentException {
        ECPoint gTilde;
        if (!(this.key instanceof ECPrivateKeyParameters)) {
            throw new IllegalArgumentException("Private key required for encryption");
        }
        ECPrivateKeyParameters ecPrivKey = (ECPrivateKeyParameters)this.key;
        ECDomainParameters ecParams = ecPrivKey.getParameters();
        ECCurve curve = ecParams.getCurve();
        BigInteger n = ecParams.getN();
        BigInteger h = ecParams.getH();
        byte[] C2 = new byte[inLen];
        System.arraycopy(in, inOff, C2, 0, inLen);
        ECPoint gHat = gTilde = curve.decodePoint(C2);
        if (this.CofactorMode || this.OldCofactorMode) {
            gHat = gHat.multiply(h);
        }
        BigInteger xHat = ecPrivKey.getD();
        if (this.CofactorMode) {
            xHat = xHat.multiply(h.modInverse(n)).mod(n);
        }
        ECPoint hTilde = gHat.multiply(xHat).normalize();
        byte[] PEH = hTilde.getAffineXCoord().getEncoded();
        byte[] kdfInput = this.SingleHashMode ? Arrays.concatenate(C2, PEH) : PEH;
        this.kdf.init(new KDFParameters(kdfInput, null));
        byte[] K = new byte[keyLen];
        this.kdf.generateBytes(K, 0, K.length);
        return new KeyParameter(K);
    }

    public CipherParameters decrypt(byte[] in, int keyLen) {
        return this.decrypt(in, 0, in.length, keyLen);
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

