/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.crypto.test;

import cfca.sadk.org.bouncycastle.crypto.BlockCipher;
import cfca.sadk.org.bouncycastle.crypto.Mac;
import cfca.sadk.org.bouncycastle.crypto.engines.DESEngine;
import cfca.sadk.org.bouncycastle.crypto.macs.CBCBlockCipherMac;
import cfca.sadk.org.bouncycastle.crypto.macs.CFBBlockCipherMac;
import cfca.sadk.org.bouncycastle.crypto.paddings.PKCS7Padding;
import cfca.sadk.org.bouncycastle.crypto.params.KeyParameter;
import cfca.sadk.org.bouncycastle.crypto.params.ParametersWithIV;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import cfca.sadk.org.bouncycastle.util.test.SimpleTest;

public class MacTest
extends SimpleTest {
    static byte[] keyBytes = Hex.decode("0123456789abcdef");
    static byte[] ivBytes = Hex.decode("1234567890abcdef");
    static byte[] input1 = Hex.decode("37363534333231204e6f77206973207468652074696d6520666f7220");
    static byte[] output1 = Hex.decode("f1d30f68");
    static byte[] output2 = Hex.decode("58d2e77e");
    static byte[] output3 = Hex.decode("cd647403");
    static byte[] input2 = Hex.decode("3736353433323120");
    static byte[] output4 = Hex.decode("3af549c9");
    static byte[] output5 = Hex.decode("188fbdd5");
    static byte[] output6 = Hex.decode("7045eecd");

    public void performTest() {
        KeyParameter key = new KeyParameter(keyBytes);
        DESEngine cipher = new DESEngine();
        Mac mac = new CBCBlockCipherMac(cipher);
        mac.init(key);
        mac.update(input1, 0, input1.length);
        byte[] out = new byte[4];
        mac.doFinal(out, 0);
        if (!this.areEqual(out, output1)) {
            this.fail("Failed - expected " + new String(Hex.encode(output1)) + " got " + new String(Hex.encode(out)));
        }
        ParametersWithIV param = new ParametersWithIV(key, ivBytes);
        mac.init(param);
        mac.update(input1, 0, input1.length);
        out = new byte[4];
        mac.doFinal(out, 0);
        if (!this.areEqual(out, output2)) {
            this.fail("Failed - expected " + new String(Hex.encode(output2)) + " got " + new String(Hex.encode(out)));
        }
        param = new ParametersWithIV(key, ivBytes);
        mac = new CFBBlockCipherMac(cipher);
        mac.init(param);
        mac.update(input1, 0, input1.length);
        out = new byte[4];
        mac.doFinal(out, 0);
        if (!this.areEqual(out, output3)) {
            this.fail("Failed - expected " + new String(Hex.encode(output3)) + " got " + new String(Hex.encode(out)));
        }
        mac.init(key);
        mac.update(input2, 0, input2.length);
        out = new byte[4];
        mac.doFinal(out, 0);
        if (!this.areEqual(out, output4)) {
            this.fail("Failed - expected " + new String(Hex.encode(output4)) + " got " + new String(Hex.encode(out)));
        }
        mac = new CBCBlockCipherMac((BlockCipher)cipher, new PKCS7Padding());
        mac.init(key);
        mac.update(input2, 0, input2.length);
        out = new byte[4];
        mac.doFinal(out, 0);
        if (!this.areEqual(out, output5)) {
            this.fail("Failed - expected " + new String(Hex.encode(output5)) + " got " + new String(Hex.encode(out)));
        }
        mac.reset();
        mac.update(input1, 0, input1.length);
        out = new byte[4];
        mac.doFinal(out, 0);
        if (!this.areEqual(out, output6)) {
            this.fail("Failed - expected " + new String(Hex.encode(output6)) + " got " + new String(Hex.encode(out)));
        }
        mac.init(key);
        mac.update(input1, 0, input1.length);
        out = new byte[4];
        mac.doFinal(out, 0);
        if (!this.areEqual(out, output6)) {
            this.fail("Failed - expected " + new String(Hex.encode(output6)) + " got " + new String(Hex.encode(out)));
        }
    }

    public String getName() {
        return "Mac";
    }

    public static void main(String[] args) {
        MacTest.runTest(new MacTest());
    }
}

