/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.crypto.tls.test;

import cfca.sadk.org.bouncycastle.asn1.x500.X500Name;
import cfca.sadk.org.bouncycastle.crypto.tls.Certificate;
import cfca.sadk.org.bouncycastle.crypto.tls.CertificateRequest;
import cfca.sadk.org.bouncycastle.crypto.tls.DefaultTlsServer;
import cfca.sadk.org.bouncycastle.crypto.tls.ProtocolVersion;
import cfca.sadk.org.bouncycastle.crypto.tls.SignatureAndHashAlgorithm;
import cfca.sadk.org.bouncycastle.crypto.tls.TlsEncryptionCredentials;
import cfca.sadk.org.bouncycastle.crypto.tls.TlsSignerCredentials;
import cfca.sadk.org.bouncycastle.crypto.tls.TlsUtils;
import cfca.sadk.org.bouncycastle.crypto.tls.test.TlsTestUtils;
import cfca.sadk.org.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Vector;

class MockTlsServer
extends DefaultTlsServer {
    MockTlsServer() {
    }

    public void notifyAlertRaised(short alertLevel, short alertDescription, String message, Exception cause) {
        PrintStream out = alertLevel == 2 ? System.err : System.out;
        out.println("TLS server raised alert (AlertLevel." + alertLevel + ", AlertDescription." + alertDescription + ")");
        if (message != null) {
            out.println("> " + message);
        }
        if (cause != null) {
            cause.printStackTrace(out);
        }
    }

    public void notifyAlertReceived(short alertLevel, short alertDescription) {
        PrintStream out = alertLevel == 2 ? System.err : System.out;
        out.println("TLS server received alert (AlertLevel." + alertLevel + ", AlertDescription." + alertDescription + ")");
    }

    protected int[] getCipherSuites() {
        return Arrays.concatenate(super.getCipherSuites(), new int[]{52243, 58386, 58387, 58384, 58385});
    }

    protected ProtocolVersion getMaximumVersion() {
        return ProtocolVersion.TLSv12;
    }

    public ProtocolVersion getServerVersion() throws IOException {
        ProtocolVersion serverVersion = super.getServerVersion();
        System.out.println("TLS server negotiated " + serverVersion);
        return serverVersion;
    }

    public CertificateRequest getCertificateRequest() throws IOException {
        Vector<SignatureAndHashAlgorithm> serverSigAlgs = null;
        if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(this.serverVersion)) {
            short[] hashAlgorithms = new short[]{6, 5, 4, 3, 2};
            short[] signatureAlgorithms = new short[]{1};
            serverSigAlgs = new Vector<SignatureAndHashAlgorithm>();
            for (int i = 0; i < hashAlgorithms.length; ++i) {
                for (int j = 0; j < signatureAlgorithms.length; ++j) {
                    serverSigAlgs.addElement(new SignatureAndHashAlgorithm(hashAlgorithms[i], signatureAlgorithms[j]));
                }
            }
        }
        Vector<X500Name> certificateAuthorities = new Vector<X500Name>();
        certificateAuthorities.add(TlsTestUtils.loadCertificateResource("x509-ca.pem").getSubject());
        return new CertificateRequest(new short[]{1}, serverSigAlgs, certificateAuthorities);
    }

    public void notifyClientCertificate(Certificate clientCertificate) throws IOException {
        cfca.sadk.org.bouncycastle.asn1.x509.Certificate[] chain = clientCertificate.getCertificateList();
        System.out.println("TLS server received client certificate chain of length " + chain.length);
        for (int i = 0; i != chain.length; ++i) {
            cfca.sadk.org.bouncycastle.asn1.x509.Certificate entry = chain[i];
            System.out.println("    fingerprint:SHA-256 " + TlsTestUtils.fingerprint(entry) + " (" + entry.getSubject() + ")");
        }
    }

    protected TlsEncryptionCredentials getRSAEncryptionCredentials() throws IOException {
        return TlsTestUtils.loadEncryptionCredentials(this.context, new String[]{"x509-server.pem", "x509-ca.pem"}, "x509-server-key.pem");
    }

    protected TlsSignerCredentials getRSASignerCredentials() throws IOException {
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = null;
        Vector sigAlgs = this.supportedSignatureAlgorithms;
        if (sigAlgs != null) {
            for (int i = 0; i < sigAlgs.size(); ++i) {
                SignatureAndHashAlgorithm sigAlg = (SignatureAndHashAlgorithm)sigAlgs.elementAt(i);
                if (sigAlg.getSignature() != 1) continue;
                signatureAndHashAlgorithm = sigAlg;
                break;
            }
            if (signatureAndHashAlgorithm == null) {
                return null;
            }
        }
        return TlsTestUtils.loadSignerCredentials(this.context, new String[]{"x509-server.pem", "x509-ca.pem"}, "x509-server-key.pem", signatureAndHashAlgorithm);
    }
}

