/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.crypto.tls.test;

import cfca.sadk.org.bouncycastle.crypto.tls.TlsClient;
import cfca.sadk.org.bouncycastle.crypto.tls.TlsClientProtocol;
import cfca.sadk.org.bouncycastle.crypto.tls.test.MockTlsClient;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.security.SecureRandom;

public class TlsClientTest {
    private static final SecureRandom secureRandom = new SecureRandom();

    public static void main(String[] args) throws Exception {
        String line;
        InetAddress address = InetAddress.getLocalHost();
        int port = 5556;
        long time1 = System.currentTimeMillis();
        MockTlsClient client = new MockTlsClient(null);
        TlsClientProtocol protocol = TlsClientTest.openTlsConnection(address, port, client);
        protocol.close();
        long time2 = System.currentTimeMillis();
        System.out.println("Elapsed 1: " + (time2 - time1) + "ms");
        client = new MockTlsClient(client.getSessionToResume());
        protocol = TlsClientTest.openTlsConnection(address, port, client);
        long time3 = System.currentTimeMillis();
        System.out.println("Elapsed 2: " + (time3 - time2) + "ms");
        OutputStream output = protocol.getOutputStream();
        output.write("GET / HTTP/1.1\r\n\r\n".getBytes("UTF-8"));
        output.flush();
        InputStream input = protocol.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        while ((line = reader.readLine()) != null) {
            System.out.println(">>> " + line);
        }
        protocol.close();
    }

    static TlsClientProtocol openTlsConnection(InetAddress address, int port, TlsClient client) throws IOException {
        Socket s = new Socket(address, port);
        TlsClientProtocol protocol = new TlsClientProtocol(s.getInputStream(), s.getOutputStream(), secureRandom);
        protocol.connect(client);
        return protocol;
    }
}

