/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.jce.provider.test;

import cfca.sadk.org.bouncycastle.crypto.agreement.DHBasicAgreement;
import cfca.sadk.org.bouncycastle.crypto.digests.SHA1Digest;
import cfca.sadk.org.bouncycastle.crypto.engines.DESEngine;
import cfca.sadk.org.bouncycastle.crypto.engines.IESEngine;
import cfca.sadk.org.bouncycastle.crypto.generators.KDF2BytesGenerator;
import cfca.sadk.org.bouncycastle.crypto.macs.HMac;
import cfca.sadk.org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.dh.IESCipher;
import cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;
import cfca.sadk.org.bouncycastle.jce.spec.IESParameterSpec;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import cfca.sadk.org.bouncycastle.util.test.SimpleTest;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;

public class DHIESTest
extends SimpleTest {
    BigInteger p1024 = new BigInteger("FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE65381FFFFFFFFFFFFFFFF", 16);
    BigInteger g1024 = new BigInteger("2", 16);
    DHParameterSpec param = new DHParameterSpec(this.p1024, this.g1024);

    DHIESTest() {
    }

    public String getName() {
        return "DHIES";
    }

    public void performTest() throws Exception {
        byte[] derivation = Hex.decode("202122232425262728292a2b2c2d2e2f");
        byte[] encoding = Hex.decode("303132333435363738393a3b3c3d3e3f");
        IESCipher c1 = new IESCipher.IES();
        IESCipher c2 = new IESCipher.IES();
        IESParameterSpec params = new IESParameterSpec(derivation, encoding, 128);
        KeyPairGenerator g = KeyPairGenerator.getInstance("DH", "BC");
        g.initialize(this.param);
        this.doTest("DHIES with default", g, "DHIES", params);
        g.initialize(512, new SecureRandom());
        this.doTest("DHIES with 512-bit", g, "DHIES", params);
        g.initialize(1024, new SecureRandom());
        this.doTest("DHIES with 1024-bit", g, "DHIES", params);
        c1 = new IESCipher(new IESEngine(new DHBasicAgreement(), new KDF2BytesGenerator(new SHA1Digest()), new HMac(new SHA1Digest()), new PaddedBufferedBlockCipher(new DESEngine())));
        c2 = new IESCipher(new IESEngine(new DHBasicAgreement(), new KDF2BytesGenerator(new SHA1Digest()), new HMac(new SHA1Digest()), new PaddedBufferedBlockCipher(new DESEngine())));
        params = new IESParameterSpec(derivation, encoding, 128, 192);
        g = KeyPairGenerator.getInstance("DH", "BC");
        this.doTest("DHIESwithDES default", g, "DHIESwithDESEDE", params);
        g.initialize(512, new SecureRandom());
        this.doTest("DHIESwithDES 512-bit", g, "DHIESwithDESEDE", params);
        g.initialize(1024, new SecureRandom());
        this.doTest("DHIESwithDES 1024-bit", g, "DHIESwithDESEDE", params);
        g = KeyPairGenerator.getInstance("DH", "BC");
        g.initialize(this.param);
        c1 = new IESCipher.IESwithAES();
        c2 = new IESCipher.IESwithAES();
        params = new IESParameterSpec(derivation, encoding, 128, 128);
        this.doTest("DHIESwithAES default", g, "DHIESwithAES", params);
        g.initialize(512, new SecureRandom());
        this.doTest("DHIESwithAES 512-bit", g, "DHIESwithAES", params);
        g.initialize(1024, new SecureRandom());
        this.doTest("DHIESwithAES 1024-bit", g, "DHIESwithAES", params);
    }

    public void doTest(String testname, KeyPairGenerator g, String cipher, IESParameterSpec p) throws Exception {
        byte[] message = Hex.decode("0102030405060708090a0b0c0d0e0f10111213141516");
        Cipher c1 = Cipher.getInstance(cipher, "BC");
        Cipher c2 = Cipher.getInstance(cipher, "BC");
        KeyPair keyPair = g.generateKeyPair();
        DHPublicKey pub = (DHPublicKey)keyPair.getPublic();
        DHPrivateKey priv = (DHPrivateKey)keyPair.getPrivate();
        c1.init(1, (Key)pub, new SecureRandom());
        c2.init(2, (Key)priv, new SecureRandom());
        byte[] out1 = c1.doFinal(message, 0, message.length);
        byte[] out2 = c2.doFinal(out1, 0, out1.length);
        if (!this.areEqual(out2, message)) {
            this.fail(testname + " test failed with null parameters, DHAES mode false.");
        }
        c1.init(1, (Key)pub, p, new SecureRandom());
        c2.init(2, (Key)priv, p, new SecureRandom());
        out1 = c1.doFinal(message, 0, message.length);
        out2 = c2.doFinal(out1, 0, out1.length);
        if (!this.areEqual(out2, message)) {
            this.fail(testname + " test failed with non-null parameters, DHAES mode false.");
        }
        c1 = Cipher.getInstance(cipher + "/DHAES/PKCS7Padding", "BC");
        c2 = Cipher.getInstance(cipher + "/DHAES/PKCS7Padding", "BC");
        c1.init(1, (Key)pub, new SecureRandom());
        c2.init(2, (Key)priv, new SecureRandom());
        out1 = c1.doFinal(message, 0, message.length);
        out2 = c2.doFinal(out1, 0, out1.length);
        if (!this.areEqual(out2, message)) {
            this.fail(testname + " test failed with null parameters, DHAES mode true.");
        }
        c1 = Cipher.getInstance(cipher + "/DHAES/PKCS7Padding", "BC");
        c2 = Cipher.getInstance(cipher + "/DHAES/PKCS7Padding", "BC");
        c1.init(1, (Key)pub, p, new SecureRandom());
        c2.init(2, (Key)priv, p, new SecureRandom());
        out1 = c1.doFinal(message, 0, message.length);
        out2 = c2.doFinal(out1, 0, out1.length);
        if (!this.areEqual(out2, message)) {
            this.fail(testname + " test failed with non-null parameters, DHAES mode true.");
        }
    }

    public static void main(String[] args) {
        Security.addProvider(new BouncyCastleProvider());
        DHIESTest.runTest(new DHIESTest());
    }
}

