/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.pqc.crypto.test;

import cfca.sadk.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import cfca.sadk.org.bouncycastle.crypto.digests.SHA224Digest;
import cfca.sadk.org.bouncycastle.crypto.params.ParametersWithRandom;
import cfca.sadk.org.bouncycastle.pqc.crypto.DigestingMessageSigner;
import cfca.sadk.org.bouncycastle.pqc.crypto.rainbow.RainbowKeyGenerationParameters;
import cfca.sadk.org.bouncycastle.pqc.crypto.rainbow.RainbowKeyPairGenerator;
import cfca.sadk.org.bouncycastle.pqc.crypto.rainbow.RainbowParameters;
import cfca.sadk.org.bouncycastle.pqc.crypto.rainbow.RainbowSigner;
import cfca.sadk.org.bouncycastle.util.BigIntegers;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import cfca.sadk.org.bouncycastle.util.test.FixedSecureRandom;
import cfca.sadk.org.bouncycastle.util.test.SimpleTest;
import java.math.BigInteger;
import java.security.SecureRandom;

public class RainbowSignerTest
extends SimpleTest {
    byte[] keyData = Hex.decode("b5014e4b60ef2ba8b6211b4062ba3224e0427dd3");
    SecureRandom keyRandom = new FixedSecureRandom(new byte[][]{this.keyData, this.keyData});

    public String getName() {
        return "Rainbow";
    }

    public void performTest() {
        RainbowParameters params = new RainbowParameters();
        RainbowKeyPairGenerator rainbowKeyGen = new RainbowKeyPairGenerator();
        RainbowKeyGenerationParameters genParam = new RainbowKeyGenerationParameters(this.keyRandom, params);
        rainbowKeyGen.init(genParam);
        AsymmetricCipherKeyPair pair = rainbowKeyGen.generateKeyPair();
        ParametersWithRandom param = new ParametersWithRandom(pair.getPrivate(), this.keyRandom);
        DigestingMessageSigner rainbowSigner = new DigestingMessageSigner(new RainbowSigner(), new SHA224Digest());
        rainbowSigner.init(true, param);
        byte[] message = BigIntegers.asUnsignedByteArray(new BigInteger("968236873715988614170569073515315707566766479517"));
        rainbowSigner.update(message, 0, message.length);
        byte[] sig = rainbowSigner.generateSignature();
        rainbowSigner.init(false, pair.getPublic());
        rainbowSigner.update(message, 0, message.length);
        if (!rainbowSigner.verify(sig)) {
            this.fail("verification fails");
        }
    }

    public static void main(String[] args) {
        RainbowSignerTest.runTest(new RainbowSignerTest());
    }
}

