/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.util;

import cfca.sadk.algorithm.common.CBCParam;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKCS7EnvelopedData;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.sm2.SM4Engine;
import cfca.sadk.algorithm.util.BigFileCipherUtil;
import cfca.sadk.algorithm.util.RSAAndItsCloseSymAlgUtil;
import cfca.sadk.algorithm.util.SM2AndItsCloseSymAlgUtil;
import cfca.sadk.asn1.parser.ASN1Node;
import cfca.sadk.asn1.parser.EnvelopFileParser;
import cfca.sadk.envelope.rsa.RSAEnvelopeUtil;
import cfca.sadk.envelope.sm2.SM2EnvelopeUtil;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.jni.JNISoftLib;
import cfca.sadk.lib.crypto.jni.JNISymAlg;
import cfca.sadk.org.bouncycastle.asn1.ASN1OctetString;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.ASN1Set;
import cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import cfca.sadk.org.bouncycastle.asn1.cms.ContentInfo;
import cfca.sadk.org.bouncycastle.asn1.cms.EncryptedContentInfo;
import cfca.sadk.org.bouncycastle.asn1.cms.EnvelopedData;
import cfca.sadk.org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import cfca.sadk.org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import cfca.sadk.org.bouncycastle.asn1.cms.RecipientIdentifier;
import cfca.sadk.org.bouncycastle.asn1.cms.RecipientInfo;
import cfca.sadk.org.bouncycastle.asn1.x500.X500Name;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.cms.CMSEnvelopedData;
import cfca.sadk.org.bouncycastle.crypto.BlockCipher;
import cfca.sadk.org.bouncycastle.crypto.StreamCipher;
import cfca.sadk.org.bouncycastle.crypto.engines.DESedeEngine;
import cfca.sadk.org.bouncycastle.crypto.engines.RC4Engine;
import cfca.sadk.org.bouncycastle.crypto.modes.CBCBlockCipher;
import cfca.sadk.org.bouncycastle.crypto.paddings.PKCS7Padding;
import cfca.sadk.org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import cfca.sadk.org.bouncycastle.crypto.params.KeyParameter;
import cfca.sadk.org.bouncycastle.crypto.params.ParametersWithIV;
import cfca.sadk.system.global.FileAndBufferConfig;
import cfca.sadk.util.Base64;
import cfca.sadk.util.CertUtil;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.security.PrivateKey;

public class EnvelopeUtil {
    public static boolean isRecipient(X509Cert recipientCert, byte[] envelopeData) throws PKIException {
        try {
            byte[] bEnvelop = Base64.decode(envelopeData);
            CMSEnvelopedData cmsEnData = new CMSEnvelopedData(bEnvelop);
            ContentInfo info = cmsEnData.toASN1Structure();
            EnvelopedData enData = EnvelopedData.getInstance(info.getContent());
            ASN1Set receivers = enData.getRecipientInfos();
            X500Name recipientIssuer = recipientCert.getIssuerX500Name();
            BigInteger recipientSN = recipientCert.getSerialNumber();
            byte[] subjectPubKeyID = recipientCert.getSubjectKeyIdentifier().getKeyIdentifier();
            if (receivers == null) {
                return false;
            }
            int len = receivers.size();
            for (int i = 0; i < len; ++i) {
                KeyTransRecipientInfo inf;
                RecipientInfo recip = RecipientInfo.getInstance(receivers.getObjectAt(i));
                if (!(recip.getInfo() instanceof KeyTransRecipientInfo) || !EnvelopeUtil.hasRecipent(inf = KeyTransRecipientInfo.getInstance(recip.getInfo()), subjectPubKeyID, recipientIssuer, recipientSN)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public static byte[] envelopeMessage(byte[] sourceData, String symmetricAlgorithm, X509Cert[] receiverCerts) throws PKIException {
        try {
            if (sourceData == null || sourceData.length <= 0) {
                throw new PKIException("the souce data is null or empty!");
            }
            if (CertUtil.isSM2Cert(receiverCerts[0])) {
                return SM2EnvelopeUtil.envelopeMessage(sourceData, symmetricAlgorithm, receiverCerts);
            }
            return RSAEnvelopeUtil.envelopeMessage(sourceData, symmetricAlgorithm, receiverCerts);
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public static byte[] envelopeMessage(byte[] sourceData, String symmetricAlgorithm, X509Cert[] receiverCerts, Session session) throws PKIException {
        try {
            if (sourceData == null || sourceData.length <= 0) {
                throw new PKIException("the souce data is null or empty!");
            }
            if (CertUtil.isSM2Cert(receiverCerts[0])) {
                return SM2EnvelopeUtil.envelopeMessage(sourceData, symmetricAlgorithm, receiverCerts, session);
            }
            return RSAEnvelopeUtil.envelopeMessage(sourceData, symmetricAlgorithm, receiverCerts, session);
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public static void envelopeFile(String sourceFilePath, String encryptFilePath, String symmetricAlgorithm, X509Cert[] receiverCerts) throws PKIException {
        try {
            File srcFile = new File(sourceFilePath);
            if (srcFile.length() <= 0L) {
                throw new PKIException("the souce file is null or empty!");
            }
            if (CertUtil.isSM2Cert(receiverCerts[0])) {
                SM2EnvelopeUtil.envelopeFile(sourceFilePath, encryptFilePath, symmetricAlgorithm, receiverCerts);
            } else {
                RSAEnvelopeUtil.envelopeFile(sourceFilePath, encryptFilePath, symmetricAlgorithm, receiverCerts);
            }
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public static void envelopeFile(String sourceFilePath, String encryptFilePath, String symmetricAlgorithm, X509Cert[] receiverCerts, Session session) throws PKIException {
        try {
            File srcFile = new File(sourceFilePath);
            if (srcFile.length() <= 0L) {
                throw new PKIException("the souce file is null or empty!");
            }
            if (CertUtil.isSM2Cert(receiverCerts[0])) {
                SM2EnvelopeUtil.envelopeFile(sourceFilePath, encryptFilePath, symmetricAlgorithm, receiverCerts, session);
            } else {
                RSAEnvelopeUtil.envelopeFile(sourceFilePath, encryptFilePath, symmetricAlgorithm, receiverCerts, session);
            }
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public static final void openEnvelopedFile(String envelopedFilePath, String plainTextFilePath, PrivateKey privateKey, X509Cert recipientCert, Session session) throws PKIException {
        try {
            EnvelopFileParser parser = new EnvelopFileParser(new File(envelopedFilePath));
            parser.parser();
            ASN1Node receiver_node = parser.getReceiver_node();
            ASN1Node encrypted_node = parser.getEncrypted_node();
            EnvelopeUtil.openEnvelopFile_ASN1Node(receiver_node, encrypted_node, privateKey, recipientCert, plainTextFilePath, session);
        }
        catch (Exception e) {
            throw new PKIException("850935", "\u89e3\u6790\u6d88\u606f\u6570\u5b57\u4fe1\u5c01\u5931\u8d25", e);
        }
    }

    private static boolean hasRecipent(KeyTransRecipientInfo inf, byte[] subjectPubKeyID, X500Name recipientIssuer, BigInteger recipientSN) {
        RecipientIdentifier id = inf.getRecipientIdentifier();
        DEROctetString oct = new DEROctetString(subjectPubKeyID);
        IssuerAndSerialNumber issu = new IssuerAndSerialNumber(recipientIssuer, recipientSN);
        return id.getId().toASN1Primitive().asn1Equals(oct) || id.getId().toASN1Primitive().asn1Equals(issu.toASN1Primitive());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void openEnvelopFile_ASN1Node(ASN1Node receiver_node, ASN1Node encrypted_node, PrivateKey privateKey, X509Cert recipientCert, String plainTextFilePath, Session session) throws PKIException {
        FilterOutputStream fos = null;
        RandomAccessFile raf = null;
        boolean isSM2Type = CertUtil.isSM2Cert(recipientCert);
        Object cipherEngine = null;
        try {
            X500Name recipientIssuer = recipientCert.getIssuerX500Name();
            BigInteger recipientSN = recipientCert.getSerialNumber();
            byte[] subjectPubKeyID = recipientCert.getSubjectKeyIdentifier().getKeyIdentifier();
            ASN1Set receivers = ASN1Set.getInstance(receiver_node.getData());
            int len = receivers.size();
            ASN1OctetString encryptKey = null;
            AlgorithmIdentifier algId = null;
            for (int i = 0; i < len; ++i) {
                KeyTransRecipientInfo inf;
                RecipientInfo recip = RecipientInfo.getInstance(receivers.getObjectAt(i));
                if (!(recip.getInfo() instanceof KeyTransRecipientInfo) || !EnvelopeUtil.hasRecipent(inf = KeyTransRecipientInfo.getInstance(recip.getInfo()), subjectPubKeyID, recipientIssuer, recipientSN)) continue;
                encryptKey = inf.getEncryptedKey();
                algId = inf.getKeyEncryptionAlgorithm();
                break;
            }
            if (encryptKey == null || algId == null) {
                throw new Exception("can not find the receiver!!!");
            }
            ASN1Node symmetric_encrypted = (ASN1Node)encrypted_node.childNodes.get(1);
            byte[] symmetricAlg_byte = symmetric_encrypted.getData();
            AlgorithmIdentifier symmetricAlgId = AlgorithmIdentifier.getInstance(ASN1Sequence.getInstance(symmetricAlg_byte));
            String encryptionAlgStr = (String)PKCS7EnvelopedData.OID_MECH.get(symmetricAlgId.getAlgorithm());
            Mechanism mechanism = null;
            boolean useJNIFlag = false;
            if (session != null && session instanceof JNISoftLib) {
                useJNIFlag = true;
            }
            if (encryptionAlgStr.indexOf("CBC") != -1) {
                DEROctetString doct = (DEROctetString)symmetricAlgId.getParameters();
                byte[] iv = null;
                CBCParam cbcParam = new CBCParam();
                iv = doct.getOctets();
                cbcParam.setIv(iv);
                if (encryptionAlgStr.equals("DESede/CBC/PKCS7Padding")) {
                    mechanism = new Mechanism("DESede/CBC/PKCS7Padding", cbcParam);
                } else if (encryptionAlgStr.equals("SM4/CBC/PKCS7Padding")) {
                    mechanism = new Mechanism("SM4/CBC/PKCS7Padding", cbcParam);
                }
            } else if (encryptionAlgStr.indexOf("ECB") != -1) {
                if (encryptionAlgStr.equals("DESede/ECB/PKCS7Padding")) {
                    mechanism = new Mechanism("DESede/ECB/PKCS7Padding");
                } else if (encryptionAlgStr.equals("SM4/ECB/PKCS7Padding")) {
                    mechanism = new Mechanism("SM4/ECB/PKCS7Padding");
                }
            } else if (encryptionAlgStr.indexOf("RC4") != -1) {
                mechanism = new Mechanism("RC4");
            }
            if (mechanism == null) {
                throw new PKIException(PKIException.UNSUPPORT_ENCRYPT_ALG_SIGNANDENVELOP_ERR, PKIException.UNSUPPORT_ENCRYPT_ALG_SIGNANDENVELOP_ERR_DES + "Algorithm is:" + encryptionAlgStr);
            }
            Mechanism contentEncryptionAlg = null;
            contentEncryptionAlg = isSM2Type ? new Mechanism("SM2") : new Mechanism("RSA/ECB/PKCS1PADDING");
            byte[] symmetricKey = session.decrypt(contentEncryptionAlg, privateKey, encryptKey.getOctets());
            File f = new File(plainTextFilePath);
            if (!f.exists()) {
                f.createNewFile();
            }
            fos = new BufferedOutputStream(new FileOutputStream(f), FileAndBufferConfig.BIG_FILE_BUFFER);
            ASN1Node file_encrypted = (ASN1Node)encrypted_node.childNodes.get(2);
            if (isSM2Type) {
                if (file_encrypted.childNodes.size() == 1) {
                    file_encrypted = (ASN1Node)file_encrypted.childNodes.get(0);
                }
                if (useJNIFlag && encryptionAlgStr.equals("SM4/CBC/PKCS7Padding")) {
                    BigFileCipherUtil.bigFileDecrypt_JNI(JNISymAlg.NID_ChinaSM4_CBC, symmetricKey, (CBCParam)mechanism.getParam(), file_encrypted, fos);
                    return;
                } else {
                    cipherEngine = new SM4Engine();
                    BigFileCipherUtil.bigFileBlockDecrypt(symmetricKey, (BlockCipher)cipherEngine, (CBCParam)mechanism.getParam(), file_encrypted, fos);
                }
                return;
            } else if (file_encrypted.childNodes.size() < 2) {
                if (file_encrypted.childNodes.size() == 1) {
                    file_encrypted = (ASN1Node)file_encrypted.childNodes.get(0);
                }
                if (mechanism.getMechanismType().equals("RC4")) {
                    if (useJNIFlag) {
                        BigFileCipherUtil.bigFileDecrypt_JNI(JNISymAlg.NID_rc4, symmetricKey, null, file_encrypted, fos);
                        return;
                    } else {
                        cipherEngine = new RC4Engine();
                        BigFileCipherUtil.bigFileRC4Decrypt((StreamCipher)cipherEngine, symmetricKey, file_encrypted, fos);
                    }
                    return;
                } else if (useJNIFlag) {
                    if (encryptionAlgStr.equals("DESede/CBC/PKCS7Padding")) {
                        BigFileCipherUtil.bigFileDecrypt_JNI(JNISymAlg.NID_des_ede3_cbc, symmetricKey, (CBCParam)mechanism.getParam(), file_encrypted, fos);
                        return;
                    } else {
                        if (!encryptionAlgStr.equals("DESede/ECB/PKCS7Padding")) throw new PKIException("do not support this algorithm:" + encryptionAlgStr);
                        BigFileCipherUtil.bigFileDecrypt_JNI(JNISymAlg.NID_des_ede3_ecb, symmetricKey, null, file_encrypted, fos);
                    }
                    return;
                } else {
                    cipherEngine = new DESedeEngine();
                    BigFileCipherUtil.bigFileBlockDecrypt(symmetricKey, (BlockCipher)cipherEngine, (CBCParam)mechanism.getParam(), file_encrypted, fos);
                }
                return;
            } else if (mechanism.getMechanismType().equals("RC4")) {
                raf = new RandomAccessFile(file_encrypted.f, "r");
                if (useJNIFlag) {
                    BigFileCipherUtil.bigFileDecrypt_JNI(JNISymAlg.NID_rc4, symmetricKey, null, file_encrypted, fos, raf);
                    return;
                } else {
                    RC4Engine rc4 = new RC4Engine();
                    KeyParameter keyParam = new KeyParameter(symmetricKey);
                    rc4.init(false, keyParam);
                    BigFileCipherUtil.bigFileRC4Decrypt((StreamCipher)rc4, file_encrypted, fos, raf);
                }
                return;
            } else {
                raf = new RandomAccessFile(file_encrypted.f, "r");
                if (useJNIFlag) {
                    if (encryptionAlgStr.equals("DESede/CBC/PKCS7Padding")) {
                        BigFileCipherUtil.bigFileDecrypt_JNI(JNISymAlg.NID_des_ede3_cbc, symmetricKey, (CBCParam)mechanism.getParam(), file_encrypted, fos, raf);
                        return;
                    } else {
                        if (!encryptionAlgStr.equals("DESede/ECB/PKCS7Padding")) throw new PKIException("do not support this algorithm:" + encryptionAlgStr);
                        BigFileCipherUtil.bigFileDecrypt_JNI(JNISymAlg.NID_des_ede3_ecb, symmetricKey, null, file_encrypted, fos, raf);
                    }
                    return;
                } else {
                    cipherEngine = new DESedeEngine();
                    PaddedBufferedBlockCipher cipher = null;
                    CBCParam param = (CBCParam)mechanism.getParam();
                    if (param == null) {
                        cipher = new PaddedBufferedBlockCipher((BlockCipher)cipherEngine, new PKCS7Padding());
                        KeyParameter params = new KeyParameter(symmetricKey);
                        cipher.init(false, params);
                    } else {
                        cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher((BlockCipher)cipherEngine), new PKCS7Padding());
                        ParametersWithIV params = new ParametersWithIV(new KeyParameter(symmetricKey), param.getIv());
                        cipher.init(false, params);
                    }
                    BigFileCipherUtil.bigFileBlockDecrypt(cipher, file_encrypted, fos, raf);
                }
            }
            return;
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    throw new PKIException(e.getMessage());
                }
            }
        }
    }

    public static final byte[] openEvelopedMessage(byte[] cmsEnvelopedData, PrivateKey privateKey, X509Cert recipientCert, Session session) throws PKIException {
        try {
            byte[] bEnvelop = null;
            boolean isSM2Type = CertUtil.isSM2Cert(recipientCert);
            bEnvelop = Base64.decode(cmsEnvelopedData);
            CMSEnvelopedData cmsEnData = new CMSEnvelopedData(bEnvelop);
            ContentInfo info = cmsEnData.toASN1Structure();
            EnvelopedData enData = EnvelopedData.getInstance(info.getContent());
            ASN1Set receivers = enData.getRecipientInfos();
            X500Name recipientIssuer = recipientCert.getIssuerX500Name();
            BigInteger recipientSN = recipientCert.getSerialNumber();
            byte[] subjectPubKeyID = recipientCert.getSubjectKeyIdentifier().getKeyIdentifier();
            if (receivers == null) {
                throw new PKIException("the receiver is null!!!");
            }
            ASN1OctetString encryptKey = null;
            AlgorithmIdentifier algId = null;
            int len = receivers.size();
            for (int i = 0; i < len; ++i) {
                KeyTransRecipientInfo inf;
                RecipientInfo recip = RecipientInfo.getInstance(receivers.getObjectAt(i));
                if (!(recip.getInfo() instanceof KeyTransRecipientInfo) || !EnvelopeUtil.hasRecipent(inf = KeyTransRecipientInfo.getInstance(recip.getInfo()), subjectPubKeyID, recipientIssuer, recipientSN)) continue;
                encryptKey = inf.getEncryptedKey();
                algId = inf.getKeyEncryptionAlgorithm();
                break;
            }
            if (encryptKey == null || algId == null) {
                throw new PKIException("can not find the receiver!!!");
            }
            Mechanism contentEncryptionAlg = null;
            contentEncryptionAlg = isSM2Type ? new Mechanism("SM2") : new Mechanism("RSA/ECB/PKCS1PADDING");
            byte[] symmetricKey = session.decrypt(contentEncryptionAlg, privateKey, encryptKey.getOctets());
            EncryptedContentInfo data = enData.getEncryptedContentInfo();
            ASN1OctetString os = data.getEncryptedContent();
            AlgorithmIdentifier symmetricAlgId = data.getContentEncryptionAlgorithm();
            String encryptionAlgStr = (String)PKCS7EnvelopedData.OID_MECH.get(symmetricAlgId.getAlgorithm());
            Mechanism mechanism = null;
            if (encryptionAlgStr.indexOf("CBC") != -1) {
                DEROctetString doct = (DEROctetString)symmetricAlgId.getParameters();
                byte[] iv = null;
                CBCParam cbcParam = new CBCParam();
                iv = doct.getOctets();
                cbcParam.setIv(iv);
                if (encryptionAlgStr.equals("DESede/CBC/PKCS7Padding")) {
                    mechanism = new Mechanism("DESede/CBC/PKCS7Padding", cbcParam);
                } else if (encryptionAlgStr.equals("SM4/CBC/PKCS7Padding")) {
                    mechanism = new Mechanism("SM4/CBC/PKCS7Padding", cbcParam);
                }
            } else if (encryptionAlgStr.indexOf("ECB") != -1) {
                if (encryptionAlgStr.equals("DESede/ECB/PKCS7Padding")) {
                    mechanism = new Mechanism("DESede/ECB/PKCS7Padding");
                } else if (encryptionAlgStr.equals("SM4/ECB/PKCS7Padding")) {
                    mechanism = new Mechanism("SM4/ECB/PKCS7Padding");
                }
            } else if (encryptionAlgStr.indexOf("RC4") != -1) {
                mechanism = new Mechanism("RC4");
            }
            if (mechanism == null) {
                throw new PKIException(PKIException.UNSUPPORT_ENCRYPT_ALG_SIGNANDENVELOP_ERR, PKIException.UNSUPPORT_ENCRYPT_ALG_SIGNANDENVELOP_ERR_DES + "Algorithm is:" + encryptionAlgStr);
            }
            boolean useJNI = false;
            if (session != null && session instanceof JNISoftLib) {
                useJNI = true;
            }
            byte[] sourceData = null;
            sourceData = isSM2Type ? SM2AndItsCloseSymAlgUtil.crypto(useJNI, false, symmetricKey, os.getOctets(), mechanism) : RSAAndItsCloseSymAlgUtil.crypto(useJNI, false, symmetricKey, os.getOctets(), mechanism);
            return sourceData;
        }
        catch (Exception e) {
            throw new PKIException("850935", "\u89e3\u6790\u6d88\u606f\u6570\u5b57\u4fe1\u5c01\u5931\u8d25", e);
        }
    }
}

