/*
 * Decompiled with CFR 0.152.
 */
package org.jawin.donated.win32;

import java.io.IOException;
import java.io.OutputStream;
import org.jawin.COMException;
import org.jawin.FuncPtr;
import org.jawin.ReturnFlags;
import org.jawin.io.LittleEndianOutputStream;
import org.jawin.io.NakedByteStream;
import org.jawin.marshal.StructConverter;

public class Security {
    public static int OpenProcessToken(int ProcessHandle, int DesiredAccess) throws COMException, IOException {
        FuncPtr fp = new FuncPtr("ADVAPI32.DLL", "OpenProcessToken");
        NakedByteStream nbs = new NakedByteStream();
        LittleEndianOutputStream leos = new LittleEndianOutputStream((OutputStream)nbs);
        leos.writeInt(ProcessHandle);
        leos.writeInt(DesiredAccess);
        byte[] res = fp.invoke("IIA:T3:lln4", 12, nbs, null, ReturnFlags.CHECK_FALSE);
        return StructConverter.bytesIntoInt((byte[])res, (int)0);
    }

    public static byte[] GetTokenInformation(int TokenHandle, int TokenEnumerationClass) throws IOException, COMException {
        FuncPtr fp = new FuncPtr("ADVAPI32.DLL", "GetTokenInformation");
        NakedByteStream nbs = new NakedByteStream();
        LittleEndianOutputStream leos = new LittleEndianOutputStream((OutputStream)nbs);
        leos.writeInt(TokenHandle);
        leos.writeInt(TokenEnumerationClass);
        byte[] sizeRes = fp.invoke("IIkkA::L16n4", 20, nbs, null, ReturnFlags.CHECK_NONE);
        int size = StructConverter.bytesIntoInt((byte[])sizeRes, (int)0);
        leos.writeInt(size);
        byte[] res = fp.invoke("IIM" + size + "IA:T1:L8n" + size, 20, nbs, null, ReturnFlags.CHECK_FALSE);
        return res;
    }

    public static byte[] GetTokenUserSid(int TokenHandle) throws IOException, COMException {
        byte[] info = Security.GetTokenInformation(TokenHandle, 1);
        byte[] res = new byte[info.length - 8];
        System.arraycopy(info, 8, res, 0, res.length);
        return res;
    }

    public static byte[] GetSidIdentifierAuthority(byte[] sid) throws COMException, IOException {
        FuncPtr fp = new FuncPtr("ADVAPI32.DLL", "GetSidIdentifierAuthority");
        return fp.invoke_S(sid, 6, ReturnFlags.CHECK_FALSE);
    }

    public static int GetSidSubAuthorityCount(byte[] sid) throws COMException, IOException {
        FuncPtr fp = new FuncPtr("ADVAPI32.DLL", "GetSidSubAuthorityCount");
        byte[] res = fp.invoke_S(sid, 1, ReturnFlags.CHECK_FALSE);
        return res[0];
    }

    public static int GetSidSubAuthority(byte[] sid, int subAuthority) throws COMException, IOException {
        FuncPtr fp = new FuncPtr("ADVAPI32.DLL", "GetSidSubAuthority");
        byte[] res = fp.invoke_S(sid, subAuthority, 4, ReturnFlags.CHECK_FALSE);
        return StructConverter.bytesIntoInt((byte[])res, (int)0);
    }

    public static String SidToString(byte[] sid) throws COMException, IOException {
        byte[] sia = Security.GetSidIdentifierAuthority(sid);
        StringBuffer sb = new StringBuffer();
        String authority = "(hex)";
        if (0 == (sia[0] & sia[1])) {
            authority = Integer.toString(StructConverter.BEBytesIntoInt((byte[])sia, (int)2));
        } else {
            for (int n = 0; n < 6; ++n) {
                int unsigned = sia[n] & 0xFF;
                authority = authority + (Integer.toHexString(unsigned) + ".").toUpperCase();
            }
        }
        sb.append("S-").append(sid[0]).append("-").append(authority);
        int subAuthorities = Security.GetSidSubAuthorityCount(sid);
        for (int n = 0; n < subAuthorities; ++n) {
            sb.append("-").append(Security.GetSidSubAuthority(sid, n));
        }
        return sb.toString();
    }
}

