/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleClob;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.CLOB;

class OracleClobReader
extends Reader {
    OracleClob clob;
    DBConversion dbConversion;
    long lobOffset;
    long markedChar;
    char[] resizableBuffer;
    int initialBufferSize;
    int currentBufferSize;
    int pos;
    int count;
    long maxPosition = Long.MAX_VALUE;
    boolean isClosed;
    boolean endOfStream;

    public OracleClobReader(CLOB clob) throws SQLException {
        this((OracleClob)clob);
    }

    public OracleClobReader(OracleClob clob) throws SQLException {
        this(clob, ((PhysicalConnection)clob.getInternalConnection()).getDefaultStreamChunkSize() / 3);
    }

    public OracleClobReader(CLOB clob, int bufferSize) throws SQLException {
        this((OracleClob)clob, bufferSize);
    }

    public OracleClobReader(OracleClob clob, int bufferSize) throws SQLException {
        this(clob, bufferSize, 1L);
    }

    public OracleClobReader(CLOB clob, int bufferSize, long beginOffset) throws SQLException {
        this((OracleClob)clob, bufferSize, beginOffset);
    }

    public OracleClobReader(OracleClob clob, int bufferSize, long beginOffset) throws SQLException {
        if (clob == null || bufferSize <= 0 || clob.getInternalConnection() == null || beginOffset < 1L) {
            throw new IllegalArgumentException();
        }
        this.dbConversion = ((PhysicalConnection)clob.getInternalConnection()).conversion;
        this.clob = clob;
        this.lobOffset = beginOffset;
        this.markedChar = -1L;
        this.resizableBuffer = null;
        this.initialBufferSize = bufferSize;
        this.currentBufferSize = 0;
        this.count = 0;
        this.pos = 0;
        this.isClosed = false;
    }

    public OracleClobReader(CLOB clob, int bufferSize, long beginOffset, long length) throws SQLException {
        this((OracleClob)clob, bufferSize, beginOffset, length);
    }

    public OracleClobReader(OracleClob clob, int bufferSize, long beginOffset, long length) throws SQLException {
        this(clob, bufferSize, beginOffset);
        this.maxPosition = beginOffset + length;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        this.ensureOpen();
        int start = off;
        int end = start + Math.min(len, cbuf.length - off);
        if (!this.needChars(end - start)) {
            return -1;
        }
        start += this.writeChars(cbuf, start, end - start);
        while (start < end && this.needChars(end - start)) {
            start += this.writeChars(cbuf, start, end - start);
        }
        return start - off;
    }

    protected boolean needChars(int howMany) throws IOException {
        this.ensureOpen();
        if (this.pos >= this.count) {
            if (!this.endOfStream) {
                try {
                    if (howMany > this.currentBufferSize) {
                        this.currentBufferSize = Math.max(howMany, this.initialBufferSize);
                        PhysicalConnection pConnection = (PhysicalConnection)this.clob.getInternalConnection();
                        try (Monitor.CloseableLock lock = pConnection.acquireCloseableLock();){
                            this.resizableBuffer = pConnection.getCharBuffer(this.currentBufferSize);
                        }
                    }
                    int size = this.currentBufferSize;
                    if (this.maxPosition - this.lobOffset < (long)this.currentBufferSize) {
                        size = (int)(this.maxPosition - this.lobOffset);
                    }
                    this.count = this.clob.getChars(this.lobOffset, size, this.resizableBuffer);
                    if (this.count < this.currentBufferSize) {
                        this.endOfStream = true;
                    }
                    if (this.count > 0) {
                        this.pos = 0;
                        this.lobOffset += (long)this.count;
                        if (this.lobOffset >= this.maxPosition) {
                            this.endOfStream = true;
                        }
                        return true;
                    }
                }
                catch (SQLException e) {
                    throw (IOException)DatabaseError.createIOException(e).fillInStackTrace();
                }
            }
            this.releaseBuffer();
            return false;
        }
        return true;
    }

    protected int writeChars(char[] destbuf, int offset, int length) {
        int availableLength = Math.min(length, this.count - this.pos);
        System.arraycopy(this.resizableBuffer, this.pos, destbuf, offset, availableLength);
        this.pos += availableLength;
        return availableLength;
    }

    @Override
    public boolean ready() throws IOException {
        this.ensureOpen();
        return this.pos < this.count;
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.releaseBuffer();
    }

    private void releaseBuffer() throws IOException {
        try {
            if (this.resizableBuffer != null) {
                ((PhysicalConnection)this.clob.getInternalConnection()).cacheBufferSync(this.resizableBuffer);
                this.resizableBuffer = null;
                this.currentBufferSize = 0;
            }
        }
        catch (SQLException e) {
            throw (IOException)DatabaseError.createIOException(e).fillInStackTrace();
        }
    }

    void ensureOpen() throws IOException {
        try {
            if (this.isClosed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 57, null).fillInStackTrace();
            }
        }
        catch (SQLException e) {
            throw (IOException)DatabaseError.createIOException(e).fillInStackTrace();
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        if (readAheadLimit < 0) {
            throw new IllegalArgumentException(DatabaseError.findMessage(195, null));
        }
        this.markedChar = this.lobOffset - (long)this.count + (long)this.pos;
    }

    @Override
    public void reset() throws IOException {
        this.ensureOpen();
        if (this.markedChar < 0L) {
            throw new IOException(DatabaseError.findMessage(195, null));
        }
        this.lobOffset = this.markedChar;
        this.pos = this.count;
        this.endOfStream = false;
    }

    @Override
    public long skip(long n) throws IOException {
        this.ensureOpen();
        long start = 0L;
        if ((long)(this.count - this.pos) >= n) {
            this.pos = (int)((long)this.pos + n);
            start += n;
        } else {
            start += (long)(this.count - this.pos);
            this.pos = this.count;
            try {
                long remainLen = this.clob.length() - this.lobOffset + 1L;
                if (remainLen >= n - start) {
                    this.lobOffset += n - start;
                    start += n - start;
                } else {
                    this.lobOffset += remainLen;
                    start += remainLen;
                }
            }
            catch (SQLException e) {
                throw (IOException)DatabaseError.createIOException(e).fillInStackTrace();
            }
        }
        return start;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            return this.clob.getInternalConnection();
        }
        catch (Exception exc) {
            return null;
        }
    }
}

