/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.internal;

import java.io.OutputStream;
import java.net.SocketException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import javax.transaction.xa.XAResource;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.TraceEventListener;
import oracle.jdbc.aq.AQMessageProperties;
import oracle.jdbc.driver.HAManager;
import oracle.jdbc.internal.ACProxyable;
import oracle.jdbc.internal.DatabaseSessionState;
import oracle.jdbc.internal.JMSDequeueOptions;
import oracle.jdbc.internal.JMSEnqueueOptions;
import oracle.jdbc.internal.JMSMessage;
import oracle.jdbc.internal.JMSNotificationRegistration;
import oracle.jdbc.internal.KeywordValueLong;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.NetStat;
import oracle.jdbc.internal.OracleArray;
import oracle.jdbc.internal.OracleBfile;
import oracle.jdbc.internal.OracleLargeObject;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.internal.PDBChangeEventListener;
import oracle.jdbc.internal.ReplayContext;
import oracle.jdbc.internal.ResultSetCache;
import oracle.jdbc.internal.XSEventListener;
import oracle.jdbc.internal.XSKeyval;
import oracle.jdbc.internal.XSNamespace;
import oracle.jdbc.internal.XSPrincipal;
import oracle.jdbc.internal.XSSecureId;
import oracle.jdbc.internal.XSSessionParameters;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCLOB;
import oracle.jdbc.pool.OracleConnectionCacheCallback;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.BfileDBAccess;
import oracle.sql.BlobDBAccess;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.ClobDBAccess;
import oracle.sql.CustomDatum;
import oracle.sql.Datum;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.TIMEZONETAB;

public interface OracleConnection
extends oracle.jdbc.OracleConnection,
ACProxyable,
Monitor {
    public static final String CONNECTION_PROPERTY_BIND_USE_DBA = "oracle.jdbc.bindUseDBA";
    public static final String CONNECTION_PROPERTY_BIND_USE_DBA_DEFAULT = "true";
    public static final byte CONNECTION_PROPERTY_BIND_USE_DBA_ACCESSMODE = 15;
    public static final String CONNECTION_PROPERTY_LOGON_CAP = "oracle.jdbc.thinLogonCapability";
    public static final String CONNECTION_PROPERTY_LOGON_CAP_DEFAULT = "o5";
    public static final byte CONNECTION_PROPERTY_LOGON_CAP_ACCESSMODE = 15;
    public static final String CONNECTION_PROPERTY_OCI_DEFAULT_DEFINES = "oracle.jdbc.useOCIDefaultDefines";
    public static final String CONNECTION_PROPERTY_OCI_DEFAULT_DEFINES_DEFAULT = "false";
    public static final byte CONNECTION_PROPERTY_OCI_DEFAULT_DEFINES_ACCESSMODE = 15;
    public static final String CONNECTION_PROPERTY_JMSNOTIFICATION = "oracle.jdbc.jmsNotification";
    public static final String CONNECTION_PROPERTY_JMSNOTIFICATION_DEFAULT = "false";
    public static final byte CONNECTION_PROPERTY_JMSNOTIFICATION_ACCESSMODE = 15;
    public static final String CONNECTION_PROPERTY_NLS_LANG_BACKDOOR = "oracle.jdbc.ociNlsLangBackwardCompatible";
    public static final String CONNECTION_PROPERTY_NLS_LANG_BACKDOOR_DEFAULT = "false";
    public static final byte CONNECTION_PROPERTY_NLS_LANG_BACKDOOR_ACCESSMODE = 15;
    public static final String CONNECTION_PROPERTY_OVERRIDE_ENABLE_READ_DATA_IN_LOCATOR = "oracle.jdbc.overrideEnableReadDataInLocator";
    public static final String CONNECTION_PROPERTY_OVERRIDE_ENABLE_READ_DATA_IN_LOCATOR_DEFAULT = "false";
    public static final byte CONNECTION_PROPERTY_OVERRIDE_ENABLE_READ_DATA_IN_LOCATOR_ACCESSMODE = 15;
    public static final String CONNECTION_PROPERTY_PERMIT_TIMESTAMP_DATE_MISMATCH = "oracle.jdbc.internal.permitBindDateDefineTimestampMismatch";
    public static final String CONNECTION_PROPERTY_PERMIT_TIMESTAMP_DATE_MISMATCH_DEFAULT = "false";
    public static final byte CONNECTION_PROPERTY_PERMIT_TIMESTAMP_DATE_MISMATCH_ACCESSMODE = 15;
    public static final String CONNECTION_PROPERTY_QUICK_ASCII_CONVERSION = "oracle.jdbc.quickASCIIConversion";
    public static final String CONNECTION_PROPERTY_QUICK_ASCII_CONVERSION_DEFAULT = "false";
    public static final byte CONNECTION_PROPERTY_QUICK_ASCII_CONVERSION_ACCESSMODE = 15;
    public static final String CONNECTION_PROPERTY_IGNORE_REPLAY_CTX_FROM_AUTH = "oracle.jdbc.ignoreReplayContextFromAuthentication";
    public static final String CONNECTION_PROPERTY_IGNORE_REPLAY_CTX_FROM_AUTH_DEFAULT = "false";
    public static final byte CONNECTION_PROPERTY_IGNORE_REPLAY_CTX_FROM_AUTH_ACCESSMODE = 1;
    public static final String CONNECTION_PROPERTY_DEFAULT_USE_JAVANETNIO = "oracle.jdbc.javaNetNio";
    public static final String CONNECTION_PROPERTY_DEFAULT_USE_JAVANETNIO_DEFAULT = "true";
    public static final byte CONNECTION_PROPERTY_DEFAULT_USE_JAVANETNIO_ACCESSMODE = 15;
    public static final String CONNECTION_PROPERTY_NS_DIRECT_BUFFER = "oracle.jdbc.nsDirectBuffer";
    public static final String CONNECTION_PROPERTY_NS_DIRECT_BUFFER_DEFAULT = "false";
    public static final byte CONNECTION_PROPERTY_NS_DIRECT_BUFFER_ACCESSMODE = 15;
    public static final String CONNECTION_PROPERTY_PLSQL_VARCHAR_PARAMETER_4K_ONLY = "oracle.jdbc.plsqlVarcharParameter4KOnly";
    public static final String CONNECTION_PROPERTY_PLSQL_VARCHAR_PARAMETER_4K_ONLY_DEFAULT = "false";
    public static final byte CONNECTION_PROPERTY_PLSQL_VARCHAR_PARAMETER_4K_ONLY_ACCESSMODE = 15;
    public static final String CONNECTION_PROPERTY_INSTANCE_NAME = "oracle.jdbc.targetInstanceName";
    public static final String CONNECTION_PROPERTY_INSTANCE_NAME_DEFAULT = null;
    public static final byte CONNECTION_PROPERTY_INSTANCE_NAME_ACCESSMODE = 15;
    public static final String CONNECTION_PROPERTY_SERVICE_NAME = "oracle.jdbc.targetServiceName";
    public static final String CONNECTION_PROPERTY_SERVICE_NAME_DEFAULT = null;
    public static final byte CONNECTION_PROPERTY_SERVICE_NAME_ACCESSMODE = 1;
    public static final String CONNECTION_PROPERTY_SHARDING_KEY = "oracle.jdbc.targetShardingKey";
    public static final String CONNECTION_PROPERTY_SHARDING_KEY_DEFAULT = null;
    public static final byte CONNECTION_PROPERTY_SHARDING_KEY_ACCESSMODE = 1;
    public static final String CONNECTION_PROPERTY_SUPER_SHARDING_KEY = "oracle.jdbc.targetSuperShardingKey";
    public static final String CONNECTION_PROPERTY_SUPER_SHARDING_KEY_DEFAULT = null;
    public static final byte CONNECTION_PROPERTY_SUPER_SHARDING_KEY_ACCESSMODE = 1;
    public static final String CONNECTION_PROPERTY_ENABLE_OCI_FAST_APPLICATION_NOTIFICATION = "oracle.jdbc.enableOCIFastApplicationNotification";
    public static final String CONNECTION_PROPERTY_ENABLE_OCI_FAST_APPLICATION_NOTIFICATION_DEFAULT = "false";
    public static final byte CONNECTION_PROPERTY_ENABLE_OCI_FAST_APPLICATION_NOTIFICATION_ACCESSMODE = 15;
    public static final String CONNECTION_PROPERTY_ENABLE_RESULTSET_CACHE = "oracle.jdbc.enableResultSetCache";
    public static final String CONNECTION_PROPERTY_ENABLE_RESULTSET_CACHE_DEFAULT = "false";
    public static final byte CONNECTION_PROPERTY_ENABLE_RESULTSET_CACHE_ACCESSMODE = 15;
    public static final String CONNECTION_PROPERTY_CALCULATE_CHECKSUM = "oracle.jdbc.calculateChecksum";
    public static final String CONNECTION_PROPERTY_CALCULATE_CHECKSUM_DEFAULT = null;
    public static final byte CONNECTION_PROPERTY_CALCULATE_CHECKSUM_ACCESSMODE = 15;
    public static final String CONNECTION_PROPERTY_JAVANET_LOCAL_IP_MSGQ = "oracle.jdbc.javaNetLocalIPForMsgq";
    public static final String CONNECTION_PROPERTY_JAVANET_LOCAL_IP_MSGQ_DEFAULT = null;
    public static final byte CONNECTION_PROPERTY_JAVANET_LOCAL_IP_MSGQ_ACCESSMODE = 15;
    public static final String CONNECTION_PROPERTY_JAVANET_MSGQ_TRANSPORT = "oracle.jdbc.javaNetMsgqTransport";
    public static final String CONNECTION_PROPERTY_JAVANET_MSGQ_TRANSPORT_DEFAULT = null;
    public static final byte CONNECTION_PROPERTY_JAVANET_MSGQ_TRANSPORT_ACCESSMODE = 15;
    public static final String CONNECTION_PROPERTY_JAVANET_MSGQ_BUSYWAIT = "oracle.jdbc.javaNetMsgqBusyWait";
    public static final String CONNECTION_PROPERTY_JAVANET_MSGQ_BUSYWAIT_DEFAULT = "40";
    public static final byte CONNECTION_PROPERTY_JAVANET_MSGQ_BUSYWAIT_ACCESSMODE = 15;
    public static final String CONNECTION_PROPERTY_JAVANET_MSGQ_KERNELWAIT = "oracle.jdbc.javaNetMsgqKernelWait";
    public static final String CONNECTION_PROPERTY_JAVANET_MSGQ_KERNELWAIT_DEFAULT = "50";
    public static final byte CONNECTION_PROPERTY_JAVANET_MSGQ_KERNELWAIT_ACCESSMODE = 15;
    public static final String CONNECTION_PROPERTY_ENABLE_METRICS = "oracle.jdbc.diagnostic.enableMetrics";
    public static final String CONNECTION_PROPERTY_ENABLE_METRICS_DEFAULT = "false";
    public static final byte CONNECTION_PROPERTY_ENABLE_METRICS_ACCESSMODE = 2;
    public static final String CONNECTION_PROPERTY_ASYNC_CURSOR_LIMIT = "oracle.jdbc.asyncCursorLimit";
    public static final String CONNECTION_PROPERTY_ASYNC_CURSOR_LIMIT_DEFAULT = "0.2";
    public static final byte CONNECTION_PROPERTY_ASYNC_CURSOR_LIMIT_ACCESSMODE = 7;
    public static final String CONNECTION_PROPERTY_TTC_COOKIE_CACHE_SIZE = "oracle.jdbc.TTCCookieCacheSize";
    public static final String CONNECTION_PROPERTY_TTC_COOKIE_CACHE_SIZE_DEFAULT = "50";
    public static final byte CONNECTION_PROPERTY_TTC_COOKIE_CACHE_SIZE_ACCESSMODE = 2;
    public static final String CONNECTION_PROPERTY_TTC_COOKIE_OPTIMIZATION_ENABLED = "oracle.net.TTCCookieOptimizationEnabled";
    public static final String CONNECTION_PROPERTY_TTC_COOKIE_OPTIMIZATION_ENABLED_DEFAULT = "true";
    public static final byte CONNECTION_PROPERTY_TTC_COOKIE_OPTIMIZATION_ENABLED_ACCESSMODE = 7;
    public static final String CONNECTION_PROPERTY_COMBINED_INITIALIZATION_ROUNDTRIPS = "oracle.jdbc.combinedInitializationRoundtrips";
    public static final String CONNECTION_PROPERTY_COMBINED_INITIALIZATION_ROUNDTRIPS_DEFAULT = "true";
    public static final byte CONNECTION_PROPERTY_COMBINED_INITIALIZATION_ROUNDTRIPS_ACCESSMODE = 7;
    public static final String CONNECTION_PROPERTY_FORCE_AL32UTF8_FOR_COMBINED_ROUNDTRIPS = "oracle.jdbc.forceAL32UTF8ForCombinedRoundtrips";
    public static final String CONNECTION_PROPERTY_FORCE_AL32UTF8_FOR_COMBINED_ROUNDTRIPS_DEFAULT = "false";
    public static final byte CONNECTION_PROPERTY_FORCE_AL32UTF8_FOR_COMBINED_ROUNDTRIPS_ACCESSMODE = 7;
    public static final int CHAR_TO_ASCII = 0;
    public static final int CHAR_TO_UNICODE = 1;
    public static final int RAW_TO_ASCII = 2;
    public static final int RAW_TO_UNICODE = 3;
    public static final int UNICODE_TO_CHAR = 4;
    public static final int ASCII_TO_CHAR = 5;
    public static final int NONE = 6;
    public static final int JAVACHAR_TO_CHAR = 7;
    public static final int RAW_TO_JAVACHAR = 8;
    public static final int CHAR_TO_JAVACHAR = 9;
    public static final int GLOBAL_TXN = 1;
    public static final int NO_GLOBAL_TXN = 0;
    public static final int VARTYPE_MAXLEN_COMPAT_STANDARD = 1;
    public static final int VARTYPE_MAXLEN_COMPAT_EXTENDED = 2;
    public static final int VARTYPE_MAXLEN_STANDARD_METADATA = 4000;
    public static final int VARTYPE_MAXLEN_STANDARD_BIND = 32766;
    public static final int VARTYPE_MAXLEN_STANDARD_BIND_OUT = Short.MAX_VALUE;
    public static final int VARTYPE_MAXLEN_STANDARD_BIND_PLSQL_BUG3936526 = 32512;
    public static final int NVARTYPE_MAXLEN_STANDARD_METADATA = 4000;
    public static final int NVARTYPE_MAXLEN_STANDARD_BIND = 32766;
    public static final int RAWTYPE_MAXLEN_STANDARD_METADATA = 2000;
    public static final int RAWTYPE_MAXLEN_STANDARD_BIND_SQL = 4000;
    public static final int RAWTYPE_MAXLEN_STANDARD_BIND_PLSQL = 32766;
    public static final int VARTYPE_MAXLEN_EXTENDED_METADATA = Short.MAX_VALUE;
    public static final int VARTYPE_MAXLEN_EXTENDED_BIND = 32766;
    public static final int VARTYPE_MAXLEN_EXTENDED_BIND_OUT = Short.MAX_VALUE;
    public static final int VARTYPE_MAXLEN_STANDARD = 4000;
    public static final int RAWTYPE_MAXLEN_STANDARD = 2000;
    public static final int NVARTYPE_MAXLEN_STANDARD = 4000;
    public static final int VARTYPE_MAXLEN_EXTENDED = Short.MAX_VALUE;
    public static final int RAWTYPE_MAXLEN_EXTENDED = Short.MAX_VALUE;
    public static final int NVARTYPE_MAXLEN_EXTENDED = 32766;
    public static final String DPPDEF_IN_NOLOG_STMT_OPTION = "DPPDEF_IN_NOLOG";
    public static final String DPPDEF_IN_PARALLEL_STMT_OPTION = "DPPDEF_IN_PARALLEL";
    public static final String DPPDEF_KW_PARALLEL_FILE_STMT_OPTION = "DPPDEF_KW_PARALLEL_FILE";
    public static final String DPPDEF_IN_STORAGE_INIT_STMT_OPTION = "DPPDEF_IN_STORAGE_INIT";
    public static final String DPPDEF_IN_STORAGE_NEXT_STMT_OPTION = "DPPDEF_IN_STORAGE_NEXT";
    public static final String DPPDEF_IN_SKIP_UNUSABLE_INDEX_STMT_OPTION = "DPPDEF_IN_SKIP_UNUSABLE_INDEX";
    public static final String DPPDEF_IN_SKIP_INDEX_MAINT_STMT_OPTION = "DPPDEF_IN_SKIP_INDEX_MAINT";

    public int getVarTypeMaxLenCompat() throws SQLException;

    public short getStructAttrNCsId() throws SQLException;

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException;

    public Properties getDBAccessProperties() throws SQLException;

    public Properties getOCIHandles() throws SQLException;

    public String getDatabaseProductVersion() throws SQLException;

    public String getURL() throws SQLException;

    public short getVersionNumber() throws SQLException;

    public int getMajorVersionNumber() throws SQLException;

    public int getMinorVersionNumber() throws SQLException;

    public Map<String, Class<?>> getJavaObjectTypeMap();

    public void setJavaObjectTypeMap(Map<String, Class<?>> var1);

    public byte getInstanceProperty(InstanceProperty var1) throws SQLException;

    public BfileDBAccess createBfileDBAccess() throws SQLException;

    public BlobDBAccess createBlobDBAccess() throws SQLException;

    public ClobDBAccess createClobDBAccess() throws SQLException;

    public void setDefaultFixedString(boolean var1);

    public boolean getDefaultFixedString();

    public oracle.jdbc.OracleConnection getWrapper();

    public Class classForNameAndSchema(String var1, String var2) throws ClassNotFoundException;

    public void setFDO(byte[] var1) throws SQLException;

    public byte[] getFDO(boolean var1) throws SQLException;

    public boolean getBigEndian() throws SQLException;

    public Object getDescriptor(byte[] var1);

    public void putDescriptor(byte[] var1, Object var2) throws SQLException;

    public Object doGetDescriptor(String var1);

    public OracleConnection getPhysicalConnection();

    public int numberOfDescriptorCacheEntries();

    public Enumeration<String> descriptorCacheKeys();

    public long getTdoCState(String var1, String var2) throws SQLException;

    public long getTdoCState(String var1) throws SQLException;

    public BufferCacheStatistics getByteBufferCacheStatistics();

    public BufferCacheStatistics getCharBufferCacheStatistics();

    public Datum toDatum(CustomDatum var1) throws SQLException;

    public short getDbCsId() throws SQLException;

    public short getJdbcCsId() throws SQLException;

    public short getNCharSet();

    public ResultSet newArrayDataResultSet(Datum[] var1, long var2, int var4, Map<String, Class<?>> var5) throws SQLException;

    public ResultSet newArrayDataResultSet(OracleArray var1, long var2, int var4, Map<String, Class<?>> var5) throws SQLException;

    public ResultSet newArrayLocatorResultSet(ArrayDescriptor var1, byte[] var2, long var3, int var5, Map<String, Class<?>> var6) throws SQLException;

    public ResultSetMetaData newStructMetaData(StructDescriptor var1) throws SQLException;

    public void getForm(OracleTypeADT var1, OracleTypeCLOB var2, int var3) throws SQLException;

    public int CHARBytesToJavaChars(byte[] var1, int var2, char[] var3) throws SQLException;

    public int NCHARBytesToJavaChars(byte[] var1, int var2, char[] var3) throws SQLException;

    public boolean IsNCharFixedWith();

    public short getDriverCharSet();

    public CharacterSet getDbCharSet();

    public int getC2SNlsRatio();

    public int getMaxCharSize() throws SQLException;

    public int getMaxCharbyteSize();

    public int getMaxNCharbyteSize();

    public boolean isCharSetMultibyte(short var1);

    public int javaCharsToCHARBytes(char[] var1, int var2, byte[] var3) throws SQLException;

    public int javaCharsToNCHARBytes(char[] var1, int var2, byte[] var3) throws SQLException;

    @Deprecated
    default public void setStartTime(long startTime) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    default public long getStartTime() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isStatementCacheInitialized();

    public void getPropertyForPooledConnection(OraclePooledConnection var1) throws SQLException;

    @Override
    public void setTypeMap(Map<String, Class<?>> var1) throws SQLException;

    public String getProtocolType();

    public Connection getLogicalConnection(OraclePooledConnection var1, boolean var2) throws SQLException;

    public void setTxnMode(int var1);

    public int getTxnMode();

    public int getHeapAllocSize() throws SQLException;

    public int getOCIEnvHeapAllocSize() throws SQLException;

    @Deprecated
    default public void setAbandonedTimeoutEnabled(boolean val) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    default public int getHeartbeatNoChangeCount() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void closeInternal(boolean var1) throws SQLException;

    public void cleanupAndClose(boolean var1) throws SQLException;

    @Deprecated
    default public OracleConnectionCacheCallback getConnectionCacheCallbackObj() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    default public Object getConnectionCacheCallbackPrivObj() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    default public int getConnectionCacheCallbackFlag() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public CLOB createClob(byte[] var1) throws SQLException;

    public CLOB createClobWithUnpickledBytes(byte[] var1) throws SQLException;

    public CLOB createClob(byte[] var1, short var2) throws SQLException;

    public BLOB createBlob(byte[] var1) throws SQLException;

    public BLOB createBlobWithUnpickledBytes(byte[] var1) throws SQLException;

    public BFILE createBfile(byte[] var1) throws SQLException;

    public boolean isDescriptorSharable(OracleConnection var1) throws SQLException;

    public OracleStatement refCursorCursorToStatement(int var1) throws SQLException;

    public XAResource getXAResource() throws SQLException;

    public boolean isV8Compatible() throws SQLException;

    public boolean getMapDateToTimestamp();

    public boolean getJDBCStandardBehavior();

    public byte[] createLightweightSession(String var1, KeywordValueLong[] var2, int var3, KeywordValueLong[][] var4, int[] var5) throws SQLException;

    public void executeLightweightSessionPiggyback(int var1, byte[] var2, KeywordValueLong[] var3, int var4) throws SQLException;

    public void doXSNamespaceOp(XSOperationCode var1, byte[] var2, XSNamespace[] var3, XSNamespace[][] var4, XSSecureId var5) throws SQLException;

    public void doXSNamespaceOp(XSOperationCode var1, byte[] var2, XSNamespace[] var3, XSSecureId var4) throws SQLException;

    public byte[] doXSSessionCreateOp(XSSessionOperationCode var1, XSSecureId var2, byte[] var3, XSPrincipal var4, String var5, XSNamespace[] var6, XSSessionModeFlag var7, XSKeyval var8) throws SQLException;

    public void doXSSessionDestroyOp(byte[] var1, XSSecureId var2, byte[] var3) throws SQLException;

    public void doXSSessionAttachOp(int var1, byte[] var2, XSSecureId var3, byte[] var4, XSPrincipal var5, String[] var6, String[] var7, String[] var8, XSNamespace[] var9, XSNamespace[] var10, XSNamespace[] var11, TIMESTAMPTZ var12, TIMESTAMPTZ var13, int var14, long var15, XSKeyval var17, int[] var18) throws SQLException;

    public void doXSSessionDetachOp(int var1, byte[] var2, XSSecureId var3, boolean var4) throws SQLException;

    public void doXSSessionChangeOp(XSSessionSetOperationCode var1, byte[] var2, XSSecureId var3, XSSessionParameters var4) throws SQLException;

    public String getDefaultSchemaNameForNamedTypes() throws SQLException;

    public void setUsable(boolean var1);

    public Class getClassForType(String var1, Map<String, Class<?>> var2);

    public void addXSEventListener(XSEventListener var1) throws SQLException;

    public void addXSEventListener(XSEventListener var1, Executor var2) throws SQLException;

    public void removeXSEventListener(XSEventListener var1) throws SQLException;

    public int getTimezoneVersionNumber() throws SQLException;

    public void removeAllXSEventListener() throws SQLException;

    public TIMEZONETAB getTIMEZONETAB() throws SQLException;

    public String getDatabaseTimeZone() throws SQLException;

    public ZoneId getDatabaseZoneId() throws SQLException;

    public ZoneId getSessionZoneId();

    public boolean getTimestamptzInGmt();

    public boolean getUse1900AsYearForTime();

    public boolean isDataInLocatorEnabled() throws SQLException;

    public boolean isLobStreamPosStandardCompliant() throws SQLException;

    public long getCurrentSCN() throws SQLException;

    public EnumSet<TransactionState> getTransactionState() throws SQLException;

    public boolean isConnectionSocketKeepAlive() throws SocketException, SQLException;

    public boolean isConnectionBigTZTC() throws SQLException;

    public void setReplayOperations(EnumSet<ReplayOperation> var1) throws SQLException;

    public void setReplayingMode(boolean var1) throws SQLException;

    public void beginNonRequestCalls() throws SQLException;

    public void endNonRequestCalls() throws SQLException;

    public void setReplayContext(ReplayContext[] var1) throws SQLException;

    public ReplayContext[] getReplayContext() throws SQLException;

    public ReplayContext getLastReplayContext() throws SQLException;

    public void setLastReplayContext(ReplayContext var1) throws SQLException;

    public void registerEndReplayCallback(EndReplayCallback var1) throws SQLException;

    public int getEOC() throws SQLException;

    public byte[] getDerivedKeyInternal(byte[] var1, int var2) throws NoSuchAlgorithmException, InvalidKeySpecException, SQLException;

    public short getExecutingRPCFunctionCode();

    public String getExecutingRPCSQL();

    public void jmsEnqueue(String var1, JMSEnqueueOptions var2, JMSMessage var3, AQMessageProperties var4) throws SQLException;

    public void jmsEnqueue(String var1, JMSEnqueueOptions var2, JMSMessage[] var3, AQMessageProperties[] var4) throws SQLException;

    public JMSMessage jmsDequeue(String var1, JMSDequeueOptions var2) throws SQLException;

    public JMSMessage jmsDequeue(String var1, JMSDequeueOptions var2, OutputStream var3) throws SQLException;

    public JMSMessage jmsDequeue(String var1, JMSDequeueOptions var2, String var3) throws SQLException;

    public JMSMessage[] jmsDequeue(String var1, JMSDequeueOptions var2, int var3) throws SQLException;

    public Map<String, JMSNotificationRegistration> registerJMSNotification(String[] var1, Map<String, Properties> var2) throws SQLException;

    public Map<String, JMSNotificationRegistration> registerJMSNotification(String[] var1, Map<String, Properties> var2, String var3) throws SQLException;

    public void unregisterJMSNotification(JMSNotificationRegistration var1) throws SQLException;

    public void startJMSNotification(JMSNotificationRegistration var1) throws SQLException;

    public void stopJMSNotification(JMSNotificationRegistration var1) throws SQLException;

    public void ackJMSNotification(JMSNotificationRegistration var1, byte[] var2, JMSNotificationRegistration.Directive var3) throws SQLException;

    public void ackJMSNotification(ArrayList<JMSNotificationRegistration> var1, byte[][] var2, JMSNotificationRegistration.Directive var3) throws SQLException;

    public int getNegotiatedSDU() throws SQLException;

    public byte getNegotiatedTTCVersion() throws SQLException;

    public void setPDBChangeEventListener(PDBChangeEventListener var1) throws SQLException;

    public void setPDBChangeEventListener(PDBChangeEventListener var1, Executor var2) throws SQLException;

    public void setChecksumMode(ChecksumMode var1) throws SQLException;

    public ResultSetCache getResultSetCache() throws SQLException;

    public void closeLogicalConnection() throws SQLException;

    public void cleanupAndClose() throws SQLException;

    public boolean isLifecycleOpen() throws SQLException;

    public void clearDrcpTagName() throws SQLException;

    public void setClientIdentifier(String var1) throws SQLException;

    public void clearClientIdentifier(String var1) throws SQLException;

    public int freeTemporaryBlobsAndClobs() throws SQLException;

    public void setChunkInfo(OracleShardingKey var1, OracleShardingKey var2, String var3) throws SQLException;

    public HAManager getHAManager();

    public void setHAManager(HAManager var1) throws SQLException;

    public boolean isUsable(boolean var1);

    public boolean isNetworkCompressionEnabled();

    public int getOutboundConnectTimeout();

    public NetStat getNetworkStat();

    public void sendRequestFlags() throws SQLException;

    public boolean hasNoOpenHandles() throws SQLException;

    public void endRequest(boolean var1) throws SQLException;

    public DatabaseSessionState getDatabaseSessionState() throws SQLException;

    public void setDatabaseSessionState(DatabaseSessionState var1) throws SQLException;

    public boolean isSafelyClosed() throws SQLException;

    public void setSafelyClosed(boolean var1) throws SQLException;

    public void addLargeObject(OracleLargeObject var1) throws SQLException;

    public void removeLargeObject(OracleLargeObject var1) throws SQLException;

    public void addBfile(OracleBfile var1) throws SQLException;

    public void removeBfile(OracleBfile var1) throws SQLException;

    public void flushRemoteDatabaseTTCCookieCache();

    public Properties getClientInfoInternal() throws SQLException;

    public boolean getAutoCommitInternal() throws SQLException;

    public boolean serverSupportsRequestBoundaries() throws SQLException;

    public boolean serverSupportsExplicitBoundaryBit() throws SQLException;

    public PreparedStatement prepareDirectPath(String var1, String var2, String[] var3) throws SQLException;

    public PreparedStatement prepareDirectPath(String var1, String var2, String[] var3, Properties var4) throws SQLException;

    public PreparedStatement prepareDirectPath(String var1, String var2, String[] var3, String var4) throws SQLException;

    public PreparedStatement prepareDirectPath(String var1, String var2, String[] var3, String var4, Properties var5) throws SQLException;

    public byte[] beginSaga(String var1, int var2, String var3, int var4, int var5, int var6, int var7, String var8) throws SQLException;

    public Integer joinSaga(String var1, byte[] var2, String var3, String var4, int var5, int var6, int var7, int var8, int var9, String var10) throws SQLException;

    public Integer commitRollbackSaga(String var1, byte[] var2, String var3, int var4, int var5, int var6, String var7) throws SQLException;

    public Properties getJavaNetProperties() throws SQLException;

    public double getPercentageQueryExecutionOnDirectShard();

    public void addFeature(ClientFeature var1) throws SQLException;

    public void enableDiagnoseFirstFailureDump(boolean var1) throws SQLException;

    default public boolean isSSSHybrid() throws SQLException {
        throw new UnsupportedOperationException();
    }

    default public void setSSSHybrid(boolean isHybrid) throws SQLException {
        throw new UnsupportedOperationException();
    }

    default public Properties getSessionInfoInternal() throws SQLException {
        throw new UnsupportedOperationException();
    }

    default public Executor getAsyncExecutor() {
        throw new UnsupportedOperationException();
    }

    public TraceEventListener getTraceEventListener();

    public static enum ClientFeature {
        CORE_ONS(0),
        SCROLLABLE_RESULTSET(1),
        UPDATABLE_RESULTSET(2),
        SCROLL_SENSITIVE_RESULTSET(3),
        CACHED_RESULTSET(4),
        UCP(5),
        SET_STRING_LONGER_THAN_32K(6),
        SET_BYTES_LONGER_THAN_32K(7),
        DEREGISTER_DRIVER(8),
        THIN_DRIVER(9),
        THIN_DRIVER_IN_SERVER(10),
        TRANSLATION_DRIVER(11),
        SHARDING_DRIVER(12),
        ROWSET(13),
        XA_CONNECTION(14),
        SET_SHARDING_KEY(15),
        GETOBJECT_USE_VALUEOF(16),
        GETOBJECT_CUSTOMDATUM(17),
        SET_TYPE_MAP(18),
        GENERIC_GETOBJECT(19),
        SET_ENDTOEND_METRICS(20),
        SET_STRING_TO_LONG(21),
        SET_STRING_TO_CLOB(22),
        SET_XXX_BYNAME(23),
        DEFINE_COLUMN_TYPE(24),
        FETCH_SIZE_1000_PLUS(25),
        BLOCK_CACHE_MEMORY_PRESSURE(26),
        ROWDATA_10M(27),
        ROWDATA_100M(28),
        ROWDATA_1000M(29),
        JDBC_STMTCACHING(30),
        PARAMETER_METADATA(31);

        private int featureId = 0;

        private ClientFeature(int featureId) {
            this.featureId = featureId;
        }

        public int getFeatureId() {
            return this.featureId;
        }
    }

    public static enum ChecksumMode {
        NO_CHECKSUM(false, false),
        CALCULATE_CHECKSUM_FETCH(true, false),
        CALCULATE_CHECKSUM_BINDS(false, true),
        CALCULATE_CHECKSUM_ALL(true, true);

        private boolean fetchChecksum;
        private boolean bindChecksum;

        private ChecksumMode(boolean fetch, boolean bind) {
            this.fetchChecksum = fetch;
            this.bindChecksum = bind;
        }

        public boolean needToCalculateFetchChecksum() {
            return this.fetchChecksum;
        }

        public boolean needToCalculateBindChecksum() {
            return this.bindChecksum;
        }
    }

    public static interface EndReplayCallback {
        public void executeCallback() throws SQLException;
    }

    public static enum ReplayOperation {
        KPDSS_SESSSTATE_APPCONT_ENABLED(1L),
        KPDSS_SESSSTATE_STATIC(2L),
        KPDSS_SESSSTATE_REQUEST_BEGIN(4L),
        KPDSS_SESSSTATE_REQUEST_END(8L),
        KPDSS_SESSSTATE_NONREQUEST_CALL(16L),
        KPDSS_SESSSTATE_NO_OPEN_HANDLES(32L),
        KPDSS_SESSSTATE_EXPL_BOUND(64L);

        private final long code;

        private ReplayOperation(long _code) {
            this.code = _code;
        }

        public final long getCode() {
            return this.code;
        }
    }

    public static interface BufferCacheStatistics {
        public int getId();

        public int[] getBufferSizes();

        public int getCacheHits(int var1);

        public int getCacheMisses(int var1);

        public int getBuffersCached(int var1);

        public int getBucketsFull(int var1);

        public int getReferencesCleared(int var1);

        public int getTooBigToCache();
    }

    public static enum XSSessionSetOperationCode {
        SESSION_SET_COOKIE(1),
        SESSION_SET_TIMEOUT(2),
        SESSION_REAUTH(3),
        SESSION_ENABLE_ROLE(4),
        SESSION_DISABLE_ROLE(5);

        private final int code;

        private XSSessionSetOperationCode(int _code) {
            this.code = _code;
        }

        public final int getCode() {
            return this.code;
        }
    }

    public static enum XSSessionModeFlag {
        SECURE(0),
        TRUSTED(1);

        private final int code;

        private XSSessionModeFlag(int _code) {
            this.code = _code;
        }

        public final int getCode() {
            return this.code;
        }
    }

    public static enum XSSessionOperationCode {
        SESSION_CREATE(1);

        private final int code;

        private XSSessionOperationCode(int _code) {
            this.code = _code;
        }

        public final int getCode() {
            return this.code;
        }
    }

    public static enum XSOperationCode {
        NAMESPACE_CREATE(1),
        NAMESPACE_DELETE(2),
        ATTRIBUTE_CREATE(3),
        ATTRIBUTE_SET(4),
        ATTRIBUTE_DELETE(5),
        ATTRIBUTE_RESET(6),
        NAMESPACE_GET(7),
        ATTRIBUTE_GET(8);

        private final int code;

        private XSOperationCode(int _code) {
            this.code = _code;
        }

        public final int getCode() {
            return this.code;
        }
    }

    public static enum TransactionState {
        TRANSACTION_STARTED,
        TRANSACTION_ENDED,
        TRANSACTION_READONLY,
        TRANSACTION_INTENTION;

    }

    public static enum InstanceProperty {
        ASM_VOLUME_SUPPORTED,
        INSTANCE_TYPE;

    }
}

