/*
 * Decompiled with CFR 0.152.
 */
package cn.com.do1.apisdk.util;

import cn.com.do1.apisdk.inter.SdkAnnotation;
import cn.com.do1.apisdk.inter.SdkMethodAnnotation;
import cn.com.do1.apisdk.inter.vo.SdkResult;
import cn.com.do1.apisdk.util.JSONUtil;
import cn.com.do1.apisdk.util.SdkConfig;
import java.io.File;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.CharUtils;

public class SdkInvocation
implements InvocationHandler {
    static Set<Class> clazzSet = new HashSet<Class>();

    public boolean isAllAscii(String a) {
        if (a != null) {
            for (char ch : a.toCharArray()) {
                if (CharUtils.isAsciiPrintable((char)ch)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean canUseGet(Object obj) {
        return obj != null && this.isAllAscii(obj.toString()) && (clazzSet.contains(obj.getClass()) || obj instanceof Number);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        SdkAnnotation ama = method.getAnnotation(SdkAnnotation.class);
        if (ama == null) {
            throw new RuntimeException("\u63a5\u53e3\u672a\u6ce8\u89e3SdkAnnotation");
        }
        StringBuilder sb = new StringBuilder();
        SdkMethodAnnotation ann = method.getAnnotation(SdkMethodAnnotation.class);
        Annotation[][] annos = method.getParameterAnnotations();
        boolean hasCorpId = false;
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (annos != null && annos.length > 0) {
            for (int i = 0; i < annos.length && args[i] != null; ++i) {
                for (int j = 0; j < annos[i].length && annos[i][j] instanceof SdkAnnotation; ++j) {
                    SdkAnnotation a = (SdkAnnotation)annos[i][j];
                    if ("corpId".equals(a.value())) {
                        hasCorpId = true;
                    }
                    if (args[i].getClass().isArray() && clazzSet.contains(args[i].getClass().getComponentType())) {
                        int length = Array.getLength(args[i]);
                        for (int k = 0; k < length; ++k) {
                            Object ele = Array.get(args[i], k);
                            if (!this.canUseGet(ele)) continue;
                            sb.append(a.value() + "=" + URLEncoder.encode(ele.toString(), "UTF-8")).append("&");
                        }
                        continue;
                    }
                    if (this.canUseGet(args[i])) {
                        sb.append(a.value() + "=" + URLEncoder.encode(args[i].toString(), "UTF-8")).append("&");
                        continue;
                    }
                    if (args[i] instanceof File) {
                        params.put(a.value(), args[i]);
                        continue;
                    }
                    if (args[i].getClass().isArray() || args[i] instanceof Iterable) {
                        params.put(a.value(), JSONUtil.arrayToString(args[i]));
                        continue;
                    }
                    params.put(a.value(), JSONUtil.objectToString(args[i]));
                }
            }
        }
        if (!hasCorpId) {
            sb.append("corpId=" + URLEncoder.encode(SdkConfig.getString("corpId"), "UTF-8")).append("&");
        }
        sb.deleteCharAt(sb.length() - 1);
        SdkResult<?> obj = SdkInvocation.doHttp(SdkConfig.getString("baseUrl") + ama.value() + "?" + sb.toString(), params, method.getReturnType(), ann);
        if (obj.getCode() != 0) {
            throw new RuntimeException(String.format("\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0c\u8fd4\u56de\u7801%s\uff0c\u8fd4\u56de\u6d88\u606f\uff1a\u2018%s\u2019", obj.getCode(), obj.getDesc()));
        }
        if (!method.getReturnType().equals(Void.class) && !method.getReturnType().equals(Void.TYPE)) {
            return obj.getData();
        }
        return null;
    }

    public static <T> SdkResult<T> doHttp(String url, Map<String, Object> params, Class<T> clazz, SdkMethodAnnotation ann) throws Exception {
        Object method = null;
        try {
            HttpClient httpClient = new HttpClient();
            int reqTimeout = 10000;
            int readTimeout = 60000;
            httpClient.getParams().setParameter("http.protocol.content-charset", (Object)"UTF-8");
            httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(reqTimeout);
            httpClient.getHttpConnectionManager().getParams().setSoTimeout(readTimeout);
            method = ann == null ? new PostMethod(url) : ann.value().getClazz().newInstance();
            if (method instanceof PostMethod) {
                PostMethod post = method;
                ArrayList<FilePart> parts = new ArrayList<FilePart>();
                if (params != null && !params.isEmpty()) {
                    boolean uploadFile = false;
                    for (Map.Entry<String, Object> entry : params.entrySet()) {
                        if (entry.getValue() instanceof File) {
                            File file = (File)entry.getValue();
                            FilePart fp = new FilePart(entry.getKey(), file);
                            fp.setCharSet("UTF-8");
                            parts.add(fp);
                            uploadFile = true;
                            continue;
                        }
                        post.addParameter(entry.getKey(), entry.getValue().toString());
                        parts.add((FilePart)new StringPart(entry.getKey(), entry.getValue().toString()));
                    }
                    if (uploadFile) {
                        post.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts.toArray(new Part[parts.size()]), post.getParams()));
                    }
                }
            } else {
                StringBuilder urlSb = new StringBuilder(url);
                if (params != null && !params.isEmpty()) {
                    for (Map.Entry<String, Object> entry : params.entrySet()) {
                        urlSb.append("&" + entry.getKey() + "=" + URLEncoder.encode(entry.getValue().toString(), "UTF-8")).append("&");
                    }
                }
                method.setURI(new URI(urlSb.toString()));
            }
            int responseStatus = httpClient.executeMethod((HttpMethod)method);
            if (responseStatus == 200) {
                String text = IOUtils.toString((InputStream)method.getResponseBodyAsStream(), (String)"UTF-8");
                System.out.println("\u63a5\u53e3\u8fd4\u56de\uff1a" + text);
                HashMap<String, Class> classMap = new HashMap<String, Class>();
                if (!clazz.equals(Void.class) && !clazz.equals(Void.TYPE)) {
                    classMap.put("data", clazz);
                }
                SdkResult sdkResult = JSONUtil.stringToObject(text, SdkResult.class, classMap);
                return sdkResult;
            }
            throw new Exception("\u901a\u8baf\u5931\u8d25\uff01");
        }
        finally {
            if (method != null) {
                method.abort();
                method.releaseConnection();
            }
        }
    }

    static {
        Collections.addAll(clazzSet, String.class, Double.class, Double.TYPE, Float.class, Float.TYPE, Long.class, Long.TYPE, Integer.class, Integer.TYPE, Short.class, Short.TYPE, Byte.class, Byte.TYPE, Character.class, Character.TYPE, Boolean.class, Boolean.TYPE);
    }
}

