/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.dvs.plugin.cci.internal;

import com.ibm.rules.dvs.plugin.cci.internal.DVSPluginLocalization;
import com.ibm.rules.dvs.plugin.cci.internal.ObjectModelServicesInteractionSpec;
import com.ibm.rules.dvs.plugin.cci.internal.RulesetSignatureFactoryInteractionSpec;
import com.ibm.rules.dvs.rsi.de.internal.CommonObjectModelServices;
import com.ibm.rules.engine.runtime.dataie.BusinessDataIEService;
import com.ibm.rules.res.message.internal.LocalizedMessageHelper;
import com.ibm.rules.res.message.internal.XUMessageCode;
import com.ibm.rules.res.util.internal.StreamUtil;
import com.ibm.rules.res.xu.client.internal.jca.JCAInteractionFunctionNames;
import com.ibm.rules.res.xu.client.internal.jca.XUInteractionSpec;
import com.ibm.rules.res.xu.engine.cre.internal.CREManager;
import com.ibm.rules.res.xu.engine.de.internal.DEManager;
import com.ibm.rules.res.xu.engine.internal.EngineManager;
import com.ibm.rules.res.xu.internal.LocalizedResourceException;
import com.ibm.rules.res.xu.internal.XUException;
import ilog.rules.archive.IlrRulesetArchive;
import ilog.rules.bom.IlrObjectModel;
import ilog.rules.dvs.rsi.IlrBOMTypeDescriptor;
import ilog.rules.dvs.rsi.IlrObjectModelServices;
import ilog.rules.dvs.rsi.exception.IlrObjectFactoryParametersException;
import ilog.rules.dvs.rsi.exception.IlrUnsupportedBOMTypeException;
import ilog.rules.dvs.rsi.internal.IlrCommonObjectModelServices;
import ilog.rules.dvs.rsi.internal.IlrDefaultBOMTypeDescriptor;
import ilog.rules.dvs.rsi.ofactory.IlrObjectFactoryParameter;
import ilog.rules.dvs.rsi.ofactory.IlrObjectFactoryParameterValue;
import ilog.rules.dvs.rsi.signature.IlrRulesetParameter;
import ilog.rules.dvs.rsi.signature.internal.IlrRulesetParameterImpl;
import ilog.rules.dvs.rsi.utils.IlrSerializationException;
import ilog.rules.dvs.rsi.utils.IlrXUSerializationUtils;
import ilog.rules.engine.dataio.IlrTranslatedDataAccessStrategy;
import ilog.rules.factory.IlrReflect;
import ilog.rules.factory.translation.IlrTranslationDebugSupport;
import ilog.rules.res.model.IlrCRERulesetArchive;
import ilog.rules.res.model.IlrEngineType;
import ilog.rules.res.model.IlrRESRulesetArchive;
import ilog.rules.res.model.internal.IlrXMLSignatureParser;
import ilog.rules.res.xu.cci.IlrInteractionExtension;
import ilog.rules.res.xu.cci.IlrXUConnection;
import ilog.rules.util.engine.IlrXmlSignatureParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.resource.ResourceException;
import javax.resource.cci.IndexedRecord;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.Record;
import org.xml.sax.InputSource;

public class ExecutionTraceInteractionExtension
implements IlrInteractionExtension,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final String DE_SIGNATURE_FILE_PATH = "RULES_ENGINE/default/resources/ruleset/com.ibm.rules.engine.signature.xml";

    @Override
    public boolean isSupported(InteractionSpec interactionSpec) throws XUException {
        String functionName = "";
        functionName = JCAInteractionFunctionNames.getFunctionName(interactionSpec);
        return (functionName = XUInteractionSpec.intern(functionName)).equals(ObjectModelServicesInteractionSpec.FUNCTION_NAME_GET_OBJECT_FACTORY_SIGNATURE) || functionName.equals(ObjectModelServicesInteractionSpec.FUNCTION_NAME_CREATE_OBJECT_INSTANCE) || functionName.equals(ObjectModelServicesInteractionSpec.FUNCTION_NAME_GET_XOM_CLASS_MAPPING_FOR_BOM_TYPE) || functionName.equals(ObjectModelServicesInteractionSpec.FUNCTION_NAME_GET_TYPE_OF_ARRAY_ELEMENTS) || functionName.equals(ObjectModelServicesInteractionSpec.FUNCTION_NAME_IS_ARRAY_TYPE) || functionName.equals(ObjectModelServicesInteractionSpec.FUNCTION_NAME_GET_FIELD_DECLARING_TYPE) || functionName.equals(ObjectModelServicesInteractionSpec.FUNCTION_NAME_IS_COLLECTION) || functionName.equals(ObjectModelServicesInteractionSpec.FUNCTION_NAME_IS_COLLECTION_WITH_SINGLE_FACTORY_PARAMETER_FOR_CONTENT) || functionName.equals(ObjectModelServicesInteractionSpec.FUNCTION_NAME_GET_NEW_XOM_ARRAY_INSTANCE_FOR_BOM_TYPE) || functionName.equals(ObjectModelServicesInteractionSpec.FUNCTION_NAME_CONVERT_TO_XOM) || functionName.equals(ObjectModelServicesInteractionSpec.FUNCTION_NAME_VALIDATE_OBJECT_FACTORY) || functionName.equals(RulesetSignatureFactoryInteractionSpec.FUNCTION_NAME_GET_RULESET_SIGNATURE);
    }

    @Override
    public String[] getSupportedFunctionNames() {
        String[] functionNames = new String[]{ObjectModelServicesInteractionSpec.FUNCTION_NAME_GET_OBJECT_FACTORY_SIGNATURE, ObjectModelServicesInteractionSpec.FUNCTION_NAME_CREATE_OBJECT_INSTANCE, ObjectModelServicesInteractionSpec.FUNCTION_NAME_GET_XOM_CLASS_MAPPING_FOR_BOM_TYPE, ObjectModelServicesInteractionSpec.FUNCTION_NAME_GET_TYPE_OF_ARRAY_ELEMENTS, ObjectModelServicesInteractionSpec.FUNCTION_NAME_IS_ARRAY_TYPE, ObjectModelServicesInteractionSpec.FUNCTION_NAME_GET_FIELD_DECLARING_TYPE, ObjectModelServicesInteractionSpec.FUNCTION_NAME_IS_COLLECTION, ObjectModelServicesInteractionSpec.FUNCTION_NAME_IS_COLLECTION_WITH_SINGLE_FACTORY_PARAMETER_FOR_CONTENT, ObjectModelServicesInteractionSpec.FUNCTION_NAME_GET_NEW_XOM_ARRAY_INSTANCE_FOR_BOM_TYPE, ObjectModelServicesInteractionSpec.FUNCTION_NAME_CONVERT_TO_XOM, ObjectModelServicesInteractionSpec.FUNCTION_NAME_VALIDATE_OBJECT_FACTORY, RulesetSignatureFactoryInteractionSpec.FUNCTION_NAME_GET_RULESET_SIGNATURE};
        return functionNames;
    }

    @Override
    public boolean execute(IlrXUConnection connection, InteractionSpec interactionSpec, Record input, Record output) throws XUException {
        String interactionSpecName = XUInteractionSpec.intern(this.getFunctionName(interactionSpec));
        assert (output != null);
        try {
            if (interactionSpecName.equals(ObjectModelServicesInteractionSpec.FUNCTION_NAME_GET_OBJECT_FACTORY_SIGNATURE)) {
                return this.getObjectFactorySignature(connection, (IndexedRecord)input, (IndexedRecord)output);
            }
            if (interactionSpecName.equals(ObjectModelServicesInteractionSpec.FUNCTION_NAME_CREATE_OBJECT_INSTANCE)) {
                return this.createObjectInstance(connection, (IndexedRecord)input, (IndexedRecord)output);
            }
            if (interactionSpecName.equals(ObjectModelServicesInteractionSpec.FUNCTION_NAME_GET_XOM_CLASS_MAPPING_FOR_BOM_TYPE)) {
                return this.getXOMClassMappingForBOMType(connection, (IndexedRecord)input, (IndexedRecord)output);
            }
            if (interactionSpecName.equals(ObjectModelServicesInteractionSpec.FUNCTION_NAME_GET_TYPE_OF_ARRAY_ELEMENTS)) {
                return this.getTypeOfArrayElements(connection, (IndexedRecord)input, (IndexedRecord)output);
            }
            if (interactionSpecName.equals(ObjectModelServicesInteractionSpec.FUNCTION_NAME_IS_ARRAY_TYPE)) {
                return this.isArrayType(connection, (IndexedRecord)input, (IndexedRecord)output);
            }
            if (interactionSpecName.equals(ObjectModelServicesInteractionSpec.FUNCTION_NAME_GET_FIELD_DECLARING_TYPE)) {
                return this.getFieldDeclaringType(connection, (IndexedRecord)input, (IndexedRecord)output);
            }
            if (interactionSpecName.equals(ObjectModelServicesInteractionSpec.FUNCTION_NAME_IS_COLLECTION)) {
                return this.isCollection(connection, (IndexedRecord)input, (IndexedRecord)output);
            }
            if (interactionSpecName.equals(ObjectModelServicesInteractionSpec.FUNCTION_NAME_IS_COLLECTION_WITH_SINGLE_FACTORY_PARAMETER_FOR_CONTENT)) {
                return this.isCollectionWithSingleFactoryParameterForContent(connection, (IndexedRecord)input, (IndexedRecord)output);
            }
            if (interactionSpecName.equals(ObjectModelServicesInteractionSpec.FUNCTION_NAME_GET_NEW_XOM_ARRAY_INSTANCE_FOR_BOM_TYPE)) {
                return this.getNewXOMArrayInstanceForBOMType(connection, (IndexedRecord)input, (IndexedRecord)output);
            }
            if (interactionSpecName.equals(ObjectModelServicesInteractionSpec.FUNCTION_NAME_CONVERT_TO_XOM)) {
                return this.convertToXOM(connection, (IndexedRecord)input, (IndexedRecord)output);
            }
            if (interactionSpecName.equals(ObjectModelServicesInteractionSpec.FUNCTION_NAME_VALIDATE_OBJECT_FACTORY)) {
                return this.validateObjectFactory(connection, (IndexedRecord)input, (IndexedRecord)output);
            }
            if (interactionSpecName.equals(RulesetSignatureFactoryInteractionSpec.FUNCTION_NAME_GET_RULESET_SIGNATURE)) {
                return this.getRulesetSignature(connection, (IndexedRecord)input, (IndexedRecord)output);
            }
            throw new LocalizedResourceException("XU.ERROR.10013");
        }
        catch (ResourceException e) {
            throw new XUException(XUMessageCode.ERROR_PLUGIN, e);
        }
    }

    @Override
    public byte getConnectionType() {
        return 0;
    }

    @Override
    public boolean isStateModified(InteractionSpec interactionSpec, Record input, Record output) throws XUException {
        return false;
    }

    protected String getFunctionName(InteractionSpec spec) throws XUException {
        if (spec instanceof ObjectModelServicesInteractionSpec) {
            try {
                return ((ObjectModelServicesInteractionSpec)spec).getFunctionName();
            }
            catch (Exception e) {
                throw new XUException(XUMessageCode.ERROR_PLUGIN, e);
            }
        }
        if (spec instanceof RulesetSignatureFactoryInteractionSpec) {
            try {
                return ((RulesetSignatureFactoryInteractionSpec)spec).getFunctionName();
            }
            catch (Exception e) {
                throw new XUException(XUMessageCode.ERROR_PLUGIN, e);
            }
        }
        try {
            return JCAInteractionFunctionNames.getFunctionName(spec);
        }
        catch (Exception ex) {
            throw new XUException(XUMessageCode.ERROR_PLUGIN, ex);
        }
    }

    protected boolean getRulesetSignature(IlrXUConnection connection, IndexedRecord input, IndexedRecord output) throws ResourceException {
        String[] serializedParameters = new String[]{};
        List<IlrRulesetParameter> rulesetParameters = this.getRulesetParameters(connection);
        if (rulesetParameters != null) {
            serializedParameters = new String[rulesetParameters.size()];
            int parameterIndex = 0;
            for (IlrRulesetParameter currentParameter : rulesetParameters) {
                try {
                    serializedParameters[parameterIndex] = IlrXUSerializationUtils.serializeRulesetParameter(currentParameter);
                }
                catch (Throwable t) {
                    throw this.createResourceException(DVSPluginLocalization.ERROR_SERIALIZING_RULESET_PARAMETER, new Object[]{currentParameter.getName()}, t);
                }
                ++parameterIndex;
            }
        }
        if (output.size() >= 1) {
            output.add(0, (Object)serializedParameters);
        } else {
            output.add((Object)serializedParameters);
        }
        return true;
    }

    protected IlrReflect getBOMReflect(IlrXUConnection connection) throws ResourceException {
        IlrReflect bom = null;
        IlrEngineType engineType = this.getEngineType(connection);
        EngineManager engineManager = connection.getEngineManager();
        if (engineType == IlrEngineType.CRE) {
            IlrTranslationDebugSupport debug = engineManager.getRuleset().getCRERuleset().getTranslationDebugSupport();
            if (debug == null) {
                String path = engineManager.getRuleset().getCanonicalRulesetPath();
                throw this.createResourceException(DVSPluginLocalization.ERROR_BOM_SUPPORT_NOT_ENABLED, new Object[]{path}, null);
            }
            bom = debug.getBom();
        } else {
            try {
                bom = engineManager.getRuleset().getBOMReflect();
            }
            catch (XUException e) {
                throw this.createResourceException(DVSPluginLocalization.ERROR_RETRIEVING_BOM, null, e);
            }
            if (bom == null) {
                String path = engineManager.getRuleset().getCanonicalRulesetPath();
                throw this.createResourceException(DVSPluginLocalization.ERROR_BOM_RESOURCE_MISSING, new Object[]{path}, null);
            }
        }
        return bom;
    }

    private IlrXmlSignatureParser.Parameter[] getXmlSignatureParameters(IlrXUConnection connection) throws ResourceException {
        IlrXmlSignatureParser.Parameter[] parameters = null;
        IlrRESRulesetArchive resRulesetArchive = null;
        try {
            resRulesetArchive = connection.getXURulesetArchiveInformation().getRESRulesetArchive();
        }
        catch (XUException e) {
            throw this.createResourceException(DVSPluginLocalization.ERROR_RETRIEVING_RES_RULESET_ARCHIVE, null, e);
        }
        InputStream xmlSignatureStream = null;
        IlrEngineType engineType = this.getEngineType(connection);
        if (resRulesetArchive != null) {
            if (engineType == IlrEngineType.CRE) {
                IlrRulesetArchive rulesetArchive = ((IlrCRERulesetArchive)resRulesetArchive).getRulesetArchive();
                try {
                    xmlSignatureStream = StreamUtil.toStream(rulesetArchive.getRulesetSignature().getBytes(rulesetArchive.getXmlEncoding()));
                }
                catch (UnsupportedEncodingException e) {
                    throw this.createResourceException(DVSPluginLocalization.ERROR_RETRIEVING_XML_RULESET_SIGNATURE, null, e);
                }
            }
            xmlSignatureStream = new ZipInputStream(resRulesetArchive.getContentStream());
            String signaturePath = DE_SIGNATURE_FILE_PATH;
            try {
                ZipEntry currentEntry;
                while ((currentEntry = xmlSignatureStream.getNextEntry()) != null && !currentEntry.getName().startsWith(signaturePath)) {
                }
            }
            catch (IOException e) {
                throw this.createResourceException(DVSPluginLocalization.ERROR_RETRIEVING_XML_RULESET_SIGNATURE, null, e);
            }
        }
        if (xmlSignatureStream != null) {
            IlrXMLSignatureParser parser = new IlrXMLSignatureParser();
            InputSource input = new InputSource(xmlSignatureStream);
            try {
                parameters = parser.parseSignature(input);
            }
            catch (Exception e) {
                throw this.createResourceException(DVSPluginLocalization.ERROR_PARSING_XML_RULESET_SIGNATURE, null, e);
            }
        }
        return parameters;
    }

    protected List<IlrRulesetParameter> getRulesetParameters(IlrXUConnection connection) throws ResourceException {
        IlrXmlSignatureParser.Parameter[] parameters = this.getXmlSignatureParameters(connection);
        IlrReflect bom = this.getBOMReflect(connection);
        ArrayList<IlrRulesetParameter> rulesetParameters = new ArrayList<IlrRulesetParameter>(parameters.length);
        for (IlrXmlSignatureParser.Parameter parameter : parameters) {
            IlrRulesetParameterImpl rulesetParameter = new IlrRulesetParameterImpl();
            rulesetParameter.setName(parameter.name);
            String rulesetParameterDirection = parameter.direction;
            if ("inout".equals(rulesetParameterDirection)) {
                rulesetParameter.setDirection(IlrRulesetParameter.RulesetParameterDirection.IN_OUT);
            } else if ("in".equals(rulesetParameterDirection)) {
                rulesetParameter.setDirection(IlrRulesetParameter.RulesetParameterDirection.IN);
            } else if ("out".equals(rulesetParameterDirection)) {
                rulesetParameter.setDirection(IlrRulesetParameter.RulesetParameterDirection.OUT);
            }
            String bomTypeAsString = parameter.bomType;
            if (bomTypeAsString == null || bomTypeAsString.isEmpty()) {
                throw this.createResourceException(DVSPluginLocalization.ERROR_BOM_TYPE_MISSING, new Object[]{rulesetParameter.getName()}, null);
            }
            IlrDefaultBOMTypeDescriptor bomTypeDescriptor = new IlrDefaultBOMTypeDescriptor(bom.getType(bomTypeAsString));
            rulesetParameter.setBOMType(bomTypeDescriptor);
            rulesetParameters.add(rulesetParameter);
        }
        return rulesetParameters;
    }

    protected boolean getObjectFactorySignature(IlrXUConnection connection, IndexedRecord input, IndexedRecord output) throws ResourceException {
        IlrBOMTypeDescriptor bomType = this.getIlrBOMTypeDescriptorParameterFromInputRecord(input, 0);
        IlrObjectModelServices oms = this.createObjectModelServices(connection);
        Map<String, IlrObjectFactoryParameter> factorySignature = null;
        try {
            factorySignature = oms.getObjectFactorySignature(bomType);
        }
        catch (IlrUnsupportedBOMTypeException e) {
            throw this.createResourceException(DVSPluginLocalization.ERROR_GETTING_OBJECT_FACTORY_SIGNATURE, new Object[]{bomType}, e);
        }
        if (output.size() >= 1) {
            output.add(0, IlrXUSerializationUtils.serializeObjectFactorySignature(factorySignature));
        } else {
            output.add(IlrXUSerializationUtils.serializeObjectFactorySignature(factorySignature));
        }
        return true;
    }

    protected boolean createObjectInstance(IlrXUConnection connection, IndexedRecord input, IndexedRecord output) throws ResourceException {
        IlrBOMTypeDescriptor bomType = this.getIlrBOMTypeDescriptorParameterFromInputRecord(input, 0);
        Map inputParametersInRecord = null;
        try {
            inputParametersInRecord = (Map)this.getObjectParameterFromInputRecord(input, 1);
        }
        catch (ClassCastException e) {
            throw this.createResourceException(DVSPluginLocalization.ERROR_CANNOT_CAST_VALUE_IN_INPUT_RECORD, new Object[]{1, inputParametersInRecord.getClass().getName()}, e);
        }
        Map<String, IlrObjectFactoryParameterValue> inputParameters = null;
        try {
            inputParameters = IlrXUSerializationUtils.deserializeObjectFactoryInputParameters(inputParametersInRecord);
        }
        catch (IlrSerializationException e) {
            throw this.createResourceException(DVSPluginLocalization.ERROR_DESERIALIZING_OBJECT_FACTORY_INPUT_PARAMETERS, new Object[]{inputParametersInRecord}, e);
        }
        IlrObjectModelServices oms = this.createObjectModelServices(connection);
        Object instanceCreatedByTheObjectFactory = null;
        try {
            instanceCreatedByTheObjectFactory = oms.createObjectInstance(bomType, inputParameters);
        }
        catch (IlrUnsupportedBOMTypeException e) {
            throw this.createResourceException(DVSPluginLocalization.ERROR_CREATING_OBJECT_INSTANCE, new Object[]{bomType.getFullyQualifiedName()}, e);
        }
        catch (IlrObjectFactoryParametersException e) {
            throw this.createResourceException(DVSPluginLocalization.ERROR_CREATING_OBJECT_INSTANCE, new Object[]{bomType.getFullyQualifiedName()}, e);
        }
        if (output.size() >= 1) {
            output.add(0, instanceCreatedByTheObjectFactory);
        } else {
            output.add(instanceCreatedByTheObjectFactory);
        }
        return true;
    }

    protected boolean getXOMClassMappingForBOMType(IlrXUConnection connection, IndexedRecord input, IndexedRecord output) throws ResourceException {
        String bomType = this.getStringParameterFromInputRecord(input, 0);
        IlrObjectModelServices oms = this.createObjectModelServices(connection);
        Class<?> xomClass = null;
        try {
            xomClass = oms.getXOMClassMappingForBOMType(bomType);
        }
        catch (ClassNotFoundException e) {
            throw this.createResourceException(DVSPluginLocalization.ERROR_GETTING_XOM_CLASS_MAPPING, new Object[]{bomType}, e);
        }
        catch (IlrUnsupportedBOMTypeException e) {
            throw this.createResourceException(DVSPluginLocalization.ERROR_GETTING_XOM_CLASS_MAPPING, new Object[]{bomType}, e);
        }
        String returnedValue = null;
        if (xomClass != null) {
            returnedValue = xomClass.getName();
        }
        if (output.size() >= 1) {
            output.add(0, (Object)returnedValue);
        } else {
            output.add((Object)returnedValue);
        }
        return true;
    }

    protected boolean getNewXOMArrayInstanceForBOMType(IlrXUConnection connection, IndexedRecord input, IndexedRecord output) throws ResourceException {
        String bomType = this.getStringParameterFromInputRecord(input, 0);
        int arrayLength = this.getIntParameterFromInputRecord(input, 1);
        IlrObjectModelServices oms = this.createObjectModelServices(connection);
        Object newInstance = null;
        try {
            newInstance = oms.getNewXOMArrayInstanceForBOMType(bomType, arrayLength);
        }
        catch (ClassNotFoundException e) {
            throw this.createResourceException(DVSPluginLocalization.ERROR_GETTING_NEW_XOM_ARRAY_INSTANCE, new Object[]{bomType}, e);
        }
        catch (IlrUnsupportedBOMTypeException e) {
            throw this.createResourceException(DVSPluginLocalization.ERROR_GETTING_NEW_XOM_ARRAY_INSTANCE, new Object[]{bomType}, e);
        }
        if (output.size() >= 1) {
            output.add(0, newInstance);
        } else {
            output.add(newInstance);
        }
        return true;
    }

    protected boolean getTypeOfArrayElements(IlrXUConnection connection, IndexedRecord input, IndexedRecord output) throws ResourceException {
        IlrBOMTypeDescriptor returnedValue;
        String bomType = this.getStringParameterFromInputRecord(input, 0);
        IlrObjectModelServices oms = this.createObjectModelServices(connection);
        try {
            returnedValue = oms.getTypeOfArrayElements(bomType);
        }
        catch (IlrUnsupportedBOMTypeException e) {
            throw this.createResourceException(DVSPluginLocalization.ERROR_GETTING_TYPE_OF_ARRAY_ELEMENTS, new Object[]{bomType}, e);
        }
        if (output.size() >= 1) {
            output.add(0, (Object)IlrXUSerializationUtils.serializeBOMTypeDescriptor(returnedValue));
        } else {
            output.add((Object)IlrXUSerializationUtils.serializeBOMTypeDescriptor(returnedValue));
        }
        return true;
    }

    protected boolean isArrayType(IlrXUConnection connection, IndexedRecord input, IndexedRecord output) throws ResourceException {
        Boolean returnedValue;
        String bomType = this.getStringParameterFromInputRecord(input, 0);
        IlrObjectModelServices oms = this.createObjectModelServices(connection);
        try {
            returnedValue = oms.isArrayType(bomType);
        }
        catch (IlrUnsupportedBOMTypeException e) {
            throw this.createResourceException(DVSPluginLocalization.ERROR_DETERMINING_IF_ARRAY, new Object[]{bomType}, e);
        }
        if (output.size() >= 1) {
            output.add(0, (Object)returnedValue);
        } else {
            output.add((Object)returnedValue);
        }
        return true;
    }

    protected boolean getFieldDeclaringType(IlrXUConnection connection, IndexedRecord input, IndexedRecord output) throws ResourceException {
        IlrBOMTypeDescriptor returnedValue;
        String bomType = this.getStringParameterFromInputRecord(input, 0);
        String fieldName = this.getStringParameterFromInputRecord(input, 1);
        IlrObjectModelServices oms = this.createObjectModelServices(connection);
        try {
            returnedValue = oms.getFieldDeclaringClass(bomType, fieldName);
        }
        catch (IlrUnsupportedBOMTypeException e) {
            throw this.createResourceException(DVSPluginLocalization.ERROR_GETTING_CLASS_DECLARING_FIELD, new Object[]{fieldName, bomType}, e);
        }
        if (output.size() >= 1) {
            output.add(0, (Object)IlrXUSerializationUtils.serializeBOMTypeDescriptor(returnedValue));
        } else {
            output.add((Object)IlrXUSerializationUtils.serializeBOMTypeDescriptor(returnedValue));
        }
        return true;
    }

    protected boolean isCollection(IlrXUConnection connection, IndexedRecord input, IndexedRecord output) throws ResourceException {
        Boolean returnedValue;
        String bomType = this.getStringParameterFromInputRecord(input, 0);
        IlrObjectModelServices oms = this.createObjectModelServices(connection);
        try {
            returnedValue = oms.isCollection(bomType);
        }
        catch (IlrUnsupportedBOMTypeException e) {
            throw this.createResourceException(DVSPluginLocalization.ERROR_DETERMINING_IF_COLLECTION, new Object[]{bomType}, e);
        }
        if (output.size() >= 1) {
            output.add(0, (Object)returnedValue);
        } else {
            output.add((Object)returnedValue);
        }
        return true;
    }

    protected boolean isCollectionWithSingleFactoryParameterForContent(IlrXUConnection connection, IndexedRecord input, IndexedRecord output) throws ResourceException {
        Boolean returnedValue;
        IlrBOMTypeDescriptor bomType = this.getIlrBOMTypeDescriptorParameterFromInputRecord(input, 0);
        IlrObjectModelServices oms = this.createObjectModelServices(connection);
        try {
            returnedValue = oms.isCollectionWithSingleFactoryParameterForContent(bomType);
        }
        catch (IlrUnsupportedBOMTypeException e) {
            throw this.createResourceException(DVSPluginLocalization.ERROR_DETERMINING_IF_COLLECTION_WITH_SINGLE_FACTORY_PARAM, new Object[]{bomType}, e);
        }
        if (output.size() >= 1) {
            output.add(0, (Object)returnedValue);
        } else {
            output.add((Object)returnedValue);
        }
        return true;
    }

    protected boolean convertToXOM(IlrXUConnection connection, IndexedRecord input, IndexedRecord output) throws ResourceException {
        IlrEngineType engineType = this.getEngineType(connection);
        if (engineType == IlrEngineType.CRE) {
            throw this.createResourceException(DVSPluginLocalization.ERROR_NOT_SUPPORTED_ENGINE_TYPE, new Object[]{engineType}, null);
        }
        Map mapInRecord = null;
        try {
            mapInRecord = (Map)this.getObjectParameterFromInputRecord(input, 0);
        }
        catch (ClassCastException e) {
            throw this.createResourceException(DVSPluginLocalization.ERROR_CANNOT_CAST_VALUE_IN_INPUT_RECORD, new Object[]{0, mapInRecord.getClass().getName()}, e);
        }
        boolean preprocess = this.getBooleanParameterFromInputRecord(input, 1);
        CommonObjectModelServices oms = (CommonObjectModelServices)this.createObjectModelServices(connection);
        Map<String, Object> xomMap = null;
        try {
            xomMap = oms.convertToXOM(mapInRecord, preprocess);
        }
        catch (IlrObjectFactoryParametersException e) {
            throw this.createResourceException(DVSPluginLocalization.ERROR_CONVERTING_TO_XOM, null, e);
        }
        if (output.size() >= 1) {
            output.add(0, xomMap);
        } else {
            output.add(xomMap);
        }
        return true;
    }

    protected boolean validateObjectFactory(IlrXUConnection connection, IndexedRecord input, IndexedRecord output) throws ResourceException {
        IlrEngineType engineType = this.getEngineType(connection);
        if (engineType == IlrEngineType.CRE) {
            throw this.createResourceException(DVSPluginLocalization.ERROR_NOT_SUPPORTED_ENGINE_TYPE, new Object[]{engineType}, null);
        }
        List bomTypeDescriptorsInRecord = null;
        try {
            bomTypeDescriptorsInRecord = (List)this.getObjectParameterFromInputRecord(input, 0);
        }
        catch (ClassCastException e) {
            throw this.createResourceException(DVSPluginLocalization.ERROR_CANNOT_CAST_VALUE_IN_INPUT_RECORD, new Object[]{0, bomTypeDescriptorsInRecord.getClass().getName()}, e);
        }
        ArrayList<IlrBOMTypeDescriptor> bomTypeDescriptors = new ArrayList<IlrBOMTypeDescriptor>();
        for (String bomTypeDescriptorInRecord : bomTypeDescriptorsInRecord) {
            try {
                bomTypeDescriptors.add(IlrXUSerializationUtils.deserializeBOMTypeDescriptor(bomTypeDescriptorInRecord));
            }
            catch (IlrSerializationException e) {
                throw this.createResourceException(DVSPluginLocalization.ERROR_DESERIALIZING_BOM_TYPE_DESCRIPTOR, new Object[]{bomTypeDescriptorInRecord}, e);
            }
        }
        CommonObjectModelServices oms = (CommonObjectModelServices)this.createObjectModelServices(connection);
        List<IlrObjectFactoryParametersException> errorList = oms.validateObjectFactory(bomTypeDescriptors);
        ArrayList<String> serializedErrorList = null;
        if (errorList != null) {
            serializedErrorList = new ArrayList<String>();
            for (IlrObjectFactoryParametersException error : errorList) {
                serializedErrorList.add(IlrXUSerializationUtils.serializeObjectFactoryParametersException(error));
            }
        }
        if (output.size() >= 1) {
            output.add(0, serializedErrorList);
        } else {
            output.add(serializedErrorList);
        }
        return true;
    }

    protected IlrObjectModelServices createObjectModelServices(IlrXUConnection connection) throws ResourceException {
        IlrEngineType engineType = this.getEngineType(connection);
        EngineManager engineManager = connection.getEngineManager();
        if (engineType == IlrEngineType.CRE) {
            IlrTranslationDebugSupport debug = engineManager.getRuleset().getCRERuleset().getTranslationDebugSupport();
            if (debug == null) {
                String path = engineManager.getRuleset().getCanonicalRulesetPath();
                throw this.createResourceException(DVSPluginLocalization.ERROR_BOM_SUPPORT_NOT_ENABLED, new Object[]{path}, null);
            }
            IlrTranslatedDataAccessStrategy dataAccessStrategy = new IlrTranslatedDataAccessStrategy((IlrObjectModel)debug.getBom(), engineManager.getRuleset().getCRERuleset().getReflect(), ((CREManager)engineManager).getCREEngine(), debug.getCompiler());
            return new IlrCommonObjectModelServices(dataAccessStrategy);
        }
        IlrReflect bom = this.getBOMReflect(connection);
        BusinessDataIEService businessDataIEService = ((DEManager)engineManager).getBusinessDataIEService();
        if (businessDataIEService == null) {
            String path = engineManager.getRuleset().getCanonicalRulesetPath();
            throw this.createResourceException(DVSPluginLocalization.ERROR_RETRIEVING_BUSINESSDATAIESERVICE, new Object[]{path}, null);
        }
        return new CommonObjectModelServices(bom, businessDataIEService);
    }

    private Object getObjectParameterFromInputRecord(IndexedRecord input, int theParameterIndexInRecord) throws ResourceException {
        if (input == null || input.size() < theParameterIndexInRecord + 1) {
            throw this.createResourceException(DVSPluginLocalization.ERROR_NO_VALUE_AT_INDEX_IN_INPUT_RECORD, new Object[]{theParameterIndexInRecord}, null);
        }
        return input.get(theParameterIndexInRecord);
    }

    private String getStringParameterFromInputRecord(IndexedRecord input, int theParameterIndexInRecord) throws ResourceException {
        String returnedValue = null;
        try {
            returnedValue = (String)this.getObjectParameterFromInputRecord(input, theParameterIndexInRecord);
        }
        catch (ClassCastException e) {
            throw this.createResourceException(DVSPluginLocalization.ERROR_CANNOT_CAST_VALUE_IN_INPUT_RECORD, new Object[]{theParameterIndexInRecord, String.class.getName()}, e);
        }
        return returnedValue;
    }

    private int getIntParameterFromInputRecord(IndexedRecord input, int theParameterIndexInRecord) throws ResourceException {
        Integer returnedValue = null;
        try {
            returnedValue = (Integer)this.getObjectParameterFromInputRecord(input, theParameterIndexInRecord);
        }
        catch (ClassCastException e) {
            throw this.createResourceException(DVSPluginLocalization.ERROR_CANNOT_CAST_VALUE_IN_INPUT_RECORD, new Object[]{theParameterIndexInRecord, Integer.class.getName()}, e);
        }
        return returnedValue;
    }

    private boolean getBooleanParameterFromInputRecord(IndexedRecord input, int theParameterIndexInRecord) throws ResourceException {
        Boolean returnedValue = null;
        try {
            returnedValue = (Boolean)this.getObjectParameterFromInputRecord(input, theParameterIndexInRecord);
        }
        catch (ClassCastException e) {
            throw this.createResourceException(DVSPluginLocalization.ERROR_CANNOT_CAST_VALUE_IN_INPUT_RECORD, new Object[]{theParameterIndexInRecord, Boolean.class.getName()}, e);
        }
        return returnedValue;
    }

    private IlrBOMTypeDescriptor getIlrBOMTypeDescriptorParameterFromInputRecord(IndexedRecord input, int theParameterIndexInRecord) throws ResourceException {
        String bomTypeAsString = this.getStringParameterFromInputRecord(input, theParameterIndexInRecord);
        IlrBOMTypeDescriptor returnedValue = null;
        try {
            returnedValue = IlrXUSerializationUtils.deserializeBOMTypeDescriptor(bomTypeAsString);
        }
        catch (IlrSerializationException e) {
            throw this.createResourceException(DVSPluginLocalization.ERROR_DESERIALIZING_BOM_TYPE_DESCRIPTOR, new Object[]{bomTypeAsString}, e);
        }
        return returnedValue;
    }

    private ResourceException createResourceException(String messageKey, Object[] params, Throwable throwable) {
        return new ResourceException(LocalizedMessageHelper.getLocalizedMessage("com.ibm.rules.dvs.plugin", messageKey, params, null, null), throwable);
    }

    private IlrEngineType getEngineType(IlrXUConnection connection) throws ResourceException {
        IlrEngineType engineType;
        try {
            engineType = connection.getXURulesetArchiveInformation().getProperties().getEngineType();
        }
        catch (XUException e) {
            throw this.createResourceException(DVSPluginLocalization.ERROR_RETRIEVING_ENGINE_TYPE, null, e);
        }
        return engineType;
    }
}

