/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.dvs.rsi.de;

import com.ibm.rules.container.EnginesPackageSimpleZipReader;
import com.ibm.rules.engine.lang.semantics.SemAttribute;
import com.ibm.rules.engine.lang.semantics.SemClass;
import com.ibm.rules.engine.lang.semantics.SemCollectionDomain;
import com.ibm.rules.engine.lang.semantics.SemConstant;
import com.ibm.rules.engine.lang.semantics.SemConstructor;
import com.ibm.rules.engine.lang.semantics.SemDomain;
import com.ibm.rules.engine.lang.semantics.SemDomainIntersection;
import com.ibm.rules.engine.lang.semantics.SemMetadata;
import com.ibm.rules.engine.lang.semantics.SemModifier;
import com.ibm.rules.engine.lang.semantics.SemObjectModel;
import com.ibm.rules.engine.lang.semantics.SemType;
import com.ibm.rules.engine.lang.semantics.SemTypeExtra;
import com.ibm.rules.engine.lang.semantics.SemTypeRestriction;
import com.ibm.rules.engine.lang.semantics.SemValue;
import com.ibm.rules.engine.lang.semantics.SemValueDomain;
import com.ibm.rules.engine.lang.semantics.SemValueSet;
import com.ibm.rules.engine.migration.incremental.BuildContext;
import com.ibm.rules.engine.migration.incremental.BuildContextBuilder;
import com.ibm.rules.engine.outline.EngineOutline;
import com.ibm.rules.engine.outline.EngineOutlineImpl;
import com.ibm.rules.engine.util.EngineCollections;
import com.ibm.rules.engine.util.Filter;
import ilog.rules.bom.IlrObjectModel;
import ilog.rules.bom.serializer.IlrSyntaxError;
import ilog.rules.dvs.rsi.exception.IlrBOMTypeNotFoundException;
import ilog.rules.dvs.rsi.exception.IlrUnsupportedBOMTypeException;
import ilog.rules.dvs.rsi.internal.IlrDefaultBOMTypeDescriptor;
import ilog.rules.factory.IlrReflect;
import ilog.rules.factory.proxy.IlrCompositeReflect;
import ilog.rules.util.issue.IlrDefaultIssueHandler;
import ilog.rules.util.issue.IlrIssueHandler;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ObjectModelHelper {
    protected static final String XML_OBJECT_FQN = "ilog.rules.xml.IlrXmlObject";
    protected static final String COLLECTION_OBJECT_FQN = "java.util.Collection";
    protected static final String DE_BOM_FILE_PATH = "RULES_ENGINE/default/resources/ruleset/com.ibm.ia.engine.bom";

    public static SemObjectModel extractObjectModel(String rulesetArchiveFilePath) throws FileNotFoundException, IOException {
        FileInputStream archiveInputStream = new FileInputStream(rulesetArchiveFilePath);
        return ObjectModelHelper.extractObjectModel(archiveInputStream);
    }

    public static SemObjectModel extractObjectModel(InputStream stream) throws IOException {
        ZipInputStream zipStream = stream instanceof ZipInputStream ? (ZipInputStream)stream : new ZipInputStream(new BufferedInputStream(stream));
        EnginesPackageSimpleZipReader engineReader = new EnginesPackageSimpleZipReader(zipStream);
        EngineOutline outline = engineReader.readEngineOutline();
        zipStream.close();
        if (outline instanceof EngineOutlineImpl) {
            EngineOutlineImpl realOutline = (EngineOutlineImpl)outline;
            SemObjectModel model = realOutline.getSemObjectModel();
            return model;
        }
        return null;
    }

    public static IlrReflect extractBOMReflect(String rulesetArchiveFilePath) throws FileNotFoundException, IOException, IlrSyntaxError {
        FileInputStream archiveInputStream = new FileInputStream(rulesetArchiveFilePath);
        return ObjectModelHelper.extractBOMReflect(archiveInputStream);
    }

    public static IlrReflect extractBOMReflect(InputStream stream) throws IOException, IlrSyntaxError {
        ZipEntry currentEntry;
        IlrReflect reflect = null;
        ZipInputStream zipStream = stream instanceof ZipInputStream ? (ZipInputStream)stream : new ZipInputStream(new BufferedInputStream(stream));
        String bomPath = DE_BOM_FILE_PATH;
        while ((currentEntry = zipStream.getNextEntry()) != null && !currentEntry.getName().startsWith(bomPath)) {
        }
        if (currentEntry != null) {
            InputStreamReader reader = new InputStreamReader((InputStream)zipStream, "UTF-8");
            reflect = new IlrReflect(IlrObjectModel.Kind.BUSINESS);
            reflect.loadPath(new Reader[]{reader});
            reader.close();
        }
        zipStream.close();
        return reflect;
    }

    public static boolean isOptional(SemAttribute theAttribute) throws IlrUnsupportedBOMTypeException {
        if (theAttribute == null) {
            throw new IllegalArgumentException();
        }
        boolean returnedValue = true;
        SemObjectModel theBOM = theAttribute.getDeclaringType().getObjectModel();
        SemType xmlObjectType = null;
        xmlObjectType = ObjectModelHelper.getTypeFromModel(theBOM, XML_OBJECT_FQN);
        if (xmlObjectType == null) {
            throw new IlrBOMTypeNotFoundException(new IlrDefaultBOMTypeDescriptor(XML_OBJECT_FQN, null));
        }
        boolean isClassMappedToXMLXOM = xmlObjectType.getExtra().isAssignableFrom(theAttribute.getDeclaringType());
        if (isClassMappedToXMLXOM) {
            returnedValue = false;
            SemDomain domain = ObjectModelHelper.getDomainForType(theAttribute.getAttributeType());
            SemCollectionDomain collectionDomain = ObjectModelHelper.getCollectionDomain(domain);
            if (collectionDomain != null && collectionDomain.getMinCardinality() == 0) {
                returnedValue = true;
            }
        }
        return returnedValue;
    }

    public static SemDomain getDomainForType(SemType type) {
        if (type instanceof SemTypeRestriction) {
            SemTypeRestriction restriction = (SemTypeRestriction)type;
            return restriction.getDomain();
        }
        return null;
    }

    public static String[] getDomainValues(SemType type) {
        if (type != null) {
            SemValue value;
            SemClass clazz = ObjectModelHelper.getClassForType(type);
            SemTypeExtra extra = type.getExtra();
            ArrayList<String> domainValueList = new ArrayList<String>();
            if (clazz != null && clazz.getModifiers().contains(SemModifier.ENUM) && extra != null && extra.getEnumAttributeFilter() != null) {
                for (SemAttribute attribute : EngineCollections.filteredIterable((Iterable)clazz.getAttributes(), (Filter)clazz.getExtra().getEnumAttributeFilter())) {
                    domainValueList.add(attribute.getName());
                }
                return domainValueList.toArray(new String[0]);
            }
            SemDomain domain = ObjectModelHelper.getDomainForType(type);
            SemValueDomain enumeratedDomain = ObjectModelHelper.getEnumeratedDomain(domain);
            if (enumeratedDomain != null && (value = enumeratedDomain.getValue()) != null && value instanceof SemValueSet) {
                SemValueSet valueSet = (SemValueSet)value;
                Set values = valueSet.getValues();
                String[] domainValues = new String[values.size()];
                int i = 0;
                for (Object domainValue : values) {
                    if (!(domainValue instanceof SemConstant)) continue;
                    domainValues[i] = String.valueOf(((SemConstant)domainValue).getValue());
                    ++i;
                }
                return domainValues;
            }
        }
        return null;
    }

    public static SemValueDomain getEnumeratedDomain(SemDomain theDomain) {
        SemValueDomain returnedValue = null;
        if (theDomain != null) {
            SemDomain[] domains;
            if (theDomain instanceof SemValueDomain) {
                returnedValue = (SemValueDomain)theDomain;
            } else if (theDomain instanceof SemDomainIntersection && (domains = ((SemDomainIntersection)theDomain).getDomains()) != null) {
                SemDomain domain;
                SemDomain[] arr$ = domains;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && (returnedValue = ObjectModelHelper.getEnumeratedDomain(domain = arr$[i$])) == null; ++i$) {
                }
            }
        }
        return returnedValue;
    }

    public static boolean isCollection(SemObjectModel bom, SemType type) throws IlrUnsupportedBOMTypeException {
        if (bom == null && type == null) {
            throw new IllegalArgumentException();
        }
        boolean returnedValue = false;
        SemType collectionType = ObjectModelHelper.getTypeFromModel(bom, COLLECTION_OBJECT_FQN);
        if (collectionType == null) {
            throw new IlrBOMTypeNotFoundException(new IlrDefaultBOMTypeDescriptor(COLLECTION_OBJECT_FQN, null));
        }
        returnedValue = collectionType.getExtra().isAssignableFrom(type);
        return returnedValue;
    }

    public static SemCollectionDomain getCollectionDomain(SemDomain theDomain) {
        SemCollectionDomain returnedValue = null;
        if (theDomain != null) {
            SemDomain[] domains;
            if (theDomain instanceof SemCollectionDomain) {
                returnedValue = (SemCollectionDomain)theDomain;
            } else if (theDomain instanceof SemDomainIntersection && (domains = ((SemDomainIntersection)theDomain).getDomains()) != null) {
                SemDomain domain;
                SemDomain[] arr$ = domains;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && (returnedValue = ObjectModelHelper.getCollectionDomain(domain = arr$[i$])) == null; ++i$) {
                }
            }
        }
        return returnedValue;
    }

    protected static SemObjectModel loadBootBOM() {
        IlrCompositeReflect tempReflect = new IlrCompositeReflect(IlrObjectModel.Platform.JAVA, Collections.EMPTY_LIST);
        return ObjectModelHelper.getObjectModelFromReflect((IlrReflect)tempReflect);
    }

    protected static SemObjectModel getObjectModelFromReflect(IlrReflect reflect) {
        BuildContextBuilder builder = new BuildContextBuilder();
        builder.setReflect(reflect);
        IlrDefaultIssueHandler errorHandler = new IlrDefaultIssueHandler();
        builder.setHandler((IlrIssueHandler)errorHandler);
        BuildContext bContext = builder.build();
        return bContext.getSemObjectModel();
    }

    public static SemType getTypeFromModel(SemObjectModel model, String typeFullyQualifiedName) {
        if (model == null || typeFullyQualifiedName == null) {
            return null;
        }
        SemType type = model.getType(typeFullyQualifiedName);
        return type;
    }

    public static SemClass getClassForType(SemType type) {
        if (type != null && type instanceof SemClass) {
            SemClass clazz = (SemClass)type;
            return clazz;
        }
        return null;
    }

    public static SemMetadata getConstructorMetadata(SemConstructor constructor, Class<?> metadata) {
        SemMetadata meta = constructor.getMetadata(metadata);
        return meta;
    }

    public static SemMetadata getAttributeMetadata(SemAttribute attribute, Class<?> metadata) {
        SemMetadata meta = attribute.getMetadata(metadata);
        return meta;
    }

    public static String getFullyQualifiedNameForType(SemType type) {
        if (type == null) {
            return null;
        }
        if (type instanceof SemTypeRestriction) {
            return ObjectModelHelper.getFullyQualifiedNameForType(((SemTypeRestriction)type).getRestrictedType());
        }
        return type.getDisplayName();
    }
}

