/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.dvs.rsi.de.model.internal;

import com.ibm.rules.dvs.rsi.de.ObjectModelHelper;
import com.ibm.rules.engine.dataio.SemDefaultConstructorMetadata;
import com.ibm.rules.engine.dvs.metadata.DefaultConstructorMetadata;
import com.ibm.rules.engine.dvs.metadata.IgnoreMetadata;
import com.ibm.rules.engine.lang.semantics.SemArrayClass;
import com.ibm.rules.engine.lang.semantics.SemAttribute;
import com.ibm.rules.engine.lang.semantics.SemClass;
import com.ibm.rules.engine.lang.semantics.SemConstructor;
import com.ibm.rules.engine.lang.semantics.SemDomain;
import com.ibm.rules.engine.lang.semantics.SemDomainKind;
import com.ibm.rules.engine.lang.semantics.SemLocalVariableDeclaration;
import com.ibm.rules.engine.lang.semantics.SemMetadata;
import com.ibm.rules.engine.lang.semantics.SemMethod;
import com.ibm.rules.engine.lang.semantics.SemModifier;
import com.ibm.rules.engine.lang.semantics.SemObjectModel;
import com.ibm.rules.engine.lang.semantics.SemType;
import com.ibm.rules.engine.lang.semantics.SemTypeKind;
import com.ibm.rules.res.message.internal.LocalizedMessageHelper;
import ilog.rules.dvs.rsi.IlrBOMTypeDescriptor;
import ilog.rules.dvs.rsi.IlrBusinessObjectModelServices;
import ilog.rules.dvs.rsi.exception.IlrBOMTypeNotFoundException;
import ilog.rules.dvs.rsi.exception.IlrMissingDefaultConstructorException;
import ilog.rules.dvs.rsi.exception.IlrUnsupportedBOMTypeException;
import ilog.rules.dvs.rsi.internal.IlrCommonMessageHelper;
import ilog.rules.dvs.rsi.internal.IlrDefaultBOMTypeDescriptor;
import ilog.rules.dvs.rsi.ofactory.IlrObjectFactoryParameter;
import ilog.rules.dvs.rsi.ofactory.internal.IlrObjectFactoryParameterImpl;
import ilog.rules.dvs.rsi.utils.IlrHRSerializationUtils;
import ilog.rules.dvs.rsi.utils.IlrSerializationException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CommonBusinessObjectModelServices
implements IlrBusinessObjectModelServices {
    protected static final Class<SemDefaultConstructorMetadata> DEFAULT_FACTORY_CONSTRUCTOR_PROPERTY_METADATA = SemDefaultConstructorMetadata.class;
    protected static final Class<DefaultConstructorMetadata> DEFAULT_FACTORY_CONSTRUCTOR_PROPERTY_IN_BOOT_BOM_METADATA = DefaultConstructorMetadata.class;
    protected static final Class<IgnoreMetadata> IGNORE_ATTRIBUTE_FOR_FACTORY_PROPERTY_METADATA = IgnoreMetadata.class;
    private static final Logger LOGGER = Logger.getLogger(CommonBusinessObjectModelServices.class.getName());
    protected SemObjectModel bom = null;

    public CommonBusinessObjectModelServices(SemObjectModel theBOM) {
        this.bom = theBOM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, IlrObjectFactoryParameter> getObjectFactorySignature(IlrBOMTypeDescriptor theBOMType) throws IlrUnsupportedBOMTypeException {
        SemObjectModel semObjectModel = this.bom;
        synchronized (semObjectModel) {
            FactorySignature signature = this.internalGetObjectFactorySignature(theBOMType);
            Map<String, IlrObjectFactoryParameter> returnedValue = null;
            if (signature != null) {
                returnedValue = signature.getParameters();
            }
            return returnedValue;
        }
    }

    @Override
    public boolean isArrayType(String theBOMTypeFullyQualifiedName) throws IlrUnsupportedBOMTypeException {
        return this.getTypeOfArrayElements(theBOMTypeFullyQualifiedName) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IlrBOMTypeDescriptor getFieldDeclaringClass(String theBOMTypeFullyQualifiedName, String theFieldName) throws IlrUnsupportedBOMTypeException {
        if (theBOMTypeFullyQualifiedName == null || theFieldName == null) {
            throw new IllegalArgumentException();
        }
        IlrDefaultBOMTypeDescriptor returnedValue = null;
        SemObjectModel semObjectModel = this.bom;
        synchronized (semObjectModel) {
            SemType type = ObjectModelHelper.getTypeFromModel(this.bom, theBOMTypeFullyQualifiedName);
            SemClass clazz = ObjectModelHelper.getClassForType(type);
            if (type == null || clazz == null) {
                throw new IlrBOMTypeNotFoundException(new IlrDefaultBOMTypeDescriptor(theBOMTypeFullyQualifiedName, null));
            }
            SemAttribute field = clazz.getAttribute(theFieldName);
            if (field == null) {
                Collection superClasses = clazz.getSuperClasses();
                if (superClasses != null) {
                    for (SemClass superClass : superClasses) {
                        if (superClass.isInterface()) continue;
                        return this.getFieldDeclaringClass(ObjectModelHelper.getFullyQualifiedNameForType((SemType)superClass), theFieldName);
                    }
                }
            } else {
                returnedValue = new IlrDefaultBOMTypeDescriptor(field.getDeclaringType());
            }
        }
        return returnedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IlrBOMTypeDescriptor getTypeOfArrayElements(String theBOMTypeFullyQualifiedName) throws IlrUnsupportedBOMTypeException {
        if (theBOMTypeFullyQualifiedName == null) {
            throw new IllegalArgumentException();
        }
        IlrDefaultBOMTypeDescriptor returnedValue = null;
        SemObjectModel semObjectModel = this.bom;
        synchronized (semObjectModel) {
            SemType bomType = ObjectModelHelper.getTypeFromModel(this.bom, theBOMTypeFullyQualifiedName);
            if (bomType == null) {
                throw new IlrBOMTypeNotFoundException(new IlrDefaultBOMTypeDescriptor(theBOMTypeFullyQualifiedName, null));
            }
            if (bomType.getKind() == SemTypeKind.ARRAY) {
                SemArrayClass arrayClass = (SemArrayClass)bomType;
                SemType elementsType = arrayClass.getComponentType();
                returnedValue = new IlrDefaultBOMTypeDescriptor(elementsType);
            }
        }
        return returnedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCollection(String theBOMTypeFullyQualifiedName) throws IlrUnsupportedBOMTypeException {
        SemObjectModel semObjectModel = this.bom;
        synchronized (semObjectModel) {
            SemType bomType = ObjectModelHelper.getTypeFromModel(this.bom, theBOMTypeFullyQualifiedName);
            if (bomType == null) {
                throw new IlrBOMTypeNotFoundException(new IlrDefaultBOMTypeDescriptor(theBOMTypeFullyQualifiedName, null));
            }
            return ObjectModelHelper.isCollection(this.bom, bomType);
        }
    }

    @Override
    public boolean isCollectionWithSingleFactoryParameterForContent(IlrBOMTypeDescriptor theBOMDescriptor) throws IlrUnsupportedBOMTypeException {
        boolean returnedValue = false;
        if (this.isCollection(theBOMDescriptor.getFullyQualifiedName())) {
            Map<String, IlrObjectFactoryParameter> objectFactorySignature = null;
            objectFactorySignature = this.getObjectFactorySignature(theBOMDescriptor);
            if (objectFactorySignature != null && objectFactorySignature.size() == 1 && objectFactorySignature.containsKey("_content")) {
                returnedValue = true;
            }
        }
        return returnedValue;
    }

    protected FactorySignature internalGetObjectFactorySignature(IlrBOMTypeDescriptor theBOMType) throws IlrUnsupportedBOMTypeException {
        Map<String, IlrObjectFactoryParameter> formatterSignature;
        Map<String, IlrObjectFactoryParameter> signatureParameters = null;
        FactorySignature.SignatureType signatureType = FactorySignature.SignatureType.BEAN;
        try {
            signatureParameters = this.getBeanFactorySignature(theBOMType);
        }
        catch (IlrUnsupportedBOMTypeException e) {
            signatureParameters = this.getFormatterFactorySignature(theBOMType);
            if (signatureParameters == null) {
                throw e;
            }
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("Exception was thrown retrieving the bean signature: using formatter signature for " + IlrHRSerializationUtils.serializeBOMTypeDescriptor(theBOMType));
            }
            signatureType = FactorySignature.SignatureType.FORMATTER;
        }
        if (this.isCollection(theBOMType.getFullyQualifiedName())) {
            SemType containedElements;
            String collectionContentParameterName = "_content";
            if (signatureParameters.get(collectionContentParameterName) != null) {
                throw new RuntimeException(LocalizedMessageHelper.getLocalizedMessage(IlrSerializationException.RESOURCE_BUNDLE_NAME, IlrCommonMessageHelper.ERROR_FACTORY_SIGNATURE_ALREADY_CONTAINS_A_PARAMETER, new Object[]{theBOMType.getFullyQualifiedName(), "_content"}, null, null));
            }
            IlrBOMTypeDescriptor typeOfContainedElements = theBOMType.getElementsType();
            if (typeOfContainedElements == null) {
                typeOfContainedElements = new IlrDefaultBOMTypeDescriptor((SemType)this.bom.getType(SemTypeKind.OBJECT));
            }
            if ((containedElements = ObjectModelHelper.getTypeFromModel(this.bom, typeOfContainedElements.getFullyQualifiedName())) == null) {
                throw new IlrBOMTypeNotFoundException(new IlrDefaultBOMTypeDescriptor(typeOfContainedElements.getFullyQualifiedName(), null));
            }
            signatureParameters.put(collectionContentParameterName, new IlrObjectFactoryParameterImpl(collectionContentParameterName, new IlrDefaultBOMTypeDescriptor(ObjectModelHelper.getFullyQualifiedNameForType((SemType)containedElements.getArrayClass()), typeOfContainedElements.getElementsType()), true));
        }
        if (signatureParameters.isEmpty() && (formatterSignature = this.getFormatterFactorySignature(theBOMType)) != null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("Using formatter signature for " + IlrHRSerializationUtils.serializeBOMTypeDescriptor(theBOMType) + " as the bean signature is empty");
            }
            signatureParameters = formatterSignature;
            signatureType = FactorySignature.SignatureType.FORMATTER;
        }
        return new FactorySignature(signatureParameters, signatureType);
    }

    protected Map<String, IlrObjectFactoryParameter> getBeanFactorySignature(IlrBOMTypeDescriptor theBOMType) throws IlrUnsupportedBOMTypeException {
        if (theBOMType == null) {
            throw new IllegalArgumentException();
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("Retrieving object factory signature for BOM type " + IlrHRSerializationUtils.serializeBOMTypeDescriptor(theBOMType));
        }
        LinkedHashMap<String, IlrObjectFactoryParameter> returnedValue = new LinkedHashMap<String, IlrObjectFactoryParameter>();
        SemType type = ObjectModelHelper.getTypeFromModel(this.bom, theBOMType.getFullyQualifiedName());
        SemClass clazz = ObjectModelHelper.getClassForType(type);
        if (type == null || clazz == null) {
            throw new IlrBOMTypeNotFoundException(theBOMType);
        }
        SemDomain domain = ObjectModelHelper.getDomainForType(type);
        if (clazz.getModifiers().contains(SemModifier.ENUM) || domain != null && domain.getKind().equals((Object)SemDomainKind.VALUE_SET)) {
            IlrDefaultBOMTypeDescriptor parameterBOMType = new IlrDefaultBOMTypeDescriptor("string", null);
            parameterBOMType.setDomainValues(ObjectModelHelper.getDomainValues(type));
            returnedValue.put("value", new IlrObjectFactoryParameterImpl("value", parameterBOMType, false));
        } else {
            SemAttribute[] allClazzFields;
            SemLocalVariableDeclaration[] mandatoryParameters;
            SemConstructor constructorToUse = this.getDefaultConstructor(clazz);
            if (constructorToUse != null && (mandatoryParameters = constructorToUse.getParameters()) != null) {
                for (SemLocalVariableDeclaration semLocalVariableDeclaration : mandatoryParameters) {
                    SemType parameterType = semLocalVariableDeclaration.getVariableType();
                    IlrDefaultBOMTypeDescriptor parameterTypeDescriptor = new IlrDefaultBOMTypeDescriptor(parameterType);
                    IlrObjectFactoryParameterImpl param = new IlrObjectFactoryParameterImpl(semLocalVariableDeclaration.getVariableName(), parameterTypeDescriptor, false);
                    param.setIsConstructorParameter(true);
                    returnedValue.put(semLocalVariableDeclaration.getVariableName(), param);
                }
            }
            if ((allClazzFields = type.getExtra().getAllAttributes().toArray(new SemAttribute[0])) != null) {
                this.sortFieldsByAlphabeticalOrder(allClazzFields);
                for (SemLocalVariableDeclaration semLocalVariableDeclaration : allClazzFields) {
                    if (semLocalVariableDeclaration.isStatic() || semLocalVariableDeclaration.getModifiers().contains(SemModifier.READONLY) || semLocalVariableDeclaration.getName().equals("class") || semLocalVariableDeclaration.getDeclaringType().getDisplayName().equals("java.util.AbstractList")) continue;
                    SemMetadata ignoreAttributePropertyValue = ObjectModelHelper.getAttributeMetadata((SemAttribute)semLocalVariableDeclaration, IGNORE_ATTRIBUTE_FOR_FACTORY_PROPERTY_METADATA);
                    boolean isOptional = ObjectModelHelper.isOptional((SemAttribute)semLocalVariableDeclaration);
                    if (ignoreAttributePropertyValue == null || !isOptional) {
                        if (returnedValue.containsKey(semLocalVariableDeclaration.getName())) continue;
                        SemType attType = semLocalVariableDeclaration.getAttributeType();
                        IlrDefaultBOMTypeDescriptor attributeTypeDescriptor = new IlrDefaultBOMTypeDescriptor(attType);
                        IlrObjectFactoryParameterImpl param = new IlrObjectFactoryParameterImpl(semLocalVariableDeclaration.getName(), attributeTypeDescriptor, isOptional);
                        param.setIsConstructorParameter(false);
                        returnedValue.put(semLocalVariableDeclaration.getName(), param);
                        continue;
                    }
                    if (!LOGGER.isLoggable(Level.FINER)) continue;
                    LOGGER.finer("Ignoring attribute " + semLocalVariableDeclaration.getName() + " marked with property " + "factory.ignore");
                }
            }
        }
        return returnedValue;
    }

    protected Map<String, IlrObjectFactoryParameter> getFormatterFactorySignature(IlrBOMTypeDescriptor theBOMType) throws IlrUnsupportedBOMTypeException {
        LinkedHashMap<String, IlrObjectFactoryParameterImpl> returnedValue = null;
        SemType type = ObjectModelHelper.getTypeFromModel(this.bom, theBOMType.getFullyQualifiedName());
        SemClass clazz = ObjectModelHelper.getClassForType(type);
        if (type == null || clazz == null) {
            throw new IlrBOMTypeNotFoundException(theBOMType);
        }
        SemClass stringType = this.bom.getType(SemTypeKind.STRING);
        SemMethod method = clazz.getMethod("valueOf", new SemType[]{stringType});
        if (method != null) {
            returnedValue = new LinkedHashMap<String, IlrObjectFactoryParameterImpl>();
            IlrDefaultBOMTypeDescriptor bomType = new IlrDefaultBOMTypeDescriptor("string", null);
            bomType.setDomainValues(ObjectModelHelper.getDomainValues(type));
            returnedValue.put("value", new IlrObjectFactoryParameterImpl("value", bomType, false));
        }
        return returnedValue;
    }

    protected SemConstructor getDefaultConstructor(SemClass theBOMClass) throws IlrUnsupportedBOMTypeException {
        if (theBOMClass == null) {
            return null;
        }
        SemConstructor returnedValue = null;
        Collection ctors = theBOMClass.getConstructors();
        if (ctors == null || ctors.isEmpty()) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("No constructor defined for BOM type " + ObjectModelHelper.getFullyQualifiedNameForType((SemType)theBOMClass));
            }
        } else if (ctors.size() == 1) {
            returnedValue = (SemConstructor)ctors.iterator().next();
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("Using the single constructor defined for BOM type " + ObjectModelHelper.getFullyQualifiedNameForType((SemType)theBOMClass));
            }
        } else {
            for (SemConstructor constructor : ctors) {
                SemMetadata defaultConstructorPropertyValue = ObjectModelHelper.getConstructorMetadata(constructor, DEFAULT_FACTORY_CONSTRUCTOR_PROPERTY_IN_BOOT_BOM_METADATA);
                if (defaultConstructorPropertyValue != null) {
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.finer("Using default constructor defined for BOM type " + ObjectModelHelper.getFullyQualifiedNameForType((SemType)theBOMClass) + " by property " + "factory.default");
                    }
                    returnedValue = constructor;
                    break;
                }
                defaultConstructorPropertyValue = ObjectModelHelper.getConstructorMetadata(constructor, DEFAULT_FACTORY_CONSTRUCTOR_PROPERTY_METADATA);
                if (defaultConstructorPropertyValue != null) {
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.finer("Using default constructor defined for BOM type " + ObjectModelHelper.getFullyQualifiedNameForType((SemType)theBOMClass) + " by property " + "dataio.default");
                    }
                    returnedValue = constructor;
                    break;
                }
                SemLocalVariableDeclaration[] constructorParameters = constructor.getParameters();
                if (constructorParameters != null && constructorParameters.length != 0) continue;
                returnedValue = constructor;
            }
        }
        if (returnedValue == null && !theBOMClass.isInterface() && !ObjectModelHelper.isCollection(this.bom, (SemType)theBOMClass)) {
            throw new IlrMissingDefaultConstructorException(new IlrDefaultBOMTypeDescriptor((SemType)theBOMClass));
        }
        return returnedValue;
    }

    protected void sortFieldsByAlphabeticalOrder(SemAttribute[] theFieldsToSort) {
        if (theFieldsToSort != null && theFieldsToSort.length != 0) {
            Arrays.sort(theFieldsToSort, new Comparator<SemAttribute>(){

                @Override
                public int compare(SemAttribute o1, SemAttribute o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
        }
    }

    protected static class FactorySignature {
        private Map<String, IlrObjectFactoryParameter> parameters = null;
        private SignatureType type = null;

        public FactorySignature(Map<String, IlrObjectFactoryParameter> parameters, SignatureType type) {
            this.parameters = parameters;
            this.type = type;
        }

        public Map<String, IlrObjectFactoryParameter> getParameters() {
            return this.parameters;
        }

        public SignatureType getType() {
            return this.type;
        }

        public static enum SignatureType {
            BEAN,
            FORMATTER;

        }
    }
}

