/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.htds.plugin.cci.internal;

import com.ibm.rules.htds.plugin.cci.internal.RulesetWrapperImpl;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DLCommonXMLUtil {
    public static Element createArrayType(Document doc, RulesetWrapperImpl ruleset, String name, String type) throws ParserConfigurationException {
        Element addElementComplexType = DLCommonXMLUtil.createXSDElement(doc, ruleset.XSDQName(), "complexType", false);
        addElementComplexType.setAttribute("final", "#all");
        addElementComplexType.setAttribute("name", name);
        Element addElementComplexTypeSeq = DLCommonXMLUtil.createXSDElement(doc, ruleset.XSDQName(), "sequence", false);
        addElementComplexType.appendChild(addElementComplexTypeSeq);
        Element addElementComplexTypeSeqElt = DLCommonXMLUtil.createXSDElement(doc, ruleset.XSDQName(), "element", false);
        addElementComplexTypeSeqElt.setAttribute("name", "item");
        addElementComplexTypeSeqElt.setAttribute("nillable", "true");
        addElementComplexTypeSeqElt.setAttribute("maxOccurs", "unbounded");
        addElementComplexTypeSeqElt.setAttribute("minOccurs", "0");
        addElementComplexTypeSeqElt.setAttribute("type", type);
        addElementComplexTypeSeq.appendChild(addElementComplexTypeSeqElt);
        return addElementComplexType;
    }

    public static Element createXSDElement(Document doc, QName xsdQName, String name, boolean optional) throws ParserConfigurationException {
        Element result = doc.createElement((xsdQName.getLocalPart().length() == 0 ? "" : xsdQName.getLocalPart() + ':') + name);
        if (optional) {
            DLCommonXMLUtil.makeOptional(result);
        }
        return result;
    }

    public static Element createElement(String xsdType, String name, boolean optional, boolean qualified, Document doc, RulesetWrapperImpl ruleset) throws ParserConfigurationException {
        Element result = DLCommonXMLUtil.createXSDElement(doc, ruleset.XSDQName(), "element", false);
        result.setAttribute("name", name);
        if (qualified) {
            result.setAttribute("form", "qualified");
        }
        result.setAttribute("type", ruleset.XSDQName().getLocalPart() + ':' + xsdType);
        if (optional) {
            DLCommonXMLUtil.makeOptional(result);
        }
        return result;
    }

    private static void makeOptional(Element result) {
        result.setAttribute("maxOccurs", "1");
        result.setAttribute("minOccurs", "0");
    }

    public static Element appendComplexTypeSequenceElements(Element parent, Document doc, RulesetWrapperImpl ruleset) throws ParserConfigurationException {
        Element complexTypeElement = DLCommonXMLUtil.createXSDElement(doc, ruleset.XSDQName(), "complexType", false);
        parent.appendChild(complexTypeElement);
        Element sequenceElement = DLCommonXMLUtil.createXSDElement(doc, ruleset.XSDQName(), "sequence", false);
        complexTypeElement.appendChild(sequenceElement);
        return sequenceElement;
    }
}

