/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.htds.plugin.cci.internal;

import com.ibm.rules.engine.migration.classdriver.runtime.XmlBindingService;
import com.ibm.rules.htds.plugin.cci.internal.Compatibility;
import com.ibm.rules.htds.plugin.cci.internal.DLGeneratorInteractionSpec;
import com.ibm.rules.htds.plugin.cci.internal.DLGeneratorLogger;
import com.ibm.rules.htds.plugin.cci.internal.DLGeneratorPlugin;
import com.ibm.rules.htds.plugin.cci.internal.HTDSPluginLocalization;
import com.ibm.rules.htds.plugin.cci.internal.HTDSSignature;
import com.ibm.rules.htds.plugin.cci.internal.HTDSUtil;
import com.ibm.rules.htds.plugin.cci.internal.RulesetMetaData;
import com.ibm.rules.htds.plugin.cci.internal.RulesetParameterWrapperImpl;
import com.ibm.rules.htds.plugin.cci.internal.RulesetWrapperImpl;
import com.ibm.rules.htds.plugin.cci.internal.WADLGenerator;
import com.ibm.rules.htds.plugin.cci.internal.WSDLGenerator;
import com.ibm.rules.res.message.internal.LocalizedMessageHelper;
import com.ibm.rules.res.message.internal.XUMessageCode;
import com.ibm.rules.res.xml.internal.XSDUtil;
import com.ibm.rules.res.xu.client.internal.XURulesetParameter;
import com.ibm.rules.res.xu.client.internal.jca.XUInteractionSpec;
import com.ibm.rules.res.xu.engine.de.internal.DEManager;
import com.ibm.rules.res.xu.engine.internal.EngineManager;
import com.ibm.rules.res.xu.internal.XUException;
import ilog.rules.res.model.IlrCRERulesetArchive;
import ilog.rules.res.model.IlrDERulesetArchive;
import ilog.rules.res.model.IlrPath;
import ilog.rules.res.model.IlrRulesetArchiveProperties;
import ilog.rules.res.xu.cci.IlrInteractionExtension;
import ilog.rules.res.xu.cci.IlrXUConnection;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.resource.ResourceException;
import javax.resource.cci.IndexedRecord;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.Record;
import javax.xml.bind.JAXBException;

public class DLGeneratorInteractionExtension
implements IlrInteractionExtension,
Serializable {
    private static final long serialVersionUID = 1L;
    private DLGeneratorPlugin plugin;

    public void setPlugin(DLGeneratorPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean isSupported(InteractionSpec interactionSpec) {
        if (interactionSpec instanceof DLGeneratorInteractionSpec && (((DLGeneratorInteractionSpec)interactionSpec).getFunctionName().equals(DLGeneratorInteractionSpec.FUNCTION_NAME_GENERATE_WSDL) || ((DLGeneratorInteractionSpec)interactionSpec).getFunctionName().equals(DLGeneratorInteractionSpec.FUNCTION_NAME_GENERATE_ZIP_WSDL) || ((DLGeneratorInteractionSpec)interactionSpec).getFunctionName().equals(DLGeneratorInteractionSpec.FUNCTION_NAME_GENERATE_ZIP_WADL) || ((DLGeneratorInteractionSpec)interactionSpec).getFunctionName().equals(DLGeneratorInteractionSpec.FUNCTION_NAME_GENERATE_WADL) || ((DLGeneratorInteractionSpec)interactionSpec).getFunctionName().equals(DLGeneratorInteractionSpec.FUNCTION_NAME_GET_RULESETSIGNATURE))) {
            return true;
        }
        String functionName = this.getFunctionName(interactionSpec);
        return (functionName = XUInteractionSpec.intern(functionName)) != null && (functionName.equals(DLGeneratorInteractionSpec.FUNCTION_NAME_GENERATE_WSDL) || functionName.equals(DLGeneratorInteractionSpec.FUNCTION_NAME_GET_RULESETSIGNATURE) || functionName.equals(DLGeneratorInteractionSpec.FUNCTION_NAME_GENERATE_ZIP_WSDL) || functionName.equals(DLGeneratorInteractionSpec.FUNCTION_NAME_GENERATE_ZIP_WADL) || functionName.equals(DLGeneratorInteractionSpec.FUNCTION_NAME_GENERATE_WADL));
    }

    private String getFunctionName(InteractionSpec interactionSpec) {
        try {
            Class<?> clazz = interactionSpec.getClass();
            Method method = clazz.getMethod("getFunctionName", new Class[0]);
            return (String)method.invoke((Object)interactionSpec, new Object[0]);
        }
        catch (Exception e) {
            if (this.plugin != null && this.plugin.isLoggable(Level.SEVERE)) {
                String msg = LocalizedMessageHelper.getLocalizedMessage("com.ibm.rules.htds.plugin", HTDSPluginLocalization.BAD_FUNCTION_NAME, new String[]{e.getMessage()});
                LogRecord record = new LogRecord(Level.SEVERE, msg);
                this.plugin.log(record);
            }
            return null;
        }
    }

    @Override
    public boolean execute(IlrXUConnection connection, InteractionSpec interactionSpec, Record input, Record output) throws XUException {
        String functionName = this.getFunctionName(interactionSpec);
        functionName = XUInteractionSpec.intern(functionName);
        try {
            if (functionName != null && functionName.equals(DLGeneratorInteractionSpec.FUNCTION_NAME_GET_RULESETSIGNATURE)) {
                this.getRulesetSignature(connection, input, output, this.plugin);
            } else if (functionName != null && functionName.equals(DLGeneratorInteractionSpec.FUNCTION_NAME_GENERATE_ZIP_WSDL)) {
                this.generateWsdl(connection, interactionSpec, input, output, true, this.plugin);
            } else if (functionName != null && functionName.equals(DLGeneratorInteractionSpec.FUNCTION_NAME_GENERATE_WSDL)) {
                this.generateWsdl(connection, interactionSpec, input, output, false, this.plugin);
            } else if (functionName != null && functionName.equals(DLGeneratorInteractionSpec.FUNCTION_NAME_GENERATE_ZIP_WADL)) {
                this.generateWadl(connection, interactionSpec, input, output, true, this.plugin);
            } else {
                this.generateWadl(connection, interactionSpec, input, output, false, this.plugin);
            }
            return true;
        }
        catch (ResourceException e) {
            throw new XUException(XUMessageCode.ERROR_PLUGIN, e);
        }
    }

    @Override
    public byte getConnectionType() {
        return 0;
    }

    @Override
    public boolean isStateModified(InteractionSpec interactionSpec, Record input, Record output) throws XUException {
        return false;
    }

    @Override
    public String[] getSupportedFunctionNames() {
        String[] functionNames = new String[]{DLGeneratorInteractionSpec.FUNCTION_NAME_GENERATE_WSDL, DLGeneratorInteractionSpec.FUNCTION_NAME_GENERATE_ZIP_WSDL, DLGeneratorInteractionSpec.FUNCTION_NAME_GENERATE_WADL, DLGeneratorInteractionSpec.FUNCTION_NAME_GENERATE_ZIP_WADL, DLGeneratorInteractionSpec.FUNCTION_NAME_GET_RULESETSIGNATURE};
        return functionNames;
    }

    public void generateWsdl(IlrXUConnection connection, InteractionSpec interactionSpec, Record input, Record output, boolean zip, DLGeneratorPlugin plugin) throws ResourceException {
        try {
            RulesetWrapperImpl rulesetWrapper = this.getRulesetWrapper(connection, input, false, new DLGeneratorLogger(plugin));
            rulesetWrapper.zipFile(zip);
            if (rulesetWrapper.getEndPoints() == null) {
                throw WSDLGenerator.createResourceException(HTDSPluginLocalization.BAD_END_POINT, null, null);
            }
            WSDLGenerator generator = new WSDLGenerator();
            ByteArrayOutputStream bt = new ByteArrayOutputStream();
            generator.generateWSDL(rulesetWrapper, bt);
            ((IndexedRecord)output).add((Object)bt);
            ((IndexedRecord)output).add((Object)rulesetWrapper.DecisionServiceWSDLName().substring(0, rulesetWrapper.DecisionServiceWSDLName().length() - ".wsdl".length()));
        }
        catch (ResourceException e) {
            throw e;
        }
        catch (Exception e) {
            if (e.getClass().getName().equals("com.sun.xml.bind.v2.runtime.IllegalAnnotationsException")) {
                try {
                    StringBuffer message = new StringBuffer();
                    message.append(e.getMessage()).append('\n');
                    Class<?> clazz = e.getClass();
                    Method method = clazz.getMethod("getErrors", new Class[0]);
                    List exceptions = (List)method.invoke((Object)e, new Object[0]);
                    for (Object ex : exceptions) {
                        message.append(((Exception)ex).getMessage()).append('\n');
                    }
                    throw WSDLGenerator.createResourceException(HTDSPluginLocalization.WSDL_GENERATION_FAILED_JAXB, new String[]{message.toString()}, e);
                }
                catch (Exception ee) {
                    // empty catch block
                }
            }
            throw WSDLGenerator.createResourceException(HTDSPluginLocalization.WSDL_GENERATION_FAILED, new String[]{connection.getSpec().getRulesetPath()}, e);
        }
    }

    public void generateWadl(IlrXUConnection connection, InteractionSpec interactionSpec, Record input, Record output, boolean zip, DLGeneratorPlugin plugin) throws ResourceException {
        try {
            RulesetWrapperImpl rulesetWrapper = this.getRulesetWrapper(connection, input, false, new DLGeneratorLogger(plugin));
            rulesetWrapper.zipFile(zip);
            if (rulesetWrapper.getEndPoints() == null) {
                throw WSDLGenerator.createResourceException(HTDSPluginLocalization.BAD_END_POINT, null, null);
            }
            WADLGenerator generator = new WADLGenerator();
            ByteArrayOutputStream bt = new ByteArrayOutputStream();
            generator.generateWADL(rulesetWrapper, bt);
            ((IndexedRecord)output).add((Object)bt);
            ((IndexedRecord)output).add((Object)rulesetWrapper.DecisionServiceWSDLName().substring(0, rulesetWrapper.DecisionServiceWSDLName().length() - ".wsdl".length()));
        }
        catch (ResourceException e) {
            throw e;
        }
        catch (Exception e) {
            if (e.getClass().getName().equals("com.sun.xml.bind.v2.runtime.IllegalAnnotationsException")) {
                try {
                    StringBuffer message = new StringBuffer();
                    message.append(e.getMessage()).append('\n');
                    Class<?> clazz = e.getClass();
                    Method method = clazz.getMethod("getErrors", new Class[0]);
                    List exceptions = (List)method.invoke((Object)e, new Object[0]);
                    for (Object ex : exceptions) {
                        message.append(((Exception)ex).getMessage()).append('\n');
                    }
                    throw WADLGenerator.createResourceException(HTDSPluginLocalization.WADL_GENERATION_FAILED_JAXB, new String[]{message.toString()}, e);
                }
                catch (Exception ee) {
                    // empty catch block
                }
            }
            throw WADLGenerator.createResourceException(HTDSPluginLocalization.WADL_GENERATION_FAILED, new String[]{connection.getSpec().getRulesetPath()}, e);
        }
    }

    private RulesetWrapperImpl getRulesetWrapper(IlrXUConnection connection, Record input, boolean light, DLGeneratorLogger logger) throws ResourceException {
        IndexedRecord indexedRecord = (IndexedRecord)input;
        Map endPointList = (Map)indexedRecord.get(0);
        String compatibility = Compatibility.LATEST.toString();
        boolean trace = false;
        boolean zipMergeStrategyForImport = true;
        if (indexedRecord.size() > 2) {
            compatibility = (String)indexedRecord.get(2);
        }
        if (indexedRecord.size() > 3) {
            trace = (Boolean)indexedRecord.get(3);
        }
        if (indexedRecord.size() > 4) {
            zipMergeStrategyForImport = Boolean.parseBoolean((String)indexedRecord.get(4));
        }
        EngineManager mgr = null;
        IlrPath rulesetPath = null;
        RulesetWrapperImpl rulesetWrapper = null;
        try {
            IlrRulesetArchiveProperties properties = connection.getManagedConnection().getXURulesetArchiveInformation(connection).getProperties();
            rulesetPath = connection.getManagedConnection().getXURulesetArchiveInformation(connection).getCanonicalPath();
            rulesetWrapper = HTDSUtil.getRulesetWrapper(properties, rulesetPath.getRulesetName(), rulesetPath.getRuleAppName(), compatibility);
            if (light && rulesetWrapper.getRESTVersion() == null) {
                return rulesetWrapper;
            }
            rulesetWrapper.trace(trace);
            rulesetWrapper.zipMergeStrategyForImport(zipMergeStrategyForImport);
            rulesetWrapper.decisionId(!rulesetWrapper.getCompatibility().equals(Compatibility.RELEASE70.toString()));
            rulesetWrapper.setManagedXOMClassLoader(connection.getXURulesetArchiveInformation().getManagedXOMClassLoader());
            mgr = connection.getManagedConnection().getEngineManager(connection, false);
        }
        catch (XUException e) {
            throw new ResourceException((Throwable)e);
        }
        RulesetMetaData rmd = null;
        if (mgr instanceof DEManager) {
            XURulesetParameter[] xuParameters = mgr.getRulesetParameters();
            rmd = new RulesetMetaData(rulesetPath.getRulesetName(), (IlrDERulesetArchive)mgr.getRuleset().getArchive().getRESRulesetArchive(), xuParameters, (XmlBindingService)((DEManager)mgr).getEngine().getService(XmlBindingService.class));
            rulesetWrapper.setRulesetMetaData(rmd);
        } else {
            rmd = new RulesetMetaData(mgr.getRuleset().getCRERuleset().getName(), (IlrCRERulesetArchive)mgr.getRuleset().getArchive().getRESRulesetArchive(), mgr.getRulesetParameters(), mgr.getRuleset().getCRERuleset().getReflect());
            rulesetWrapper.setRulesetMetaData(rmd);
        }
        if (endPointList != null) {
            HashMap<String, URL> realEndPointList = new HashMap<String, URL>();
            for (Map.Entry entry : endPointList.entrySet()) {
                realEndPointList.put((String)entry.getKey(), XSDUtil.toEndpointURL((URL)entry.getValue(), null));
            }
            rulesetWrapper.setEndPoints(realEndPointList);
        } else if (!light) {
            throw WSDLGenerator.createResourceException(HTDSPluginLocalization.BAD_END_POINT, null, null);
        }
        rulesetWrapper.setLogger(logger);
        return rulesetWrapper;
    }

    public void getRulesetSignature(IlrXUConnection connection, Record input, Record output, DLGeneratorPlugin plugin) throws ResourceException {
        DLGeneratorLogger logger = new DLGeneratorLogger(plugin);
        RulesetWrapperImpl rulesetWrapper = this.getRulesetWrapper(connection, input, true, logger);
        HTDSSignature result = new HTDSSignature();
        result.setDecisionServiceNamespace(rulesetWrapper.TargetNamespaceQName().getNamespaceURI());
        result.setDecisionServiceExceptionQName(rulesetWrapper.getDecisionServiceFaultPartQName());
        result.setParamNamespace(rulesetWrapper.ParameterNamespaceQName().getNamespaceURI());
        result.setDecisionID(rulesetWrapper.getDecisionIdName());
        result.setOutputStringQName(rulesetWrapper.getOutputStringName());
        result.setFiredRulesCountQName(rulesetWrapper.getFiredRuleCountName());
        result.setDefaultNamespace(rulesetWrapper.DecisionServiceDefaultNamespaceQName().getNamespaceURI());
        if (rulesetWrapper.getRESTVersion() != null) {
            result.setDecisionServiceRequestQName(rulesetWrapper.getDecisionServiceRESTRequestQName());
            result.setDecisionServiceResponseQName(rulesetWrapper.getDecisionServiceRESTResponseQName());
            List<RulesetParameterWrapperImpl> params = null;
            try {
                params = rulesetWrapper.RulesetParameter();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (JAXBException e) {
                e.printStackTrace();
            }
            for (RulesetParameterWrapperImpl parameterWrapper : params) {
                String name = parameterWrapper.getRulesetParameter().getName();
                byte dir = parameterWrapper.getRulesetParameter().getDirection();
                char dirChar = '#';
                switch (dir) {
                    case 1: {
                        dirChar = '+';
                        break;
                    }
                    case 2: {
                        dirChar = '-';
                        break;
                    }
                }
                if (parameterWrapper.getParameterType() == 2) {
                    result.addParameter(name + "=" + dirChar + "{" + rulesetWrapper.ParameterNamespaceQName().getNamespaceURI() + "}" + name, parameterWrapper.getRulesetParameter().getType());
                    continue;
                }
                switch (parameterWrapper.getParameterType()) {
                    case 1: {
                        String namespace = parameterWrapper.getXMLReference().getNamespace();
                        result.addParameter(name + "=" + dirChar + "{" + namespace + "}" + parameterWrapper.getXMLReference().getName(), "XMLE");
                        break;
                    }
                    case 0: {
                        result.addParameter(name + "=" + dirChar + "{" + parameterWrapper.getXMLReference().getNamespace() + "}" + parameterWrapper.getXMLReference().getName(), "XML");
                        break;
                    }
                    case 3: {
                        result.addParameter(name + "=" + dirChar + "{" + rulesetWrapper.ParameterNamespaceQName().getNamespaceURI() + "}" + name, parameterWrapper.getRulesetParameter().getType());
                    }
                }
            }
        } else {
            result.setDecisionServiceRequestQName(rulesetWrapper.getDecisionServiceRequestPartQName());
            result.setDecisionServiceResponseQName(rulesetWrapper.getDecisionServiceResponsePartQName());
            try {
                XURulesetParameter[] params = connection.getManagedConnection().getRulesetParameters(connection);
                block20: for (int i = 0; i < params.length; ++i) {
                    switch (params[i].getKind()) {
                        case 1: {
                            result.addParameter(params[i].getName(), "XML");
                            continue block20;
                        }
                        case 0: {
                            result.addParameter(params[i].getName(), params[i].getType());
                            continue block20;
                        }
                        default: {
                            throw new RuntimeException();
                        }
                    }
                }
            }
            catch (XUException e) {
                throw new ResourceException((Throwable)e);
            }
        }
        ((IndexedRecord)output).add((Object)result.getInternalArrayForPluginCommunication());
    }
}

