/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.htds.plugin.cci.internal;

import java.io.Serializable;
import java.util.Iterator;
import java.util.TreeSet;

public class HTDSSignature
implements Serializable {
    private static final long serialVersionUID = 1L;
    private TreeSet<Parameter> parameters;
    private String decisionServiceNamespace;
    private String decisionServiceRequestQName;
    private String decisionServiceResponseQName;
    private String decisionID;
    private String outputStringQName;
    private String firedRulesCountQName;
    private String paramNamespace;
    private String defaultNamespace;
    private String decisionServiceExceptionQName;
    private String localisationString;

    public String getLocalisationString() {
        return this.localisationString;
    }

    public void setLocalisationString(String localisationString) {
        this.localisationString = localisationString;
    }

    public String getDecisionServiceNamespace() {
        return this.decisionServiceNamespace;
    }

    public void setDecisionServiceNamespace(String decisionServiceNamespace) {
        this.decisionServiceNamespace = decisionServiceNamespace;
    }

    public String getDecisionServiceExceptionQName() {
        return this.decisionServiceExceptionQName;
    }

    public void setDecisionServiceExceptionQName(String decisionServiceExceptionQName) {
        this.decisionServiceExceptionQName = decisionServiceExceptionQName;
    }

    public String getDecisionServiceRequestQName() {
        return this.decisionServiceRequestQName;
    }

    public void setDecisionServiceRequestQName(String decisionServiceRequestQName) {
        this.decisionServiceRequestQName = decisionServiceRequestQName;
    }

    public String getDecisionServiceResponseQName() {
        return this.decisionServiceResponseQName;
    }

    public void setDecisionServiceResponseQName(String decisionServiceResponseQName) {
        this.decisionServiceResponseQName = decisionServiceResponseQName;
    }

    public String getDecisionID() {
        return this.decisionID;
    }

    public void setDecisionID(String decisionID) {
        this.decisionID = decisionID;
    }

    public String getOutputStringQName() {
        return this.outputStringQName;
    }

    public void setOutputStringQName(String outputStringQName) {
        this.outputStringQName = outputStringQName;
    }

    public String getFiredRulesCountQName() {
        return this.firedRulesCountQName;
    }

    public void setFiredRulesCountQName(String firedRulesCountQName) {
        this.firedRulesCountQName = firedRulesCountQName;
    }

    public String getParamNamespace() {
        return this.paramNamespace;
    }

    public void setParamNamespace(String paramNamespace) {
        this.paramNamespace = paramNamespace;
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public void setDefaultNamespace(String defaultNamespace) {
        this.defaultNamespace = defaultNamespace;
    }

    public void setParameter(TreeSet<Parameter> parameter) {
        this.parameters = parameter;
    }

    public TreeSet<Parameter> getParameters() {
        return this.parameters;
    }

    public void addParameter(String name, String type) {
        int indexEqual;
        if (this.parameters == null) {
            this.parameters = new TreeSet();
        }
        if ((indexEqual = name.indexOf(61)) == -1) {
            this.parameters.add(new Parameter(name, type));
        } else {
            Parameter.Direction direction = null;
            switch (name.charAt(indexEqual + 1)) {
                case '-': {
                    direction = Parameter.Direction.IN;
                    break;
                }
                case '+': {
                    direction = Parameter.Direction.IN;
                    break;
                }
                default: {
                    direction = Parameter.Direction.INOUT;
                }
            }
            this.parameters.add(new Parameter(direction, name.substring(0, indexEqual), name.substring(indexEqual + 2), type));
        }
    }

    public String[] getInternalArrayForPluginCommunication() {
        String[] result = new String[9 + (this.parameters == null ? 0 : this.parameters.size() * 2)];
        result[0] = this.decisionID;
        result[1] = this.decisionServiceNamespace;
        result[2] = this.decisionServiceRequestQName;
        result[3] = this.decisionServiceResponseQName;
        result[4] = this.defaultNamespace;
        result[5] = this.firedRulesCountQName;
        result[6] = this.outputStringQName;
        result[7] = this.paramNamespace;
        result[8] = this.decisionServiceExceptionQName;
        if (this.parameters != null) {
            Iterator<Parameter> it = this.parameters.iterator();
            if (this.parameters != null) {
                int index = 9;
                while (it.hasNext()) {
                    Parameter parameter = it.next();
                    result[index++] = parameter.getNameForSerialization();
                    result[index++] = parameter.getTypeForSerialization();
                }
            }
        }
        return result;
    }

    public void setInternalArrayForPluginCommunication(String[] value) {
        this.decisionID = value[0];
        this.decisionServiceNamespace = value[1];
        this.decisionServiceRequestQName = value[2];
        this.decisionServiceResponseQName = value[3];
        this.defaultNamespace = value[4];
        this.firedRulesCountQName = value[5];
        this.outputStringQName = value[6];
        this.paramNamespace = value[7];
        this.decisionServiceExceptionQName = value[8];
        int paramCount = value.length - 9 >> 1;
        for (int i = 0; i < paramCount; ++i) {
            int ai = (i << 1) + 9;
            this.addParameter(value[ai], value[ai + 1]);
        }
    }

    public static class Parameter
    implements Comparable<Parameter>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final String name;
        private String qname;
        private Direction direction;
        private final boolean isXmlElement;
        private final String type;

        public Parameter(String name, String type) {
            this.name = name;
            if ("XMLE".equals(type)) {
                this.type = "XML";
                this.isXmlElement = true;
            } else {
                this.type = type;
                this.isXmlElement = false;
            }
        }

        public Parameter(Direction direction, String name, String qname, String type) {
            this.direction = direction;
            this.name = name;
            this.qname = qname;
            if ("XMLE".equals(type)) {
                this.type = "XML";
                this.isXmlElement = true;
            } else {
                this.type = type;
                this.isXmlElement = false;
            }
        }

        public String getName() {
            return this.name;
        }

        String getNameForSerialization() {
            if (this.qname == null) {
                return this.name;
            }
            return this.name + "=" + (this.direction == Direction.IN ? "+" : (this.direction == Direction.OUT ? "-" : "#")) + this.qname;
        }

        public String getType() {
            return this.type;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public boolean isXMLElement() {
            return this.isXmlElement;
        }

        String getTypeForSerialization() {
            if (!this.isXmlElement) {
                return this.type;
            }
            return "XMLE";
        }

        public String getQName() {
            return this.qname;
        }

        @Override
        public int compareTo(Parameter o) {
            return this.name.compareTo(o.name);
        }

        public static enum Direction {
            IN,
            OUT,
            INOUT;

        }
    }
}

