/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.htds.plugin.cci.internal;

import com.ibm.rules.htds.plugin.cci.internal.HTDSPluginLocalization;
import com.ibm.rules.htds.plugin.cci.internal.HTDSUtil;
import com.ibm.rules.htds.plugin.cci.internal.RulesetWrapperImpl;
import com.ibm.rules.htds.plugin.cci.internal.WSDLGenerator;
import com.ibm.rules.res.xml.internal.JAXBClassDesciption;
import com.ibm.rules.res.xml.internal.XSDUtil;
import com.ibm.rules.res.xu.client.internal.XURulesetParameter;
import ilog.rules.bom.IlrClass;
import ilog.rules.bom.IlrNamespace;
import ilog.rules.bom.IlrPackage;
import ilog.rules.bom.IlrType;
import ilog.rules.res.model.IlrRulesetParameter;
import ilog.rules.res.model.internal.IlrRulesetParameterImpl;
import ilog.rules.xml.model.IlrXmlClassInfo;
import ilog.rules.xml.model.IlrXmlPackageInfo;
import ilog.rules.xml.model.IlrXmlSimpleTypeInfo;
import ilog.rules.xml.model.IlrXmlXomFactory;
import ilog.rules.xml.util.IlrXmlReference;
import java.io.File;
import java.util.Map;
import javax.resource.ResourceException;

public class RulesetParameterWrapperImpl {
    public static final short XML_TYPE = 0;
    public static final short XML_ELEMENT = 1;
    public static final short SIMPLE_JAVA_TYPE = 2;
    public static final short JAVA_TYPE = 3;
    private short parameterType;
    private int depth = 0;
    private IlrXmlReference xmlReference;
    private String xsdType;
    private String xsdLocation;
    private final RulesetWrapperImpl rulesetWrapper;
    private final XURulesetParameter rulesetParameter;
    private final IlrType xmlType;
    private JAXBClassDesciption jaxbClassDescription;

    public RulesetParameterWrapperImpl(RulesetWrapperImpl rulesetWrapper, XURulesetParameter rulesetParameter, Map<String, String[]> nsURI2name, IlrType xmlType) throws ResourceException, ClassNotFoundException {
        this.rulesetParameter = rulesetParameter;
        this.rulesetWrapper = rulesetWrapper;
        this.xmlType = xmlType;
        this.determineParameterXMLInfos(nsURI2name);
    }

    public short getParameterType() {
        return this.parameterType;
    }

    public IlrRulesetParameter getRulesetParameter() {
        return this.rulesetParameter;
    }

    public String getXSDType() {
        return this.xsdType;
    }

    public int getDepth() {
        return this.depth;
    }

    public IlrXmlReference getXMLReference() {
        return this.xmlReference;
    }

    public String getXSDLocation() {
        return this.xsdLocation;
    }

    public JAXBClassDesciption getJAXBClassDescription() {
        if (this.jaxbClassDescription == null) {
            XSDUtil.ArrayType arrayType = XSDUtil.extractArrayType(this.rulesetParameter.getType());
            this.jaxbClassDescription = this.findJAXBDescription(this.rulesetWrapper.JavaFqn2QName(), arrayType.getJavaType());
        }
        return this.jaxbClassDescription;
    }

    private JAXBClassDesciption findJAXBDescription(Map<String, JAXBClassDesciption> javaFqn2QName, String javaType) {
        String tmpJavaType = javaType;
        JAXBClassDesciption result = null;
        while (result == null) {
            result = javaFqn2QName.get(tmpJavaType);
            if (result != null) continue;
            int indexSlash = tmpJavaType.lastIndexOf(46);
            if (indexSlash == -1) break;
            tmpJavaType = tmpJavaType.substring(0, indexSlash) + "$" + tmpJavaType.substring(indexSlash + 1);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void determineParameterXMLInfos(Map<String, String[]> nsURI2name) throws ResourceException, ClassNotFoundException {
        String[] nameAndlocation;
        String type;
        IlrXmlSimpleTypeInfo info;
        IlrXmlClassInfo classInfo;
        String realType = this.rulesetParameter.getXMLType();
        if (realType == null && ("ilog.rules.factory.IlrDynamicArray".equals(realType = this.rulesetParameter.getType()) || this.rulesetParameter.isArray() && this.rulesetParameter.getComponentKind() == 1)) {
            throw WSDLGenerator.createResourceException(HTDSPluginLocalization.PARAMETER_KIND_NOT_SUPPORTED, new String[]{this.rulesetParameter.getName(), this.rulesetParameter.getType()}, null);
        }
        XSDUtil.ArrayType arrayType = XSDUtil.extractArrayType(realType);
        if (HTDSUtil.isComplexJavaType(this.rulesetParameter, arrayType) && XSDUtil.getSimpleJavaType(arrayType.getJavaType()) == null) {
            this.parameterType = (short)3;
            this.depth = arrayType.getDepth();
            return;
        }
        IlrXmlReference rootElement = this.getParameterRootElement(this.rulesetParameter);
        if (rootElement == null) {
            if (this.xmlType == null) {
                String type2 = XSDUtil.getSimpleJavaType(arrayType.getJavaType());
                if (type2 == null) {
                    throw WSDLGenerator.createResourceException(HTDSPluginLocalization.SCHEMA_GEN_BAD_PARAM_TYPE, new String[]{this.rulesetParameter.getName()}, null);
                }
                this.parameterType = (short)2;
                this.xsdType = type2;
                this.depth = arrayType.getDepth();
            } else {
                XSDUtil.TypeArrayType typeArray = XSDUtil.extractTypeArrayType(this.xmlType);
                if (!(typeArray.getType() instanceof IlrClass)) throw WSDLGenerator.createResourceException(HTDSPluginLocalization.SCHEMA_GEN_BAD_PARAM_TYPE, new String[]{this.rulesetParameter.getName()}, null);
                classInfo = IlrXmlXomFactory.getClassInfo((IlrClass)((IlrClass)typeArray.getType()));
                if (classInfo == null) {
                    info = IlrXmlXomFactory.getSimpleTypeInfo((IlrClass)((IlrClass)typeArray.getType()));
                    if (info != null) {
                        if (typeArray.getDepth() > 0) {
                            throw WSDLGenerator.createResourceException(HTDSPluginLocalization.PARAMETER_KIND_NOT_SUPPORTED, new String[]{this.rulesetParameter.getName(), this.rulesetParameter.getType()}, null);
                        }
                        this.parameterType = 0;
                        this.xmlReference = info.xmlType;
                        this.depth = typeArray.getDepth();
                        this.xsdLocation = this.getXSDLocationFromParameter(this.rulesetParameter);
                    } else {
                        type = XSDUtil.getSimpleJavaType(typeArray.getType().getFullyQualifiedName());
                        if (type == null) {
                            throw WSDLGenerator.createResourceException(HTDSPluginLocalization.SCHEMA_GEN_BAD_PARAM_TYPE, new String[]{this.rulesetParameter.getName()}, null);
                        }
                        this.parameterType = (short)2;
                        this.xsdType = type;
                        this.depth = typeArray.getDepth();
                    }
                } else {
                    if (typeArray.getDepth() > 0) {
                        throw WSDLGenerator.createResourceException(HTDSPluginLocalization.PARAMETER_KIND_NOT_SUPPORTED, new String[]{this.rulesetParameter.getName(), this.rulesetParameter.getType()}, null);
                    }
                    this.parameterType = 0;
                    this.xmlReference = classInfo.xmlType;
                    this.depth = typeArray.getDepth();
                    this.xsdLocation = this.getXSDLocationFromParameter(this.rulesetParameter);
                }
            }
        } else {
            String tmpXSDLocation = this.getXSDLocationFromParameter(this.rulesetParameter);
            if (tmpXSDLocation == null) {
                throw new ResourceException("XSD for element \"" + this.rulesetParameter.getType() + "\" is missing in the ruleset archive.");
            }
            if (!this.isNamespaceAvailable(rootElement, tmpXSDLocation)) {
                this.parameterType = 1;
                this.xmlReference = rootElement;
                this.xsdLocation = tmpXSDLocation;
            } else if (this.xmlType instanceof IlrClass) {
                classInfo = IlrXmlXomFactory.getClassInfo((IlrClass)((IlrClass)this.xmlType));
                if (classInfo == null) {
                    info = IlrXmlXomFactory.getSimpleTypeInfo((IlrClass)((IlrClass)this.xmlType));
                    if (info != null) {
                        this.parameterType = 0;
                        this.xmlReference = info.xmlType;
                        this.xsdLocation = tmpXSDLocation;
                    } else {
                        arrayType = XSDUtil.extractArrayType(this.xmlType.getDisplayName());
                        type = XSDUtil.getSimpleJavaType(arrayType.getJavaType());
                        if (type == null) {
                            this.parameterType = 1;
                            this.xmlReference = rootElement;
                            this.xsdLocation = this.getXSDLocationFromParameter(this.rulesetParameter);
                            this.depth = arrayType.getDepth();
                        } else {
                            this.parameterType = (short)2;
                            this.xsdType = type;
                            this.depth = arrayType.getDepth();
                        }
                    }
                } else if (classInfo.xmlLocalScope) {
                    this.parameterType = 1;
                    this.xmlReference = rootElement;
                    this.xsdLocation = tmpXSDLocation;
                } else {
                    this.parameterType = 0;
                    this.xmlReference = classInfo.xmlType;
                    this.xsdLocation = tmpXSDLocation;
                }
            } else {
                this.parameterType = 1;
                this.xmlReference = rootElement;
                this.xsdLocation = tmpXSDLocation;
            }
        }
        if (this.parameterType == 2) return;
        String namespace = this.xmlReference.getNamespace();
        if (namespace.length() == 0) {
            namespace = this.rulesetWrapper.DecisionServiceDefaultNamespaceQName().getNamespaceURI();
        }
        if ((nameAndlocation = nsURI2name.get(namespace)) == null) {
            nameAndlocation = new String[]{this.rulesetWrapper.getDecisionServiceDefaultNamespace() + nsURI2name.size(), this.xsdLocation};
            nsURI2name.put(namespace, nameAndlocation);
            return;
        } else {
            boolean alreadyDefined = false;
            String[] tmp = new String[nameAndlocation.length + 2];
            tmp[nameAndlocation.length] = this.rulesetWrapper.getDecisionServiceDefaultNamespace() + nsURI2name.size();
            tmp[nameAndlocation.length + 1] = this.xsdLocation;
            for (int i = 0; i < nameAndlocation.length; ++i) {
                tmp[i] = nameAndlocation[i];
                if (i % 2 != 1) continue;
                if (nameAndlocation[i].equals(this.xsdLocation)) {
                    alreadyDefined = true;
                    continue;
                }
                tmp[nameAndlocation.length] = nameAndlocation[i - 1];
            }
            if (alreadyDefined) return;
            nsURI2name.put(namespace, tmp);
        }
    }

    private IlrXmlReference getParameterRootElement(XURulesetParameter parameter) {
        if (this.xmlType == null) {
            return null;
        }
        String xomTypeName = this.xmlType.getFullyQualifiedName();
        IlrNamespace nm = this.xmlType.getEnclosingNamespace();
        if (nm != null) {
            while (!(nm instanceof IlrPackage)) {
                nm = nm.getEnclosingNamespace();
            }
            IlrXmlPackageInfo pckInfo = IlrXmlXomFactory.getPackageInfo((IlrPackage)((IlrPackage)nm));
            if (pckInfo != null) {
                IlrXmlPackageInfo.RootElement[] rootElements = pckInfo.getRootElements();
                for (int i = 0; i < rootElements.length; ++i) {
                    IlrXmlPackageInfo.RootElement re = rootElements[i];
                    if (!xomTypeName.equals(re.xomType)) continue;
                    return re.xmlName;
                }
            }
        }
        return null;
    }

    private String getXSDLocationFromParameter(IlrRulesetParameterImpl parameter) {
        if (this.xmlType instanceof IlrClass) {
            IlrXmlSimpleTypeInfo simpleinfo;
            IlrXmlClassInfo classInfo = IlrXmlXomFactory.getClassInfo((IlrClass)((IlrClass)this.xmlType));
            if (classInfo != null && classInfo.xsdLocation != null) {
                return new File(classInfo.xsdLocation).getName();
            }
            if (classInfo == null && (simpleinfo = IlrXmlXomFactory.getSimpleTypeInfo((IlrClass)((IlrClass)this.xmlType))) != null && simpleinfo.xsdLocation != null) {
                return new File(simpleinfo.xsdLocation).getName();
            }
        }
        return null;
    }

    private boolean isNamespaceAvailable(IlrXmlReference xmlReference, String xsdLocation) {
        String namespace = xmlReference.getNamespace();
        try {
            this.rulesetWrapper.getRulesetMetaData().getSchema(namespace, xsdLocation);
        }
        catch (Throwable t) {
            return true;
        }
        return false;
    }
}

