/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.htds.plugin.cci.internal;

import com.ibm.rules.htds.plugin.cci.internal.Compatibility;
import com.ibm.rules.htds.plugin.cci.internal.DLCommonXMLUtil;
import com.ibm.rules.htds.plugin.cci.internal.HTDSPluginLocalization;
import com.ibm.rules.htds.plugin.cci.internal.HTDSUtil;
import com.ibm.rules.htds.plugin.cci.internal.RulesetParameterWrapperImpl;
import com.ibm.rules.htds.plugin.cci.internal.RulesetWrapper;
import com.ibm.rules.htds.plugin.cci.internal.RulesetWrapperImpl;
import com.ibm.rules.res.message.internal.LocalizedMessageHelper;
import com.ibm.rules.res.xml.internal.JAXBClassDesciption;
import com.ibm.rules.res.xml.internal.XSD;
import com.ibm.rules.res.xml.internal.XSDUtil;
import com.ibm.rules.res.xml.internal.XSDWrapper;
import com.ibm.rules.res.xu.client.internal.XURulesetParameter;
import com.ibm.wsdl.extensions.schema.SchemaConstants;
import com.ibm.wsdl.extensions.schema.SchemaDeserializer;
import com.ibm.wsdl.extensions.schema.SchemaImpl;
import com.ibm.wsdl.extensions.schema.SchemaSerializer;
import ilog.rules.res.model.IlrRulesetParameter;
import ilog.rules.res.util.io.IlrFileUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.resource.ResourceException;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSDLGenerator {
    private static final String ROOT_IMPORT = "__root__";
    private transient ExtensionRegistry extensionRegistry;
    private transient WSDLFactory factory;
    private transient TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private transient DocumentBuilderFactory xmlfactory;
    private transient DocumentBuilder builder;

    public WSDLGenerator() {
        try {
            this.transformerFactory.setAttribute("indent-number", 2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected WSDLFactory getFactory() throws WSDLException {
        if (this.factory == null) {
            this.factory = WSDLFactory.newInstance();
        }
        return this.factory;
    }

    protected DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        if (this.builder == null) {
            this.builder = this.getDocumentBuilderFactory().newDocumentBuilder();
        }
        return this.builder;
    }

    protected DocumentBuilderFactory getDocumentBuilderFactory() {
        if (this.xmlfactory == null) {
            this.xmlfactory = DocumentBuilderFactory.newInstance();
            this.xmlfactory.setNamespaceAware(true);
            this.xmlfactory.setValidating(true);
        }
        return this.xmlfactory;
    }

    protected ExtensionRegistry getExtensionRegistry() throws WSDLException {
        if (this.extensionRegistry == null) {
            this.extensionRegistry = this.getFactory().newPopulatedExtensionRegistry();
            this.registerSchemaParser(this.extensionRegistry);
        }
        return this.extensionRegistry;
    }

    protected Definition getDefinition(RulesetWrapperImpl ruleset) throws WSDLException {
        Definition definition = this.getFactory().newDefinition();
        definition.setTargetNamespace(ruleset.TargetNamespaceQName().getNamespaceURI());
        definition.addNamespace(ruleset.TargetNamespaceQName().getLocalPart(), ruleset.TargetNamespaceQName().getNamespaceURI());
        definition.addNamespace(ruleset.WSDLQName().getLocalPart(), ruleset.WSDLQName().getNamespaceURI());
        definition.addNamespace(ruleset.SOAPQName().getLocalPart(), ruleset.SOAPQName().getNamespaceURI());
        definition.addNamespace(ruleset.XSDQName().getLocalPart(), ruleset.XSDQName().getNamespaceURI());
        if (!ruleset.definitionNoName()) {
            definition.setQName(new QName(ruleset.DecisionServiceName()));
        }
        return definition;
    }

    private Map<String, XSDWrapper> declareParametersImports(RulesetWrapperImpl ruleset, Element root, boolean zipMergeStrategyForImport) throws ParserConfigurationException {
        LinkedHashMap<String, XSDWrapper> ns2wrapper = new LinkedHashMap<String, XSDWrapper>();
        for (Map.Entry<String, String[]> entry : ruleset.NamespaceURI2NameAndLocation().entrySet()) {
            String uri = entry.getKey();
            String[] values = entry.getValue();
            int loopCount = values.length / 2;
            if (ruleset.inlineWSDL()) {
                loopCount = 1;
            }
            for (int i = 0; i < loopCount; ++i) {
                String location = values[i * 2 + 1];
                if (ruleset.XSDQName().getNamespaceURI().equals(uri) || ruleset.ParameterNamespaceQName().getNamespaceURI().equals(uri)) continue;
                XSDWrapper xsdWrapper = (XSDWrapper)ns2wrapper.get(uri);
                if (xsdWrapper == null) {
                    xsdWrapper = new XSDWrapper();
                    xsdWrapper.setNamespaceUri(uri);
                    ns2wrapper.put(uri, xsdWrapper);
                }
                xsdWrapper.getSchemaLocationList().add(location);
            }
        }
        for (Map.Entry<String, Object> entry : ns2wrapper.entrySet()) {
            Element importElmt = DLCommonXMLUtil.createXSDElement(root.getOwnerDocument(), ruleset.XSDQName(), "import", false);
            importElmt.setAttribute("namespace", entry.getKey());
            if (ruleset.zipFile) {
                if (zipMergeStrategyForImport) {
                    importElmt.setAttribute("schemaLocation", ((XSDWrapper)entry.getValue()).getFirstName());
                } else {
                    importElmt.setAttribute("schemaLocation", ((XSDWrapper)entry.getValue()).getComputedName());
                }
            }
            root.appendChild(importElmt);
        }
        return ns2wrapper;
    }

    private void declareParametersNamespaceAttributes(RulesetWrapperImpl ruleset, Element root) {
        for (Map.Entry<String, String[]> entry : ruleset.NamespaceURI2NameAndLocation().entrySet()) {
            String uri = entry.getKey();
            String name = entry.getValue()[0];
            if (uri.equals(ruleset.XSDQName().getNamespaceURI())) continue;
            if (uri.equals("")) {
                uri = ruleset.DecisionServiceDefaultNamespaceQName().getNamespaceURI();
            }
            root.setAttribute("xmlns:" + name, uri);
        }
    }

    private RulesetParameterWrapperImpl getRulesetParameterWrapper(RulesetWrapperImpl ruleset, IlrRulesetParameter parameter) throws ResourceException, ClassNotFoundException, IOException, JAXBException {
        for (RulesetParameterWrapperImpl tmp : ruleset.RulesetParameter()) {
            if (!tmp.getRulesetParameter().getName().equals(parameter.getName())) continue;
            return tmp;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void appendParameter(Element root, RulesetWrapperImpl ruleset, RulesetParameterWrapperImpl parameter, QName qnameType, String ref, boolean simpleJavaType, Map<QName, Integer> arrayType2depth, boolean forceQualified) throws ParserConfigurationException, ResourceException {
        String name = parameter.getRulesetParameter().getName();
        int depth = parameter.getDepth();
        QName xsdQName = ruleset.XSDQName();
        Element elt = DLCommonXMLUtil.createXSDElement(root.getOwnerDocument(), xsdQName, "element", false);
        if (depth == 0) {
            if (qnameType != null) {
                elt.setAttribute("name", name);
                if (forceQualified) {
                    elt.setAttribute("form", "qualified");
                }
                elt.setAttribute("type", qnameType.getPrefix() + ':' + qnameType.getLocalPart());
            } else if (ref != null) {
                elt.setAttribute("ref", ref);
            }
        } else if (simpleJavaType) {
            if (depth != 1) throw WSDLGenerator.createResourceException(HTDSPluginLocalization.MULTI_DIMENTIONAL_ARRAY_NOT_SUPPORTED, null, null);
            elt.setAttribute("name", name);
            elt.setAttribute("form", "qualified");
            elt.setAttribute("maxOccurs", "unbounded");
            elt.setAttribute("minOccurs", "0");
            elt.setAttribute("nillable", "true");
            elt.setAttribute("type", xsdQName.getLocalPart() + ':' + parameter.getXSDType());
        } else if (qnameType != null) {
            elt.setAttribute("name", name);
            if (forceQualified) {
                elt.setAttribute("form", "qualified");
            }
            elt.setAttribute("type", qnameType.getPrefix() + ':' + qnameType.getLocalPart());
        } else if (ref != null) {
            elt.setAttribute("ref", ref);
        }
        root.appendChild(elt);
    }

    private void declareParametersContent(RulesetWrapperImpl ruleset, Element root, String forceXSDNamespace, Map<QName, Integer> arrayType2depth) throws DOMException, ResourceException, ParserConfigurationException, ClassNotFoundException, IOException, JAXBException {
        boolean forceQualified = false;
        for (RulesetParameterWrapperImpl parameter : ruleset.RulesetParameter()) {
            if (parameter.getParameterType() == 2) continue;
            Element rootElem = DLCommonXMLUtil.createXSDElement(root.getOwnerDocument(), ruleset.XSDQName(), "element", false);
            root.appendChild(rootElem);
            rootElem.setAttribute("name", parameter.getRulesetParameter().getName());
            Element cTypeElem = DLCommonXMLUtil.createXSDElement(root.getOwnerDocument(), ruleset.XSDQName(), "complexType", false);
            rootElem.appendChild(cTypeElem);
            Element sequenceElem = DLCommonXMLUtil.createXSDElement(root.getOwnerDocument(), ruleset.XSDQName(), "sequence", false);
            cTypeElem.appendChild(sequenceElem);
            switch (parameter.getParameterType()) {
                case 1: {
                    String namespace = parameter.getXMLReference().getNamespace();
                    if (namespace.length() == 0) {
                        namespace = ruleset.DecisionServiceDefaultNamespaceQName().getNamespaceURI();
                    }
                    this.appendParameter(sequenceElem, ruleset, parameter, null, ruleset.NamespaceURI2NameAndLocation().get(namespace)[0] + ':' + parameter.getXMLReference().getName(), false, arrayType2depth, forceQualified);
                    break;
                }
                case 0: {
                    String namespace = parameter.getXMLReference().getNamespace();
                    if (namespace.length() == 0) {
                        namespace = ruleset.DecisionServiceDefaultNamespaceQName().getNamespaceURI();
                    }
                    QName qnameType = new QName(parameter.getXMLReference().getNamespace(), parameter.getXMLReference().getName(), ruleset.NamespaceURI2NameAndLocation().get(namespace)[0]);
                    this.appendParameter(sequenceElem, ruleset, parameter, qnameType, null, false, arrayType2depth, forceQualified);
                    break;
                }
                case 3: {
                    JAXBClassDesciption jaxbClassDesc = parameter.getJAXBClassDescription();
                    if (jaxbClassDesc.getElementLocalName() != null) {
                        this.appendParameter(sequenceElem, ruleset, parameter, null, ruleset.NameAndLocationWithCreation(jaxbClassDesc.getElementNamespaceURI(), null)[0] + ':' + jaxbClassDesc.getElementLocalName(), false, arrayType2depth, forceQualified);
                        break;
                    }
                    QName qnameType = new QName(jaxbClassDesc.getTypeName().getNamespaceURI(), jaxbClassDesc.getTypeName().getLocalPart(), ruleset.NamespaceURI2NameAndLocation().get(jaxbClassDesc.getTypeName().getNamespaceURI())[0]);
                    this.appendParameter(sequenceElem, ruleset, parameter, qnameType, null, false, arrayType2depth, forceQualified);
                }
            }
        }
    }

    private void addParameter(Element root, RulesetWrapperImpl ruleset, IlrRulesetParameter param, Map<QName, Integer> arrayType2depth, boolean forceQualified) throws ParserConfigurationException, ResourceException, ClassNotFoundException, IOException, JAXBException {
        RulesetParameterWrapperImpl rulesetParameterWrapper = this.getRulesetParameterWrapper(ruleset, param);
        if (rulesetParameterWrapper.getParameterType() == 2) {
            QName qnameType = new QName(ruleset.XSDQName().getNamespaceURI(), rulesetParameterWrapper.getXSDType(), ruleset.XSDQName().getLocalPart());
            this.appendParameter(root, ruleset, rulesetParameterWrapper, qnameType, null, true, arrayType2depth, forceQualified);
        } else {
            Element elt = DLCommonXMLUtil.createXSDElement(root.getOwnerDocument(), ruleset.XSDQName(), "element", false);
            if (rulesetParameterWrapper.getDepth() == 0) {
                elt.setAttribute("ref", ruleset.ParameterNamespaceQName().getLocalPart() + ':' + param.getName());
            } else if (rulesetParameterWrapper.getDepth() == 1) {
                elt.setAttribute("maxOccurs", "unbounded");
                elt.setAttribute("minOccurs", "0");
                elt.setAttribute("ref", ruleset.ParameterNamespaceQName().getLocalPart() + ':' + param.getName());
            } else {
                throw WSDLGenerator.createResourceException(HTDSPluginLocalization.MULTI_DIMENTIONAL_ARRAY_NOT_SUPPORTED, null, null);
            }
            root.appendChild(elt);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, XSD> getSchemas(Definition definition, RulesetWrapperImpl ruleset) throws DOMException, ResourceException, ClassNotFoundException, IOException, JAXBException, ParserConfigurationException {
        boolean elementFormDefaultQualified;
        boolean zipMergeStrategyForImport = ruleset.zipMergeStrategyForImport();
        Map<String, XSD> result = new LinkedHashMap<String, XSD>();
        DocumentBuilder builder = this.getDocumentBuilder();
        Document doc = builder.newDocument();
        if (ruleset.zipFile) {
            Element importDecisionServiceSchemaElement = doc.createElement(ruleset.XSDQName().getLocalPart() + ':' + SchemaConstants.Q_ELEM_XSD_2001.getLocalPart());
            importDecisionServiceSchemaElement.setAttribute("xmlns:" + ruleset.XSDQName().getLocalPart(), ruleset.XSDQName().getNamespaceURI());
            Element importElement = DLCommonXMLUtil.createXSDElement(doc, ruleset.XSDQName(), "import", false);
            importElement.setAttribute("namespace", ruleset.TargetNamespaceQName().getNamespaceURI());
            importElement.setAttribute("schemaLocation", ruleset.DecisionServiceSchemaName());
            importDecisionServiceSchemaElement.appendChild(importElement);
            result.put(ROOT_IMPORT, new XSD(importDecisionServiceSchemaElement));
        }
        if (ruleset.trace()) {
            InputStream inputStream = this.getClass().getResourceAsStream("decisionTraceFilter.xsd");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IlrFileUtil.copy(inputStream, baos);
            XSD xsd = new XSD(baos.toByteArray());
            xsd.setTargetNamespace("http://www.ibm.com/rules/decisionservice/trace");
            result.put("decisionTraceFilter.xsd", xsd);
            inputStream = this.getClass().getResourceAsStream("decisionTrace.xsd");
            baos = new ByteArrayOutputStream();
            IlrFileUtil.copy(inputStream, baos);
            xsd = new XSD(baos.toByteArray());
            xsd.setTargetNamespace("http://www.ibm.com/rules/decisionservice/tracefilter");
            result.put("decisionTrace.xsd", xsd);
        }
        XSDUtil xsdUtil = new XSDUtil(ruleset.getLogger());
        Map<String, XSD> results = HTDSUtil.createXSDMap(ruleset, ruleset.getLogger());
        result.putAll(results);
        HashMap<QName, Integer> arrayType2depth = new HashMap<QName, Integer>();
        Element schemaParameterElement = doc.createElement(ruleset.XSDQName().getLocalPart() + ':' + SchemaConstants.Q_ELEM_XSD_2001.getLocalPart());
        ruleset.RulesetParameter();
        schemaParameterElement.setAttribute("targetNamespace", ruleset.ParameterNamespaceQName().getNamespaceURI());
        schemaParameterElement.setAttribute("xmlns:" + ruleset.XSDQName().getLocalPart(), ruleset.XSDQName().getNamespaceURI());
        this.declareParametersNamespaceAttributes(ruleset, schemaParameterElement);
        Map<String, XSDWrapper> ns2wrapper = this.declareParametersImports(ruleset, schemaParameterElement, zipMergeStrategyForImport);
        this.declareParametersContent(ruleset, schemaParameterElement, null, arrayType2depth);
        XSD tmp = new XSD(schemaParameterElement);
        tmp.setTargetNamespace(ruleset.ParameterNamespaceQName().getNamespaceURI());
        result.put(ruleset.ParametersSchemaName(), tmp);
        if (!ruleset.inlineWSDL() && !zipMergeStrategyForImport) {
            for (Map.Entry<String, XSDWrapper> entry : ns2wrapper.entrySet()) {
                if (entry.getValue().getSchemaLocationList().size() <= 1) continue;
                Element tmpWrapperElement = doc.createElement(ruleset.XSDQName().getLocalPart() + ':' + SchemaConstants.Q_ELEM_XSD_2001.getLocalPart());
                tmpWrapperElement.setAttribute("targetNamespace", entry.getKey());
                tmpWrapperElement.setAttribute("xmlns:" + ruleset.XSDQName().getLocalPart(), ruleset.XSDQName().getNamespaceURI());
                for (String schemaLocation : entry.getValue().getSchemaLocationList()) {
                    Element includeElmt = DLCommonXMLUtil.createXSDElement(tmpWrapperElement.getOwnerDocument(), ruleset.XSDQName(), "include", false);
                    includeElmt.setAttribute("schemaLocation", schemaLocation);
                    tmpWrapperElement.appendChild(includeElmt);
                }
                result.put(entry.getValue().getComputedName(), new XSD(tmpWrapperElement));
            }
        }
        XURulesetParameter[] params = ruleset.getRulesetMetaData().getRulesetParameters();
        TreeSet<XURulesetParameter> treeParameters = new TreeSet<XURulesetParameter>(new Comparator<XURulesetParameter>(){

            @Override
            public int compare(XURulesetParameter o1, XURulesetParameter o2) {
                int nameCompare = o1.getName().compareTo(o2.getName());
                if (nameCompare != 0) {
                    return nameCompare;
                }
                return o1.getKind() - o2.getKind();
            }
        });
        boolean importJaxbArrayNS = false;
        for (XURulesetParameter parameter : params) {
            RulesetParameterWrapperImpl rulesetParameterWrapper;
            treeParameters.add(parameter);
            if (importJaxbArrayNS || (rulesetParameterWrapper = this.getRulesetParameterWrapper(ruleset, parameter)).getDepth() <= 1 || rulesetParameterWrapper.getParameterType() != 2) continue;
            importJaxbArrayNS = true;
        }
        Element schemaDecisionServiceElement = doc.createElement(ruleset.XSDQName().getLocalPart() + ':' + SchemaConstants.Q_ELEM_XSD_2001.getLocalPart());
        boolean bl = elementFormDefaultQualified = !Compatibility.LATEST.toString().equals(ruleset.getCompatibility());
        if (elementFormDefaultQualified) {
            schemaDecisionServiceElement.setAttribute("attributeFormDefault", "unqualified");
            schemaDecisionServiceElement.setAttribute("elementFormDefault", "qualified");
        }
        schemaDecisionServiceElement.setAttribute("targetNamespace", ruleset.TargetNamespaceQName().getNamespaceURI());
        schemaDecisionServiceElement.setAttribute("xmlns:" + ruleset.ParameterNamespaceQName().getLocalPart(), ruleset.ParameterNamespaceQName().getNamespaceURI());
        schemaDecisionServiceElement.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        schemaDecisionServiceElement.setAttribute("xmlns:" + ruleset.XSDQName().getLocalPart(), ruleset.XSDQName().getNamespaceURI());
        if (importJaxbArrayNS) {
            schemaDecisionServiceElement.setAttribute("xmlns:ajaxb", "http://jaxb.dev.java.net/array");
            Element importElement = DLCommonXMLUtil.createXSDElement(doc, ruleset.XSDQName(), "import", false);
            importElement.setAttribute("namespace", "http://jaxb.dev.java.net/array");
            if (ruleset.zipFile) {
                importElement.setAttribute("schemaLocation", "jaxb.array.xsd");
            }
            schemaDecisionServiceElement.appendChild(importElement);
        }
        if (ruleset.trace()) {
            schemaDecisionServiceElement.setAttribute("xmlns:trace", "http://www.ibm.com/rules/decisionservice/trace");
            schemaDecisionServiceElement.setAttribute("xmlns:filter", "http://www.ibm.com/rules/decisionservice/tracefilter");
        }
        Element importElement = DLCommonXMLUtil.createXSDElement(doc, ruleset.XSDQName(), "import", false);
        importElement.setAttribute("namespace", ruleset.ParameterNamespaceQName().getNamespaceURI());
        if (ruleset.zipFile) {
            importElement.setAttribute("schemaLocation", ruleset.ParametersSchemaName());
        }
        schemaDecisionServiceElement.appendChild(importElement);
        if (ruleset.trace()) {
            Element importTraceFilterElement = DLCommonXMLUtil.createXSDElement(doc, ruleset.XSDQName(), "import", false);
            importTraceFilterElement.setAttribute("namespace", "http://www.ibm.com/rules/decisionservice/tracefilter");
            Element importTraceElement = DLCommonXMLUtil.createXSDElement(doc, ruleset.XSDQName(), "import", false);
            importTraceElement.setAttribute("namespace", "http://www.ibm.com/rules/decisionservice/trace");
            if (ruleset.zipFile) {
                importTraceFilterElement.setAttribute("schemaLocation", "decisionTraceFilter.xsd");
                importTraceElement.setAttribute("schemaLocation", "decisionTrace.xsd");
            }
            schemaDecisionServiceElement.appendChild(importTraceFilterElement);
            schemaDecisionServiceElement.appendChild(importTraceElement);
        }
        Element requestElement = DLCommonXMLUtil.createXSDElement(doc, ruleset.XSDQName(), "element", false);
        requestElement.setAttribute("name", ruleset.getDecisionServiceRequestPartQName());
        schemaDecisionServiceElement.appendChild(requestElement);
        Element requestElementComplexType = DLCommonXMLUtil.createXSDElement(doc, ruleset.XSDQName(), "complexType", false);
        requestElement.appendChild(requestElementComplexType);
        Element requestElementComplexTypeSeq = DLCommonXMLUtil.createXSDElement(doc, ruleset.XSDQName(), "sequence", false);
        requestElementComplexType.appendChild(requestElementComplexTypeSeq);
        if (ruleset.decisionId()) {
            requestElementComplexTypeSeq.appendChild(DLCommonXMLUtil.createElement("string", ruleset.getDecisionIdName(), true, !elementFormDefaultQualified, doc, ruleset));
        }
        if (ruleset.trace()) {
            Element decisionTraceFilterElement = DLCommonXMLUtil.createXSDElement(doc, ruleset.XSDQName(), "element", false);
            decisionTraceFilterElement.setAttribute("ref", "filter:decisionTraceFilter");
            requestElementComplexTypeSeq.appendChild(decisionTraceFilterElement);
        }
        Element responseElement = DLCommonXMLUtil.createXSDElement(doc, ruleset.XSDQName(), "element", false);
        responseElement.setAttribute("name", ruleset.getDecisionServiceResponsePartQName());
        schemaDecisionServiceElement.appendChild(responseElement);
        Element responseElementComplexTypeSeq = DLCommonXMLUtil.appendComplexTypeSequenceElements(responseElement, doc, ruleset);
        if (ruleset.simpleTraceElements()) {
            responseElementComplexTypeSeq.appendChild(DLCommonXMLUtil.createElement("string", ruleset.getOutputStringName(), false, false, doc, ruleset));
            responseElementComplexTypeSeq.appendChild(DLCommonXMLUtil.createElement("int", ruleset.getFiredRuleCountName(), false, false, doc, ruleset));
        }
        if (ruleset.decisionId()) {
            responseElementComplexTypeSeq.appendChild(DLCommonXMLUtil.createElement("string", ruleset.getDecisionIdName(), false, !elementFormDefaultQualified, doc, ruleset));
        }
        if (ruleset.trace()) {
            Element executionTraceElement = DLCommonXMLUtil.createXSDElement(doc, ruleset.XSDQName(), "element", false);
            executionTraceElement.setAttribute("ref", "trace:decisionTrace");
            responseElementComplexTypeSeq.appendChild(executionTraceElement);
        }
        Element exceptionElement = DLCommonXMLUtil.createXSDElement(doc, ruleset.XSDQName(), "element", false);
        exceptionElement.setAttribute("name", ruleset.getDecisionServiceFaultPartQName());
        schemaDecisionServiceElement.appendChild(exceptionElement);
        Element exceptionElementComplexType = DLCommonXMLUtil.createXSDElement(doc, ruleset.XSDQName(), "complexType", false);
        exceptionElement.appendChild(exceptionElementComplexType);
        Element exceptionElementComplexTypeSeq = DLCommonXMLUtil.createXSDElement(doc, ruleset.XSDQName(), "sequence", false);
        exceptionElementComplexType.appendChild(exceptionElementComplexTypeSeq);
        Element exceptionElementComplexTypeSeqElt = DLCommonXMLUtil.createXSDElement(doc, ruleset.XSDQName(), "element", false);
        exceptionElementComplexTypeSeqElt.setAttribute("maxOccurs", "1");
        exceptionElementComplexTypeSeqElt.setAttribute("minOccurs", "1");
        exceptionElementComplexTypeSeqElt.setAttribute("name", "exception");
        exceptionElementComplexTypeSeqElt.setAttribute("nillable", "false");
        exceptionElementComplexTypeSeqElt.setAttribute("type", ruleset.XSDQName().getLocalPart() + ':' + "string");
        exceptionElementComplexTypeSeq.appendChild(exceptionElementComplexTypeSeqElt);
        XSD decisionServiceXsd = new XSD(schemaDecisionServiceElement);
        decisionServiceXsd.setTargetNamespace(ruleset.TargetNamespaceQName().getNamespaceURI());
        result.put(ruleset.DecisionServiceSchemaName(), decisionServiceXsd);
        for (XURulesetParameter xURulesetParameter : treeParameters) {
            byte direction = xURulesetParameter.getDirection();
            if (direction == 1 || direction == 4) {
                this.addParameter(requestElementComplexTypeSeq, ruleset, xURulesetParameter, arrayType2depth, !elementFormDefaultQualified);
            }
            if (direction != 2 && direction != 4) continue;
            this.addParameter(responseElementComplexTypeSeq, ruleset, xURulesetParameter, arrayType2depth, !elementFormDefaultQualified);
        }
        if (arrayType2depth.size() != 0) {
            void var30_37;
            XSD jaxbxsd = null;
            Object var30_36 = null;
            for (Map.Entry entry : result.entrySet()) {
                XSD xsd = (XSD)entry.getValue();
                if (xsd.getTargetNamespace() == null) continue;
                if (xsd.getTargetNamespace().equals("http://jaxb.dev.java.net/array")) {
                    jaxbxsd = xsd;
                    continue;
                }
                if (!xsd.getTargetNamespace().equals(ruleset.ParameterNamespaceQName().getNamespaceURI())) continue;
                XSD xSD = xsd;
            }
            if (jaxbxsd == null) {
                Element schemaJaxbArrayElement = doc.createElement(ruleset.XSDQName().getLocalPart() + ':' + SchemaConstants.Q_ELEM_XSD_2001.getLocalPart());
                schemaJaxbArrayElement.setAttribute("targetNamespace", "http://jaxb.dev.java.net/array");
                schemaJaxbArrayElement.setAttribute("xmlns:tns", "http://jaxb.dev.java.net/array");
                schemaJaxbArrayElement.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
                schemaJaxbArrayElement.setAttribute("xmlns:" + ruleset.XSDQName().getLocalPart(), ruleset.XSDQName().getNamespaceURI());
                for (Map.Entry entry : arrayType2depth.entrySet()) {
                    QName qname = (QName)entry.getKey();
                    if (!qname.getNamespaceURI().equals(ruleset.XSDQName().getNamespaceURI())) continue;
                    int depth = (Integer)entry.getValue();
                    String currentType = qname.getLocalPart();
                    String currentPrefix = ruleset.XSDQName().getLocalPart();
                    for (int i = 0; i < depth - 1; ++i) {
                        String typeArray = currentType + "Array";
                        Element tmpElt = DLCommonXMLUtil.createArrayType(doc, ruleset, typeArray, currentPrefix + ':' + currentType);
                        schemaJaxbArrayElement.appendChild(tmpElt);
                        currentType = typeArray;
                        currentPrefix = "tns";
                    }
                }
                result.put("jaxb.array.xsd", new XSD(schemaJaxbArrayElement));
            }
            if (var30_37 != null) {
                // empty if block
            }
        }
        if (ruleset.inlineWSDL()) {
            result = xsdUtil.treatSameNamespaces(result, false);
        } else if (zipMergeStrategyForImport) {
            for (Map.Entry entry : ns2wrapper.entrySet()) {
                XSDWrapper wrapper = (XSDWrapper)entry.getValue();
                if (wrapper.getSchemaLocationList().size() <= 1) continue;
                String mainSchemaLocation = null;
                XSD mainXsd = null;
                for (String schemaLocation : wrapper.getSchemaLocationList()) {
                    if (mainSchemaLocation == null) {
                        mainSchemaLocation = schemaLocation;
                        mainXsd = result.get(schemaLocation);
                        continue;
                    }
                    XSD otherXsd = result.remove(schemaLocation);
                    mainXsd.setEvents(xsdUtil.mergeEvents(mainXsd.getEvents(), otherXsd.getEvents()));
                }
            }
        }
        return result;
    }

    private Types getTypes(Definition definition, RulesetWrapperImpl ruleset, Map<String, XSD> externalSchemas) throws WSDLException, DOMException, ResourceException, ClassNotFoundException, IOException, JAXBException, ParserConfigurationException {
        Types types = definition.createTypes();
        Map<String, XSD> schemas = this.getSchemas(definition, ruleset);
        if (schemas.size() == 0) {
            return null;
        }
        if (ruleset.inlineWSDL()) {
            types = definition.createTypes();
            for (Map.Entry<String, XSD> entry : schemas.entrySet()) {
                Schema schema = (Schema)this.getExtensionRegistry().createExtension(Types.class, SchemaConstants.Q_ELEM_XSD_2001);
                schema.setRequired(Boolean.valueOf(false));
                types.addExtensibilityElement((ExtensibilityElement)schema);
                schema.setElement(entry.getValue().getElement());
            }
        } else {
            types = definition.createTypes();
            for (Map.Entry<String, XSD> entry : schemas.entrySet()) {
                if (entry.getKey().equals(ROOT_IMPORT)) {
                    Schema schema = (Schema)this.getExtensionRegistry().createExtension(Types.class, SchemaConstants.Q_ELEM_XSD_2001);
                    schema.setRequired(Boolean.valueOf(false));
                    types.addExtensibilityElement((ExtensibilityElement)schema);
                    schema.setElement(entry.getValue().getElement());
                    continue;
                }
                externalSchemas.put(entry.getKey(), entry.getValue());
            }
        }
        return types;
    }

    protected Definition populateDefaultDefinition(RulesetWrapperImpl ruleset, Map<String, XSD> additionalXSDs) throws WSDLException, DOMException, ResourceException, ClassNotFoundException, IOException, JAXBException, ParserConfigurationException {
        Definition definition = this.getDefinition(ruleset);
        Types types = this.getTypes(definition, ruleset, additionalXSDs);
        definition.setTypes(types);
        Operation operation = definition.createOperation();
        operation.setName(ruleset.DecisionServiceOperationName());
        operation.setStyle(OperationType.REQUEST_RESPONSE);
        operation.setUndefined(false);
        Input input = definition.createInput();
        if (!ruleset.definitionNoName()) {
            input.setName(ruleset.getDecisionServiceRequestQName());
        }
        Message inputMessage = definition.createMessage();
        inputMessage.setQName(new QName(ruleset.TargetNamespaceQName().getNamespaceURI(), ruleset.getDecisionServiceRequestQName()));
        Part inputPart = definition.createPart();
        inputPart.setName(ruleset.getDecisionServiceRequestPartName());
        inputPart.setElementName(new QName(ruleset.TargetNamespaceQName().getNamespaceURI(), ruleset.getDecisionServiceRequestPartQName()));
        inputMessage.addPart(inputPart);
        operation.setInput(input);
        input.setMessage(inputMessage);
        Output output = definition.createOutput();
        if (!ruleset.definitionNoName()) {
            output.setName(ruleset.getDecisionServiceResponseQName());
        }
        Message outputMessage = definition.createMessage();
        outputMessage.setQName(new QName(ruleset.TargetNamespaceQName().getNamespaceURI(), ruleset.getDecisionServiceResponseQName()));
        Part outputPart = definition.createPart();
        outputPart.setName(ruleset.getDecisionServiceResponsePartName());
        outputPart.setElementName(new QName(ruleset.TargetNamespaceQName().getNamespaceURI(), ruleset.getDecisionServiceResponsePartQName()));
        outputMessage.addPart(outputPart);
        operation.setOutput(output);
        output.setMessage(outputMessage);
        Fault fault = definition.createFault();
        fault.setName(ruleset.getDecisionServiceFaultQName());
        Message faultMessage = definition.createMessage();
        faultMessage.setQName(new QName(ruleset.TargetNamespaceQName().getNamespaceURI(), ruleset.getDecisionServiceFaultQName()));
        Part faultPart = definition.createPart();
        faultPart.setName(ruleset.getDecisionServiceFaultPartName());
        faultPart.setElementName(new QName(ruleset.TargetNamespaceQName().getNamespaceURI(), ruleset.getDecisionServiceFaultPartQName()));
        faultMessage.addPart(faultPart);
        operation.addFault(fault);
        fault.setMessage(faultMessage);
        BindingOperation bindOp = definition.createBindingOperation();
        bindOp.setName(ruleset.DecisionServiceOperationName());
        SOAPOperation soapOperation = (SOAPOperation)this.getExtensionRegistry().createExtension(BindingOperation.class, new QName(ruleset.SOAPQName().getNamespaceURI(), "operation"));
        soapOperation.setStyle("document");
        soapOperation.setSoapActionURI(ruleset.DecisionServiceOperationName());
        bindOp.addExtensibilityElement((ExtensibilityElement)soapOperation);
        bindOp.setOperation(operation);
        BindingInput bindingInput = definition.createBindingInput();
        if (!ruleset.getCompatibility().equals(Compatibility.RELEASE70.toString()) && !ruleset.getCompatibility().equals(Compatibility.RELEASE71.toString())) {
            bindingInput.setName(ruleset.decisionServiceRequestQName);
        }
        SOAPBody inputBody = (SOAPBody)this.getExtensionRegistry().createExtension(BindingInput.class, new QName(ruleset.SOAPQName().getNamespaceURI(), "body"));
        inputBody.setUse("literal");
        bindingInput.addExtensibilityElement((ExtensibilityElement)inputBody);
        bindOp.setBindingInput(bindingInput);
        BindingOutput bindingOutput = definition.createBindingOutput();
        if (!ruleset.getCompatibility().equals(Compatibility.RELEASE70.toString()) && !ruleset.getCompatibility().equals(Compatibility.RELEASE71.toString())) {
            bindingOutput.setName(ruleset.decisionServiceResponseQName);
        }
        bindingOutput.addExtensibilityElement((ExtensibilityElement)inputBody);
        bindOp.setBindingOutput(bindingOutput);
        BindingFault bindingFault = definition.createBindingFault();
        bindingFault.setName(ruleset.getDecisionServiceFaultQName());
        SOAPFault faultBody = (SOAPFault)this.getExtensionRegistry().createExtension(BindingFault.class, new QName(ruleset.SOAPQName().getNamespaceURI(), "fault"));
        faultBody.setName(ruleset.getDecisionServiceFaultQName());
        faultBody.setUse("literal");
        bindingFault.addExtensibilityElement((ExtensibilityElement)faultBody);
        bindOp.addBindingFault(bindingFault);
        PortType portType = definition.createPortType();
        portType.setQName(new QName(ruleset.TargetNamespaceQName().getNamespaceURI(), ruleset.DecisionServiceName()));
        portType.addOperation(operation);
        Binding binding = definition.createBinding();
        binding.setQName(new QName(ruleset.TargetNamespaceQName().getNamespaceURI(), ruleset.DecisionServiceBindingName()));
        binding.setPortType(portType);
        SOAPBinding soapBinding = (SOAPBinding)this.getExtensionRegistry().createExtension(Binding.class, new QName(ruleset.SOAPQName().getNamespaceURI(), "binding"));
        soapBinding.setTransportURI("http://schemas.xmlsoap.org/soap/http");
        soapBinding.setStyle("document");
        binding.addExtensibilityElement((ExtensibilityElement)soapBinding);
        binding.addBindingOperation(bindOp);
        Service srv = definition.createService();
        srv.setQName(new QName(ruleset.DecisionServiceName()));
        for (Map.Entry<String, URL> entry : ruleset.getEndPoints().entrySet()) {
            String hostname = entry.getKey();
            Port port = definition.createPort();
            port.setName(ruleset.DecisionServicePortName().replaceAll("<hostname>", XSDUtil.getNCName(hostname == null ? "" : hostname, false, ruleset.getCompatibility().equals(Compatibility.LATEST.toString()) || ruleset.getCompatibility().equals(Compatibility.RELEASE7113.toString()))));
            SOAPAddress soapAddress = (SOAPAddress)this.getExtensionRegistry().createExtension(Port.class, new QName(ruleset.SOAPQName().getNamespaceURI(), "address"));
            soapAddress.setLocationURI(entry.getValue().toExternalForm());
            port.addExtensibilityElement((ExtensibilityElement)soapAddress);
            port.setBinding(binding);
            srv.addPort(port);
        }
        inputMessage.setUndefined(false);
        definition.addMessage(inputMessage);
        outputMessage.setUndefined(false);
        definition.addMessage(outputMessage);
        faultMessage.setUndefined(false);
        definition.addMessage(faultMessage);
        binding.setUndefined(false);
        definition.addBinding(binding);
        portType.setUndefined(false);
        definition.addPortType(portType);
        definition.addService(srv);
        return definition;
    }

    public void generateWSDL(RulesetWrapper ruleset, OutputStream outstream) throws WSDLException, DOMException, ResourceException, ClassNotFoundException, IOException, JAXBException, ParserConfigurationException {
        HashMap<String, XSD> additionalXSDs = new HashMap<String, XSD>();
        if (ruleset.zipFile()) {
            RulesetWrapperImpl rulesetWrapper = new RulesetWrapperImpl(ruleset);
            ZipOutputStream zos = new ZipOutputStream(outstream);
            zos.putNextEntry(new ZipEntry(rulesetWrapper.DecisionServiceWSDLName()));
            ByteArrayOutputStream wsdlboas = new ByteArrayOutputStream();
            Definition definition = this.populateDefaultDefinition(rulesetWrapper, additionalXSDs);
            WSDLWriter writer = this.factory.newWSDLWriter();
            writer.writeWSDL(definition, (OutputStream)wsdlboas);
            wsdlboas.flush();
            wsdlboas.close();
            zos.write(wsdlboas.toByteArray());
            for (Map.Entry entry : additionalXSDs.entrySet()) {
                String filename = (String)entry.getKey();
                ZipEntry zentry = new ZipEntry(filename);
                zos.putNextEntry(zentry);
                XSD currXSD = (XSD)entry.getValue();
                if (currXSD.getDefaultNamespace() != null && !currXSD.isFlattenedInclusion() && currXSD.getOriginalXSD() != null) {
                    zos.write(currXSD.getOriginalXSD());
                } else {
                    Element root = currXSD.getElement();
                    try {
                        ByteArrayOutputStream xsdboas = new ByteArrayOutputStream();
                        DOMSource source = new DOMSource(root);
                        Transformer transformer = this.transformerFactory.newTransformer();
                        transformer.setOutputProperty("indent", "yes");
                        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                        StreamResult result = new StreamResult(xsdboas);
                        transformer.transform(source, result);
                        xsdboas.flush();
                        xsdboas.close();
                        zos.write(xsdboas.toByteArray());
                    }
                    catch (TransformerException e) {
                        e.printStackTrace();
                    }
                }
                zos.closeEntry();
            }
            zos.close();
        } else {
            Definition definition = this.populateDefaultDefinition(new RulesetWrapperImpl(ruleset), additionalXSDs);
            definition.setExtensionRegistry(this.getExtensionRegistry());
            WSDLWriter writer = this.factory.newWSDLWriter();
            writer.writeWSDL(definition, outstream);
        }
    }

    private void registerSchemaParser(ExtensionRegistry registry) {
        registry.mapExtensionTypes(Types.class, SchemaConstants.Q_ELEM_XSD_1999, SchemaImpl.class);
        registry.registerDeserializer(Types.class, SchemaConstants.Q_ELEM_XSD_1999, (ExtensionDeserializer)new SchemaDeserializer());
        registry.registerSerializer(Types.class, SchemaConstants.Q_ELEM_XSD_1999, (ExtensionSerializer)new SchemaSerializer());
        registry.mapExtensionTypes(Types.class, SchemaConstants.Q_ELEM_XSD_2000, SchemaImpl.class);
        registry.registerDeserializer(Types.class, SchemaConstants.Q_ELEM_XSD_2000, (ExtensionDeserializer)new SchemaDeserializer());
        registry.registerSerializer(Types.class, SchemaConstants.Q_ELEM_XSD_2000, (ExtensionSerializer)new SchemaSerializer());
        registry.mapExtensionTypes(Types.class, SchemaConstants.Q_ELEM_XSD_2001, SchemaImpl.class);
        registry.registerDeserializer(Types.class, SchemaConstants.Q_ELEM_XSD_2001, (ExtensionDeserializer)new SchemaDeserializer());
        registry.registerSerializer(Types.class, SchemaConstants.Q_ELEM_XSD_2001, (ExtensionSerializer)new SchemaSerializer());
    }

    public void addSchema(QName xsdQName, Types types, Element schemaElement) throws WSDLException {
        SchemaImpl schema = (SchemaImpl)this.getExtensionRegistry().createExtension(Types.class, new QName(xsdQName.getNamespaceURI(), "schema"));
        schema.setElement(schemaElement);
        schema.setElementType(new QName(xsdQName.getNamespaceURI(), "schema"));
        types.addExtensibilityElement((ExtensibilityElement)schema);
    }

    public static ResourceException createResourceException(String messageKey, Object[] messageParameters, Exception ex) {
        String message = LocalizedMessageHelper.getLocalizedMessage("com.ibm.rules.htds.plugin", messageKey, messageParameters, null, null);
        ResourceException exception = new ResourceException(message, messageKey);
        if (ex != null) {
            exception.initCause((Throwable)ex);
        }
        return exception;
    }
}

