/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.logging.internal;

import com.ibm.rules.res.logging.internal.XULogRecord;
import com.ibm.rules.res.message.internal.LocalizedMessageHelper;
import com.ibm.rules.res.message.internal.MessageCode;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class RESFormatter
extends Formatter {
    public static final String NEW_LINE = System.getProperty("line.separator");
    protected DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2);
    protected static final String WHITESPACES = "                                                                                          ";
    protected static final int LEVEL_STRING_MAX_LENGTH = 9;
    protected static final int CODE_STRING_MAX_LENGTH = 10;
    protected boolean displayThreadId = false;
    protected boolean displayLevel = true;
    protected boolean displayDate = true;

    @Override
    public String formatMessage(LogRecord record) {
        return this.formatMessage(record.getMessage(), record.getParameters(), record.getResourceBundle());
    }

    protected String formatMessage(String pformat, Object[] pparameters, ResourceBundle presourceBundle) {
        String format = pformat;
        ResourceBundle resourceBundle = presourceBundle;
        Object[] parameters = pparameters;
        if (resourceBundle == null) {
            return format;
        }
        try {
            format = resourceBundle.getString(format);
        }
        catch (MissingResourceException ex) {
            // empty catch block
        }
        if (parameters == null || parameters.length == 0) {
            return format;
        }
        try {
            return MessageFormat.format(format, parameters);
        }
        catch (Exception ex) {
            return format;
        }
    }

    protected String formatThrowable(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        StringWriter result = new StringWriter();
        PrintWriter writer = new PrintWriter(result);
        throwable.printStackTrace(writer);
        writer.flush();
        result.flush();
        return result.toString();
    }

    protected void appendDate(LogRecord record, StringBuffer buffer) {
        Date date = new Date(record.getMillis());
        buffer.append(this.dateFormat.format(date));
    }

    protected void appendLevel(LogRecord record, StringBuffer buffer) {
        buffer.append("[");
        buffer.append(record.getLevel().getName());
        buffer.append("]");
        buffer.append(WHITESPACES.substring(0, 9 - record.getLevel().getName().length()));
    }

    protected void appendMessageId(LogRecord record, StringBuffer buffer) {
        String msgKey = record.getMessage();
        String msgId = null;
        if (msgKey != null) {
            if (MessageCode.isValid(msgKey)) {
                msgId = msgKey;
            } else if (record.getResourceBundle() != null) {
                msgId = LocalizedMessageHelper.getMessageId(msgKey, record.getResourceBundle());
            }
        }
        if (msgId == null) {
            buffer.append(WHITESPACES.substring(0, 10));
        } else {
            buffer.append(msgId);
            buffer.append(WHITESPACES.substring(0, 10 - msgId.length()));
        }
    }

    protected void appendMessage(LogRecord record, StringBuffer buffer) {
        buffer.append(this.formatMessage(record));
    }

    protected void appendThrowable(LogRecord record, StringBuffer buffer) {
        buffer.append(this.formatThrowable(record.getThrown()));
    }

    protected void appendThreadId(StringBuffer buffer) {
        buffer.append(Long.toString(Thread.currentThread().getId()));
    }

    protected void appendXULogRecordExtra(LogRecord record, StringBuffer buffer) {
        if (record instanceof XULogRecord) {
            XULogRecord xuRecord = (XULogRecord)record;
            buffer.append(' ');
            if (xuRecord.getRulesetPath() == null) {
                buffer.append('-');
            } else {
                buffer.append(xuRecord.getRulesetPath());
            }
            buffer.append(' ');
            if (xuRecord.getCCIConnectionId() == null) {
                buffer.append('-');
            } else {
                buffer.append(xuRecord.getCCIConnectionId());
            }
            buffer.append('.');
            if (xuRecord.getSPIConnectionId() == null) {
                buffer.append('-');
            } else {
                buffer.append(xuRecord.getSPIConnectionId());
            }
            buffer.append(' ');
            if (xuRecord.getUserData() == null) {
                buffer.append('-');
            } else {
                buffer.append(xuRecord.getUserData());
            }
        }
    }

    @Override
    public String format(LogRecord record) {
        StringBuffer buffer = new StringBuffer();
        if (this.displayDate) {
            this.appendDate(record, buffer);
            buffer.append(' ');
        }
        if (this.displayLevel) {
            this.appendLevel(record, buffer);
            buffer.append(' ');
        }
        this.appendMessageId(record, buffer);
        if (this.displayThreadId) {
            buffer.append(' ');
            this.appendThreadId(buffer);
        }
        this.appendXULogRecordExtra(record, buffer);
        buffer.append(' ');
        this.appendMessage(record, buffer);
        if (record.getThrown() != null) {
            buffer.append(' ');
            this.appendThrowable(record, buffer);
        }
        buffer.append(NEW_LINE);
        return buffer.toString();
    }
}

