/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.logging.internal;

import com.ibm.rules.res.logging.internal.HandlerPrivilegedAction;
import com.ibm.rules.res.logging.internal.RESFormatter;
import com.ibm.rules.res.logging.internal.RESLogRecord;
import com.ibm.rules.res.logging.internal.RESRecordFactory;
import com.ibm.rules.res.message.internal.LocalizedMessageHelper;
import java.io.OutputStream;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;

public class RESLogger {
    public static final String CONSOLE_LOGGER_NAME = "com.ibm.rules.res.console";
    public static final String DVS_LOGGER_NAME = "com.ibm.rules.res.dvs";
    public static final String CDI_LOGGER_NAME = "com.ibm.rules.res.cdi";
    public static final String HTDS_LOGGER_NAME = "com.ibm.rules.res.htds";
    public static final String EXECUTION_LOGGER_NAME = "com.ibm.rules.res.execution";
    public static final String PERSISTENCE_LOGGER_NAME = "com.ibm.rules.res.persistence";
    public static final String PERSISTENCE_SQL_LOGGER_NAME = "com.ibm.rules.res.persistence.sql";
    public static final String RES_COMMON_LOGGER_NAME = "com.ibm.rules.res.common";
    public static final String MBEAN_LOGGER_NAME = "com.ibm.rules.res.mbean";
    protected Logger logger;
    protected RESRecordFactory factory;

    public RESLogger(Logger logger, String bundleName) {
        this.logger = logger;
        this.factory = new RESRecordFactory(logger.getName(), bundleName, LocalizedMessageHelper.getResourceBundle(bundleName));
    }

    public void log(Level level, String key, Object[] params, Throwable t) {
        RESLogRecord rec = this.factory.createRESLogRecord(level, key, params, t);
        this.logger.log(rec);
    }

    public void info(String key, Object[] params, Throwable t) {
        this.log(Level.INFO, key, params, t);
    }

    public void warning(String key, Object[] params, Throwable t) {
        this.log(Level.WARNING, key, params, t);
    }

    public void severe(String key, Object[] params, Throwable t) {
        this.log(Level.SEVERE, key, params, t);
    }

    public static RESLogger getRESLogger(String name, String bundleName) {
        return new RESLogger(RESLogger.getLogger(name, bundleName), bundleName);
    }

    public static Logger getLogger(String name, String bundleName) {
        LogManager manager = LogManager.getLogManager();
        Logger logger = manager.getLogger(name);
        if (logger == null) {
            logger = Logger.getLogger(name, bundleName);
            manager.addLogger(logger);
        }
        return logger;
    }

    public static Logger getLogger(OutputStream output) {
        return RESLogger.getLogger(output, new RESFormatter());
    }

    public static Logger getLogger(OutputStream output, Formatter formatter) {
        Logger logger = Logger.getAnonymousLogger();
        logger.setUseParentHandlers(false);
        Handler[] handlers = logger.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            logger.removeHandler(handlers[i]);
        }
        StreamHandler handler = HandlerPrivilegedAction.newStreamHandler(output, formatter);
        logger.addHandler(handler);
        return logger;
    }

    public void info(String key, Object[] params) {
        this.log(Level.INFO, key, params, null);
    }

    public boolean isLoggable(Level level) {
        return this.logger.isLoggable(level);
    }
}

