/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.message.internal;

import com.ibm.rules.res.logging.internal.RESLogger;
import com.ibm.rules.res.message.internal.MessageCode;
import com.ibm.rules.res.message.internal.XXMessageCode;
import ilog.rules.res.util.lang.IlrClassPrivilegedAction;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Logger;

public class LocalizedMessageHelper {
    private final String resourceBundleName;
    private final ClassLoader cl;
    private final Locale locale;

    private LocalizedMessageHelper(String resourceBundleName, Locale locale, ClassLoader cl) {
        this.resourceBundleName = resourceBundleName;
        this.locale = locale;
        this.cl = cl;
    }

    public static LocalizedMessageHelper createInstance(String resourceBundleName, Locale locale) {
        return new LocalizedMessageHelper(resourceBundleName, locale, null);
    }

    public static LocalizedMessageHelper createInstance(String resourceBundleName, Locale locale, ClassLoader cl) {
        return new LocalizedMessageHelper(resourceBundleName, locale, cl);
    }

    public static LocalizedMessageHelper createInstance(String resourceBundleName, Locale locale, Class<?> clazz) {
        ClassLoader classLoader = IlrClassPrivilegedAction.getClassLoader(clazz);
        return new LocalizedMessageHelper(resourceBundleName, locale, classLoader);
    }

    public static ResourceBundle getResourceBundle(String name) {
        return LocalizedMessageHelper.getResourceBundle(name, null, null);
    }

    public static ResourceBundle getResourceBundle(String name, Locale locale, ClassLoader cl) {
        if (locale == null) {
            locale = LocalizedMessageHelper.getLocale();
        }
        if (cl == null) {
            cl = IlrClassPrivilegedAction.getClassLoader(LocalizedMessageHelper.class);
        }
        try {
            return ResourceBundle.getBundle(name, locale, cl);
        }
        catch (MissingResourceException e) {
            cl = Thread.currentThread().getContextClassLoader();
            try {
                return ResourceBundle.getBundle(name, locale, cl);
            }
            catch (MissingResourceException e2) {
                return ResourceBundle.getBundle(name, locale);
            }
        }
    }

    public static String getMessageId(String oldCode, String bundleName, Locale locale, ClassLoader cl) {
        ResourceBundle bundle = LocalizedMessageHelper.getResourceBundle(bundleName, locale, cl);
        return LocalizedMessageHelper.getMessageId(oldCode, bundle);
    }

    public static String getMessageId(String oldCode, String resourceBundleName) {
        return LocalizedMessageHelper.getMessageId(oldCode, resourceBundleName, null, null);
    }

    public static String getMessageId(String msgKey, ResourceBundle bundle) {
        try {
            return bundle.getString(msgKey + "_msgid");
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public String getLocalizedMessage(String messageKey) {
        return LocalizedMessageHelper.getLocalizedMessage(this.resourceBundleName, messageKey, null, this.locale, this.cl, false);
    }

    public String getLocalizedMessage(String messageKey, Locale locale) {
        return LocalizedMessageHelper.getLocalizedMessage(this.resourceBundleName, messageKey, null, locale, this.cl, false);
    }

    public String getLocalizedMessage(String messageKey, Object[] messageParameters) {
        return LocalizedMessageHelper.getLocalizedMessage(this.resourceBundleName, messageKey, messageParameters, this.locale, this.cl, false);
    }

    public String getLocalizedMessage(String messageKey, Object[] messageParameters, Locale locale) {
        return LocalizedMessageHelper.getLocalizedMessage(this.resourceBundleName, messageKey, messageParameters, locale, this.cl, false);
    }

    public String getLocalizedMessage(String messageKey, Object[] messageParameters, boolean includeMsgCode) {
        return LocalizedMessageHelper.getLocalizedMessage(this.resourceBundleName, messageKey, messageParameters, this.locale, this.cl, includeMsgCode);
    }

    public String getLocalizedMessage(String messageKey, Object[] messageParameters, boolean includeMsgCode, Locale locale) {
        return LocalizedMessageHelper.getLocalizedMessage(this.resourceBundleName, messageKey, messageParameters, locale, this.cl, includeMsgCode);
    }

    public static String getLocalizedMessage(String resourceBundleName, String messageKey, Object[] messageParameters, Locale plocale, ClassLoader cl) {
        return LocalizedMessageHelper.getLocalizedMessage(resourceBundleName, messageKey, messageParameters, plocale, cl, false);
    }

    public static String getLocalizedMessage(String bundleName, String code, Object[] params) {
        return LocalizedMessageHelper.getLocalizedMessage(bundleName, code, params, false);
    }

    public static String getLocalizedMessage(String bundleName, String code, Object[] params, boolean includeMsgCode) {
        return LocalizedMessageHelper.getLocalizedMessage(bundleName, code, params, LocalizedMessageHelper.getLocale(), Thread.currentThread().getContextClassLoader(), includeMsgCode);
    }

    public static Locale getLocale() {
        return Locale.getDefault();
    }

    public static String getLocalizedMessage(String bundleName, String key, Object[] msgParams, Locale plocale, ClassLoader cl, boolean includeMsgCode) {
        return LocalizedMessageHelper.getLocalizedMessage(bundleName, key, msgParams, plocale, cl, includeMsgCode, true);
    }

    public static String getLocalizedMessage(String bundleName, String key, Object[] msgParams, Locale plocale, ClassLoader cl, boolean includeMsgCode, boolean throwException) {
        Locale locale = plocale;
        if (locale == null) {
            locale = LocalizedMessageHelper.getLocale();
        }
        try {
            ResourceBundle resource = LocalizedMessageHelper.getResourceBundle(bundleName, locale, cl);
            String msg = msgParams == null ? resource.getString(key) : MessageFormat.format(resource.getString(key), msgParams);
            if (includeMsgCode) {
                if (MessageCode.isValid(key)) {
                    return key + ": " + msg;
                }
                return LocalizedMessageHelper.getMessageId(key, bundleName, plocale, cl) + ": " + msg;
            }
            return msg;
        }
        catch (RuntimeException e) {
            if (throwException) {
                if (e instanceof MissingResourceException) {
                    LocalizedMessageHelper.logMissingResourceException(bundleName, key, (MissingResourceException)e);
                }
                return LocalizedMessageHelper.formatMessageWithoutBundle(bundleName, key, msgParams);
            }
            return null;
        }
    }

    protected static void logMissingResourceException(String bundle, String k, MissingResourceException e) {
        Logger logger = RESLogger.getLogger("com.ibm.rules.res.common", "com.ibm.rules.res.common");
        try {
            RESLogger resLog = new RESLogger(logger, "com.ibm.rules.res.common");
            resLog.severe(XXMessageCode.ERROR_RESOURCE_BUNDLE_NOT_FOUND, new Object[]{bundle, k}, e);
        }
        catch (MissingResourceException e2) {
            logger.severe("Cannot find key " + k + " for resource bundle: " + "com.ibm.rules.res.common");
        }
    }

    protected static String formatMessageWithoutBundle(String bundleName, String key, Object[] msgParams) {
        StringBuffer buf = new StringBuffer(bundleName);
        buf.append(", Message code: ");
        buf.append(key);
        if (msgParams != null) {
            buf.append(", parameters: ");
            for (int i = 0; i < msgParams.length; ++i) {
                buf.append(msgParams[i]);
                if (i == msgParams.length - 1) continue;
                buf.append(", ");
            }
        }
        return buf.toString();
    }
}

