/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.model.archive.internal;

import com.ibm.rules.res.model.XOMInformation;
import com.ibm.rules.res.model.XOMResourceInformation;
import com.ibm.rules.res.model.archive.internal.IlrModelArchiveLocalization;
import com.ibm.rules.res.model.archive.internal.SimpleRulesetArchive;
import com.ibm.rules.res.model.internal.XOMInternalNameUtil;
import com.ibm.rules.res.model.internal.XOMResourceInformationImpl;
import com.ibm.rules.res.util.internal.StreamUtil;
import ilog.rules.archive.IlrRulesetArchive;
import ilog.rules.res.model.IlrCRERulesetArchive;
import ilog.rules.res.model.IlrDERulesetArchive;
import ilog.rules.res.model.IlrEngineType;
import ilog.rules.res.model.IlrFormatException;
import ilog.rules.res.model.IlrMutableRuleAppInformation;
import ilog.rules.res.model.IlrMutableRulesetArchiveInformation;
import ilog.rules.res.model.IlrRESRulesetArchive;
import ilog.rules.res.model.IlrRepositoryFactory;
import ilog.rules.res.model.IlrRulesetArchiveProperties;
import ilog.rules.res.model.archive.IlrArchiveException;
import ilog.rules.res.model.xml.IlrRuleAppArchiveDescriptor;
import ilog.rules.res.util.io.IlrFileUtil;
import ilog.rules.res.util.zip.IlrZIPUtil;
import ilog.rules.tools.IlrVersionFullInfo;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.xml.sax.SAXException;

public class Archive {
    private static final String META_INF = "META-INF";
    private static final String RCERULESETARCHIVE_FILENAME = "ruleset.jar";
    private static final String DESCRIPTOR_PATH = "META-INF/archive.xml";
    private static IlrRuleAppArchiveDescriptor descriptorManager = new IlrRuleAppArchiveDescriptor();

    void write(OutputStream outputStream, Set<IlrMutableRuleAppInformation> ruleApps, Set<XOMInformation> xomInfos) throws IlrArchiveException, IOException {
        JarOutputStream result = null;
        try {
            result = new JarOutputStream(outputStream, Archive.getManifest());
            result.setLevel(9);
            for (IlrMutableRuleAppInformation ruleApp : ruleApps) {
                for (IlrMutableRulesetArchiveInformation ruleset : ruleApp.getRulesets()) {
                    Archive.addRulesetArchiveEntry(result, ruleset);
                }
            }
            if (xomInfos != null) {
                for (XOMInformation xomInfo : xomInfos) {
                    if (!(xomInfo instanceof XOMResourceInformation)) continue;
                    Archive.addXOMResourceInformationEntry(result, (XOMResourceInformation)xomInfo);
                }
            }
            Archive.addDescriptorEntry(result, DESCRIPTOR_PATH, ruleApps, xomInfos);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IlrArchiveException("com.ibm.rules.res.model.archive.messages", IlrModelArchiveLocalization.ERROR_PROCESS_RULEAPP_ARCHIVE, e);
        }
        finally {
            if (result != null) {
                try {
                    result.close();
                }
                catch (IOException e) {}
            }
        }
    }

    Set<IlrMutableRuleAppInformation> read(Set<XOMInformation> xomInfosToComplete, IlrRepositoryFactory repositoryFactory, JarInputStream jarInputStream) throws IlrArchiveException, IOException {
        Map<String, byte[]> zipResources = null;
        try {
            zipResources = IlrZIPUtil.toMap(jarInputStream);
        }
        catch (IllegalArgumentException e) {
            throw new IlrArchiveException("com.ibm.rules.res.model.archive.messages", IlrModelArchiveLocalization.ERROR_INVALID_ARCHIVE, e);
        }
        byte[] descriptor = zipResources.remove(DESCRIPTOR_PATH);
        if (descriptor == null) {
            throw new IlrArchiveException("com.ibm.rules.res.model.archive.messages", IlrModelArchiveLocalization.ERROR_INVALID_ARCHIVE);
        }
        try {
            Set<IlrMutableRuleAppInformation> ruleApps = descriptorManager.load(xomInfosToComplete, repositoryFactory, StreamUtil.toStream(descriptor));
            for (IlrMutableRuleAppInformation ruleApp : ruleApps) {
                for (IlrMutableRulesetArchiveInformation ruleset : ruleApp.getRulesets()) {
                    IlrRulesetArchiveProperties properties = ruleset.getProperties();
                    boolean rve = false;
                    IlrEngineType type = null;
                    byte[] rulesetArchive = null;
                    if (properties != null) {
                        String engineTypeAsString = (String)properties.get("ruleset.engine");
                        type = IlrEngineType.toEngineType(engineTypeAsString);
                        if (type == null) {
                            throw new IlrArchiveException("com.ibm.rules.res.model.archive.messages", IlrModelArchiveLocalization.ERROR_INVALID_ARCHIVE_TYPE, new String[]{engineTypeAsString});
                        }
                        if (type != IlrEngineType.CRE) {
                            rve = true;
                        }
                    }
                    if ((rulesetArchive = rve ? zipResources.remove(Archive.getRVERulesetArchivePath(ruleset)) : zipResources.remove(Archive.getRCERulesetArchivePath(ruleset))) == null) {
                        throw new IlrArchiveException("com.ibm.rules.res.model.archive.messages", IlrModelArchiveLocalization.ERROR_RULESET_ARCHIVE_NULL, new String[]{ruleset.toString()});
                    }
                    ruleset.setRESRulesetArchive(type, StreamUtil.toStream(rulesetArchive));
                }
            }
            if (xomInfosToComplete != null) {
                for (XOMInformation xomInfo : xomInfosToComplete) {
                    if (!(xomInfo instanceof XOMResourceInformationImpl)) continue;
                    XOMResourceInformationImpl rxomInfo = (XOMResourceInformationImpl)xomInfo;
                    byte[] data = zipResources.remove(XOMInternalNameUtil.getNameAsFile(rxomInfo.getName(), rxomInfo.getVersion()));
                    rxomInfo.setData(data);
                }
            }
            return ruleApps;
        }
        catch (Exception e) {
            if (e != null && e instanceof SAXException && e.getMessage().equals("System entity not supported")) {
                throw new IlrArchiveException("com.ibm.rules.res.model.archive.messages", IlrModelArchiveLocalization.ERROR_SYSTEM_ENTITY_NOT_SUPPORTED);
            }
            throw new IlrArchiveException("com.ibm.rules.res.model.archive.messages", IlrModelArchiveLocalization.ERROR_PROCESS_RULEAPP_ARCHIVE, e);
        }
    }

    private static String getRCERulesetArchivePath(IlrMutableRulesetArchiveInformation ruleset) {
        StringBuffer buff = new StringBuffer(ruleset.getCanonicalPath().toString().substring(1));
        buff.append('/').append(RCERULESETARCHIVE_FILENAME);
        return buff.toString();
    }

    private static String getRVERulesetArchivePath(IlrMutableRulesetArchiveInformation ruleset) {
        StringBuffer buff = new StringBuffer(ruleset.getCanonicalPath().toString().substring(1));
        buff.append('/').append("ruleset.dsar");
        return buff.toString();
    }

    private static void addRulesetArchiveEntry(JarOutputStream jarOutputStream, IlrMutableRulesetArchiveInformation ruleset) throws IOException, IlrArchiveException {
        IlrRESRulesetArchive rulesetArchive = ruleset.getRESRulesetArchive();
        if (rulesetArchive == null) {
            throw new IlrArchiveException("com.ibm.rules.res.model.archive.messages", IlrModelArchiveLocalization.ERROR_RULESET_ARCHIVE_NULL, new String[]{String.valueOf(ruleset.toString())});
        }
        if (rulesetArchive instanceof IlrCRERulesetArchive) {
            JarEntry entry = new JarEntry(Archive.getRCERulesetArchivePath(ruleset));
            jarOutputStream.putNextEntry(entry);
            IlrRulesetArchive rceRulesetArchive = ((IlrCRERulesetArchive)rulesetArchive).getRulesetArchive();
            if (rceRulesetArchive instanceof SimpleRulesetArchive) {
                ((SimpleRulesetArchive)rceRulesetArchive).writeJar(jarOutputStream);
            } else {
                JarOutputStream jos = new JarOutputStream(jarOutputStream);
                jos.setLevel(9);
                rceRulesetArchive.write(jos);
                jos.finish();
            }
        } else {
            JarEntry entry = new JarEntry(Archive.getRVERulesetArchivePath(ruleset));
            jarOutputStream.putNextEntry(entry);
            IlrFileUtil.copy(((IlrDERulesetArchive)rulesetArchive).getContentStream(), jarOutputStream);
        }
        jarOutputStream.closeEntry();
    }

    private static void addXOMResourceInformationEntry(JarOutputStream jarOutputStream, XOMResourceInformation xomInfo) throws IOException, IlrArchiveException {
        JarEntry entry = new JarEntry(Archive.getXOMResourceFileName(xomInfo));
        jarOutputStream.putNextEntry(entry);
        IlrFileUtil.copy((InputStream)new ByteArrayInputStream(xomInfo.getData()), jarOutputStream);
        jarOutputStream.closeEntry();
    }

    private static String getXOMResourceFileName(XOMResourceInformation xomInfo) {
        return XOMInternalNameUtil.getNameAsFile(xomInfo.getName(), xomInfo.getVersion());
    }

    private static void addDescriptorEntry(JarOutputStream jarOutputStream, String entryName, Set<IlrMutableRuleAppInformation> ruleApps, Set<XOMInformation> xomInfos) throws IOException, IlrFormatException {
        JarEntry entry = new JarEntry(entryName);
        jarOutputStream.putNextEntry(entry);
        descriptorManager.save(ruleApps, xomInfos, jarOutputStream);
        jarOutputStream.closeEntry();
    }

    private static Manifest getManifest() {
        Manifest result = new Manifest();
        Attributes mainAttrib = result.getMainAttributes();
        mainAttrib.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        mainAttrib.put(Attributes.Name.SPECIFICATION_TITLE, "RuleApp Archive");
        mainAttrib.put(Attributes.Name.IMPLEMENTATION_TITLE, "Decision Server");
        mainAttrib.put(Attributes.Name.IMPLEMENTATION_VENDOR, "IBM");
        mainAttrib.put(Attributes.Name.IMPLEMENTATION_VERSION, IlrVersionFullInfo.getVersion());
        return result;
    }
}

