/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.model.archive.internal;

import com.ibm.rules.res.model.XOMInformation;
import com.ibm.rules.res.model.archive.internal.Archive;
import com.ibm.rules.res.model.archive.internal.IlrModelArchiveLocalization;
import ilog.rules.res.model.IlrIllegalArgumentRuntimeException;
import ilog.rules.res.model.IlrMutableRuleAppInformation;
import ilog.rules.res.model.IlrRepositoryFactory;
import ilog.rules.res.model.archive.IlrArchiveException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import java.util.jar.JarInputStream;

public class ArchiveManagerWithXOM {
    private static final String BUNDLE_NAME = "com.ibm.rules.res.model.archive.messages";
    private final Archive archiver = new Archive();

    public void writeWithXOM(OutputStream outputStream, Set<IlrMutableRuleAppInformation> ruleApps, Set<XOMInformation> xomInfos) throws IOException, IlrArchiveException {
        if (outputStream == null) {
            throw new IlrIllegalArgumentRuntimeException(BUNDLE_NAME, IlrModelArchiveLocalization.ERROR_NULL_OUTPUTSTREAM);
        }
        if (ruleApps == null || ruleApps.size() == 0) {
            throw new IlrIllegalArgumentRuntimeException(BUNDLE_NAME, IlrModelArchiveLocalization.ERROR_NO_RULEAPP);
        }
        this.archiver.write(outputStream, ruleApps, xomInfos);
    }

    public Set<IlrMutableRuleAppInformation> readWithXOM(Set<XOMInformation> xomInfosToComplete, IlrRepositoryFactory repositoryFactory, JarInputStream jarInputStream) throws IOException, IlrArchiveException {
        if (jarInputStream == null) {
            throw new IlrIllegalArgumentRuntimeException(BUNDLE_NAME, IlrModelArchiveLocalization.ERROR_NO_INPUTSTREAM);
        }
        if (repositoryFactory == null) {
            throw new IlrIllegalArgumentRuntimeException(BUNDLE_NAME, IlrModelArchiveLocalization.ERROR_NO_FACTORY);
        }
        return this.archiver.read(xomInfosToComplete, repositoryFactory, jarInputStream);
    }
}

