/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.model.internal;

import com.ibm.rules.res.message.internal.LocalizedException;
import com.ibm.rules.res.model.MutableXOMLibraryInformation;
import com.ibm.rules.res.model.MutableXOMRepository;
import com.ibm.rules.res.model.XOMLibraryId;
import com.ibm.rules.res.model.XOMResourceId;
import com.ibm.rules.res.model.internal.MutableXOMRepositoryImpl;
import com.ibm.rules.res.model.internal.XOMElement;
import com.ibm.rules.res.persistence.XOMRepositoryDAO;
import ilog.rules.res.model.IlrResourceRuntimeException;
import ilog.rules.res.model.IlrVersion;
import ilog.rules.res.model.internal.IlrModelImplLocalization;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class MutableXOMLibraryInformationImpl
extends XOMElement
implements MutableXOMLibraryInformation {
    private static final long serialVersionUID = -3503909034610438503L;
    protected MutableXOMRepositoryImpl repository;
    protected List<String> content;

    protected MutableXOMLibraryInformationImpl(String name, IlrVersion version, Date creationDate) {
        super(name, version, creationDate);
    }

    @Override
    public MutableXOMRepository getRepository() {
        return this.repository;
    }

    @Override
    public String[] getResources() {
        if (this.content == null) {
            return new String[0];
        }
        return this.content.toArray(new String[this.content.size()]);
    }

    @Override
    public int compareTo(XOMLibraryId o) {
        int nameComparison = this.getName().compareToIgnoreCase(o.getName());
        if (nameComparison == 0) {
            return this.getVersion().compareTo(o.getVersion());
        }
        return nameComparison;
    }

    @Override
    public void addResourceAt(int index, XOMResourceId resource) {
        this.addResourceAt(index, "resuri://" + resource.getName() + "/" + resource.getVersion());
    }

    public void addResourceAt(int index, String resource) {
        if (this.content == null) {
            this.content = new LinkedList<String>();
        }
        this.content.add(index, resource);
    }

    @Override
    public void addLibraryAt(int index, XOMLibraryId library) {
        if (this.content == null) {
            this.content = new LinkedList<String>();
        }
        this.content.add(index, "reslib://" + library.getName() + "/" + library.getVersion());
    }

    @Override
    public boolean removeElementAt(int index) {
        if (this.content == null) {
            return false;
        }
        return this.content.remove(index) != null;
    }

    protected XOMRepositoryDAO getDAO() {
        return this.repository == null ? null : this.repository.getDAO();
    }

    protected void linked(MutableXOMRepositoryImpl newRepository) {
        this.repository = newRepository;
    }

    protected void setRepository(MutableXOMRepositoryImpl newRepository) {
        if (this.getRepository() != null && newRepository != null || this.getRepository() == null && newRepository == null) {
            throw new IllegalStateException();
        }
        if (newRepository != null) {
            XOMRepositoryDAO repositoryDAO = newRepository.getDAO();
            if (repositoryDAO != null) {
                try {
                    repositoryDAO.addLibrary(this.getName(), this.getVersion(), this.getResources());
                }
                catch (LocalizedException e) {
                    throw new IlrResourceRuntimeException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.ADD_LIBRARY_ERROR, new String[]{this.toString()}, (Throwable)e);
                }
            }
        } else {
            XOMRepositoryDAO repositoryDAO = this.getDAO();
            if (repositoryDAO != null) {
                try {
                    repositoryDAO.removeLibrary(this);
                }
                catch (LocalizedException e) {
                    throw new IlrResourceRuntimeException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.REMOVE_LIBRARY_ERROR, new String[]{this.toString()}, (Throwable)e);
                }
            }
        }
        this.linked(newRepository);
    }
}

