/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.model.internal;

import com.ibm.rules.res.message.internal.LocalizedException;
import com.ibm.rules.res.model.MutableXOMLibraryInformation;
import com.ibm.rules.res.model.MutableXOMRepository;
import com.ibm.rules.res.model.XOMInformation;
import com.ibm.rules.res.model.XOMRepositoryFactory;
import com.ibm.rules.res.model.XOMResourceId;
import com.ibm.rules.res.model.XOMResourceInformation;
import com.ibm.rules.res.model.internal.MutableXOMLibraryInformationImpl;
import com.ibm.rules.res.model.internal.XOMElementContainer;
import com.ibm.rules.res.model.internal.XOMResourceInformationImpl;
import com.ibm.rules.res.persistence.XOMRepositoryDAO;
import com.ibm.rules.res.util.internal.StreamUtil;
import ilog.rules.res.model.IlrAlreadyExistException;
import ilog.rules.res.model.IlrResourceRuntimeException;
import ilog.rules.res.model.IlrVersion;
import ilog.rules.res.model.internal.IlrModelImplLocalization;
import java.util.Collections;
import java.util.Set;

public class MutableXOMRepositoryImpl
implements MutableXOMRepository {
    protected final XOMRepositoryFactory repositoryFactory;
    protected XOMRepositoryDAO repositoryDAO;
    protected XOMElementContainer<MutableXOMLibraryInformation> librariesContainer = new XOMElementContainer();
    protected XOMElementContainer<XOMResourceInformation> resourcesContainer = new XOMElementContainer();

    protected MutableXOMRepositoryImpl(XOMRepositoryFactory repositoryFactory) {
        this(repositoryFactory, null, null, null);
    }

    public XOMRepositoryDAO getDAO() {
        return this.repositoryDAO;
    }

    protected MutableXOMRepositoryImpl(XOMRepositoryFactory repositoryFactory, XOMRepositoryDAO repositoryDAO, Set<MutableXOMLibraryInformation> libraries, Set<XOMResourceInformation> resources) {
        this.repositoryFactory = repositoryFactory;
        this.repositoryDAO = repositoryDAO;
        this.librariesContainer = new XOMElementContainer();
        if (libraries != null) {
            for (MutableXOMLibraryInformation library : libraries) {
                this.librariesContainer.addElement(library.getName(), library.getVersion(), library);
                ((MutableXOMLibraryInformationImpl)library).linked(this);
            }
        }
        this.resourcesContainer = new XOMElementContainer();
    }

    @Override
    public Set<MutableXOMLibraryInformation> getLibraries() {
        return Collections.unmodifiableSet(this.librariesContainer.getElements());
    }

    @Override
    public Set<XOMResourceInformation> getResources() {
        return Collections.unmodifiableSet(this.resourcesContainer.getElements());
    }

    @Override
    public Set<MutableXOMLibraryInformation> getLibraries(String libraryName) {
        return Collections.unmodifiableSet(this.librariesContainer.getElements(libraryName));
    }

    @Override
    public Set<XOMResourceInformation> getResources(String resourceName) {
        return Collections.unmodifiableSet(this.resourcesContainer.getElements(resourceName));
    }

    @Override
    public MutableXOMLibraryInformation getGreatestLibrary(String libraryName) {
        return this.librariesContainer.getGreatestElement(libraryName);
    }

    @Override
    public XOMResourceInformation getGreatestResource(String resourceName) {
        return this.resourcesContainer.getGreatestElement(resourceName);
    }

    @Override
    public MutableXOMLibraryInformation getLibrary(String libraryName, IlrVersion libraryVersion) {
        return this.librariesContainer.getElement(libraryName, libraryVersion);
    }

    @Override
    public XOMResourceInformation getResource(String resourceName, IlrVersion resourceVersion) {
        return this.resourcesContainer.getElement(resourceName, resourceVersion);
    }

    @Override
    public MutableXOMLibraryInformation addLibrary(MutableXOMLibraryInformation library) throws IlrAlreadyExistException {
        if (library == null) {
            return null;
        }
        if (library.getRepository() == this || this.librariesContainer.containsElement(library.getName(), library.getVersion())) {
            throw new IlrAlreadyExistException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.LIBRARY_ALREADY_EXIST, new String[]{library.toString()});
        }
        ((MutableXOMLibraryInformationImpl)library).setRepository(this);
        this.librariesContainer.addElement(library.getName(), library.getVersion(), library);
        return library;
    }

    @Override
    public boolean removeLibrary(MutableXOMLibraryInformation library) {
        if (library == null || library.getRepository() != this) {
            return false;
        }
        MutableXOMLibraryInformationImpl lib = (MutableXOMLibraryInformationImpl)this.librariesContainer.getElement(library.getName(), library.getVersion());
        if (lib == null || lib != library) {
            return false;
        }
        lib.setRepository(null);
        this.librariesContainer.removeElement(library.getName(), library.getVersion());
        return true;
    }

    @Override
    public XOMResourceInformation addResource(XOMResourceInformation resource) throws IlrAlreadyExistException {
        if (resource == null) {
            return null;
        }
        XOMRepositoryDAO repositoryDAO = this.getDAO();
        XOMInformation result = null;
        if (repositoryDAO != null) {
            try {
                XOMResourceId tmp = repositoryDAO.addResource(resource.getName(), resource.getVersion(), StreamUtil.toStream(resource.getData()));
                result = new XOMResourceInformationImpl(tmp, repositoryDAO);
            }
            catch (LocalizedException e) {
                throw new IlrResourceRuntimeException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.ADD_RESOURCE_ERROR, new String[]{this.toString()}, (Throwable)e);
            }
        }
        this.resourcesContainer.addElement(result.getName(), result.getVersion(), (XOMResourceInformation)result);
        return result;
    }

    @Override
    public boolean removeResource(XOMResourceInformation resource) {
        if (resource == null) {
            return false;
        }
        XOMResourceInformationImpl res = (XOMResourceInformationImpl)this.resourcesContainer.getElement(resource.getName(), resource.getVersion());
        if (res == null || res != resource) {
            return false;
        }
        XOMRepositoryDAO repositoryDAO = this.getDAO();
        if (repositoryDAO != null) {
            try {
                repositoryDAO.removeResource(resource);
            }
            catch (LocalizedException e) {
                throw new IlrResourceRuntimeException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.REMOVE_RESOURCE_ERROR, new String[]{this.toString()}, (Throwable)e);
            }
        }
        this.resourcesContainer.removeElement(resource.getName(), resource.getVersion());
        return true;
    }
}

