/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.model.internal;

import ilog.rules.res.model.IlrVersion;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class XOMElementContainer<E> {
    private final HashMap<String, TreeMap<IlrVersion, E>> elements = new HashMap();

    public XOMElementContainer() {
    }

    public XOMElementContainer(XOMElementContainer<E> elementContainer) {
        for (Map.Entry<String, TreeMap<IlrVersion, E>> entry : elementContainer.elements.entrySet()) {
            this.elements.put(entry.getKey(), new TreeMap(entry.getValue()));
        }
    }

    public synchronized int getNbElements() {
        int result = 0;
        for (TreeMap<IlrVersion, E> tm : this.elements.values()) {
            result += tm.size();
        }
        return result;
    }

    public synchronized Set<E> getElements() {
        HashSet<E> result = new HashSet<E>();
        for (TreeMap<IlrVersion, E> tm : this.elements.values()) {
            result.addAll(tm.values());
        }
        return result;
    }

    public synchronized Set<E> getElements(String elementName) {
        TreeMap<IlrVersion, E> tm = this.elements.get(elementName);
        if (tm != null) {
            return new HashSet<E>(tm.values());
        }
        return new HashSet();
    }

    public synchronized E getGreatestElement(String elementName) {
        TreeMap<IlrVersion, E> tm = this.elements.get(elementName);
        if (tm != null) {
            return tm.get(tm.lastKey());
        }
        return null;
    }

    public synchronized E getElement(String elementName, IlrVersion elementVersion) {
        TreeMap<IlrVersion, E> tm = this.elements.get(elementName);
        if (tm != null && elementVersion != null) {
            return tm.get(elementVersion);
        }
        return null;
    }

    public synchronized E addElement(String elementName, IlrVersion elementVersion, E entity) {
        TreeMap<IlrVersion, Object> tm = this.elements.get(elementName);
        if (tm == null) {
            tm = new TreeMap();
            this.elements.put(elementName, tm);
        }
        tm.put(elementVersion, entity);
        return entity;
    }

    public synchronized E removeElement(String elementName, IlrVersion elementVersion) {
        TreeMap<IlrVersion, E> tm = this.elements.get(elementName);
        if (tm != null) {
            E result = tm.remove(elementVersion);
            if (tm.size() == 0) {
                this.elements.remove(elementName);
            }
            return result;
        }
        return null;
    }

    public synchronized boolean containsElement(String elementName, IlrVersion elementVersion) {
        TreeMap<IlrVersion, E> tm = this.elements.get(elementName);
        if (tm != null) {
            return tm.containsKey(elementVersion);
        }
        return false;
    }
}

