/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.model.internal;

import com.ibm.rules.res.model.IllegalArgumentRuntimeException;
import com.ibm.rules.res.model.MutableXOMLibraryInformation;
import com.ibm.rules.res.model.MutableXOMRepository;
import com.ibm.rules.res.model.ResourceRuntimeException;
import com.ibm.rules.res.model.XOMLibraryInformation;
import com.ibm.rules.res.model.XOMRepository;
import com.ibm.rules.res.model.XOMRepositoryFactory;
import com.ibm.rules.res.model.XOMResourceId;
import com.ibm.rules.res.model.XOMResourceInformation;
import com.ibm.rules.res.model.internal.MutableXOMLibraryInformationImpl;
import com.ibm.rules.res.model.internal.MutableXOMRepositoryImpl;
import com.ibm.rules.res.model.internal.XOMLibraryInformationImpl;
import com.ibm.rules.res.model.internal.XOMRepositoryImpl;
import com.ibm.rules.res.model.internal.XOMResourceInformationImpl;
import com.ibm.rules.res.persistence.DAOException;
import com.ibm.rules.res.persistence.XOMRepositoryDAO;
import ilog.rules.res.model.IlrFormatException;
import ilog.rules.res.model.IlrIllegalArgumentRuntimeException;
import ilog.rules.res.model.IlrVersion;
import ilog.rules.res.model.internal.IlrModelImplLocalization;
import ilog.rules.res.model.internal.IlrNameValidator;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class XOMRepositoryFactoryImpl
implements XOMRepositoryFactory {
    private static final long serialVersionUID = 1L;

    @Override
    public MutableXOMRepository createRepository() {
        return new MutableXOMRepositoryImpl(this);
    }

    public MutableXOMRepository createRepository(XOMRepositoryDAO repositoryDAO) throws ResourceRuntimeException, IllegalArgumentRuntimeException {
        Set<MutableXOMLibraryInformation> libraries = this.loadLibraries(repositoryDAO);
        Set<XOMResourceInformation> resources = this.loadResources(repositoryDAO);
        return new MutableXOMRepositoryImpl(this, repositoryDAO, libraries, resources);
    }

    @Override
    public MutableXOMLibraryInformation createLibrary(String name, IlrVersion version) throws IlrFormatException, IllegalArgumentRuntimeException {
        return this.createLibrary(name, version, new Date());
    }

    @Override
    public MutableXOMLibraryInformation createLibrary(String name, IlrVersion version, Date creationDate) throws IlrFormatException, IlrIllegalArgumentRuntimeException {
        this.checkLibraryParameters(name, version, creationDate);
        return new MutableXOMLibraryInformationImpl(name, version, creationDate);
    }

    @Override
    public MutableXOMLibraryInformation createLibrary(MutableXOMLibraryInformation library) throws IlrIllegalArgumentRuntimeException {
        MutableXOMLibraryInformation newLibrary;
        if (library == null) {
            throw new IlrIllegalArgumentRuntimeException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.LIBRARY_NULL_ERROR);
        }
        try {
            newLibrary = this.createLibrary(library.getName(), library.getVersion(), library.getDate());
        }
        catch (IlrFormatException e) {
            throw new IllegalStateException();
        }
        String[] initList = library.getResources();
        int size = initList.length;
        for (int i = 0; i < size; ++i) {
            ((MutableXOMLibraryInformationImpl)newLibrary).addResourceAt(i, initList[i]);
        }
        return newLibrary;
    }

    @Override
    public XOMRepository unmodifiableRepository(MutableXOMRepository repository) {
        if (repository == null) {
            return null;
        }
        return new XOMRepositoryImpl(this, repository);
    }

    @Override
    public XOMLibraryInformation unmodifiableLibrary(MutableXOMLibraryInformation library) {
        if (library == null) {
            return null;
        }
        return new XOMLibraryInformationImpl(library, library.getResources());
    }

    @Override
    public Set<XOMLibraryInformation> unmodifiableLibraries(Set<MutableXOMLibraryInformation> libraries) {
        if (libraries == null) {
            return null;
        }
        HashSet<XOMLibraryInformation> result = new HashSet<XOMLibraryInformation>(libraries.size());
        for (MutableXOMLibraryInformation library : libraries) {
            result.add(this.unmodifiableLibrary(library));
        }
        return Collections.unmodifiableSet(result);
    }

    protected void checkLibraryParameters(String name, IlrVersion version, Date creationDate) throws IlrFormatException, IllegalArgumentRuntimeException {
        IlrNameValidator.validateLibraryName(name);
        if (version == null) {
            throw new IlrIllegalArgumentRuntimeException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.VERSION_NULL_ERROR);
        }
        if (creationDate == null) {
            throw new IlrIllegalArgumentRuntimeException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.DATE_NULL_ERROR);
        }
    }

    protected void checkRulesetParameters(String name, IlrVersion version, Date creationDate) throws IlrFormatException, IlrIllegalArgumentRuntimeException {
        IlrNameValidator.validateRulesetName(name);
        if (version == null) {
            throw new IlrIllegalArgumentRuntimeException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.VERSION_NULL_ERROR);
        }
        if (creationDate == null) {
            throw new IlrIllegalArgumentRuntimeException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.DATE_NULL_ERROR);
        }
    }

    protected Set<MutableXOMLibraryInformation> loadLibraries(XOMRepositoryDAO repositoryDAO) throws ResourceRuntimeException, IllegalArgumentRuntimeException {
        if (repositoryDAO == null) {
            throw new IllegalArgumentRuntimeException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.RESOURCE_PROVIDER_NULL_ERROR);
        }
        try {
            return repositoryDAO.loadLibraries(this);
        }
        catch (DAOException e) {
            throw new ResourceRuntimeException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.REPOSITORY_LOAD_ERROR, e);
        }
    }

    protected Set<XOMResourceInformation> loadResources(XOMRepositoryDAO repositoryDAO) throws ResourceRuntimeException, IllegalArgumentRuntimeException {
        if (repositoryDAO == null) {
            throw new IllegalArgumentRuntimeException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.RESOURCE_PROVIDER_NULL_ERROR);
        }
        try {
            Set<XOMResourceId> tmp = repositoryDAO.loadResources();
            HashSet<XOMResourceInformation> result = new HashSet<XOMResourceInformation>();
            for (XOMResourceId xomResourceId : tmp) {
                result.add(new XOMResourceInformationImpl(xomResourceId, repositoryDAO));
            }
            return result;
        }
        catch (DAOException e) {
            throw new ResourceRuntimeException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.REPOSITORY_LOAD_ERROR, e);
        }
    }

    @Override
    public XOMResourceInformation createResource(String name, byte[] data) throws IlrFormatException {
        IlrNameValidator.validateResourceName(name);
        return new XOMResourceInformationImpl(name, data);
    }
}

