/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.model.internal;

import com.ibm.rules.res.model.MutableXOMLibraryInformation;
import com.ibm.rules.res.model.MutableXOMRepository;
import com.ibm.rules.res.model.XOMLibraryInformation;
import com.ibm.rules.res.model.XOMRepository;
import com.ibm.rules.res.model.XOMRepositoryFactory;
import com.ibm.rules.res.model.XOMResourceInformation;
import ilog.rules.res.model.IlrVersion;
import java.util.Set;

public class XOMRepositoryImpl
implements XOMRepository {
    private final XOMRepositoryFactory factory;
    private final MutableXOMRepository repository;

    public XOMRepositoryImpl(XOMRepositoryFactory factory, MutableXOMRepository repository) {
        this.factory = factory;
        this.repository = repository;
    }

    @Override
    public Set<XOMLibraryInformation> getLibraries() {
        return this.factory.unmodifiableLibraries(this.repository.getLibraries());
    }

    @Override
    public Set<XOMResourceInformation> getResources() {
        return this.repository.getResources();
    }

    @Override
    public Set<XOMLibraryInformation> getLibraries(String libraryName) {
        return this.factory.unmodifiableLibraries(this.repository.getLibraries(libraryName));
    }

    @Override
    public Set<XOMResourceInformation> getResources(String resourceName) {
        return this.repository.getResources(resourceName);
    }

    @Override
    public XOMLibraryInformation getGreatestLibrary(String libraryName) {
        return this.factory.unmodifiableLibrary((MutableXOMLibraryInformation)this.repository.getGreatestLibrary(libraryName));
    }

    @Override
    public XOMResourceInformation getGreatestResource(String resourceName) {
        return this.repository.getGreatestResource(resourceName);
    }

    @Override
    public XOMLibraryInformation getLibrary(String libraryName, IlrVersion libraryVersion) {
        return this.factory.unmodifiableLibrary((MutableXOMLibraryInformation)this.repository.getLibrary(libraryName, libraryVersion));
    }

    @Override
    public XOMResourceInformation getResource(String resourceName, IlrVersion resourceVersion) {
        return this.repository.getResource(resourceName, resourceVersion);
    }
}

