/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.model.rest;

import com.ibm.rules.res.model.rest.Parts;
import com.ibm.rules.res.model.rest.Ruleset;
import com.ibm.rules.res.model.rest.Rulesets;
import com.ibm.rules.res.model.rest.io.RESTRulesetsJsonDeserializer;
import com.ibm.rules.rest.RESTCollection;
import com.ibm.rules.rest.io.RESTCollectionJsonSerializer;
import ilog.rules.res.model.IlrMutableRuleAppInformation;
import ilog.rules.res.model.IlrMutableRulesetArchiveInformation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@XmlRootElement(name="rulesets")
@JsonSerialize(using=RESTCollectionJsonSerializer.class)
@JsonDeserialize(using=RESTRulesetsJsonDeserializer.class)
public class AllRulesets
extends RESTCollection<IlrMutableRulesetArchiveInformation, Ruleset> {
    public static AllRulesets DEFAULT_OUT_INSTANCE;
    private Parts parts;
    private Set<IlrMutableRuleAppInformation> ruleApps;
    private Collection<Ruleset> rulesets;

    public AllRulesets() {
        super(Locale.ENGLISH);
    }

    public AllRulesets(Set<IlrMutableRuleAppInformation> ruleApps, Locale locale, Parts parts) {
        super(locale);
        this.ruleApps = ruleApps;
        this.parts = parts;
    }

    @XmlElement(name="ruleset")
    public Collection<Ruleset> getRulesets() {
        if (this.rulesets != null) {
            return this.rulesets;
        }
        if (this.ruleApps == null) {
            this.rulesets = new ArrayList<Ruleset>();
            return this.rulesets;
        }
        return this.getRESTCollection();
    }

    public void setRulesets(Collection<Ruleset> rulesets) {
        this.rulesets = rulesets;
    }

    @Override
    @JsonIgnore
    public Collection<IlrMutableRulesetArchiveInformation> getInitialCollection() {
        if (this.ruleApps != null) {
            LinkedList<IlrMutableRulesetArchiveInformation> result = new LinkedList<IlrMutableRulesetArchiveInformation>();
            for (IlrMutableRuleAppInformation ruleApp : this.ruleApps) {
                ArrayList names = new ArrayList();
                for (IlrMutableRulesetArchiveInformation rulesetInformation : ruleApp.getRulesets()) {
                    result.add(rulesetInformation);
                }
            }
            return result;
        }
        return null;
    }

    @Override
    public Ruleset toRESTObject(IlrMutableRulesetArchiveInformation internalObject, Locale locale) {
        return Rulesets.toRESTObject(internalObject, locale, this.parts);
    }

    @Override
    public Collection<Ruleset> getForcedRESTCollection() {
        return this.rulesets;
    }

    static {
        ArrayList<Ruleset> collout = new ArrayList<Ruleset>();
        collout.add(Ruleset.DEFAULT_OUT_INSTANCE);
        DEFAULT_OUT_INSTANCE = new AllRulesets();
        DEFAULT_OUT_INSTANCE.setRulesets(collout);
    }
}

